program CU (input,output);
uses graph,crt,pcx,dos;

{Computer Underground  [By jwm] }
{Code Start Date : 3.10.93      }
{Code Finish Date: 6.8.93       }
{Minor Revision  : 6.22.93    - changed cash to LongInt format
                              - fixed load/abort bug from File Menu
                              - made cash box in restore megs larger
                              - spread computers in the battle procedure}

type
  playerrec=record
           alias:string[20];
           commlvl,pwdlvl,virlvl,userlvl,megsgone,backups:integer;
           cpulvl,backlvl,shieldlvl:integer;
           cash:longint;
           hacked:boolean;
  end;
  systemrec=record
           name:string[40];
           cash:integer;
           min,sec:word;
           hacked:boolean;
  end;

  tiletype=record
            occupied:boolean;
            showing:boolean;
            partnum:integer;
  end;

var
  grafdevice,grafmode:integer;
  r:registers;
  player:playerrec;
  userfont:integer;
  comm,hack,mcaffee,yervir,backtype,computer:array [0..20] of string [30];
  icon:array [1..25] of pointer;
  cpunk:array [1..20] of playerrec;
  sys:array [0..25] of systemrec;
  matrix:array [1..16] of tiletype;

(*-----------Mouse Routines Begin------------------------------*)
(* All of the following mouse routines were written by Jeff W. Marlow *)

function installed:boolean;
 begin
   installed:=true;   {assume they have a mouse to begin with}
   r.ax:=0;
   intr ($33,r);
   if r.ax=0 then      {if AX register returns zero then there is no mouse}
     installed:=false;
 end; {installed}

procedure showmouse;
 begin
   asm
     mov ax,1             {self-explanatory}
     int 33h
   end; {asm}
 end; {showmouse}

procedure hidemouse;
  begin
    asm
      mov ax,2      {before doing a screen update mouse must be hidden}
      int 33h
    end; {asm}
  end; {showmouse}

procedure mouse_status (var mx,my:integer;var button:boolean);
  begin
    r.ax:=3;
    intr ($33,r);
    mx:=r.cx;
    my:=r.dx;
    if r.bx>0 then
      button:=true
    else
      button:=false;
  end;

procedure mouse_here (x,y:integer);
  begin
    r.ax:=4;
    r.cx:=x;
    r.dx:=y;
    intr ($33,r);
  end;

procedure mouse_range (x1,y1,x2,y2:integer);
  begin
    r.ax:=7;
    r.cx:=x1;
    r.dx:=x2;
    intr ($33,r);
    r.ax:=8;
    r.cx:=y1;
    r.dx:=y2;
    intr ($33,r);
  end;

procedure change_cursor;
 const
   {$I  finger.con}
 begin
   r.ax:=9;
   r.bx:=5;
   r.cx:=1;
   r.es:=seg(finger);
   r.dx:=ofs(finger);
   intr ($33,r);
 end;

(*------------------Mouse Routines End Here----------------------------*)

procedure initgrafx (gd,gm:integer);
  begin
    initgraph (gd,gm,'');
    if graphResult<>0 then
      begin
        writeln ('Graphics Error!  Number:',graphResult,'   Aborting...');
        halt;
      end;
  end;

procedure fader (message:string;size:integer);
 var
   j,haxoftfont:integer;
 begin
   cleardevice;
   haxoftfont:=installuserfont ('titl.fnt');
   settextstyle (haxoftfont,horizdir,size);
   settextjustify (centertext,centertext);
   setusercharsize (size,1,size,1);
   setcolor (7);
   setrgbpalette (7,0,0,0);
   outtextxy (getmaxx div 2,getmaxy div 2,message);
   for j:=1 to 63 do
     setrgbpalette (7,j,j,j);
   delay (400);
   for j:=63 downto 1 do
     setrgbpalette (7,j,j,j);
   cleardevice;
   setrgbpalette (7,45,45,40);
 end; {fader}

procedure title_screen;
  var
    continue:char;
    pal:palettetype;
  begin
    initgrafx (VGA,VGAHi);   {the title screen is high resolution}
    fader ('HAXOFT PRESENTS...',6);
    getpalette (pal);
    pal.colors[7]:=24;   {color of lines on the computer}
    pal.colors[8]:=7;    {main color of computer}
    pal.colors[6]:=15;
    setallpalette (pal);
    read_pcx_file (grafdevice, 'cu.gfx');
    continue:=readkey;
    closegraph;
    initgrafx (VGA,VgaMed);
  end;

procedure program_data;
  var
    a,b,c,d,e,f:text;
    i:integer;
  begin
    assign (a,'virs.dat');
    assign (b,'cpu.dat');
    assign (c,'backups.dat');
    assign (d,'pwdfind.dat');
    assign (e,'comms.dat');
    assign (f,'shields.dat');
    reset (a);reset (b);reset (c);reset (d);reset (e);reset (f);
    for i:=0 to 20 do
      begin
        readln (a,yervir[i]);
        readln (b,computer[i]);
        readln (c,backtype[i]);
        readln (d,hack[i]);
        readln (e,comm[i]);
        readln (f,mcaffee[i]);
      end;
    close (a);close (b);close (c);close (d);close (e);close (f);
  end;

procedure load_graphics;
  var
    i:integer;
    size:word;
    graphfile:file;
    grdata:array [1..25] of string;
  begin
    grdata[1]:='newgame.xgf';
    grdata[2]:='hd144.xgf';
    grdata[3]:='computer.xgf';
    grdata[4]:='todisk.xgf';
    grdata[5]:='fromdisk.xgf';
    grdata[6]:='mainfram.xgf';
    grdata[7]:='money.xgf';
    grdata[8]:='worm.xgf';
    grdata[9]:='restore.xgf';
    grdata[10]:='battle.xgf';
    grdata[11]:='3dbutton.xgf';
    grdata[12]:='snakeop.xgf';
    grdata[13]:='snakecl.xgf';
    grdata[14]:='safecrak.xgf';
    grdata[15]:='eye.xgf';
    grdata[16]:='qtile.xgf';
    grdata[17]:='htile.xgf';
    grdata[18]:='tile01.xgf';
    grdata[19]:='tile02.xgf';
    grdata[20]:='tile03.xgf';
    grdata[21]:='tile04.xgf';
    grdata[22]:='tile05.xgf';
    grdata[23]:='tile06.xgf';
    grdata[24]:='tile07.xgf';
    grdata[25]:='tile08.xgf';
    for i:=1 to 25 do
      begin
        assign (graphfile,grdata[i]);
        reset (graphfile,1);
        size:=filesize(graphfile);
        getmem (icon[i],Size);
        blockread (graphfile,icon[i]^,Size);
        close (graphfile);
      end;
  end;  {load_graphics}

procedure init_crackers;
  var
    finfo:playerrec;
    datafile:string;
    f:file of playerrec;
    i,j:integer;
  begin
    datafile:='crackers.cu';
    assign (f,datafile);
    reset (f);
    seek (f,0);
    read (f,finfo);
    j:=finfo.commlvl;     {this field tells the # of records in the file}
    for i:=1 to j do
      begin
        seek (f,i);
        read (f,cpunk[i]);
      end;
    close (f);
  end;    {init_crackers}

procedure init_systems;
  var
    f:file of systemrec;
    i,n:integer;
  begin
    assign (f,'systems.cu');
    reset (f);
    seek (f,0);
    read (f,sys[0]);
    n:=sys[0].cash;  {number of recs in the file}
    for i:=1 to n do
      begin
        seek (f,i);
        read (f,sys[i]);
      end;
    close (f);
  end;  {init_systems}

procedure drawbutton (x,y,upordown:integer);
  begin
    case upordown of
      1:putimage (x,y,icon[11]^,normalput);
      2:putimage (x,y,icon[11]^,notput);
    end;
  end;   {drawbutton}

procedure clear_monitor;
  begin
    setbkcolor (black);
    setcolor (lightgray);
    cleardevice;
    setfillstyle (widedotfill,lightmagenta);
    bar (0,0,getmaxx,getmaxy);
    setfillstyle (solidfill,lightgray);
    bar (10,10,getmaxx-10,getmaxy-10);
    setfillstyle (interleavefill,lightgray);
    bar (40,35,getmaxx-40,getmaxy-35);
    setfillstyle (solidfill,darkgray);
    bar (45,40,getmaxx-45,getmaxy-40);
    setfillstyle (solidfill,black);
    bar (50,45,getmaxx-50,getmaxy-45);
    setcolor (brown);
    settextstyle (triplexfont,horizdir,1);
    settextjustify (lefttext,toptext);
    outtextxy (50,315,'HaxoftSVGA/93');
    settextstyle (smallfont,horizdir,3);
    setcolor (lightred);
    setfillstyle (solidfill,darkgray);
    bar (565,317,565+textwidth('POWER')+6,330);
    outtextxy (570,320,'POWER');
  end;

procedure show_cash;
  var
    money:string;
    old:word;
  begin
    old:=getcolor;
    setcolor (lightred);
    str (player.cash,money);
    outtextxy (475,55,'Cash');
    outtextxy (475,75,'$'+money);
    setcolor (old);
  end;

procedure new_player;
  begin
    hidemouse;
    clear_monitor;
    settextstyle (gothicfont,horizdir,5);
    settextjustify (centertext,toptext);
    setcolor (yellow);
    outtextxy (getmaxx div 2,60,'Login With Your Alias:');
    gotoxy (35,17);
    readln (player.alias);
    with player do
      begin
        commlvl:=1;
        pwdlvl:=0;   {no password cracker}
        virlvl:=1;
        userlvl:=1;
        megsgone:=0;      {no megs gone...yet}
        backups:=2;
        cash:=150;
        cpulvl:=1;
        backlvl:=1;
        shieldlvl:=0;    {no protection from viruses}
      end;
    if player.alias='Haxoft93' then      {a cheat!!!}
      begin
        with player do
          begin
            commlvl:=20;
            pwdlvl:=20;
            virlvl:=20;
            userlvl:=20;
            megsgone:=0;
            backups:=99;
            cash:=20000;
            cpulvl:=20;
            backlvl:=20;
            shieldlvl:=20;
          end;
      end;
    showmouse;
  end;   {newplayer}

procedure encrypt (var data:playerrec);
  var
    i:integer;
  begin
    for i:=1 to length (data.alias) do
      data.alias[i]:=chr(ord(data.alias[i])-1);
    with data do
      begin
        commlvl:=commlvl*9;
        userlvl:=userlvl*4;
        megsgone:=megsgone+5;
        backups:=backups+13;
        cash:=cash;
        cpulvl:=cpulvl+27;
      end;
  end;

procedure decrypt (var data:playerrec);
  var
    i:integer;
  begin
    for i:=1 to length (data.alias) do
      data.alias[i]:=chr(ord(data.alias[i])+1);
    with data do
      begin
        commlvl:=commlvl div 9;
        userlvl:=userlvl div 4;
        megsgone:=megsgone-5;
        backups:=backups-13;
        cash:=cash;
        cpulvl:=cpulvl-27;
      end;
  end;

procedure save_game;
  var
    savefile:file of playerrec;
    guysdown:playerrec;
    sysdown:file of shortint;
    filename:string;
    i:integer;
    tmp:shortint;
  begin
    filename:=player.alias;
    delete (filename,9,35);     {make the alias suitable as a filename}
    assign (savefile,filename+'.sg');
    rewrite (savefile);
    encrypt (player);
    seek (savefile,0);
    write (savefile,player);
    seek (savefile,1);
    for i:=1 to 20 do
      begin
        if cpunk[i].hacked then
          guysdown.alias[i]:='1'
        else 
          guysdown.alias[i]:='0';
      end;
    write (savefile,guysdown);
    close (savefile);
    decrypt (player);
    assign (sysdown,filename+'.h93');
    rewrite (sysdown);
    seek (sysdown,0);
    tmp:=25;
    write (sysdown,tmp);
    for i:=1 to 25 do
      begin
        seek (sysdown,i);
        if sys[i].hacked then
          tmp:=1
        else
          tmp:=0;
        write (sysdown,tmp);
      end;
    close (sysdown);
  end;

procedure load_game (var loaded:boolean);
  var
    f:file of playerrec;
    sf2:file of shortint;
    i:integer;
    value:shortint;
    guysdown:playerrec;
    filename:string;
    punktmp:array [1..20] of playerrec;
    systmp:array [0..25] of systemrec;
  begin
    loaded:=false;
    hidemouse;
    move (cpunk,punktmp,sizeof(cpunk));
    move (sys,systmp,sizeof(sys));
    init_crackers;
    init_systems;
    clear_monitor;
    settextstyle (gothicfont,horizdir,5);
    settextjustify (centertext,toptext);
    setcolor (yellow);
    outtextxy (getmaxx div 2,60,'What Was Your Alias?');
    setcolor (lightblue);
    settextstyle (triplexfont,horizdir,3);
    outtextxy (getmaxx div 2,110,'(Hit ENTER alone to abort)');
    gotoxy (35,17);
    readln (filename);
    if not(filename='') then
      begin
        delete (filename,9,35);
        {$I-}
        assign (f,filename+'.sg');
        reset (f);
        if IOresult <> 0 then
          begin
            showmouse;
            load_game (loaded);
          end
        else
          begin
            seek (f,0);
            read (f,player);
            decrypt (player);
            seek (f,1);
            read (f,guysdown);
            for i:=1 to 20 do
              begin
                if guysdown.alias[i]='1' then
                  cpunk[i].hacked:=true
                else
                  cpunk[i].hacked:=false;
              end;
            close (f);
            assign (sf2,filename+'.h93');
            reset (sf2);
            for i:=1 to 25 do
              begin
                seek (sf2,i);
                read (sf2,value);
                if value=1 then
                  sys[i].hacked:=true
                else
                  sys[i].hacked:=false;
              end;
            close (sf2);
            loaded:=true;
          end;
        {$I+}
      end
    else
      begin
        move (systmp,sys,sizeof(systmp));
        move (punktmp,cpunk,sizeof(punktmp));
        loaded:=false;
      end;
    showmouse;
  end;

procedure list_punks (var fightnum:integer);
  const
    spaces13='             ';
    spaces14='              ';
  var
    i,y:integer;
    nums:string;
  begin
    settextstyle (defaultfont,horizdir,1);
    setcolor (lightcyan);
    outtextxy (60,50,'Exp. Level     '+'Name');
    setcolor (red);
    line (60,60,555,60);
    str (1,nums);
    y:=65;
    for i:=1 to 20 do
      begin
        str (i,nums);
        if not(cpunk[i].hacked) then
          begin
            setcolor (lightgreen);
            if length (nums)=2 then
              outtextxy (60,y,nums+spaces13+cpunk[i].alias)
            else
              outtextxy (60,y,nums+spaces14+cpunk[i].alias);
          end
        else
          begin
            setcolor (green);
            outtextxy (60,y,'--'+spaces13+'Out of Commission');
          end;
        inc (y,10);
      end;
    setcolor (red);
    line (60,y+5,555,y+5);
    setcolor (lightblue);
    settextstyle (sansseriffont,vertdir,3);
    settextjustify (centertext,centertext);
    outtextxy (400,175,'Cyberpunk'); outtextxy (475,175,'Directory');
    settextstyle (sansseriffont,horizdir,2);
    settextjustify (lefttext,toptext);
    {$I-}
    repeat
      outtextxy (75,y+10,'0 to Wimp Out:');
      setcolor (yellow);
      setfillstyle (emptyfill,yellow);
      bar3d (260,y+12,555,getmaxy-50,5,topon);
      gotoxy (40,21);
      readln (fightnum);
    until IOResult=0;
    {$I+}
    if (fightnum<1) or (fightnum>20) or
       (cpunk[fightnum].hacked=true) then fightnum:=-1;
  end;

procedure update_stats (enemy:integer);
  var
    numholder:string[5];
  begin
    setfillstyle (interleavefill,lightblue);
    bar (60,167,260,300);
    bar (360,167,570,300);
    setcolor (lightcyan);
    settextstyle (userfont,horizdir,5);
    settextjustify (lefttext,toptext);
    {Player 1 Status}
    with player do
      begin
        str (userlvl,numholder);
        outtextxy (62,170,'Level: '+numholder);
        str (userlvl*10,numholder);
        outtextxy (62,185,'Total Megs: '+numholder);
        str ((userlvl*10)-megsgone,numholder);
        outtextxy (62,200,'Megs Left: '+numholder);
        str (backups,numholder);  outtextxy (62,215,'Restores: '+numholder);
        outtextxy (62,230,'Virus: '+yervir[virlvl]);
        outtextxy (62,245,'Shield: '+mcaffee[shieldlvl]);
      end;  {with}
    {Opponent Status}
    with cpunk[enemy] do
      begin
        str (userlvl,numholder);
        outtextxy (362,170,'Level: '+numholder);
        str (userlvl*10,numholder);
        outtextxy (362,185,'Total Megs: '+numholder);
        str ((userlvl*10)-megsgone,numholder);
        outtextxy (362,200,'Megs Left: '+numholder);
        str (backups,numholder);  outtextxy (362,215,'Restores: '+numholder);
        {    outtextxy (362,230,'Virus: '+yervir[virlvl]);
             outtextxy (362,245,'Shield: '+mcaffee[shieldlvl]);
             outtextxy (362,260,'Comm: '+comm[commlvl]);
        }
      end;  {with}
  end;  {update_stats}

procedure virus_animation;
  var
    x,imnum:integer;
  begin
    imnum:=12;
    for x:=170 to 400 do
      begin
        putimage (x,110,icon[imnum]^,xorput);
        delay (35);
        putimage (x,110,icon[imnum]^,xorput);
        if x mod 5>2 then
          imnum:=12
        else
          imnum:=13;
      end;
  end;    {virus_animation}

procedure clickhere (x,y:integer;col:word);
  var
    mx,my:integer;
    mb:boolean;
  begin
    settextstyle (gothicfont,horizdir,3);
    settextjustify (lefttext,toptext);
    setcolor (col);
    drawbutton (x,y,1);
    outtextxy (x+25,y,' Click here');
    mouse_range (x,y,x+25,y+25);
    showmouse;
    repeat
       mouse_status (mx,my,mb);
    until mb=true;
    hidemouse;
    drawbutton (x,y,2);
    delay (100);
    drawbutton (x,y,1);
    showmouse;
  end;

procedure battle_message (msg,i1,i2:integer);
  var
    c,g:string;
    mx,my:integer;
    button:boolean;
  begin
    str (i1,g);
    str (i2,c);
    setcolor (lightmagenta);
    settextstyle (sansseriffont,horizdir,1);
    settextjustify (centertext,bottomtext);
    case msg of
      1:begin
          outtextxy (310,120,'You trash '+g+' megs!');
          outtextxy (310,140,'Oh no! You lost '+c+' megs!');
        end;
      2:begin
          outtextxy (310,120,'Your virus destroys '+g+' megs!');
          outtextxy (310,140,'His virus scraps '+c+' megs!');
        end;
      3:begin
          outtextxy (310,120,'You restore '+g+' megs.');
          outtextxy (310,140,'He restores '+c+' megs.');
        end;
    end;
    repeat
      mouse_status (mx,my,button);
    until button;
    setfillstyle (emptyfill,black);
    bar (160,105,447,147);   {black-out over the text}
  end;

procedure decide_damage (torv,op:integer);
  var
    inflicted,recieved:integer;
  begin
    randomize;
    case torv of
      1:begin {trash megs}
          inflicted:=random(player.userlvl+player.commlvl)+random(5);
          recieved:=random(cpunk[op].userlvl+cpunk[op].commlvl)+random(6);
        end;
      2:begin {virus transmisson}
          if not(player.virlvl=0) then
            begin
              inflicted:=random(player.userlvl+player.virlvl)
                         +random(7)-random(cpunk[op].shieldlvl);
              player.virlvl:=0;  {you can only use a virus once}
            end
          else
            inflicted:=0;
            recieved:=random(cpunk[op].userlvl+cpunk[op].virlvl)
                      +random(6)-random(player.shieldlvl);
        end;
    end;  {case}
    inflicted:=abs (inflicted);
    recieved:=abs (recieved);
    cpunk[op].megsgone:=cpunk[op].megsgone+inflicted;
    player.megsgone:=player.megsgone+recieved;
    battle_message (torv,inflicted,recieved);
  end;  {decide_damage}

procedure restoreinbattle (enemy:integer);
  var
    fixed,hefixed:integer;
  begin
    randomize;
    if not(player.backups=0) and (player.megsgone>0) then
      begin
        fixed:=random(player.backlvl)+random(5);
        dec (player.megsgone,fixed);
        if player.megsgone<0 then player.megsgone:=0;
        dec (player.backups,1);
      end
    else
      fixed:=0;
    if not(cpunk[enemy].backups=0) and (cpunk[enemy].megsgone>0) then
       begin
         hefixed:=random(cpunk[enemy].backlvl)+random(4);
         dec (cpunk[enemy].megsgone,hefixed);
         if cpunk[enemy].megsgone<0 then cpunk[enemy].megsgone:=0;
         dec (cpunk[enemy].backups,1);
       end
    else
      hefixed:=0;
    battle_message (3,fixed,hefixed);
  end;

procedure battle_results (playerwin:boolean;opp:integer);
  var
    nums:string[5];
    reward,mx,my:integer;
    mb:boolean;
  begin
    randomize;
    clear_monitor;
    setcolor (lightred);
    settextstyle (triplexfont,horizdir,4);
    settextjustify (centertext,centertext);
    if playerwin then
      begin
        reward:=random (4);
        if player.userlvl < cpunk[opp].userlvl then
           player.userlvl:=cpunk[opp].userlvl;
        player.cash:=player.cash+cpunk[opp].cash;
        player.backups:=player.backups+cpunk[opp].backups;
        outtextxy (320,100,'He`s finished!');
        str (player.userlvl,nums);
        outtextxy (320,140,'You are now at level: '+nums);
        str (cpunk[opp].cash,nums);
        cpunk[opp].megsgone:=cpunk[opp].userlvl*10;
        cpunk[opp].cash:=0;
        if player.userlvl*10-player.megsgone<player.userlvl*10 div 2 then
          player.megsgone:=player.userlvl*10 div 2;  {givem half}
        outtextxy (320,180,'He had $'+nums+' in his account');
        setcolor (red);
        settextstyle (sansseriffont,horizdir,3);
        with cpunk[opp] do
          begin
            case reward of
              1:begin
                  if player.commlvl < commlvl then
                    begin
                      outtextxy (320,220,'You download: '+comm[commlvl]);
                      outtextxy (320,240,'(His Comm Software)');
                      player.commlvl:=commlvl;
                    end;
                end;
              2:begin
                  if player.pwdlvl < pwdlvl then
                    begin
                      outtextxy (320,220,'You download: '+hack[pwdlvl]);
                      outtextxy (320,240,'(His Password Cracker)');
                      player.pwdlvl:=pwdlvl;
                    end;
                end;
              3:begin
                  if player.shieldlvl < shieldlvl then
                    begin
                      outtextxy (320,220,'You download: '+mcaffee[shieldlvl]);
                      outtextxy (320,240,'(His Viral Protection)');
                      player.shieldlvl:=shieldlvl;
                    end;
                end;
              4:begin
                  if player.backlvl < backlvl then
                    begin
                      outtextxy (320,220,'You download: '+backtype[backlvl]);
                      outtextxy (320,240,'(His Backup Software)');
                      player.backlvl:=backlvl;
                    end;
                end;
            end;  {case}
          end;    {with}
      end
    else
      begin
        outtextxy (320,60,'You`re outta megs!');
        setcolor (lightblue);
        outtextxy (320,100,cpunk[opp].alias);
        outtextxy (320,140,'is laughing at you!');
        setcolor (blue);
        outtextxy (320,180,'Restore yer megs (and pride) &');
        setcolor (yellow);
        outtextxy (320,220,'GO GET HIM!!!');
        cpunk[opp].megsgone:=0;
        cpunk[opp].virlvl:=cpunk[opp].userlvl;
      end;
    clickhere (305,270,lightcyan);
    mouse_range (0,0,getmaxx,getmaxy);
  end;  {battle_results}

procedure fight_screen (opponent:integer);
  begin
    clear_monitor;
    setcolor (yellow);
    settextstyle (smallfont,horizdir,4);
    settextjustify (lefttext,toptext);
    outtextxy (295,47,comm[player.commlvl]);
    putimage (90,90,icon[3]^,normalput);     {/put the computers   }
    putimage (445,90,icon[3]^,normalput);     {\       on the screen}
    setcolor (brown);
    setlinestyle (dashedln,3,normwidth);
    line (170,148,435,148);
    setlinestyle (solidln,0,normwidth);
    settextstyle (userfont,horizdir,6);
    settextjustify (centertext,bottomtext);
    setcolor (lightgreen);
    outtextxy (485,87,cpunk[opponent].alias);
    outtextxy (130,87,player.alias);
    settextstyle (userfont,horizdir,4);
    settextjustify (centertext,toptext);
    setcolor (green);
    outtextxy (485,155,computer[cpunk[opponent].cpulvl]);
    outtextxy (130,155,computer[player.cpulvl]);
    setfillstyle (xhatchfill,lightred);
    bar (260,167,360,300);
    settextjustify (lefttext,toptext);
    setcolor (white);
    drawbutton (265,170,1); outtextxy (295,170,'Trash');
                            outtextxy (295,180,'Megs');
    drawbutton (265,200,1); outtextxy (295,200,'Restore');
                            outtextxy (295,210,'Megs');
    drawbutton (265,230,1); outtextxy (295,230,'Transmit');
                            outtextxy (295,240,'Virus');
    drawbutton (265,270,1); outtextxy (295,270,'Drop');
                            outtextxy (295,280,'Carrier');
    update_stats (opponent);
  end;

procedure battle;
  var
    mx,my,i,flag:integer;
    mb:boolean;
  begin
    hidemouse;
    flag:=0;
    clear_monitor;
    list_punks (i);
    if i=-1 then
      begin
        showmouse;
        exit;
      end
    else
      begin
        fight_screen (i);
        mouse_range (260,167,360,300);  {keep the mouse in the options}
        showmouse;
        repeat
          mouse_status (mx,my,mb);
          if mb then
            begin
              if (mx>264) and (mx<291) then
                begin
                  if (my>170) and (my<195) then  {Trash Megs button}
                    begin
                      hidemouse;
                      drawbutton (265,170,2);  {press the 3D button}
                      delay (100);
                      drawbutton (265,170,1);  {restore original button}
                      decide_damage (1,i);
                      update_stats (i);
                      if player.megsgone>=player.userlvl*10 then
                        begin
                          player.megsgone:=player.userlvl*10;
                          battle_results (false,i);
                          flag:=99;
                        end;
                      if cpunk[i].megsgone>=cpunk[i].userlvl*10 then
                        begin
                          cpunk[i].hacked:=true;
                          battle_results (true,i);
                          flag:=99;
                        end;
                      showmouse;
                    end;
                  if (my>200) and (my<225) then   {Restore Megs button}
                    begin
                      hidemouse;
                      drawbutton (265,200,2);  {press the 3D button}
                      delay (100);
                      drawbutton (265,200,1);  {restore original button}
                      restoreinbattle (i);
                      update_stats (i);
                      showmouse;
                    end;
                  if (my>230) and (my<255) then   {Transmit Virus button}
                    begin
                      hidemouse;
                      drawbutton (265,230,2);  {press the 3D button}
                      delay (100);
                      drawbutton (265,230,1);  {restore original button}
                      if player.virlvl>0 then
                         virus_animation;
                      decide_damage (2,i);
                      update_stats (i);
                      if player.megsgone>=player.userlvl*10 then
                        begin
                          player.megsgone:=player.userlvl*10;
                          battle_results (false,i);
                          flag:=99;
                        end;
                      if cpunk[i].megsgone>=cpunk[i].userlvl*10 then
                        begin
                          cpunk[i].hacked:=true;
                          battle_results (true,i);
                          flag:=99;
                        end;
                      showmouse;
                    end;
                  if (my>270) and (my<295) then   {Drop Carrier button}
                    begin
                      hidemouse;
                      drawbutton (265,270,2);  {press the 3D button}
                      delay (100);
                      drawbutton (265,270,1);  {restore original button}
                      showmouse;
                      flag:=99;
                    end;
                end;
            end;
        until flag > 0;
      end;
    mouse_range (0,0,getmaxx,getmaxy);
    showmouse;
  end;   {battle}

procedure player_status;
  var
    numberstr:string;
  begin
    setcolor (lightred);
    setfillstyle (ltbkslashfill,lightblue);
    bar3d (370,60,575,300,10,topon);
    setcolor (cyan);
    setfillstyle (slashfill,blue);
    bar (390,75,555,95);
    setcolor (lightmagenta);
    settextstyle (sansseriffont,horizdir,3);
    settextjustify (lefttext,bottomtext);
    outtextxy (403,92,'S T A T U S');
    settextstyle (smallfont,horizdir,4);
    settextjustify (lefttext,toptext);
    setcolor (yellow);
    with player do
      begin
         outtextxy (375,100,'Alias        : '+alias);
         str (userlvl,numberstr);
         outtextxy (375,115,'Exp Level    : '+numberstr);
         str (cash,numberstr);
         outtextxy (375,130,'Cash         : '+numberstr);
         str (userlvl*10,numberstr);
         outtextxy (375,145,'HD Capacity  : '+numberstr);
         str (userlvl*10-megsgone,numberstr);
         outtextxy (375,160,'Megs Left    : '+numberstr);
         outtextxy (375,175,'Comm Program : '+comm[commlvl]);
         outtextxy (375,190,'Hack Program : '+hack[pwdlvl]);
         outtextxy (375,205,'Virus Shield : '+mcaffee[shieldlvl]);
         outtextxy (375,220,'Your Virus   : '+yervir[virlvl]);
         outtextxy (375,235,'Backup Media : '+backtype[backlvl]);
         outtextxy (375,250,'Your Computer: '+computer[cpulvl]);
      end;
  end;

procedure restore_megs;
  var
    numst:string;
    howmany,mx,my,cost:integer;
    mb,flag:boolean;
  begin
    flag:=false;
    hidemouse;
    clear_monitor;
    settextstyle (gothicfont,vertdir,5);
    settextjustify (lefttext,centertext);
    setcolor (lightblue);
    outtextxy (60,getmaxy div 2,'Restore Megs');
    setfillstyle (interleavefill,magenta);
    bar (115,65,580,295);
    settextstyle (sansseriffont,horizdir,1);
    settextjustify (lefttext,toptext);
    setcolor (white); setfillstyle (emptyfill,white);
    str (player.cash,numst); outtextxy (115,43,'Cash: $'+numst);
    str (player.userlvl*10-player.megsgone,numst);
    outtextxy (320,43,'Megs Left: '+numst);
    howmany:=0;
    cost:=howmany*player.userlvl;
    settextstyle (sansseriffont,horizdir,2);  setcolor (lightcyan);
    outtextxy (125,70,'Restore ');
    bar (235,70,275,100);   {restore megs go here}
    outtextxy (290,70,'Megs');
    bar (480,70,575,100);   {cost goes here}
    settextjustify (righttext,toptext);
    outtextxy (475,70,'Cost $');
    settextjustify (lefttext,toptext);
    drawbutton (235,120,1);outtextxy (270,120,'+');
    drawbutton (235,150,1);outtextxy (270,150,'-');
    drawbutton (235,180,1);outtextxy (270,180,'Ok');
    drawbutton (235,230,1);outtextxy (270,230,'Cancel');
    setcolor (cyan);
    str (howmany,numst); outtextxy (235,70,numst);
    str (cost,numst); outtextxy (480,70,numst);
    mouse_range (235,115,260,255);
    showmouse;
    repeat
      mouse_status (mx,my,mb);
      if mb=true then
        begin
          if my<145 then
            begin
              if (howmany<player.megsgone) and (player.cash>=cost) then
                begin
                  hidemouse;
                  drawbutton (235,120,2);delay (100);
                  inc (howmany,1);
                  cost:=howmany*player.userlvl;
                  bar (235,70,275,100);   
                  bar (480,70,575,100);
                  str (howmany,numst); outtextxy (235,70,numst);
                  str (cost,numst); outtextxy (480,70,numst);
                  drawbutton (235,120,1);
                  showmouse;
                end
              else
                begin
                  sound (2400);delay (100);nosound;
                end;
            end
          else if (my>150) and (my<175) then
            begin
              if howmany>0 then
                begin
                  hidemouse;
                  drawbutton (235,150,2);delay (100);
                  dec (howmany,1);
                  cost:=howmany*player.userlvl;
                  bar (235,70,275,100);   
                  bar (480,70,575,100);
                  str (howmany,numst); outtextxy (235,70,numst);
                  str (cost,numst); outtextxy (480,70,numst);
                  drawbutton (235,150,1);
                  showmouse;
                end
              else
                begin
                  sound (2400);delay (100);nosound;
                end;
            end
          else if (my>180) and (my<205) then
            begin
              if player.cash<cost then
                begin
                  sound (2400);delay (100);nosound;
                end
              else
                begin
                  hidemouse;
                  drawbutton (235,180,2);delay (100);
                  dec (player.cash,cost);
                  player.megsgone:=player.megsgone-howmany;
                  drawbutton (235,180,1);
                  flag:=true;
                  showmouse;
                end;
            end
          else if (my>230) and (my<255) then
            begin
              hidemouse;
              drawbutton (235,230,2);delay (100);drawbutton (235,230,1);
              showmouse;
              flag:=true;
            end;
        end;
    until flag=true;
    mouse_range (0,0,getmaxx,getmaxy);
  end;

procedure go_for_it (odds,minget,maxget:integer);
  var
    result,gained,fined,losecpu:integer;
    richer,losing:string[5];
  begin
    hidemouse;
    clear_monitor;
    settextstyle (triplexfont,horizdir,7);
    settextjustify (centertext,toptext);
    outtextxy (320,50,'Accessing...');
    delay (550);
    randomize;
    result:=random (odds);
    if result=3 then    {3 is the lucky number for all odds}
      begin
        case random(4) of
           0:gained:=maxget;
           1:gained:=(maxget+minget) div 2;
           2:gained:=(maxget+minget) div 3;
           3:gained:=minget;
         end;
        inc (player.cash,gained);
        settextstyle (triplexfont,horizdir,4);
        setcolor (yellow);
        outtextxy (320,150,'Attempt Successful!!!');
        str (gained,richer);
        setcolor (lightmagenta);
        outtextxy (320,200,'You re-route $'+richer+' to');
        outtextxy (320,230,'your account.  Congratulations!');
      end
    else
      begin
        case odds of
          9:fined:=200;
          7:fined:=150;
          4:fined:=75;
        end;
        str (fined,losing);
        settextstyle (triplexfont,horizdir,4);
        setcolor (yellow);
        outtextxy (320,150,'You Got Busted!!');
        setcolor (cyan);
        outtextxy (320,200,'You are fined $'+losing);
        losecpu:=random (2);
        if (losecpu=1) or (player.cash=0) then
          begin
            outtextxy (320,230,'You lose your '+computer[player.cpulvl]);
            player.cpulvl:=0;
          end;
        if player.cash >= fined then
          dec (player.cash,fined)
        else
          player.cash:=0;
      end;
    clickhere (310,270,green);
  end;

procedure bank_run;
  var
    pick,mx,my:integer;
    mbpressed,flag:boolean;
  begin
    hidemouse;
    flag:=false;
    clear_monitor;
    settextstyle (triplexfont,horizdir,4);
    settextjustify (centertext,toptext);
    setcolor (lightcyan);
    outtextxy (320,55,'Bank Account Access Attempt');
    settextstyle (defaultfont,horizdir,2);
    setcolor (blue);
    outtextxy (320,95,'Odds on Success');
    setcolor (lightblue);
    outtextxy (320,120,'Accounts $2000 + ....... 8 to 1');
    outtextxy (320,140,'$1000 - $1999    ....... 6 to 1');
    outtextxy (320,160,'$999 or less     ....... 3 to 1');
    settextstyle (userfont,horizdir,6);
    setcolor (red);
    outtextxy (320,180,'Warning: Bank hacking is a serious offense.');
    outtextxy (320,195,'If you are caught you may be fined and/or lose');
    outtextxy (320,210,'possession of your computer system.');
    setcolor (lightgreen);
    settextstyle (smallfont,horizdir,4);
    settextjustify (centertext,bottomtext);
    outtextxy (145,260,'$2000 +');
    putimage (130,265,icon[7]^,normalput);   {icon #7-->money}
    outtextxy (245,260,'$1999 - $1000');
    putimage (230,265,icon[7]^,normalput);
    outtextxy (345,260,'$999 -');
    putimage (330,265,icon[7]^,normalput);
    outtextxy (463,260,'Abort');
    drawbutton (450,265,1);
    mouse_range (130,265,475,290);
    showmouse;
    while flag=false do
      begin
        mouse_status (mx,my,mbpressed);
        if mbpressed then
          begin
            if (mx>130) and (mx<160) then
              begin
                go_for_it (9,2000,3500);
                flag:=true;
              end;
            if (mx>230) and (mx<260) then
              begin
                go_for_it (7,1000,1999);
                flag:=true;
              end;
            if (mx>330) and (mx<360) then
              begin
                go_for_it (4,999,50);
                flag:=true;
              end;
            if (mx>450) and (mx<475) then
              begin
                hidemouse;
                drawbutton (450,265,2); delay (100);
                drawbutton (450,265,1);
                showmouse;
                flag:=true;
              end;
          end;
      end;
    mouse_range (0,0,getmaxx,getmaxy);
  end;

procedure download_vir;
  var
    i,y,which:integer;
    nums:string;
  begin
    clear_monitor;
    settextstyle (defaultfont,horizdir,1);
    settextjustify (lefttext,toptext);
    setcolor (lightgreen);
    outtextxy (60,50,'Damage Level     '+'Name / Cost');
    setcolor (lightred);
    line (60,60,555,60);
    y:=65;
    setcolor (lightblue);
    for i:=1 to 20 do
      begin
        str (i,nums); outtextxy (60,y,nums);
        str (i*15,nums); outtextxy (200,y,yervir[i]+'----> $'+nums);
        inc (y,10);
      end;
    setcolor (red);
    line (60,y+5,555,y+5);
    setcolor (lightcyan);
    settextstyle (userfont,vertdir,7);
    settextjustify (centertext,centertext);
    outtextxy (440,175,'Virii'); outtextxy (475,175,'Incorporated');
    settextstyle (sansseriffont,horizdir,2);
    settextjustify (lefttext,toptext);
    show_cash;
    {$I-}
    repeat
      outtextxy (75,y+10,'0 to Abort  ');
      setcolor (white);
      setfillstyle (emptyfill,yellow);
      bar3d (260,y+12,555,getmaxy-50,5,topon);
      gotoxy (40,21);
      readln (which);
    until IOResult=0;
    {$I+}
    if (which<1) or (which>20) or (which*15>player.cash) then
      begin
        showmouse;
        sound (2400);delay (100);nosound;
        exit;
      end
    else
     begin
       clear_monitor;
       player.cash:=player.cash-which*15;
       player.virlvl:=which;
       settextstyle (triplexfont,horizdir,4);
       settextjustify (centertext,toptext);
       setcolor (magenta);
       outtextxy (320,45,'You successfully download');
       setcolor (lightmagenta);
       outtextxy (320,100,'the '+yervir[which]);
       setcolor (magenta);
       outtextxy (320,140,'virus.');
       clickhere (300,220,lightblue);
       mouse_range (0,0,getmaxx,getmaxy);
     end;
  end;

procedure file_menu;
  var
    mx,my:integer;
    mb,flag:boolean;
  begin
    flag:=false;
    hidemouse;
    clear_monitor;
    setfillstyle (solidfill,magenta);
    bar (50,45,589,304);
    settextstyle (gothicfont,horizdir,5);
    settextjustify (centertext,toptext);
    setcolor (yellow);
    outtextxy (320,45,'- File Options -');
    settextstyle (defaultfont,horizdir,2);
    settextjustify (lefttext,toptext);
    setcolor (lightmagenta);
    drawbutton (250,100,1); outtextxy (285,100,'Save game');
    drawbutton (250,140,1); outtextxy (285,140,'Load game');
    drawbutton (250,180,1); outtextxy (285,180,'Restart');
    drawbutton (250,220,1); outtextxy (285,220,'Return to game');
    settextstyle (smallfont,horizdir,4);
    outtextxy (430,290,'Press POWER to quit C.U.');
    showmouse;
    repeat
      mouse_status (mx,my,mb);
      if mb then
        begin
          if (565<mx) and (mx<585) and (317<my) and (my<330) then
            begin    {they hit the power button so quit}
              closegraph;
              flag:=true;
            end;
          if (mx>250) and (mx<280) then
            begin
              if (my>100) and (my<125) then  {save game}
                begin
                  hidemouse;
                  drawbutton (250,100,2); delay (100);
                  drawbutton (250,100,1);
                  save_game;
                  outtextxy (250,255,'Game Saved.');
                  clickhere (250,270,white);
                  mouse_range (0,0,getmaxx,getmaxy);
                  flag:=true;
                end;
              if (my>140) and (my<165) then   {load game}
                begin
                  hidemouse;
                  drawbutton (250,140,2); delay (100);
                  drawbutton (250,140,1);
                  showmouse;
                  load_game (flag);
                  flag:=true;
                end;
              if (my>180) and (my<205) then   {restart game}
                begin
                  hidemouse;
                  drawbutton (250,180,2); delay (100);
                  drawbutton (250,180,1);
                  showmouse;
                  init_crackers;
                  init_systems;
                  new_player;
                  flag:=true;
                end;
              if (my>220) and (my<245) then  {cancel}
                begin
                  hidemouse;
                  drawbutton (250,220,2); delay (100);
                  drawbutton (250,220,1);
                  showmouse;
                  flag:=true;
                end;
            end;
        end;
    until flag=true;
  end;  {file_menu}

procedure items_menu (var item:integer);
  var
    mx,my:integer;
    mb:boolean;
  begin
    hidemouse;
    clear_monitor;
    setfillstyle (solidfill,blue); floodfill (320,200,8);
    settextjustify (centertext,toptext);
    settextstyle (smallfont,horizdir,8);
    setcolor (white);
    outtextxy (320,240,'One Stop'); outtextxy (320,270,'Hacking Shop');
    settextjustify (lefttext,toptext);
    settextstyle (triplexfont,horizdir,3);
    setcolor (lightblue);
    drawbutton (275,60,1); outtextxy (305,60,'Computers');
    drawbutton (275,90,1); outtextxy (305,90,'Backup Media');
    drawbutton (275,120,1); outtextxy (305,120,'Virus Shields');
    drawbutton (275,150,1); outtextxy (305,150,'Comm Progs');
    drawbutton (275,180,1); outtextxy (305,180,'Hack Progs');
    drawbutton (275,210,1); outtextxy (305,210,'Leave');
    showmouse;
    item:=0;
    repeat
      mouse_status (mx,my,mb);
      if mb then
        begin
          if (mx>275) and (mx<300) then
            begin
              if (my>60) and (my<85) then
                begin
                  hidemouse;
                  drawbutton (275,60,2); delay (100);
                  drawbutton (275,60,1);
                  showmouse;
                  item:=1;
                end;
              if (my>90) and (my<115) then
                begin
                  hidemouse;
                  drawbutton (275,90,2); delay (100);
                  drawbutton (275,90,1);
                  showmouse;
                  item:=2;
                end;
              if (my>120) and (my<145) then
                begin
                  hidemouse;
                  drawbutton (275,120,2); delay (100);
                  drawbutton (275,120,1);
                  showmouse;
                  item:=3;
                end;
              if (my>150) and (my<175) then
                begin
                  hidemouse;
                  drawbutton (275,150,2); delay (100);
                  drawbutton (275,150,1);
                  showmouse;
                  item:=4;
                end;
              if (my>180) and (my<205) then
                begin
                  hidemouse;
                  drawbutton (275,180,2); delay (100);
                  drawbutton (275,180,1);
                  showmouse;
                  item:=5;
                end;
              if (my>210) and (my<235) then
                begin
                  hidemouse;
                  drawbutton (275,210,2); delay (100);
                  drawbutton (275,210,1);
                  showmouse;
                  item:=6;
                end;
            end;
        end;
    until item>0;
  end;

procedure list_stock (pricefactor,item:integer);
  var
    gimme,y,i:integer;
    nums:string;
  begin
    hidemouse;
    clear_monitor;
    settextstyle (defaultfont,horizdir,1);
    settextjustify (lefttext,toptext);
    setcolor (lightmagenta);
    outtextxy (60,50,'Item Number      '+'Name / Cost');
    setcolor (magenta);
    line (60,60,555,60);
    y:=65;
    setcolor (white);
    for i:=1 to 20 do
      begin
        str (i,nums); outtextxy (60,y,nums);
        str (i*pricefactor,nums);
        case item of
           1:outtextxy (200,y,computer[i]+'----> $'+nums);
           2:outtextxy (200,y,backtype[i]+'----> $'+nums);
           3:outtextxy (200,y,mcaffee[i]+'----> $'+nums);
           4:outtextxy (200,y,comm[i]+'----> $'+nums);
           5:outtextxy (200,y,hack[i]+'----> $'+nums);
         end;
        inc (y,10);
      end;
    setcolor (magenta);
    line (60,y+5,555,y+5);
    setcolor (yellow);
    settextstyle (userfont,vertdir,7);
    settextjustify (centertext,centertext);
    outtextxy (440,175,'One Stop'); outtextxy (475,175,'Hacking Shop');
    settextstyle (sansseriffont,horizdir,2);
    settextjustify (lefttext,toptext);
    show_cash;
    {$I-}
    repeat
      outtextxy (75,y+10,'0 to Leave ');
      setcolor (white);
      setfillstyle (emptyfill,yellow);
      bar3d (260,y+12,555,getmaxy-50,5,topon);
      gotoxy (40,21);
      readln (gimme);
    until IOResult=0;
    {$I+}
    if (gimme>0) and (gimme<21) and (player.cash>=gimme*pricefactor) then
      begin
        if (player.cpulvl>=gimme-2) or (item=1) then
          begin
            dec (player.cash,gimme*pricefactor);
            case item of
               1:player.cpulvl:=gimme;
               2:player.backlvl:=gimme;
               3:player.shieldlvl:=gimme;
               4:player.commlvl:=gimme;
               5:player.pwdlvl:=gimme;
             end;
            clear_monitor;
            settextstyle (triplexfont,horizdir,4);
            settextjustify (centertext,toptext);
            setcolor (white);
            outtextxy (320,50,'Thank-you for shopping at');
            outtextxy (320,100,'the One Stop Hacking Shop');
            setcolor (lightblue);
            outtextxy (320,150,'No Refunds!');
          end
        else
          begin
            clear_monitor;
            settextstyle (triplexfont,horizdir,4);
            settextjustify (centertext,toptext);
            setcolor (white);
            outtextxy (320,50,'Sorry, this item');
            outtextxy (320,100,'is not compatible');
            outtextxy (320,150,'with your computer.');
          end;
        clickhere (300,200,lightcyan);
        mouse_range (0,0,getmaxx,getmaxy);
      end
    else
      begin
        sound (2400);delay (100);nosound;
      end;
  end;  {list_stock}

procedure buy;
  var
    mx,my,what:integer;
    mb:boolean;
  begin
    items_menu (what);
    case what of
      1:list_stock (250,what);
      2:list_stock (150,what);
      3:list_stock (100,what);
      4:list_stock (150,what);
      5:list_stock (175,what);
      6:exit;
    end;
  end;

procedure offermsg (offer:integer);
  var
    hold:string;
  begin
    setfillstyle (solidfill,black); bar (50,130,580,200);
    setcolor (lightblue);
    settextstyle (triplexfont,horizdir,3);
    settextjustify (centertext,toptext);
    outtextxy (320,130,'We will gladly give you');
    str (offer,hold);
    outtextxy (320,170,'$'+hold+' for it.');
  end;

procedure farewell (deal:boolean);
  begin
    clear_monitor;
    settextstyle (triplexfont,horizdir,4);
    settextjustify (centertext,toptext);
    setcolor (white);
    if deal then
      begin
        outtextxy (320,100,'It is a pleasure');
        outtextxy (320,150,'doing business with');
        outtextxy (320,200,'you.');
      end
    else
      begin
        outtextxy (320,100,'Maybe some');
        outtextxy (320,150,'other time then.');
      end;
    clickhere (300,250,lightmagenta);
    mouse_range (0,0,getmaxx,getmaxy);
  end;

procedure sell;
  var
    mx,my,what,high,low,price,gamble:integer;
    mb,argued,ok:boolean;
  begin
    argued:=false;
    items_menu (what);
    case what of
       1:if player.cpulvl=0 then exit;
       2:if player.backlvl=0 then exit;
       3:if player.shieldlvl=0 then exit;
       4:if player.commlvl=0 then exit;
       5:if player.pwdlvl=0 then exit;
       6:exit;
     end;
    hidemouse;
    clear_monitor;
    settextstyle (triplexfont,horizdir,3);
    settextjustify (centertext,toptext);
    setcolor (lightred);
    outtextxy (320,50,'So...you wish to sell your');
    setcolor (red);
    case what of
       1:begin
           outtextxy (320,90,computer[player.cpulvl]);
           high:=player.cpulvl*250-20;
           low:=player.cpulvl*250-75;
           price:=player.cpulvl*250-60;
         end;
       2:begin
           outtextxy (320,90,backtype[player.backlvl]);
           high:=player.backlvl*150-20;
           low:=player.backlvl*150-75;
           price:=player.backlvl*150-60;
         end;
       3:begin
           outtextxy (320,90,mcaffee[player.shieldlvl]);
           high:=player.shieldlvl*100-10;
           low:=player.shieldlvl*100-50;
           price:=player.shieldlvl*100-30;
         end;
       4:begin
           outtextxy (320,90,comm[player.commlvl]);
           high:=player.commlvl*150-20;
           low:=player.commlvl*150-80;
           price:=player.commlvl*150-65;
         end;
       5:begin
           outtextxy (320,90,hack[player.pwdlvl]);
           high:=player.pwdlvl*175-25;
           low:=player.pwdlvl*175-80;
           price:=player.pwdlvl*175-50;
         end;
     end;
    offermsg (price);
    settextstyle (smallfont,horizdir,6); settextjustify (lefttext,toptext);
    setcolor (lightgreen);
    drawbutton (60,270,1); outtextxy (90,270,'Argue');
    drawbutton (200,270,1); outtextxy (230,270,'Accept');
    drawbutton (400,270,1); outtextxy (430,270,'Forget it!');
    ok:=false;
    showmouse;
    repeat
      mouse_status (mx,my,mb);
      if mb then
        begin
          if (my>270) and (my<295) then
            begin
              if (mx>60) and (mx<85) and (argued=false) then
                begin
                  hidemouse;
                  drawbutton (60,270,2); delay (100);
                  drawbutton (60,270,1);
                  argued:=true;
                  randomize;
                  gamble:=random (3);
                  if gamble=2 then
                    price:=high
                  else
                    price:=low;
                  offermsg (price);
                  showmouse;
                end;
              if (mx>200) and (mx<225) then
                begin
                  hidemouse;
                  drawbutton (200,270,2); delay (100);
                  drawbutton (200,270,1);
                  farewell (true);
                  inc (player.cash,price);
                  case what of
                     1:player.cpulvl:=0;
                     2:player.backlvl:=0;
                     3:player.shieldlvl:=0;
                     4:player.commlvl:=0;
                     5:player.pwdlvl:=0;
                   end;
                  showmouse;
                  ok:=true;
                end;
              if (mx>400) and (mx<425) then
                begin
                  hidemouse;
                  drawbutton (400,270,2); delay (100);
                  drawbutton (400,270,1);
                  farewell (false);
                  showmouse;
                  ok:=true;
                end;
            end;
        end;
    until ok;
  end;

procedure shopping;
  var
    mx,my:integer;
    mb,flag:boolean;
  begin
    hidemouse;
    clear_monitor;
    settextstyle (sansseriffont,horizdir,3);
    settextjustify (centertext,toptext);
    setcolor (yellow);
    outtextxy (320,50,'Welcome to Wired World');
    setcolor (lightred);
    settextstyle (triplexfont,horizdir,3);
    outtextxy (320,100,'What would you like to do:');
    setcolor (lightgreen);
    settextjustify (lefttext,toptext);
    drawbutton (300,150,1); outtextxy (330,150,'Buy');
    drawbutton (300,200,1); outtextxy (330,200,'Sell');
    showmouse;
    flag:=false;
    repeat
      mouse_status (mx,my,mb);
      if mb then
        begin
          if (mx>300) and (mx<325) then
            begin
              if (my>150) and (my<175) then
                begin
                  hidemouse;
                  drawbutton (300,150,2); delay (100);
                  drawbutton (300,150,1);
                  showmouse;
                  buy;
                  flag:=true;
                end;
              if (my>200) and (my<225) then
                begin
                  hidemouse;
                  drawbutton (300,200,2); delay (100);
                  drawbutton (300,200,1);
                  showmouse;
                  sell;
                  flag:=true;
                end;
            end;
        end;
    until flag;
    showmouse;
  end;

procedure punk_specs (who:integer);
  var
    whos:string;
  begin
    clear_monitor;
    settextstyle (triplexfont,horizdir,4);
    settextjustify (centertext,toptext);
    outtextxy (320,50,'HACKERSCOPE');
    settextstyle (userfont,horizdir,5);
    settextjustify (lefttext,toptext);
    setcolor (lightred);
    setfillstyle (solidfill,lightblue);
    bar (60,90,575,300);
    setcolor (white);
    with cpunk[who] do
      begin
         outtextxy (280,100,'Alias        : '+alias);
         str (userlvl,whos);
         outtextxy (280,115,'Exp Level    : '+whos);
         str (cash,whos);
         outtextxy (280,130,'Cash         : '+whos);
         str (userlvl*10,whos);
         outtextxy (280,145,'HD Capacity  : '+whos);
         str (userlvl*10-megsgone,whos);
         outtextxy (280,160,'Megs Left    : '+whos);
         outtextxy (280,175,'Comm Program : '+comm[commlvl]);
         outtextxy (280,190,'Hack Program : '+hack[pwdlvl]);
         outtextxy (280,205,'Virus Shield : '+mcaffee[shieldlvl]);
         outtextxy (280,220,'Virus        : '+yervir[virlvl]);
         outtextxy (280,235,'Backup Media : '+backtype[backlvl]);
         outtextxy (280,250,'Computer     : '+computer[cpulvl]);
      end;
    clickhere (70,145,yellow);
    mouse_range (0,0,getmaxx,getmaxy);
  end;

procedure scope;
  var
    mx,my,who,cost:integer;
    mb,flag:boolean;
    num:string;
  begin
    hidemouse;
    clear_monitor;
    settextstyle (sansseriffont,horizdir,4);
    settextjustify (centertext,toptext);
    setcolor (lightcyan);
    outtextxy (320,50,'Hackerscope');
    setcolor (lightgreen);
    settextstyle (smallfont,horizdir,4);
    outtextxy (320,95,'This Will Cost You $100');
    settextstyle (userfont,horizdir,5);
    settextjustify (lefttext,toptext);
    drawbutton (60,270,1); outtextxy (90,270,'Next');
    drawbutton (200,270,1); outtextxy (230,270,'Previous');
    drawbutton (300,270,1); outtextxy (330,270,'Go');
    drawbutton (400,270,1); outtextxy (430,270,'Abort');
    settextstyle (triplexfont,horizdir,4);
    setcolor (yellow);
    flag:=false;
    who:=1;
    str (who,num);
    outtextxy (200,130,num);
    outtextxy (250,130,cpunk[who].alias);
    showmouse;
    while not(flag) do
      begin
        mouse_status (mx,my,mb);
        if mb then
          begin
            if (my>270) and (my<295) then
              begin
                if (mx>60) and (mx<85) then
                  begin
                    if who=20 then
                      who:=1
                    else
                      inc (who,1);
                    hidemouse;
                    drawbutton (60,270,2); delay (100);
                    drawbutton (60,270,1);
                    setfillstyle (solidfill,black);
                    bar (200,130,500,250);   {blank out the previous}
                    str (who,num);
                    outtextxy (200,130,num);
                    outtextxy (250,130,cpunk[who].alias);
                    showmouse;
                  end;
                if (mx>200) and (mx<225) then
                  begin
                   if who=1 then
                      who:=20
                    else
                      dec (who,1);
                    hidemouse;
                    drawbutton (200,270,2); delay (100);
                    drawbutton (200,270,1);
                    setfillstyle (solidfill,black);
                    bar (200,130,500,250);   {blank out the previous}
                    str (who,num);
                    outtextxy (200,130,num);
                    outtextxy (250,130,cpunk[who].alias);
                    showmouse;
                  end;
                if (mx>300) and (mx<325) then
                  begin
                    hidemouse;
                    drawbutton (300,270,2); delay (100);
                    drawbutton (300,270,1);
                    punk_specs (who);
                    flag:=true;
                    player.cash:=player.cash-100;
                    showmouse;
                  end;
                if (mx>400) and (mx<425) then
                  begin
                    hidemouse;
                    drawbutton (400,270,2); delay (100);
                    drawbutton (400,270,1);
                    flag:=true;
                    showmouse;
                  end;
              end;
          end;
      end;
  end;  {scope}

procedure the_end;
var
  gd,gm:integer;
  i,j,k:integer;
  seeme:char;
begin
  closegraph;
  initgrafx (VGA,VGAHi);
  if keypressed then
    seeme:=readkey;
  setcolor (blue);
  for i:=1 to 63 do
    begin
      line (1,i,getmaxx,i+417);
      line (1,i,getmaxx,(i+417) div 2);
      line (1,i,getmaxx,(i+417) div 3);
      line (1,i,getmaxx,(i+417) div 4);
      line (1,i,getmaxx,(i+417) div 5);
      line (1,i+417,getmaxx,i);
      line (1,(i+417) div 2,getmaxx,i);
      line (1,(i+417) div 3,getmaxx,i);
      line (1,(i+417) div 4,getmaxx,i);
      line (1,(i+417) div 5,getmaxx,i);
    end;
    setcolor (7);
    settextstyle (gothicfont,horizdir,7);
    settextjustify (centertext,toptext);
    outtextxy (265,-5,'You`ve done it!!');
    settextstyle (smallfont,horizdir,7);
    outtextxy (565,5,'You are the');
    outtextxy (565,25,'best hacker');
    outtextxy (565,45,'in the world!');
    outtextxy (320,70,'Unfortunately, with your extensive');
    outtextxy (320,90,'hacking you have developed a mild');
    outtextxy (320,110,'case of Carpal Tunnel Syndrome.  ');
    outtextxy (320,135,'You decide to use the proceeds from');
    outtextxy (320,155,'your exploits to treat yourself to');
    outtextxy (320,175,'a relaxing vacation in Tahiti.');
    outtextxy (320,195,'However, hijackers attempt to take');
    outtextxy (320,215,'control of the plane.  You waste no');
    outtextxy (320,235,'time and quickly disarm the elderly');
    outtextxy (320,255,'female terrorists.  You are a hero!');
    outtextxy (320,275,'You are offered many illustrious opportunites');
    outtextxy (320,295,'but decide to become a game programmer');
    outtextxy (320,315,'for a very small software company called');
    outtextxy (320,335,'HAXOFT.');
    settextstyle (triplexfont,horizdir,6);
    for i:=1 to 63 do
      setrgbpalette (7,i,i,i);
    setcolor (lightmagenta);
    outtextxy (320,375,'The End...');
    repeat
            setrgbpalette (1,i,0,i);
            setrgbpalette (0,0,0,i);
            if i=63 then
              j:=1;
            if i=0 then
              j:=0;
            if j=0 then
              begin
                inc (i);
              end
            else
              begin
                dec (i);
              end;
    until keypressed;
  closegraph;
  clrscr;
  writeln ('Hope you enjoyed playing C.U. by Jeff Marlow');
  writeln ('              -= Haxoft 1993 =-');
  halt;  {back to dos}
end;  {the_end}

procedure _box (x1,y1,x2,y2:integer;colr:word);
  var
    holder:word;
  begin
    holder:=getcolor;
    setcolor (colr);
    line (x1,y1,x2,y1); line (x2,y1,x2,y2);
    line (x2,y2,x1,y2); line (x1,y2,x1,y1);
    setcolor (holder);
  end; {box}

procedure choose_ikon (x,y,part:integer);
  begin
    case part of
      1:putimage (x,y,icon[18]^,normalput);
      2:putimage (x,y,icon[19]^,normalput);
      3:putimage (x,y,icon[20]^,normalput);
      4:putimage (x,y,icon[21]^,normalput);
      5:putimage (x,y,icon[22]^,normalput);
      6:putimage (x,y,icon[23]^,normalput);
      7:putimage (x,y,icon[24]^,normalput);
      8:putimage (x,y,icon[25]^,normalput);
      9:putimage (x,y,icon[16]^,normalput);
      10:putimage (x,y,icon[17]^,normalput);
    end;
  end;  {choose_ikon}

procedure crossout (position,qorx:integer);
  begin
    case position of
      1: choose_ikon (350,90,qorx);
      2: choose_ikon (400,90,qorx);
      3: choose_ikon (450,90,qorx);
      4: choose_ikon (500,90,qorx);
      5: choose_ikon (350,140,qorx);
      6: choose_ikon (400,140,qorx);
      7: choose_ikon (450,140,qorx);
      8: choose_ikon (500,140,qorx);
      9: choose_ikon (350,190,qorx);
      10:choose_ikon (400,190,qorx);
      11:choose_ikon (450,190,qorx);
      12:choose_ikon (500,190,qorx);
      13:choose_ikon (350,240,qorx);
      14:choose_ikon (400,240,qorx);
      15:choose_ikon (450,240,qorx);
      16:choose_ikon (500,240,qorx);
    end;
  end; {crossout}

function check_match (tile1,tile2:integer):integer;
  begin
    if matrix[tile1].partnum=matrix[tile2].partnum then
      begin
        matrix[tile1].occupied:=false;
        matrix[tile2].occupied:=false;
        crossout (tile1,10);
        crossout (tile2,10);
        check_match:=1;
      end
    else
      begin
        crossout (tile1,9);
        crossout (tile2,9);
        matrix[tile1].showing:=false;
        matrix[tile2].showing:=false;
        check_match:=0;
      end;
  end;  {check_match}

procedure trashed (item:integer);
  begin
    settextstyle (smallfont,horizdir,4);
    settextjustify (lefttext,toptext);
    setcolor (item+7);
    case item of
      1:outtextxy (75,185,'1.  User List');
      2:outtextxy (75,200,'2.  Public Files');
      3:outtextxy (75,215,'3.  Private Files');
      4:outtextxy (75,230,'4.  Data Files');
      5:outtextxy (75,245,'5.  System Log');
      6:outtextxy (75,260,'6.  System Files');
      7:outtextxy (75,275,'7.  Text Files');
      8:outtextxy (75,290,'8.  Top Secret Files');
    end;
  end; {trashed}

procedure update_time_bar (min,sec:word);
  var
    i,modules:integer;
    smin,ssec:string;
    oldfont:textsettingstype;
  begin
    modules:=(min*60)+sec;
    gettextsettings (oldfont);
    settextstyle (defaultfont,horizdir,2);
    settextjustify (centertext,toptext);
    hidemouse;
    setcolor (lightred);
    for i:=70 to 70+modules do
      line (i,110,i,135);
    setcolor (blue);
    for i:=70+modules+1 to 300 do
      line (i,110,i,135);
    str (min,smin); str (sec,ssec);
    if length (ssec)=1 then
      insert ('0',ssec,1);
    setcolor (white);
    outtextxy (185,115,smin+':'+ssec);
    showmouse;
    with oldfont do
      begin
        settextstyle (font,direction,charsize);
        settextjustify (horiz,vert);
      end;
  end;  {update_time_bar}

procedure sys_decide (winorlose,lvl:integer);
  var
    mx,my,i,j:integer;
    mb:boolean;
    legal,earned:string;
  begin
    hidemouse;
    clear_monitor;
    settextstyle (gothicfont,horizdir,4);
    settextjustify (centertext,toptext);
    case winorlose of
      0:begin  {player loses}
          i:=player.userlvl*50;
          str (i,legal);
          setcolor (white);
          outtextxy (320,50,'Your phone line has been traced.');
          outtextxy (320,80,'The police kick down');
          outtextxy (320,105,'your door and they');
          setcolor (yellow);
          outtextxy (320,135,'take your computer!');
          settextstyle (smallfont,horizdir,5);
          setcolor (lightgreen);
          outtextxy (320,210,'When you get it back your hacking program');
          outtextxy (320,230,'is gone!');
          outtextxy (320,250,'Legal fees cost you $'+legal);
          if player.cash > i then
            dec (player.cash,i)
          else
            player.cash:=0;
          player.pwdlvl:=0;
          i:=1;
          j:=0;
          setcolor (lightblue);
          outtextxy (320,280,' CLICK THE MOUSE ');
          mouse_range (getmaxx,getmaxy,getmaxx,getmaxy);
          showmouse;
          repeat
            mouse_status (mx,my,mb);
            setrgbpalette (0,i,0,0);
            if i=63 then
              j:=1;
            if i=0 then
              j:=0;
            if j=0 then
              inc (i)
            else
              dec (i);
            sound (i+125);
          until mb;
          nosound;
          setrgbpalette (0,0,0,0);
        end;
      1:begin
          settextstyle (triplexfont,horizdir,4);
          settextjustify (centertext,toptext);
          setcolor (white);
          outtextxy (320,60,'You have successfully');
          outtextxy (320,90,'destroyed the');
          outtextxy (320,120,sys[lvl].name+ ' system!');
          setcolor (lightblue);
          outtextxy (320,175,'You feel a surge of power...');
          settextstyle (smallfont,horizdir,6);
          setcolor (cyan);
          str (sys[lvl].cash,earned);
          inc (player.cash,sys[lvl].cash);
          inc (player.userlvl,lvl);
          sys[lvl].hacked:=true;
          outtextxy (320,225,'You just earned a cool $'+earned);
          clickhere (310,270,lightcyan);
          if lvl=25 then
            the_end;        {The Game Is Finished!!!}
        end;
     end;
    mouse_range (0,0,getmaxx,getmaxy);
  end;   {sys_decide}

procedure too_lame;
  var
    i:integer;
  begin
    settextstyle (userfont,horizdir,5);
    settextjustify (lefttext,toptext);
    i:=60;
    repeat
      setcolor (lightgreen);
      outtextxy (240,i,'Attempting...');
      setcolor (green);
      delay (175);
      outtextxy (360,i,'Unsuccessful.');
      inc (i,40);
    until (i>180);
    setcolor (lightcyan);
    settextstyle (sansseriffont,horizdir,4);
    settextjustify (centertext,toptext);
    outtextxy (320,220,hack[player.pwdlvl]+' cannot break in.');
    clickhere (310,260,white);
    mouse_range (0,0,getmaxx,getmaxy);
  end;  {too_lame}

procedure battlesys (who:integer);
  var
    mx,my,tx,ty,tile,i,j,temp,faceup,matched:integer;
    mb,bool,timeup:boolean;
    sysh,sysm,syss,sys100,lasts,ls100:word;
  begin
    clear_monitor;
    if (player.pwdlvl<who) and (who<20) then
      begin
        too_lame;
        exit;
      end
    else if (who>20) and (player.pwdlvl<20) then
      begin
        too_lame;
        exit;
      end;
    for i:=1 to 16 do
      matrix[i].occupied:=false;
    for j:=1 to 2 do
      begin
        for i:=1 to 8 do
          begin
            bool:=false;
            while not (bool) do
              begin
                repeat
                  randomize;
                  temp:=random(17);
                until temp>0;
                if not(matrix[temp].occupied) then
                  begin
                    matrix[temp].occupied:=true;
                    matrix[temp].partnum:=i;
                    matrix[temp].showing:=false;
                    bool:=true;
                  end;
              end;
          end;
      end;
    settextstyle (sansseriffont,horizdir,3);
    settextjustify (lefttext,toptext);
    setcolor (lightred);
    outtextxy (350,50,sys[who].name);
    tx:=350; ty:=90; tile:=1;
    while tile<17 do
      begin
        putimage (tx,ty,icon[16]^,normalput);
        if tile mod 4=0 then
          begin
            inc (ty,50);
            tx:=350;
          end
        else
          inc (tx,50);
        inc (tile);
      end;
    setcolor (green);
    line (60,180,330,180);
    line (60,100,310,100);
    _box (60,150,330,303,lightgreen);
    _box (60,50,310,140,green);
    setcolor (white);
    outtextxy (75,150,'File Types Trashed');
    settextstyle (triplexfont,horizdir,3);
    outtextxy (75,50,'Time Bar');
    settextstyle (userfont,horizdir,5);
    outtextxy (90,85,'You are being traced');
    mouse_range (350,90,550,290);
    timeup:=false;
    faceup:=0;
    matched:=0;
    showmouse;
    update_time_bar (sys[who].min,sys[who].sec);
    gettime (sysh,sysm,syss,sys100);
    lasts:=syss;
    ls100:=0;
    repeat
      mouse_status (mx,my,mb);
      gettime (sysh,sysm,syss,sys100);
      if (syss>lasts) or ((syss=0) and (ls100=0)) then
        begin
          lasts:=syss;
          if syss=0 then
            ls100:=1
          else
            ls100:=0;
          case sys[who].sec of
            0:begin
                sys[who].sec:=59;
                sys[who].min:=sys[who].min-1;
              end;
            else
              sys[who].sec:=sys[who].sec-1;
           end;
          update_time_bar (sys[who].min,sys[who].sec);
        end;
      if (sys[who].min=0) and (sys[who].sec=0) then
        timeup:=true;
      if mb then
        begin
          if (mx<400) and (my<140) then
            begin
              if not(matrix[1].showing) and (matrix[1].occupied) then
                begin
                  hidemouse;
                  choose_ikon (350,90,matrix[1].partnum);
                  matrix[1].showing:=true;
                  if faceup=0 then
                    faceup:=1
                  else
                    begin
                      if check_match (1,faceup)>0 then
                        trashed (matrix[1].partnum);
                      matched:=matched+check_match (1,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>400) and (mx<450) and (my<140) then
            begin
              if not(matrix[2].showing) then
                begin
                  hidemouse;
                  choose_ikon (400,90,matrix[2].partnum);
                  matrix[2].showing:=true;
                  if faceup=0 then
                    faceup:=2
                  else
                    begin
                      if check_match (2,faceup)>0 then
                        trashed (matrix[2].partnum);
                      matched:=matched+check_match (2,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>450) and (mx<500) and (my<140) then
            begin
              if not(matrix[3].showing) then
                begin
                  hidemouse;
                  choose_ikon (450,90,matrix[3].partnum);
                  matrix[3].showing:=true;
                  if faceup=0 then
                    faceup:=3
                  else
                    begin
                      if check_match (3,faceup)>0 then
                        trashed (matrix[3].partnum);
                      matched:=matched+check_match (3,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>500) and (my<140) then
            begin
              if not(matrix[4].showing) then
                begin
                  hidemouse;
                  choose_ikon (500,90,matrix[4].partnum);
                  matrix[4].showing:=true;
                  if faceup=0 then
                    faceup:=4
                  else
                    begin
                      if check_match (4,faceup)>0 then
                        trashed (matrix[4].partnum);
                      matched:=matched+check_match (4,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx<400) and (my>140) and (my<190) then
            begin
              if not(matrix[5].showing) then
                begin
                  hidemouse;
                  choose_ikon (350,140,matrix[5].partnum);
                  matrix[5].showing:=true;
                  if faceup=0 then
                    faceup:=5
                  else
                    begin
                      if check_match (5,faceup)>0 then
                        trashed (matrix[5].partnum);
                      matched:=matched+check_match (5,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>400) and (mx<450) and (my>140) and (my<190) then
            begin
              if not(matrix[6].showing) then
                begin
                  hidemouse;
                  choose_ikon (400,140,matrix[6].partnum);
                  matrix[6].showing:=true;
                  if faceup=0 then
                    faceup:=6
                  else
                    begin
                      if check_match (6,faceup)>0 then
                        trashed (matrix[6].partnum);
                      matched:=matched+check_match (6,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>450) and (mx<500) and (my>140) and (my<190) then
            begin
              if not(matrix[7].showing) then
                begin
                  hidemouse;
                  choose_ikon (450,140,matrix[7].partnum);
                  matrix[7].showing:=true;
                  if faceup=0 then
                    faceup:=7
                  else
                    begin
                      if check_match (7,faceup)>0 then
                        trashed (matrix[7].partnum);
                      matched:=matched+check_match (7,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>500) and (my>140) and (my<190) then
            begin
              if not(matrix[8].showing) then
                begin
                  hidemouse;
                  choose_ikon (500,140,matrix[8].partnum);
                  matrix[8].showing:=true;
                  if faceup=0 then
                    faceup:=8
                  else
                    begin
                      if check_match (8,faceup)>0 then
                        trashed (matrix[8].partnum);
                      matched:=matched+check_match (8,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx<400) and (my>190) and (my<240) then
            begin
              if not(matrix[9].showing) then
                begin
                  hidemouse;
                  choose_ikon (350,190,matrix[9].partnum);
                  matrix[9].showing:=true;
                  if faceup=0 then
                    faceup:=9
                  else
                    begin
                      if check_match (9,faceup)>0 then
                        trashed (matrix[9].partnum);
                      matched:=matched+check_match (9,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>400) and (mx<450) and (my>190) and (my<240) then
            begin
              if not(matrix[10].showing) then
                begin
                  hidemouse;
                  choose_ikon (400,190,matrix[10].partnum);
                  matrix[10].showing:=true;
                  if faceup=0 then
                    faceup:=10
                  else
                    begin
                      if check_match (10,faceup)>0 then
                        trashed (matrix[10].partnum);
                      matched:=matched+check_match (10,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>450) and (mx<500) and (my>190) and (my<240) then
            begin
              if not(matrix[11].showing) then
                begin
                  hidemouse;
                  choose_ikon (450,190,matrix[11].partnum);
                  matrix[11].showing:=true;
                  if faceup=0 then
                    faceup:=11
                  else
                    begin
                      if check_match (11,faceup)>0 then
                        trashed (matrix[11].partnum);
                      matched:=matched+check_match (11,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>500) and (my>190) and (my<240) then
            begin
              if not(matrix[12].showing) then
                begin
                  hidemouse;
                  choose_ikon (500,190,matrix[12].partnum);
                  matrix[12].showing:=true;
                  if faceup=0 then
                    faceup:=12
                  else
                    begin
                      if check_match (12,faceup)>0 then
                        trashed (matrix[12].partnum);
                      matched:=matched+check_match (12,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx<400) and (my>240) then
            begin
              if not(matrix[13].showing) then
                begin
                  hidemouse;
                  choose_ikon (350,240,matrix[13].partnum);
                  matrix[13].showing:=true;
                  if faceup=0 then
                    faceup:=13
                  else
                    begin
                      if check_match (13,faceup)>0 then
                        trashed (matrix[13].partnum);
                      matched:=matched+check_match (13,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>400) and (mx<450) and (my>240) then
            begin
              if not(matrix[14].showing) then
                begin
                  hidemouse;
                  choose_ikon (400,240,matrix[14].partnum);
                  matrix[14].showing:=true;
                  if faceup=0 then
                    faceup:=14
                  else
                    begin
                      if check_match (14,faceup)>0 then
                        trashed (matrix[14].partnum);
                      matched:=matched+check_match (14,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>450) and (mx<500) and (my>240) then
            begin
              if not(matrix[15].showing) then
                begin
                  hidemouse;
                  choose_ikon (450,240,matrix[15].partnum);
                  matrix[15].showing:=true;
                  if faceup=0 then
                    faceup:=15
                  else
                    begin
                      if check_match (15,faceup)>0 then
                        trashed (matrix[15].partnum);
                      matched:=matched+check_match (15,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
          if (mx>500) and (my>240) then
            begin
              if not(matrix[16].showing) then
                begin
                  hidemouse;
                  choose_ikon (500,240,matrix[16].partnum);
                  matrix[16].showing:=true;
                  if faceup=0 then
                    faceup:=16
                  else
                    begin
                      if check_match (16,faceup)>0 then
                        trashed (matrix[16].partnum);
                      matched:=matched+check_match (16,faceup);
                      faceup:=0;
                    end;
                  showmouse;
                end;
            end;
        end;
    until (matched=8) or (timeup);
    mouse_range (0,0,getmaxx,getmaxy);
    if timeup then
      sys_decide (0,who)
    else
      sys_decide (1,who);
  end;

procedure big_systems;
  var
    mx,my,who,maxs:integer;
    mb:boolean;
    flag:boolean;
    num:string;
  begin
    hidemouse;
    clear_monitor;
    setfillstyle (solidfill,blue);
    bar (50,45,590,305);
    settextstyle (triplexfont,horizdir,4);
    settextjustify (centertext,toptext);
    setcolor (yellow);
    outtextxy (320,55,'Systems...');
    settextstyle (userfont,horizdir,5);
    settextjustify (lefttext,toptext);
    setcolor (lightblue);
    drawbutton (60,270,1); outtextxy (90,270,'Next');
    drawbutton (150,270,1); outtextxy (180,270,'Previous');
    drawbutton (300,270,1); outtextxy (330,270,'Go');
    drawbutton (400,270,1); outtextxy (430,270,'Abort');
    settextstyle (triplexfont,horizdir,4);
    flag:=false;
    who:=1;
    if sys[who].hacked then
      setcolor (darkgray)
    else
      setcolor (lightgreen);
    maxs:=sys[0].cash;
    str (who,num);
    outtextxy (150,130,num);
    outtextxy (200,130,sys[who].name);
    showmouse;
    while not(flag) do
      begin
        mouse_status (mx,my,mb);
        if mb then
          begin
            if (my>270) and (my<295) then
              begin
                if (mx>60) and (mx<85) then
                  begin
                    if who=maxs then
                      who:=1
                    else
                      inc (who,1);
                    hidemouse;
                    drawbutton (60,270,2); delay (100);
                    drawbutton (60,270,1);
                    setfillstyle (solidfill,blue);
                    bar (150,130,585,250);   {blank out the previous}
                    str (who,num);
                    if sys[who].hacked then
                      setcolor (darkgray)
                    else
                      setcolor (lightgreen);
                    outtextxy (150,130,num);
                    outtextxy (200,130,sys[who].name);
                    showmouse;
                  end;
                if (mx>150) and (mx<180) then
                  begin
                   if who=1 then
                      who:=maxs
                   else
                      dec (who,1);
                    hidemouse;
                    drawbutton (150,270,2); delay (100);
                    drawbutton (150,270,1);
                    setfillstyle (solidfill,blue);
                    bar (150,130,585,250);   {blank out the previous}
                    str (who,num);
                    if sys[who].hacked then
                      setcolor (darkgray)
                    else
                      setcolor (lightgreen);
                    outtextxy (150,130,num);
                    outtextxy (200,130,sys[who].name);
                    showmouse;
                  end;
                if (mx>300) and (mx<325) then
                  begin
                    hidemouse;
                    drawbutton (300,270,2); delay (100);
                    drawbutton (300,270,1);
                    if not(sys[who].hacked) then
                       battlesys (who);
                    flag:=true;
                    showmouse;
                  end;
                if (mx>400) and (mx<425) then
                  begin
                    hidemouse;
                    drawbutton (400,270,2); delay (100);
                    drawbutton (400,270,1);
                    flag:=true;
                    showmouse;
                  end;
              end;
          end;
      end;
  end;

procedure options;
  begin
    setcolor (lightgreen);
    settextstyle (userfont,horizdir,4);
    settextjustify (lefttext,toptext);
    putimage (55,50,icon[4]^,normalput);
    outtextxy (95,50,'Load/save/restart');
    putimage (55,80,icon[7]^,normalput);
    outtextxy (95,80,'Wired World (Buy/Sell)');
    putimage (55,110,icon[6]^,normalput);
    outtextxy (95,110,'Crack BBS/Corporate/Government systems');
    putimage (55,140,icon[10]^,normalput);
    outtextxy (95,140,'Battle with another cracker');
    putimage (55,170,icon[14]^,normalput);
    outtextxy (95,170,'Attempt bank run');
    putimage (55,200,icon[8]^,normalput);
    outtextxy (95,200,'Download a new virus');
    putimage (55,230,icon[9]^,normalput);
    outtextxy (95,230,'Restore HD megs');
    putimage (55,260,icon[15]^,normalput);
    outtextxy (95,260,'Scope a cyberpunk [$100.00]');
  end;

procedure start_game;
  var
    i,mx,my:integer;
    mb,flag:boolean;
  begin
    flag:=false;
    hidemouse;
    clear_monitor;
    player_status;
    options;
    showmouse;
    while flag=false do
      begin
        mouse_status (mx,my,mb);
        if mb=true then
          begin
            if (565<mx) and (mx<585) and (317<my) and (my<330) then
              begin    {they hit the power button so quit}
                closegraph;
                flag:=true;
              end;
            if (mx>=55) and (mx<=85) then
              begin
                if (my>50) and (my<75) then  {save game}
                  begin
                    file_menu;
                    hidemouse;
                    clear_monitor;
                    player_status;
                    options;
                    showmouse;
                  end;
                if (my>80) and (my<105) then  {shopping online}
                  begin
                    shopping;
                    hidemouse;
                    clear_monitor;
                    player_status;
                    options;
                    showmouse;
                  end;
                if (my>110) and (my<135) then   {crash corporate/bbses}
                  begin
                    if (player.megsgone<player.userlvl*10) and
                       (player.cpulvl>0) and (player.commlvl>0) and
                       (player.pwdlvl>0) then
                      begin
                        big_systems;
                        hidemouse;
                        clear_monitor;
                        player_status;
                        options;
                        showmouse;
                      end
                    else
                      begin
                        sound (2400);delay (100);nosound;  {warning beep}
                      end;
                  end;
                if (my>140) and (my<165) then   {battle}
                  begin
                    if (player.megsgone<player.userlvl*10) and
                       (player.cpulvl>0) and (player.commlvl>0) then
                      begin
                        battle;
                        hidemouse;
                        clear_monitor;
                        player_status;
                        options;
                        showmouse;
                      end
                    else
                      begin
                        sound (2400);delay (100);nosound;  {warning beep}
                      end;
                  end;
                if (my>170) and (my<195) then  {Bank run}
                  begin
                    if (player.cpulvl>0) then
                      begin
                        bank_run;
                        hidemouse;
                        clear_monitor;
                        player_status;
                        options;
                        showmouse;
                      end
                    else
                      begin
                        sound (2400);delay (100);nosound;  {warning beep}
                      end;
                  end;
                if (my>200) and (my<225) then   {virus download}
                  begin
                    hidemouse;
                    download_vir;
                    hidemouse;
                    clear_monitor;
                    player_status;
                    options;
                    showmouse;
                  end;
                if (my>230) and (my<255) then
                  begin
                    if not(player.megsgone=0) then
                      begin
                        restore_megs;
                        hidemouse;
                        clear_monitor;
                        player_status;
                        options;
                        showmouse;
                      end
                    else
                      begin
                        sound (2400);delay (100);nosound;  {warning beep}
                      end;
                  end;
                if (my>260) and (my<290) then
                  begin
                    if player.cash>=100 then
                      begin
                        scope;
                        hidemouse;
                        clear_monitor;
                        player_status;
                        options;
                        showmouse;
                      end
                    else
                      begin
                        sound (2400);delay (100);nosound;  {warning beep}
                      end;
                  end;
              end;
          end;
      end;
  end;

procedure bootup;
  var
    msx,msy:integer;
    b,flag:boolean;
  begin
    clear_monitor;
    flag:=false;
    setcolor (lightgreen);
    settextstyle (gothicfont,horizdir,5);
    settextjustify (lefttext,centertext);
    putimage (80,50,icon[1]^,normalput);
    outtextxy (185,97,'Start A New Game');
    putimage (80,170,icon[2]^,normalput);
    outtextxy (185,220,'Restore An Old Game');
    showmouse;
    mouse_range (0,0,639,349);   {set the mouse range to the whole screen}
    mouse_here (getmaxx div 2,getmaxy div 2);  {put it in the middle}
    repeat
      mouse_status (msx,msy,b);
      if b=true then
        begin
          if (80<msx) and (msx<180) and (50<msy) and (msy<145) then
            begin    {start a new game}
              init_crackers;
              init_systems;
              new_player;
              flag:=true;
            end
          else if (80<msx) and (msx<180) and (170<msy) and (msy<270) then
            begin    {restore a game}
              init_crackers;
              init_systems;
              load_game (flag);
              if flag=false then
                begin
                  hidemouse;
                  clear_monitor;
                  setcolor (lightgreen);
                  settextstyle (gothicfont,horizdir,5);
                  settextjustify (lefttext,centertext);
                  putimage (80,50,icon[1]^,normalput);
                  outtextxy (185,97,'Start A New Game');
                  putimage (80,170,icon[2]^,normalput);
                  outtextxy (185,220,'Restore An Old Game');
                  showmouse;
                end;
            end
          else if (565<msx) and (msx<585) and (317<msy) and (msy<330) then
            begin    {they hit the power button so quit}
              closegraph;
              halt;
            end;
        end;
    until flag=true;
  end;


begin  {main}
  clrscr;
  if installed=false then
    begin
      textcolor (red+blink);
      writeln ('Error: mouse not detected!');
      textcolor (lightgray);
      writeln ('Sorry, C.U. requires a mouse to play.');
      halt;
    end
  else
      change_cursor;
  userfont:=installuserfont ('jeff.chr');
  title_screen;
  program_data;
  load_graphics;
  bootup;
  start_game;
  closegraph;
end.  {main}

