/* Ngpaint Version 1.0
 * 
 * For Details look at 
 * http://www.geocities.com/SiliconValley/2926/txt/NGpaint.html
 *
 * 
 * ----------------------------------------
 * Sep 28 1999  - josef.chmel@gmx.de
 *
 * Initialization.
 * Sorry no comments in the moment.
 * Look in Ngpaint.java.
 * ----------------------------------------
 */


import java.awt.*;

//****************************************
public class GraphicButton extends Panel {
    boolean raised=true;        
    Image img;
    String label;
    Color labelColor;
    int tag;

    public GraphicButton( Image img ) {
	this.img = img;
    }

    public GraphicButton( Image img, String label, Color color ) {
	this.img = img;
	this.label = label;
	labelColor = color;
	setForeground(Color.lightGray);
    }
 
    public GraphicButton( String label, Color color ) {
	this.label = label;
	labelColor = color;
    }

    public Dimension preferredSize() {
	return new Dimension(30,30);
    }

    public void paint( Graphics g) {
	Dimension d = size();

	if(img != null) {
	    if(raised) {
		g.drawImage(img, 1, 1, 28, 28, this);
	    } else {
		g.drawImage(img, 2, 2, 29, 29, this);		
	    }
	}
	if((label!=null) && (img==null)) {
	    g.setColor(labelColor);
	    g.drawString(label, 1, d.height-2);
	}
 	drawMy3DRect(g, 0, 0, 30, 30, raised, 3);
	
    }

    public static void drawMy3DRect(Graphics g, int x, int y, int w, int h, boolean raised, int bw) {
	int i;

	for(i=0; i<bw; i++) {
	    g.draw3DRect(x+i, y+i, w-i, h-i, raised);
	}
	    

    }

}

