
{}
{ DBFSERV  Version: 1.0 (10.IV.1998) }
{ Copyrigth (c) 1998 by Antivivisektion@t-online.de }
{ comes with NO WARRANTY - please read the disclaimer in DBFSERV.DOC }
{}

{$A+,B-,D+,E-,F-,G+,I+,L+,N+,O-,P+,Q+,R+,S+,T+,V+,X+,Y+}
{$I-,S-,R-,Q-}

Unit DBFSERV;
Interface

{ ----- Some runtime-settings and one TYPE ------------------------------- }
{ | }
{ | } Const
{ | }   CacheHits: LongInt = 0; { little statistics }
{ | }   CacheMiss: LongInt = 0; { ... }
{ | }   AutoTrim: Boolean = TRUE; { perform an RTRIM on all string-fields }
{ | }   BatchMode: Boolean = FALSE; { TRUE = no Halt after CreateUnit }
{ | } Type
{ | }   Number = Single; { our type for "N"umber-fields }
{ | }

{ ----- One-Time user-interface to create the dbf-Units ------------------ }
{ | }
{ | } Procedure CreateUnit(dbfpath,dbfname: String);
{ | } Procedure Help;
{ | }

{ ----- This interface is used by all the created dbf-Units. ------------- }
{ |      *** DON'T CALL THESE FUNCTIONS DIRECTLY! ***                       }
{ | }
{ | } Procedure dbf_Open(Var f: File);
{ | } Procedure dbf_Close(Var f: File);
{ | } Function dbf_RECNO(Var f: File): LongInt;
{ | } Procedure dbf_Get(Var f: File; t: Char; r: LongInt; o,l,d: Word);
{ | }
{ | } Const UpLink: Pointer = @dbf_Get;
{ | } Type
{ | }   CacheArray = Array[Byte] Of Char;
{ | }   FileRec = record
{ | }     Handle,Mode,RecSize: Word;
{ | }     Private: array[1..26] of Byte;
{ | }     HS,RS: Word;
{ | }     OldExit: Pointer;
{ | }     Cache: ^CacheArray;
{ | }     InCache: LongInt;
{ | }     Name: array[0..79] of Char;
{ | }   End;
{ | }

Implementation
Uses DOS; { Import TEXTREC }

{ ----- Creates a special unit for the specified dbf-file ---------------- }
{ | }
{ | }  Procedure CreateUnit(dbfpath,dbfname: String);
{ | }

{ some internal datastructs }
Var
  Fields: Record Name: Array [1..11] of Char; Typ: Char; x: LongInt;
  Len: Byte; Dec: Byte; Res: Array [18..31] of Char; End;
  f: File; i,j,Off: Word; o: TEXT;

  Function Upper(s: String): String;
  var i: Word;
  Begin
    for i := 1 To Length(s) Do s[i] := UpCase(s[i]);
    Upper := s;
  End;

  Procedure Abort(What: String);
  Var IO: Byte;
  Begin
    IO := IOResult;
    WriteLn('Runtime-Error ',IO,' on ',What,'');
    Case IO Of
      2: Writeln('file not found');
      3: Writeln('path not found');
      4: Writeln('too many open files (no handles available)');
      5: Writeln('access denied');
    End;
    Halt;
  End;

Begin
  Help;
  If (InOutRes <> 0) Then Abort('Entry CREATEUNIT');
  If (dbfpath[length(dbfpath)] <> '\')
     Then
       Begin
         Inc(dbfpath[0]);
         dbfpath[length(dbfpath)] := '\';
       End;
  Assign(f,dbfpath+dbfname+'.dbf');
  dbf_Open(f);
  IF (InOutRes <> 0) Then Abort('Open '+dbfpath+dbfname+'.dbf for read');

{ DEL (generic field) = 1. Field, Typ: L, offset: 0, Size: 1 Byte }
  With Fields Do
  Begin
    Name[1] := 'D'; Name[2] := 'E'; Name[3] := 'L'; Name[4] := #0;
    Typ := 'L'; Off := 0; Len := 1; Dec := 0;
  End;

  Assign(o,dbfname+'.pas');
  Rewrite(o);
  IF (InOutRes <> 0)
     Then Abort('Open '+dbfname+'.pas for writing');

  WriteLn(o,'{$A+,B-,D+,E-,F-,G+,I+,L+,N+,O-,P+,Q+,R+,S+,T+,V+,X+,Y+}');
  WriteLn(o,'{$I+,S-,R-,Q-}');
  WriteLn(o,'Unit ',Upper(dbfName),';');
  WriteLn(o,'Interface');
  WriteLn(o,'Uses DBFSERV;');
  WriteLn(o);
  WriteLn(o,'Const dbfName: String[63] = ''',dbfpath+dbfname,'.dbf'';');
  WriteLn(o,'  RECPTR: LongInt = 1;');
  WriteLn(o,'Var F: FILE;');
  WriteLn(o);
  WriteLn(o,'Procedure Open;');
  WriteLn(o,'Procedure Close;');
  WriteLn(o,'Function RECNO: LongInt;');
  WriteLn(o);
  Off := 0;
  For i := 0 To (FileRec(f).HS-33) Div 32 Do
  With Fields Do
  Begin
    If (i <> 0)
       Then
         Begin
           If (i = 1) Then Seek(f,32);
           BlockRead(f,Fields,SizeOf(Fields));
           IF (InOutRes <> 0) Then Abort('Read '+dbfpath+dbfname+'.dbf');
         End;

    j := Pos(#0,Name)-1;
    Write(o,'Function ',Copy(Name,1,j),': ');
    Case Typ Of
      'L': Write(o,'Boolean');
      'C': Write(o,'String');
      'N': Write(o,'Number');
      'D': Write(o,'String');
      Else Begin Write('Unknown typ: ',Typ,', Name: ',Name); RunError(201); End;
    End;
{ Function dbf_Get(Var f: File; t: Char; r: LongInt; o,l,d: Word): ?; }
    Write(o,'; { ',TYP,' L',LEN,' D',DEC,' @',OFF,' } Inline(');
{$IFOPT G+} { uses PUSH IMM8 and PUSH IMM16 }
    Write(o,'$1E/');
    If (Ofs(f) > $7F) Then Write(o,'$68/>f/') Else Write(o,'$6A/<f/');
    If (Byte(Typ) > $7F) Then Write(o,'$68/>',Ord(Typ),'/')
       Else Write(o,'$6A/<',Ord(Typ),'/');
    Write(o,#13#10'$FF/$36/>RECPTR+2/$FF/$36/>RECPTR');
    If (Off > $7F) Then Write(o,'/$68/>',Off) Else Write(o,'/$6A/<',Off);
    If (LEN > $7F) Then Write(o,'/$68/>',LEN) Else Write(o,'/$6A/<',LEN);
    If (DEC > $7F) Then Write(o,'/$68/>',DEC) Else Write(o,'/$6A/<',DEC);
{$ELSE}
    WriteLn(o,'$1E/$B8/>f/$50/ $B0/<',Ord(Typ),'/$50 /$FF/$36/');
    Write(o,'>RECPTR+2/$FF/$36/>RECPTR/  $B8/>',Off,'/$50/');
    Write(o,'$B8/>',Len,'/$50/ $B8/>',DEC,'/$50');
{$ENDIF}
    WriteLn(o,'/$FF/$1E/>UpLink);');
    Inc(Off,Len);
    { PUSH WORD PTR [DATA] = $FF/$36/>DATA }
    { PUSH WORD DATA       = $68/>DATA     }
    { PUSH BYTE DATA       = $6A/<DATA     }
    { MOV AX,DATA; PUSH AX = $B8/>DATA/$50 }
  End;
  WriteLn(o);
  WriteLn(o,'Implementation');
  WriteLn(o);
  WriteLn(o,'Procedure Open;');
  WriteLn(o,'Begin');
  WriteLn(o,'  dbf_Open(f);');
  WriteLn(o,'End;');
  WriteLn(o);
  WriteLn(o,'Procedure Close;');
  WriteLn(o,'Begin');
  WriteLn(o,'  dbf_Close(f);');
  WriteLn(o,'End;');
  WriteLn(o);
  WriteLn(o,'Function RECNO: LongInt;');
  WriteLn(o,'Begin');
  WriteLn(o,'  RECNO := dbf_RECNO(f);');
  WriteLn(o,'End;');
  WriteLn(o);
  WriteLn(o,'Procedure MyExit; Far;');
  WriteLn(o,'Begin');
  WriteLn(o,'  dbf_Close(f);');
  WriteLn(o,'  ExitProc := FileRec(f).OldExit;');
  WriteLn(o,'End;');
  WriteLn(o);
  WriteLn(o,'Begin');
  WriteLn(o,'  Assign(f,dbfName);');
  WriteLn(o,'  FileRec(f).OldExit := ExitProc;');
  WriteLn(o,'  ExitProc := @MYEXIT;');
  WriteLn(o,'End.');
  System.Close(o);
  dbf_Close(f);
  IF (InOutRes <> 0) Then Abort('Write '+dbfname+'.pas data');

  WriteLn(#13#10'Status: ',Upper(Copy(textrec(o).Name,1,Pos(#0,textrec(o).Name)-1)),
    ' has been successfuly created.'#13#10);
  WriteLn('Remove the CREATEUNIT statement now and include ',
    Upper(Copy(textrec(o).Name,1,Pos('.',textrec(o).Name)-1)),
    ' in the USES clause.');
  WriteLn('Please report any compile/runtime-errors in DBFSERV or in the ',
    Upper(copy(textrec(o).Name,1,Pos('.',textrec(o).Name)-1)),' unit!');
  If Not(Batchmode) Then Halt;
End;

Procedure dbf_Open(Var f: File);
Var H : Record VER: Byte; YY,MM,DD: Byte; RECs: Longint; HS,RS: Word; End;
Begin
  Case FileRec(f).Mode Of
    fmInput,fmOutput,fmInOut: ;
    fmClosed: Begin
                FileMode := $40;
                Reset(f,1);
                If (InOutRes <> 0) Then Exit;
                BlockRead(f,H,SizeOf(H));
                FileRec(f).HS := H.HS; { Header Size }
                FileRec(f).RS := H.RS; { Record Size }
                FileRec(f).InCache := -1;
                {If (H.RS <= MaxAvail)
                   Then} GetMem(FileRec(f).Cache,H.RS)
                   {Else FileRec(f).Cache := NIL};
              End;
    Else RunError(102); { File not assigned }
  End;
End;

Procedure dbf_Close(Var f: File);
Begin
  Case FileRec(f).Mode Of
    fmInput,fmOutput,fmInOut:
    Begin
      System.Close(F);
      If (FileRec(f).Cache <> NIL)
         Then FreeMem(FileRec(f).Cache,FileRec(f).RS);
    End;
  End;
End;

Function dbf_RecNo(Var f: File): LongInt;
Var l: LongInt;
Begin
  dbf_Open(f);
  Seek(f,4);
  BlockRead(f,l,4);
  dbf_RecNo := L;
End;

Procedure dbf_Get(Var f: File; t: Char; r: LongInt; o,l,d: Word);
Var DATA: String[31]; N: Number; i: Word; Result: ^String;
Begin
  dbf_Open(f);
  If (FileRec(f).InCache = r)
     Then Inc(CacheHits)
     Else
       Begin
         FileRec(f).InCache := r;
         Seek(f,LongInt(FileRec(f).HS)+Pred(r)*FileRec(f).RS);
         BlockRead(f,FileRec(f).Cache^,FileRec(f).RS);
         Inc(CacheMiss);
       End;
  Case T Of
    'L': Case UpCase(Char(FileRec(f).Cache^[o])) Of
             'Y','T','*': asm mov al, TRUE; end;
             Else asm mov al, FALSE; End;
         End;
    'C': Begin
           asm
             les ax, [f+4]
             mov word ptr [Result], ax
             mov word ptr [Result+2], es
           end;
           Move(FileRec(f).Cache^[o],Result^[1],l);
           Result^[0] := Char(l);
           if AutoTrim Then While (Length(Result^) > 0) And
                 (Result^[Length(Result^)] = ' ') Do Dec(Result^[0]);
         End;
    'N': Begin
           Move(FileRec(f).Cache^[o],Data[1],l);
           Data[0] := Char(l);
           Val(Data,N,i);
           asm
             fld N
           end;
         End;
  End;
End;

Procedure Help; Assembler;
asm
    mov   ah,$40
    mov   bx,2
    mov   cx,offset @Z
    mov   dx,offset @A
    sub   cx,dx
    push  ds
    push  cs
    pop   ds
    int   $21
    pop   ds
    ret

@A: db 7,13,10,"DBSERV 1.00 - Copyright (c) 9.IV.1998"
    db " by Antivivisektion@t-online.de",13,10
    db "Please refer the DBSERV.DOC file for copyright and help.",13,10
@Z:
End;

Begin
{ OFS(HELP) = 0 >>> no PROCs of this Unit were linked, so !help! }
  If (Ofs(Help) = 0) Then Begin Help; Halt; End;
End.
