program Calculator (input, output);
{ This program implements a three function calculator that operates on}
{ integers }

  const
    Sentinel = '=';     {this character is used to 'quit' the calculator}

  type
    OpType = (Plus, Minus, Times, EndSignal);

  var
    OldValue, NewValue: integer;
    Op: OpType;

procedure GetOperator (var Op: OpType);
{ Pre: User is ready to enter Op}
{ Post: User has entered an appropriate value and Op holds the}
{       corresponding operator }
  var
    Entry: char;

  begin
    write('Enter operator + - * (= to quit): ');
    readln(Entry);
    while not (Entry in ['+', '-', '*', '=']) do
      begin
	writeln('Invalid operator.  Please re-enter');
	readln(Entry);
      end;
    case Entry of
      '+':
	Op := Plus;
      '-':
	Op := Minus;
      '*':
	Op := Times;
      Sentinel:
	Op := EndSignal;
    end;
  end;

procedure Perform (Op: Optype; var NewValue: integer; var OldValue: integer);
{ Pre: OldValue and NewValue are initialized}
{      Op is a binary operator}
{ Post: OldValue holds result of applying Op to NewValue and OldValue }

  begin
    case Op of
      Plus:
	OldValue := OldValue + NewValue;
      Minus:
	OldValue := OldValue - NewValue;
      Times:
	OldValue := Oldvalue * NewValue;
    end;
  end;

begin
  write('Enter starting value: ');
  readln(OldValue);
  write('----> ');
  writeln(OldValue);
  GetOperator(Op);
  while Op <> EndSignal do
  begin
    write('Enter next value: ');
    readln(NewValue);
    Perform(Op, NewValue, OldValue);
    write('----> ');
    writeln(OldValue);
    GetOperator(Op);
  end;
end.