program TestType;
{$I-}
(* No need for I/O checking on here. *)

{$M 2048, 4096, 4096}
(* Some routines need some place on the heap (exactly one sector, *)
(* i.e. 512 bytes would be enough in most cases).                 *)

uses
 DrvTypes;

var
 S: string;
begin
 if ParamCount = 0 then WriteLn ('No parameter given') else
 begin
  S := ParamStr (1);
  Write (UpCase (S [1]), ': ');
  case DriveType (S [1]) of
   dtNone: WriteLn ('doesn''t exist');
   dtCurrent: WriteLn ('is an alias for the current drive');
   dtSubsted: WriteLn ('is a SUBSTed drive');
   dtOther: WriteLn ('is an unknown device with direct I/O not allowed');
   dtAssigned: WriteLn ('is an ASSIGNed drive');
   dtPhantom: WriteLn ('is a ''phantom'' drive (it is a second letter used for another drive)');
   dtFloppy525DD: WriteLn ('is a 5.25" double density floppy drive (360kB)');
   dtFloppy525HD: WriteLn ('is a 5.25" high density floppy drive (1.2MB)');
   dtFloppy35DD: WriteLn ('is a 3.5" double density floppy drive (720kB)');
   dtFloppy8SD: WriteLn ('is a 8" single density floppy drive (you robbed antiques, didn''t you?)');
   dtFloppy8DD: WriteLn ('is a 8" double density floppy drive');
   dtFloppy35HD: WriteLn ('is a 3.5" high density floppy drive (1.44MB)');
   dtTape: WriteLn ('is a streamer');
   dtOptical: WriteLn ('is a read/write optical device');
   dtFloppy35ED: WriteLn ('is a 3.5" extended density floppy drive (2.88MB)');
   dtPseudoFixed: WriteLn ('is reported as removable and fixed disk at the same time - strange!');
   dtRemovable: WriteLn ('is a drive with removable media (cannot determine the type, '
           + #13#10'    maybe it''s an external floppy drive or optical disk)');
   dtFixed: WriteLn ('is a fixed disk or another drive with nonremovable media');
   dtNetwork: WriteLn ('is a network drive');
   dtCDRom: begin
             Write ('is a CD-ROM drive with');
             if not (CdRomReady ((byte (S [1]) - 64) and not ($20))) then Write ('out');
             WriteLn (' a CD');
            end;
   dtRAMDrive: WriteLn ('is a ramdrive');
   dtInterLink: WriteLn ('is a remote drive connected via InterLink');
   dtLapLink: WriteLn ('is a remote drive connected via LapLink driver DD.BIN');
   dtDriveMap: WriteLn ('is a remote drive connected via DriveMap');
   dtJam: WriteLn ('is an on-line compressed disk driven by JAM driver');
   dtStacker: WriteLn ('is an on-line compressed disk driven by Stacker');
   dtStackerAnywhere: WriteLn ('is an on-line compressed floppy drive (Stacker Anywhere)');
   dtDoubleOrDriveSpace: WriteLn ('is an on-line compressed disk driven by DoubleSpace or DriveSpace');
   dtSuperStore: WriteLn ('is an on-line compressed disk driven by SuperStore');
   dtDoubleDisk: WriteLn ('is an on-line compressed disk driven by DoubleDisk');
   dtOtherCompressed: WriteLn ('is an on-line compressed disk (unknown driver)');
   dtDiskreet: WriteLn ('is an encrypted drive created using Diskreet (NDisk)');
   dtSecureFileSystem: WriteLn ('is an encrypted drive created using Secure File System');
   dtPCMCIA: WriteLn ('is a drive residing on a PCMCIA card');
   dtPlaceHolder: WriteLn ('is a place held for future use by some driver (not currently used)');
   dtError: WriteLn ('type cannot be determined due to insufficient memory');
     (* \-> some routines need to allocate memory for one sector on the heap *)
  end;
 end;
end.
