{
  name: vox v2.1
  by: eric mcdaniel
  email: stdemm01@shsu.edu
  programed: summer '97
  language: tp7.0 (pascal)
  description: voxel program similar to vp3(a voxel plasma) but
               more realistic.  i spent many hours programing this
               after i programmed vp3.  i cant draw realisticly for
               anything... so i used a picture i got off the
               internet.  while the ground.bmp isnt even close to
               being in its orginal form, it still looks about
               the same (originally it was a pcx picture of
               512x512x256, now its a bmp picture of 256x256x256).
               the reason for changing this picture is that bmps are
               the only format i know how to read and i needed it to
               be smaller because of pascals limited amount of memory.
               i made height.bmp from scratch (with the help of a
               program i made and paint shop pro).
  keys: <m> -- shows map of picture and where you are
        <k> -- toggles between comp/key control
        <arrows> (only usable if in key control)
            <up> -- forward
            <down> -- backward
            <left> -- turn left
            <right> -- turn right
        <esc> -- exit
  files: vox.pas
         ground.bmp
         height.bmp
}

{$g+}                {puts comp in 286 mode for assembler stuff}
uses crt,dos,kbrd;
const dist=$80;      {setting it higher will let you see further but}
                     {it will also make frames per second (fps) less}
      cnst=20;       {added to forward/backward time}
      tm=100;        {random forward/backward time}
      tcnst=1;       {added to left/right time}
      ttm=10;        {random left/right time}

type halfmap=array[0..$7fff] of byte;       {1/2 of 65536 because pascal-}
     fullmap=array[0..1] of ^halfmap;       {-can only handle up to 65535!!!}
     vscr=array[0..$fdff] of byte;          {virtual screen}
var kbd:kbrdobj;                            {the keyboard handler}
    hmap:fullmap;                           {height map}
    tmap:fullmap;                           {texture map}
    buffer:^vscr;                           {the buffer}
    vbuff:word;                             {buffers address}
    cost,sint:array[0..$7ff] of integer;    {cosin and sin tables}
    dct:array[1..dist+1] of integer;        {distance compensation table}
    x,y,angle:word;                         {camera info}
    height:byte;                            {camera info}
    key,map,k,m,ok,om:boolean;              {comp/key control}
    s1:string;                              {the subdirs}
    a12,b12,c12,d12:boolean;                {used for comp control}
    at1,bt1:integer;                        {used for comp control}
    time:longint absolute $0:$46c;          {used for fps}
    starttime,endtime,fps:longint;          {used for fps}

{this copies the entire screen at source to dest}
procedure flip(source,dest:word); assembler;
asm
   push ds
   mov ax,[dest]
   mov es,ax
   mov ax,[source]
   mov ds,ax
   xor si,si
   xor di,di
   mov cx,32000
   rep movsw
   pop ds
end;

{this sets the mode}
procedure mode(m:word);assembler;
asm
   mov ax,m
   int 10h
end;

{this sets a dac register to a specific rgb value}
procedure setdac(num,r,g,b:byte);
begin
     port[$3c8]:=num;
     port[$3c9]:=r;
     port[$3c9]:=g;
     port[$3c9]:=b;
end;

{draws a vertical line down the screen}
procedure drawvert(x1,y1,y2:integer;c:byte);assembler;
asm
   mov ax,y1
   shl ax,6
   mov bx,ax
   shl ax,2
   add bx,ax
   add bx,x1     {bx:=y1*320+x1}

   mov dx,y2
   inc dx
   sub dx,y1     {dx:=y2+1-y1}

   mov ax,vbuff  {es:=seg(buffer^)}
   mov es,ax

   mov al,c
@loop:
   mov byte ptr[es:bx],al {actually draws a pixel at mem[vbuff:bx]}
   dec dx        {dx-=1}
   cmp dx,0
   je @fin       {if dx=0 then jump @fin}
   add bx,320    {bx+=320}
   jmp @loop     {jump @loop}
@fin:
end;

{casts a verticle ray and renders result}
procedure ray(a,x,y,sx:word);
var dx,dy,p,o,d:word;
    my:integer;
    h,y2:longint;
begin
     dx:=cost[a];
     dy:=sint[a];
     my:=200;
     d:=0;
     repeat
           inc(x,dx);
           inc(y,dy);
           inc(d);                         {new distance}
           p:=y shr 15;                    {calculate offset into map}
           o:=(y and $7f00)+hi(x);
           h:=hmap[p]^[o]-height;
           y2:=dct[d]-(h shl 5)div d;      {calculate height}
           if y2<0 then
              y2:=0;
           if (y2<my) then
           begin
                drawvert(sx,y2,my-1,tmap[p]^[o]);  {voxel}
                my:=y2;
           end;
     until d>=dist;
end;

{mem[where:a+b*320]:=c}
procedure plot(a,b:word;c:byte;where:word);assembler;
asm
   mov ax,where
   mov es,ax
   mov ax,b
   shl ax,6
   mov bx,ax
   shl ax,2
   add ax,bx
   add ax,a
   mov di,ax
   mov al,c
   mov [es:di],al
end;

{draws map in corner}
procedure drawmap;
const xknst=255;
      yknst=1;
var a,b,c,d,oa:word;
begin
     d:=0;
     oa:=0;
     for a := 32 to 63 do
     for b := 0 to 63 do
     begin
          if oa<>a then
             inc(d,768);
          plot(xknst+b,yknst+a,tmap[0]^[d],vbuff);
          inc(d,4);
          oa:=a;
     end;
     d:=0;
     oa:=0;
     for a := 0 to 31 do
     for b := 0 to 63 do
     begin
          if oa<>a then
             inc(d,768);
          plot(xknst+b,yknst+a,tmap[1]^[d],vbuff);
          inc(d,4);
          oa:=a;
     end;
     c:=(y and $7f00)+hi(x);
     d:=(c mod 256) div 4;
     c:=(c div 256) div 4;
     if y shr 15 = 0 then
        c:=c+31;
     plot(xknst+d,yknst+c,0,vbuff);
     plot(xknst+(d+cost[(angle+768)and 2047] div 128),yknst+(c+sint[(angle+768)and 2047] div 128),0,vbuff);
     plot(xknst+(d+cost[(angle+1280)and 2047] div 128),yknst+(c+sint[(angle+1280)and 2047] div 128),0,vbuff);
                                    {last 3 lines are you}
end;

{calculates whole screen view}
procedure drawview;
var a,i:integer;
    dd:integer;
begin
     for i:=0 to 319 do               {fill every column}
     begin
          a:=(angle+i+1888) and 2047; {calculate ray angle with view angle}
          ray(a,x,y,i);               {cast the ray}
     end;
     if map then
        drawmap;
end;

{reads bmps into maps}
procedure initmap;
var num,r,g,b:byte;
    f:file;
begin
     new(tmap[0]);                     {assign 64k for a 256x256 texture map}
     new(tmap[1]);
     new(hmap[0]);                     {assign 64k for a 256x256 height map}
     new(hmap[1]);
     assign(f,concat(s1,'ground.bmp'));
     reset(f,1);
     seek(f,54);                       {the palette starts at byte 54}
     for num:=0 to 255 do
     begin
          blockread(f,tmap[0]^,4);
          b:=tmap[0]^[0] shr 2;
          g:=tmap[0]^[1] shr 2;
          r:=tmap[0]^[2] shr 2;
          setdac(num,r,g,b);
     end;
     blockread(f,tmap[0]^,32768);      {load texture map}
     blockread(f,tmap[1]^,32768);
     close(f);
     assign(f,concat(s1,'height.bmp'));
     reset(f,1);
     seek(f,1078);                     {skip the palette for this one}
     blockread(f,hmap[0]^,32768);
     blockread(f,hmap[1]^,32768);
     close(f);
end;

{calculates lookup tables}
procedure inittables;
var a:word;
begin
     for a:=0 to 2047 do
     begin
          cost[a]:=trunc(cos(a*pi/1024)*256);   {precalculate cosin}
          sint[a]:=trunc(sin(a*pi/1024)*256);   {and sin}
     end;
     for a:=1 to dist+1 do                      {precalculate distance table}
         dct[a]:=1023 div longint(a)+127;
end;

{deletes name from string}
function strdel(s:string;n:word):string;
begin
     delete(s,n,7);
     strdel:=s;
end;

begin
     s1:='';
{     s1:=paramstr(0);
     s1:=strdel(s1,length(s1)-6);        {uncomment these if making an exe}
     at1:=0;
     bt1:=0;
     a12:=false;
     b12:=false;
     c12:=false;
     d12:=false;
     k:=false;
     m:=k;
     ok:=k;
     om:=m;
     kbd.init;
     inittables;
     x:=$8000;                           {set up player}
     y:=$8000;
     angle:=600;
     mode($13);                          {switch to graph mode 13h}
     new(buffer);
     initmap;
     vbuff:=seg(buffer^);
     fps:=0;
     starttime:=time;
     repeat
           height:=hmap[y shr 15]^[(y and $7f00)+hi(x)];
                    {adjust camera height according to height map}
           k:=kbd.down(37);              {'k'}
           m:=kbd.down(50);              {'m'}
           if not(k)and(ok) then
              key:=not(key);
           if not(m)and(om) then
              map:=not(map);
           ok:=k;
           om:=m;
           fillchar(buffer^,64000,229);  {clear the buffer}
           drawview;                     {draw a screen}
           flip(vbuff,$a000);            {flip buffer to screen}
           inc(fps);
           if key then
           begin
                if kbd.down(200) then
                begin                    {forward}
                     inc(x,cost[angle]);
                     inc(y,sint[angle]);
                end;
                if kbd.down(203) then    {left}
                   angle:=(angle+2020) and 2047;
                if kbd.down(205) then    {right}
                   angle:=(angle+20) and 2047;
                if kbd.down(208) then
                begin                    {backward}
                     dec(x,cost[angle]);
                     dec(y,sint[angle]);
                end;
           end
           else
           begin
                if at1<=0 then           {movement forward/backward}
                begin
                     at1:=random(4);
                     if at1=0 then
                     begin
                          b12:=true;
                          a12:=false;
                     end
                     else
                     if at1=1 then
                     begin
                          a12:=false;
                          b12:=false;
                     end
                     else
                     begin
                          a12:=true;
                          b12:=false;
                     end;
                     at1:=random(tm)+cnst;
                end;
                if bt1<=0 then           {turn left/right}
                begin
                     bt1:=random(3);
                     if bt1=0 then
                     begin
                          d12:=true;
                          c12:=false;
                     end
                     else
                     if bt1=1 then
                     begin
                          c12:=true;
                          d12:=false;
                     end
                     else
                     begin
                          c12:=false;
                          d12:=false;
                     end;
                     bt1:=random(ttm)+tcnst;
                end;
                dec(bt1);
                dec(at1);
                if a12 then
                begin                    {move forward}
                     inc(x,cost[angle]);
                     inc(y,sint[angle]);
                end;
                if c12 then              {turn left}
                   angle:=(angle+2032) and $7ff;
                if d12 then              {turn right}
                   angle:=(angle+16) and $7ff;
                if b12 then
                begin                    {move backward}
                     dec(x,cost[angle]);
                     dec(y,sint[angle]);
                end;
           end;
  until kbd.down(1);
  endtime:=time;
  mode(3);                               {switch back to text}
  kbd.done;
  writeln('fps: ',fps/((endtime-starttime)/18.2):3:5);
  freemem(buffer,sizeof(buffer));
  freemem(tmap[0],sizeof(tmap[0]));
  freemem(tmap[1],sizeof(tmap[1]));
  freemem(hmap[0],sizeof(hmap[0]));
  freemem(hmap[1],sizeof(hmap[1]));
end.