unit DynArray;
interface
uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Dialogs,
     StdCtrls, DB, DBTables,Grids,Forms;

(*******************************************************************************

 Matrix Sortieren (Sortauf , Sortabw   alle Zeilen werden soriterte
                   Parameter Spalte1 , Spalte2 wenn Werte in Spalte 1
                   gleich sind , dann vergleiche Spalte 2
                   Spalte2  = -1 --> sortierung nur nach Spalte 1
                   Die Sortierfolge steht als Index in SortList.
                   Der Zugriff kann ber GetDataSort oder TextSort erfolgen.

 Matrix Prozent   ( Es erfolgt eine Umrechnung der Spalten in %
                    Parameter : vonZeile , bisZeile, Spalte  , Bezugsspalte
                    Die Bezugsspalte wird gleich 100 % gesetzt.
                    wird als bisZeile 0 angegeben, so werden alle Zeilen der
                    Matrix berechnet.
                    Die Umrechnung erfolgt nur in der angegebenen Spalte
                    Beim Umrechnen einer ganzen Matrix mu ber alle Spalten
                    iteriert werden.
                   )

procedure Nosort : Es wird der Sortierindex initialisiert, welcher die Orginal-
                   struktur wiedergibt.
*******************************************************************************)


type TDatentyp = (dtExtended,dtInteger);

     TBaseMatrix = Class
                   Baseptr    : Pointer;
                   SortList   : TList;
                   zg         : Pointer;
                   memsize    : Integer;
                   datasize   : Integer;
                   Sortsize   : Integer;
                   counti     : Integer;
                   countj     : Integer;
                   Hugej      : Integer;
                   aDatentyp  : TDatentyp;
                   Filename   : String;
                   Format     : String;         { Formatdarstellung siehe FormatFloat }
                   SpTitel    : TStringList;
                   ZlTitel    : TStringList;
                   Constructor Create(Datentyp: TDatentyp;i,j : Integer);
                   Procedure   InitPointer(i,j : Integer);
                   Destructor  Destroy; override;
                   Procedure   Assign(Source : TBaseMatrix);
                   Procedure   Error(Art : Integer);
                   Procedure   Clear;
                   Procedure   SavetoFile(DateiName : string);
                   Procedure   LoadfromFile(DateiName : String);
                   Procedure   LoadFromBlob(Field : TField);
                   Procedure   SaveToBlob(Field : TField);
                   Procedure   ReDim(i,j : Integer);
                   Function    GetPointer(i,j: Integer): Pointer;
                   Procedure   SetVektor(Index : Integer; var Ziel);   { Zugriff auf eine Zeile }
                   Procedure   GetVektor(Index : Integer; var Ziel);   { Zugriff auf eine Zeile }
                   Procedure   DelSpalte(Index : Integer);
                   Procedure   DelZeile(Index  : Integer);
                   procedure   CopySpalte(Quellfeld : TBaseMatrix;QuellSpalte : Integer;
                                          ZielSpalte: Integer);
                   procedure   CopyZeile(Quellfeld : TBaseMatrix;QuellZeile : Integer;
                                         ZielZeile : Integer);
                   procedure   NoSort;
                  end;

     TIntMatrix = Class(TBaseMatrix)
                   Constructor Create(Dim_i,Dim_j : Integer);
                  protected
                   Procedure   SetData(i,j: Integer; Wert : Integer);
                   Function    GetData(i,j : Integer) : Integer;
                   Function    GetTextData(i,j : Integer) : String;
                  public
                   procedure   AddZeile(Summenzeile,AddZeile : Integer);
                   procedure   AddMatrix(Matrix : TIntMatrix);
                   property Text[i,j : Integer ] : string
                            read GetTextData;
                   property Data[ i,j :Integer ]: Integer
                            read GetData write SetData; default;
                 end;


     TExtendedMatrix = Class(TBaseMatrix)
                        Constructor Create(Dim_i,Dim_j : Integer);
                       protected
                        Procedure   SetData(i,j: Integer; Wert : Extended);
                        Function    GetData(i,j : Integer) : Extended;
                        Function    GetDataSort(i,j : Integer) : Extended;
                        Function    GetTextData(i,j : Integer) : String;
                        Function    GetTextSortData(i,j : Integer) : String;
                      public
                        procedure   AddZeile(Summenzeile,AddZeile : Integer);
                        procedure   AddMatrix(Matrix : TExtendedMatrix);
                        procedure   Sortaufw(Feld1,Feld2 : Integer);
                        procedure   Sortabw(Feld1,Feld2  : Integer);
                        procedure   Percent(vonZeile,bisZeile,Spalte,BezugsZeile : Integer);
                        procedure   ShowGrid(Grid : TStringGrid);
                        Function    isZeileNull(Zeile : Integer) : Boolean;
                        Function    isSpalteNull(Spalte : Integer) : Boolean;
                        Function    GetFormat(ModString : String;
                                              Defaultdez,
                                              Spaltedez,Zeiledez,
                                              i,j : Integer): String;
                        property Text[i,j : Integer ] : string
                                 read GetTextData;
                        property SortText[i,j : Integer ] : string
                                 read GetTextSortData;

                        property Data[ i,j :Integer ]: Extended
                                 read GetData write SetData; default;
                        property DataSort[ i,j :Integer ]: Extended
                                 read GetDataSort;

                      end;


const NullasBlank : Boolean = true;

{ Testanzeige dynamisches Array vom Typ extended }

Procedure ZeigDat(Daten : TExtendedmatrix;Titel : String;Wait : Boolean);

procedure DupliziereMatrix(var Daten : TExtendedMatrix);

{ Aus dem Basisformat werden die Dezimalstellen eleminiert und mit der gewnschten
  Stellenanzahl ergnzt.
}

Function SetFormat(BasisFormat : String;DezStellen : Integer) : String;


implementation

type EArrayException = class(Exception);
     EBoundsError    = class(EArrayException);
     EPointerError   = class(EArrayException);
     ESaveError      = class(EArrayException);

type TDateiinfo = record
                   i,j,memsize : Integer;
                   Datentyp    : TDatentyp;
                  end;

Var sm :  TExtendedMatrix;       { Zeiger auf aktuell zu sortierende Matrix }
    F1 :  Integer;               { Index 1. Sortierspalte                   }
    F2 : Integer;                { Index 2. sortierspalte                   }

procedure TBaseMatrix.NoSort;
var i : Integer;
Begin
 SortList:=TList.Create;
 for i:=0 to counti do Sortlist.Add(TObject(i));
end;

Procedure TBaseMatrix.InitPointer(i,j : Integer);
Begin
 Case aDatentyp of
        dtExtended :  datasize:=sizeof(Extended);
        dtInteger  :  datasize:=sizeof(Integer);
       end;
 Hugej := j+1;
 memsize:= dataSize* (i+1)* (Hugej);
 counti:= i;
 countj:= j;
end;

Constructor TBaseMatrix.Create(Datentyp: TDatentyp;i,j : Integer);
Begin
 inherited Create;
 aDatentyp:=Datentyp;
 Format:='';
 InitPointer(i,j);
 GetMem(BasePtr,memsize);
 fillchar(BasePtr^,memsize,0);
 SortList:=nil;
 SpTitel:=TStringlist.Create;
 ZlTitel:=TStringlist.Create;
end;

Destructor TBaseMatrix.Destroy;
Begin
 if BasePtr<>nil then FreeMem(BasePtr,memsize);
 BasePtr:=nil;
 if SortList <> nil then SortList.Free;
 SortList:=nil;
 SpTitel.Free;
 ZlTitel.Free;
 inherited Destroy;
end;


Procedure   TBaseMatrix.ReDim(i,j : Integer);
var size,lng    : Integer;
    ptr         : Pointer;
    n           : Integer;
    oldi        : Integer;
    oldsp,neusp : Integer;
    zg,zg1      : Pointer;
Begin
  if (i=counti) and (j=countj) then Exit;
  if BasePtr = nil then Exit;
  Ptr:=nil;
  size := memsize;
  lng  := datasize;
  oldi := counti;
  oldsp:= (countj+1) * datasize;
  InitPointer(i,j);
  neusp:= (countj+1) * datasize;
  lng:=oldsp;
  if lng>neusp then lng:=neusp;
  GetMem(Ptr,memsize);
  fillchar(Ptr^,memsize,0);
  zg:=BasePtr;
  zg1:=Ptr;
  n:=0;
  While (n<=i) and (n<=oldi) do
        Begin
         move(zg^,zg1^,lng);
         zg :=Pointer(longint(zg)+oldsp);
         zg1:=Pointer(longint(zg1)+neusp);
         inc(n);
        end;
 FreeMem(BasePtr,size);
 BasePtr:=Ptr;
 if SortList <> nil then SortList.Free;
 SortList:=nil;
end;

Function TBaseMatrix.GetPointer(i,j: Integer) : Pointer;
Begin
 if BasePtr=nil then begin
                       zg:=nil;
                       Error(0);
                       exit;
                      end;
  If   (i>counti) or (i<0)
    or (j>countj) or (j<0) then  Error(1)
                           else  Begin
                                  if i>0 then i:=i*Hugej;
                                  result:=pointer(longint(BasePtr)+(j+i)*Datasize);
                                 end;

                                 end;


Procedure TBaseMatrix.Clear;
var i : Integer;
    t : TObject;
Begin
 if BasePtr<>nil then Begin
                       fillchar(BasePtr^,memsize,0);
                      end;
 if SpTitel<>nil then  SpTitel.Clear;
 if Zltitel <> nil then ZlTitel.Clear;
end;

Procedure TBaseMatrix.Error(Art : Integer);
Begin
 case Art of
       0 : raise EPointerError.Create('DynArray Pointer=nil');
       1 : raise EBoundsError.Create('DynArray Invalid Index');
       2 : raise ESaveError.Create('DynArray kann Datei zum Speichern der Matrix nicht ffnen');
       3 : raise ESaveError.Create('DynArray Datei '+Filename+' nicht vorhanden');
       4 : raise ESaveError.Create('DynArray Datei laden - differenter Datentyp');
      end;
end;


Procedure TBaseMatrix.GetVektor(Index : Integer; var Ziel);
Var size : Integer;
Begin
 size := Hugej * datasize;
 zg:=GetPointer(Index,1);
 if zg<>nil then Move(zg^,Ziel,size);
end;


Procedure TBaseMatrix.SetVektor(Index : Integer; var Ziel);
Var size : Integer;
Begin
 size := Hugej * datasize;
 zg:=GetPointer(Index,1);
 if zg<>nil then Move(Ziel,zg^,size);
end;


Procedure  TBaseMatrix.LoadfromFile(DateiName : String);
var  handle  : Integer;
     inf     : TDateiInfo;
begin
 if fileexists( DateiName ) then
    Begin
     handle:= FileOpen( DateiName, 0 );
     FileRead( handle, inf, sizeof(inf) );
     if inf.Datentyp <> aDatentyp then Begin
                                        Error(4);
                                        FileClose(handle);
                                        Exit;
                                       end;
     if BasePtr <> nil then Begin FreeMem(BasePtr,memsize);  BasePtr:=nil; end;
     Case aDatentyp of
            dtExtended :  Datasize:=sizeof(Extended);
            dtInteger  :  Datasize:=sizeof(Integer);
           end;
     memsize:= inf.memsize;
     counti:= inf.i;
     countj:= inf.j;
     Hugej:= countj;
     GetMem(BasePtr,memsize);
     fillchar(BasePtr^,memsize,0);
     FileRead(Handle , BasePtr^, memsize);
     FileClose(handle);
    end
else Begin
      Filename:=DateiName;
      Error(3);
      FileName:='';
     end;
end;

Procedure TBaseMatrix.LoadFromBlob(Field : TField);
Var BlobStream : TBlobStream;
    size       : Integer;
    inf        : TDateiInfo;
    buf        : String;
Begin
 BlobStream := TBlobStream.Create(TBlobField(Field), bmRead);
try
SpTitel.Clear;
Zltitel.Clear;
BlobStream.Position:=0;
Size := BlobStream.Seek(0, soFromEnd);
if size>0 then
   Begin
    BlobStream.Position:=0;
    BlobStream.Read(inf,sizeof(inf));
    if inf.Datentyp = aDatentyp then
       Begin
        if BasePtr <> nil then Begin FreeMem(BasePtr,memsize); BasePtr:=nil; end;
        Case aDatentyp of
               dtExtended :  Datasize:=sizeof(Extended);
               dtInteger  :  Datasize:=sizeof(Integer);
              end;
        memsize:= inf.memsize;
   Case aDatentyp of
        dtExtended :  datasize:=sizeof(Extended);
        dtInteger  :  datasize:=sizeof(Integer);
       end;
        counti:= inf.i;
        countj:= inf.j;
        Hugej:= countj+1;
        GetMem(BasePtr,memsize);
        fillchar(BasePtr^,memsize,0);
        BlobStream.Read(BasePtr^, memsize);
       end
     else Error(4);
    end;
 finally
 BlobStream.Free;
 end;
end;


Procedure TBaseMatrix.SavetoFile (DateiName : String );
var  handle  : Integer;
     inf     : TDateiInfo;
begin
  if memsize > 0 then
   Begin
    if fileexists( DateiName ) then
     DeleteFile( PChar(DateiName) );
    handle:= FileCreate( DateiName );
    if handle > - 1 then begin
                          inf.i:=counti;
                          inf.j:=countj;
                          inf.memsize:=memsize;
                          inf.Datentyp:=aDatentyp;
                          FileWrite( handle, inf, sizeof(inf) );
                          FileWrite( handle, Baseptr^, memSize );
                          FileClose(handle);
                         end
                     else Error(2);
   end;
end;


Procedure TBaseMatrix.SaveToBlob(Field : TField);
Var BlobStream : TBlobStream;
    size       : Integer;
    inf        : TDateiInfo;
    bufz,bufs  : String;
Begin
 BlobStream := TBlobStream.Create(TBlobField(Field), bmWrite);
try
BlobStream.Position:=0;
if memsize > 0 then
   Begin
     inf.i:=counti;
     inf.j:=countj;
     inf.memsize:=memsize;
     inf.Datentyp:=aDatentyp;
     BlobStream.Write( inf, sizeof(inf) );
     BlobStream.Write( Baseptr^, memSize );
    end;
finally
BlobStream.Free;
end;
end;

Procedure TBaseMatrix.Assign(Source : TBaseMatrix);
Begin
 if Source is TBaseMatrix then
 Begin
  if BasePtr <> nil then Begin FreeMem(BasePtr,memsize);  BasePtr:=nil; end;
  counti  := TBaseMatrix(Source).counti;
  countj  := TBaseMatrix(Source).countj;
  Hugej   := TBaseMatrix(Source).Hugej;
  datasize:= TBaseMatrix(Source).datasize;
  memsize := TBaseMatrix(Source).memsize;
  GetMem(BasePtr,memsize);
  Move(TBaseMatrix(Source).BasePtr^,BasePtr^,memsize);
  SpTitel.Assign(TBaseMatrix(Source).SpTitel);
  ZlTitel.Assign(TBaseMatrix(Source).ZlTitel);
 end;
end;


procedure TBaseMatrix.DelSpalte(Index : Integer);
var i,j   : Integer;
    size  : Integer;
    var zg1 : Pointer;
Begin
 for i:=0 to counti do
     Begin
      zg1:=GetPointer(i,Index);
      zg:=GetPointer(i,index+1);
      size:=(countj-Index)*DataSize;
      move(zg^,zg1^,size);
     end;
 if Index<SpTitel.count then SpTitel.Delete(Index);
 Dec(countj);
end;

(*
procedure TBaseMatrix.InsertSpalte(Index : Integer);
var i,j   : Integer;
    size  : Integer;
    var zg1 : Pointer;
Begin
 for i:=0 to counti do
     Begin
      zg1:=GetPointer(i,Index);
      zg:=GetPointer(i,index+1);
      size:=(countj-Index)*DataSize;
      move(zg^,zg1^,size);
     end;
 if Index<SpTitel.count then SpTitel.Delete(Index);
 Dec(countj);
end;
*)

procedure TBaseMatrix.DelZeile(Index : Integer);
var i,j : Integer;
    zg1 : Pointer;
Begin
 for i:=Index to counti-1 do
     for j:=0 to countj do Begin
                            zg1:=GetPointer(i,j);
                            zg:=GetPointer(i+1,j);
                            Move(zg^,zg1^,Datasize);
                           end;
{
 for j:=0 to countj do Begin
                        zg:=GetPointer(counti,j);
                        fillchar(zg^,Datasize,0);
                       end;
}
 if Index<ZlTitel.count then ZlTitel.Delete(Index);
 dec(counti);
end;

procedure TBaseMatrix.CopySpalte(Quellfeld : TBaseMatrix;Quellspalte : Integer;
                                 Zielspalte  : Integer);
var i   : Integer;
    zg1 : Pointer;
Begin
 for i:=0 to counti do
     Begin
      if i<= Quellfeld.Counti then
         Begin
          zg1:=Quellfeld.GetPointer(i,QuellSpalte);
          zg:=GetPointer(i,ZielSpalte);
          move(zg1^,zg^,Datasize);
         end;
     end;
 end;

procedure TBaseMatrix.CopyZeile(Quellfeld  : TBaseMatrix;QuellZeile : Integer;
                                 ZielZeile : Integer);
var i   : Integer;
    zg1 : Pointer;
Begin
 for i:=0 to countj do
     Begin
      zg1:=Quellfeld.GetPointer(QuellZeile,i);
      zg:=GetPointer(ZielZeile,i);
      move(zg1^,zg^,Datasize);
     end;
  if     (QuellZeile<Quellfeld.Zltitel.count)
     and (ZielZeile<Zltitel.count) then
          Begin
           ZlTitel[Zielzeile]:=Quellfeld.ZlTitel[Quellzeile];
           ZlTitel.Objects[Zielzeile]:=Quellfeld.ZlTitel.objects[Quellzeile];
          end;
 end;

(*******************************************************
  Integer - Matrix
 *******************************************************)

Constructor TIntMatrix.Create(Dim_i,Dim_j : Integer);
Begin
 inherited Create(dtInteger,Dim_i,Dim_j);
end;


Procedure TIntMatrix.SetData(i,j: Integer; Wert : Integer);
Begin
 zg:=GetPointer(i,j);
 if zg<>nil then Move(Wert,zg^,Datasize);
end;

Function TIntMatrix.GetData(i,j: Integer) : Integer;
Begin
 zg:=GetPointer(i,j);
 if zg<>nil then move(zg^,result,Datasize);
end;


Function TIntMatrix.GetTextData(i,j : Integer) : String;
Begin
 result:=inttostr(GetData(i,j));
end;

procedure TIntMatrix.AddZeile(Summenzeile,AddZeile : Integer);
var i,j : Integer;
    s   : Integer;
Begin
 for i:=0 to countj do Begin
                        s:=GetData(Summenzeile,i);
                        s:=s+GetData(AddZeile,i);
                        SetData(Summenzeile,i,s);
                       end;
end;


procedure TIntMatrix.AddMatrix(Matrix : TIntMatrix);
var i,j,ii,ij,kj : Integer;
    a,b    : Integer;
    zg,zg1 : Pointer;
Begin
 if   (BasePtr=nil)
   or (Matrix.BasePtr=nil) then begin
                                 Error(0);
                                 exit;
                                end;
 j:= memsize div datasize;
 zg:=  BasePtr;
 zg1:= Matrix.BasePtr;
 for i:= 0 to j-1 do Begin
                      move(zg^,a,Datasize);
                      move(zg1^,b,datasize);
                      a:=a+b;
                      move(a,zg^,Datasize);
                      zg:=Pointer(longint(zg)+Datasize);
                      zg1:=Pointer(longint(zg1)+Datasize);
                     end;
end;


(*******************************************************
  Extended  - Matrix
 *******************************************************)


Constructor TExtendedMatrix.Create(Dim_i,Dim_j : Integer);
Begin
 inherited Create(dtExtended,Dim_i,Dim_j);
end;


Procedure TExtendedMatrix.SetData(i,j: Integer; Wert : Extended);
Begin
 zg:=GetPointer(i,j);
 if zg<>nil then Move(Wert,zg^,Datasize);
end;

Function TExtendedMatrix.GetData(i,j: Integer) : Extended;
Begin
 zg:=GetPointer(i,j);
 if zg<>nil then move(zg^,result,Datasize);
end;


Function TExtendedMatrix.isZeileNull(Zeile : Integer) : Boolean;
Var i : Integer;
Begin
 result:=false;
 for i:=0 to countj do if GetData(Zeile,i) <> 0.0 then Exit;
 result:=true;
end;


Function TExtendedMatrix.isSpalteNull(Spalte : Integer) : Boolean;
Var i : Integer;
Begin
 result:=false;
 for i:=0 to counti do if GetData(i,Spalte) <> 0.0 then Exit;
 result:=true;
end;


Function TExtendedMatrix.GetDataSort(i,j: Integer) : Extended;
var n : Integer;
Begin
 if SortList=nil then Begin
                       result:=0.0;
                       Exit;
                      end;
 i:=Integer(SortList[i]);
 zg:=GetPointer(i,j);
 if zg<>nil then move(zg^,result,Datasize);
end;


Function TExtendedMatrix.GetTextData(i,j : Integer) : String;
Begin
 if length(Format) >0 then result  := FormatFloat(Format,GetData(i,j))
                      else result  :=FloatToStr(GetData(i,j));
end;

Function TExtendedMatrix.GetTextSortData(i,j : Integer) : String;
Begin
 if length(Format) >0 then result  := FormatFloat(Format,GetDataSort(i,j))
                      else result  := FloatToStr(GetDataSort(i,j));
end;

procedure TExtendedMatrix.AddZeile(Summenzeile,AddZeile : Integer);
var i,j : Integer;
    s   : Extended;
Begin
 for i:=0 to countj do Begin
                        s:=GetData(Summenzeile,i);
                        s:=s+GetData(AddZeile,i);
                        SetData(Summenzeile,i,s);
                       end;
end;


procedure TExtendedMatrix.AddMatrix(Matrix : TExtendedMatrix);
var i,j,ii,ij,kj : Integer;
    a,b    : Extended;
    zg,zg1 : Pointer;
Begin
 if   (BasePtr=nil)
   or (Matrix.BasePtr=nil) then begin
                                 Error(0);
                                 exit;
                                end;
 j:= memsize div datasize;
 zg:=  BasePtr;
 zg1:= Matrix.BasePtr;
 for i:= 0 to j-1 do Begin
                      move(zg^,a,Datasize);
                      move(zg1^,b,datasize);
                      a:=a+b;
                      move(a,zg^,Datasize);
                      zg:=Pointer(longint(zg)+Datasize);
                      zg1:=Pointer(longint(zg1)+Datasize);
                     end;
end;

Function Aufsteigend(Item1,Item2 : Pointer): Integer;
Var Hz1,Hz2 : Extended;
Begin
 Hz1:=sm.GetData(Integer(Item1),F1);
 Hz2:=sm.GetData(Integer(Item2),F1);
 result:=0;
 if Hz1=Hz2 then Begin
                  if F2 = -1 then Exit;
                  Hz1:=sm.GetData(Integer(Item1),F2);
                  Hz2:=sm.GetData(Integer(Item2),F2);
                 end;
 if Hz1<Hz2 then result:=-1
            else if Hz1>Hz2 then result:=1;
end;

procedure TExtendedMatrix.Sortaufw(Feld1,Feld2 : Integer);
var i : Integer;
Begin
 if SortList = nil then sortList:=TList.Create;
 SortList.Clear;
 for i:=0 to counti do Sortlist.Add(Pointer(i));
 sm:=Self;
 F1:=Feld1;
 F2:=Feld2;
 Sortlist.Sort(Aufsteigend);
end;

Function Absteigend(Item1,Item2 : Pointer): Integer;
Var Hz1,Hz2 : Extended;
Begin
 Hz1:=sm.GetData(Integer(Item1),F1);
 Hz2:=sm.GetData(Integer(Item2),F1);
 result:=0;
 if Hz1=Hz2 then Begin
                  if F2 = -1 then Exit;
                  Hz1:=sm.GetData(Integer(Item1),F2);
                  Hz2:=sm.GetData(Integer(Item2),F2);
                 end;
 if Hz1<Hz2 then result:=1
            else if Hz1>Hz2 then result:=-1;
end;

procedure TExtendedMatrix.Sortabw(Feld1,Feld2  : Integer);
var i : Integer;
Begin
 if SortList = nil then sortList:=TList.Create;
 SortList.Clear;
 for i:=0 to counti do Sortlist.Add(Pointer(i));
 sm:=self;
 F1:=Feld1;
 F2:=Feld2;
 Sortlist.Sort(Absteigend);
end;

procedure TExtendedMatrix.Percent(vonZeile,bisZeile,Spalte,BezugsZeile : Integer);
Var Hz1 : Extended;
    i   : Integer;
Begin
 Hz1:=GetData(Bezugszeile,Spalte);
 if Hz1=0 then Exit;
 if BisZeile=0 then bisZeile:=counti;
 for i:=vonZeile to BisZeile do
     Begin
      if i <> Bezugszeile then SetData(i,Spalte,(GetData(i,Spalte)*100.0 / Hz1))
                          else SetData(i,Spalte,100.0);
     end;
end;


procedure TExtendedMatrix.ShowGrid(Grid : TStringGrid);
var i, j : Integer;
Begin
 Grid.ColCount := countj+2;
 Grid.rowcount := counti+2;
 for i:=0 to ZlTitel.count-1 do Grid.Cells[0,i+1]:=ZlTitel[i];
 for i:=ZlTitel.count to Grid.rowcount-1 do Grid.Cells[0,i+1]:='';
 for i:=0 to SpTitel.count-1 do Grid.Cells[i+1,0]:=SpTitel[i];
 for i:=SpTitel.count to Grid.colcount-1 do Grid.Cells[i+1,0]:='';
 for i:= 0 to counti do
     for j:=0 to countj do Grid.Cells[j+1,i+1]:= GetTextData(i,j);
end;

Procedure ZeigDat(Daten : TExtendedmatrix;Titel : String;Wait : Boolean);
Begin
 (*
 FrmTestanzeige:= TFrmTestanzeige.Create(Application);
 SetDaten(Daten);
 FrmTestanzeige.Caption :=Titel;
 FrmTestanzeige.Init;
 if wait then FrmTestanzeige.Showmodal
         else FrmTestanzeige.Show;
 *)
end;


procedure DupliziereMatrix(var Daten : TExtendedMatrix);
var org : TExtendedMatrix;
    i,n : Integer;
Begin
 org:=TExtendedMatrix.Create(Daten.counti,Daten.countj);
 Org.Assign(Daten);
 (*
 Daten.Free;
 Daten:=TExtendedMatrix.Create(Org.counti,Org.countj+Org.countj);
 *)
 Daten.ReDim(Daten.counti,Daten.countj+Daten.countj);
 n:=0;
 for i:=0 to Org.countj do
     Begin
      if n<Daten.countj then Daten.CopySpalte(Org,i,n);
      inc(n);
      if n<Daten.countj then Daten.CopySpalte(Org,i,n);
      inc(n);
     end;
 Daten.ZlTitel.Assign(Org.ZlTitel);
 Daten.SpTitel.Clear;
 for i:=0 to Org.SpTitel.count-1 do
     Begin
      Daten.SpTitel.AddObject(Org.SpTitel[i],Org.SpTitel.Objects[i]);
      Daten.SpTitel.AddObject(Org.SpTitel[i],Org.SpTitel.Objects[i]);
     end;
 Org.Destroy;
end;

Function SetFormat(BasisFormat : String;DezStellen : Integer) : String;
var i : Integer;
Begin
 i:=pos('.',BasisFormat);
 if i>0 then result:=Copy(BasisFormat,1,i-1)
        else result:=BasisFormat;
 if DezStellen >0 then Begin
                        result:=result+'.';
                        While DezStellen >0 do Begin result:=result+'0'; dec(DezStellen); end;
                       end;
end;

Function TExtendedMatrix.GetFormat(ModString : String;Defaultdez,Spaltedez,Zeiledez,i,j : Integer): String;
var buf : String;
    Hz1 : Extended;
Begin
 Hz1:=GetData(i,j);
 if (Hz1=0) and NullasBlank then Begin
                                  result:='';
                                  Exit;
                                 end; 
 if Zeiledez>0 then Defaultdez:=Zeiledez;
 if Spaltedez>0 then Defaultdez:=Spaltedez;
 if (Zeiledez>0) and (Spaltedez>0) then
     Begin
      if Zeiledez>Spaltedez then Defaultdez:= Zeiledez
                            else Defaultdez:= Spaltedez;
     end;
 buf:=ModString;
 if Defaultdez=$ff then Defaultdez:=0;
 if (Defaultdez>0) and (pos('.',Modstring)=0) then buf:=buf+'.';
 While Defaultdez>0 do Begin
                        buf:=buf+'0';
                        dec(Defaultdez);
                       end;
 if (i<=counti) and (j<=countj) then result:=FormatFloat(buf,Hz1)
                                else result:=FormatFloat(buf,0);
end;

end.
