(*
This is an atempt to make a extension language for Delphi,
searching internet for such program I can't found anithing
for imediate and easy use ( ofcourse that I found TCL, LUA, ...,
but not yet adapted to use in Delphi, if somebody know one please
notyfy me mingole@redestb.es) but I found a program called pascals.pas
writed by Niklaus Wirth in 1976, see below.

(*author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76*)
(* updated 19.3.80, 22.4.81 msp uwa for cs101/200 *)

(*
So I get that file and did some investigation, changes and adaptations
and get a compiler and a interpreter for a subset of pascal language.
I think that it's near what I was looking for:

  - An extension language to embed in Delphi.
  - Reasonable easy to extend.
  - Easy to learn, it's pascal.
  - Full control over the process, full source code.

Ofcourse there are problems and I'm putting it in the net for people that
need it like me and people that can do some work and sugestions to
get it better.

    I'll apreciate sugestions and comments in Portuguese, Spanish or English
my Internet address is  mingole@resdestb.es , in TSTICPAS.PAS file I'll try
to explain how it works.
        The file list is:
            - ICPAS.PAS  : this file contain Interface routines.
            - ICPASI.PAS : this is the Interpret.
            - ICPASC.PAS : the compiler.
            - ICPASH.PAS : the internal header file.
            - PASTST.PAS : a modified version to test the compiler and
                           the interpret.
            - TSTICPAS.PAS : contain an poor example that
                             was compiled in TURBO PASCAL 7 and in
                             Delphi 1.0.
            - PASCALS.PAS : the original file from Niklaus Wirth,
                            I made some changes to compile it in
                            TURBO PASCAL 7, I include it for people
                            that want to study it and to compare
                            with the actual version.

(*
author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76

Reworked by: Domingo Alvarez Duarte, Madrid - Spain 06.01.97
             mingole@redestb.es

Version : 1.0
*)

unit ICPASC;

{$N+,E+}

interface
uses ICPAS, ICPASH;

procedure GrowIdTab(picp : ICPAS_PICPrivateRecord);
procedure GrowStringTab(picp : ICPAS_PICPrivateRecord);
procedure GrowCodeArray(picp : ICPAS_PICPrivateRecord);
procedure GrowArrayTab(picp : ICPAS_PICPrivateRecord);
procedure GrowBlockTab(picp : ICPAS_PICPrivateRecord);
procedure GrowNConstArray(picp : ICPAS_PICPrivateRecord);
procedure inSymbol(picp : ICPAS_PICPrivateRecord);
procedure error(picp : ICPAS_PICPrivateRecord; n : integer);
procedure block( picp : ICPAS_PICPrivateRecord;
                 const fsys: symset; blktyp: blockType; level: integer);
procedure emit(picp : ICPAS_PICPrivateRecord; fct: ICPAS_OpCode);
procedure emit1(  picp : ICPAS_PICPrivateRecord;
                  fct : ICPAS_OpCode; bi: integer);
procedure emit2(  picp : ICPAS_PICPrivateRecord;
                  fct : ICPAS_OpCode; ai,bi: integer);
procedure printtables(picp : ICPAS_PICPrivateRecord);
procedure errorMsg(picp : ICPAS_PICPrivateRecord);
function InputIsFinished(pf: ICPAS_TPText) : Boolean;
function GetInputLine(pf: ICPAS_TPText; var s : string) : Boolean;
function locId( picp : ICPAS_PICPrivateRecord;
                level : integer;
                const ids: ICPAS_TAlfa): integer;

implementation

procedure fatal(picp : ICPAS_PICPrivateRecord; n : integer); forward;


procedure GrowIdTab(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
     with picp^ do
     begin
          newSize := (PIdTabSize+ICPAS_IdTabGrowStep) * Sizeof(ICPAS_IdTab);
          curSize := PIdTabSize * Sizeof(ICPAS_IdTab);
          if (not ReallocMem(Pointer(PIdTab), curSize, newSize)) or
             ((PIdTabSize+ICPAS_IdTabGrowStep) > ICPAS_IdTabMaxSize)
             then fatal(picp, FERRIDENTIFIER)
          else
               Inc(PIdTabSize, ICPAS_IdTabGrowStep);
     end;
end;

procedure GrowStringTab(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
  with picp^ do
  begin
     newSize := (PStringTabSize+ICPAS_StringTabGrowStep) * Sizeof(char);
     curSize := PStringTabSize * Sizeof(char);
     if (not ReallocMem(Pointer(PStringTab), curSize, newSize)) or
        ((PStringTabSize+ICPAS_StringTabGrowStep) > ICPAS_StringTabMaxSize)
        then fatal(picp, FERRSTRINGS)
     else
         Inc(PStringTabSize, ICPAS_StringTabGrowStep);
  end;
end;

procedure GrowCodeArray(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
  with picp^ do
  begin
     newSize := (PCodeArraySize+ICPAS_CodeArrayGrowStep) *
                Sizeof(ICPAS_CodeArray);
     curSize := PCodeArraySize * Sizeof(ICPAS_CodeArray);
     if (not ReallocMem(Pointer(PCodeArray), curSize, NewSize)) or
        ((PCodeArraySize+ICPAS_CodeArrayGrowStep) > ICPAS_CodeArrayMaxSize)
        then fatal(picp, FERRCODE)
     else
         Inc(PCodeArraySize, ICPAS_CodeArrayGrowStep);
  end;
end;

procedure GrowArrayTab(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
  with picp^ do
  begin
     newSize := (PArrayTabSize+ICPAS_ArrayTabGrowStep) * Sizeof(ICPAS_ArrayTab);
     curSize := PArrayTabSize * Sizeof(ICPAS_ArrayTab);
     if (not ReallocMem(Pointer(PArrayTab), curSize, newSize)) or
        ((PArrayTabSize+ICPAS_ArrayTabGrowStep) > ICPAS_ArrayTabMaxSize)
        then fatal(picp, FERRARRAYS)
     else
         Inc(PArrayTabSize, ICPAS_ArrayTabGrowStep);
  end;
end;

procedure GrowBlockTab(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
  with picp^ do
  begin
     newSize := (PBlockTabSize+ICPAS_BlockTabGrowStep) * Sizeof(ICPAS_BlockTab);
     curSize := PBlockTabSize * Sizeof(ICPAS_BlockTab);
     if (not ReallocMem(Pointer(PBlockTab), curSize, newSize)) or
        ((PBlockTabSize+ICPAS_BlockTabGrowStep) > ICPAS_BlockTabMaxSize)
        then fatal(picp, FERRPROCEDURES)
     else
         Inc(PBlockTabSize, ICPAS_BlockTabGrowStep);
  end;
end;

procedure GrowNConstArray(picp : ICPAS_PICPrivateRecord);
var
   curSize, newSize : integer;
begin
  with picp^ do
  begin
     newSize := (PNConstArraySize+ICPAS_NConstArrayGrowStep) *
                Sizeof(ICPAS_TNumConst);
     curSize := PNConstArraySize * Sizeof(ICPAS_TNumConst);
     if (not ReallocMem(Pointer(PNConstArray), curSize, newSize)) or
        (( PNConstArraySize+ICPAS_NConstArrayGrowStep) >
           ICPAS_NConstArrayMaxSize)
        then fatal(picp, FERRREALS)
     else
         Inc(PNConstArraySize, ICPAS_NConstArrayGrowStep);
  end;
end;

procedure errorMsg(picp : ICPAS_PICPrivateRecord);
var
   k: integer;
   msg : string;
begin
     with picp^ do
     begin
   if WriteOut then
   begin
     k:=0; writeln; writeln(pouterr^,' error codes:');
     while errs <> [] do
     begin
          while not (k in errs) do Inc(k);
          write(pouterr^, k,'  ');
          case k of
              0 : msg := ' identifier not declared';
              1 : msg := ' identifier declared twice';
              2 : msg := ' identifier expected';
              3 : msg := ' ''program'' expected';
              4 : msg := ' '')'' expected';
              5 : msg := ' '':'' expected';
              6 : msg := ' incorrect symbol';
              7 : msg := ' identifier or ''var'' expected';
              8 : msg := ' ''of'' expected';
              9 : msg := ' ''('' expected';
              10 : msg := ' identifier, ''array'' or ''record'' expected';
              11 : msg := ' pected';
              12 : msg := ' '']'' expected';
              13 : msg := ' ''..'' expected';
              14 : msg := ' '';'' expected';
              15 : msg := ' function must be integer,real,boolean or char';
              16 : msg := ' ''='' expected';
              17 : msg := ' expression must be boolean';
              18 : msg := ' control var must be integer,char or boolean';
              19 : msg := ' ''for'' limits of wrong type';
              20 : msg := ' no file ''output'' in program heading';
              21 : msg := ' number too large';
              22 : msg := ' ''.'' expected. check begin--ends';
              23 : msg := ' ''case'' expression must be integer,char or boolean';
              24 : msg := ' illegal character';
              25 : msg := ' ''='' must precede constant or identifier';
              26 : msg := ' array index of wrong type';
              27 : msg := ' array bounds not valid';
              28 : msg := ' array not declared';
              29 : msg := ' type identifier expected';
              30 : msg := ' undefined type';
              31 : msg := ' record not declared';
              32 : msg := ' operand must be of type boolean';
              33 : msg := ' illegal type in arithmetic expression';
              34 : msg := ' operand must be of type integer';
              35 : msg := ' may not compare these types';
              36 : msg := ' actual and formal params of different type';
              37 : msg := ' variable expected';
              38 : msg := ' string must contain chars';
              39 : msg := ' incorrect number of params';
              40 : msg := ' can only read integer,real,char';
              41 : msg := ' can only write integer,real,char,boolean';
              42 : msg := ' only applies to reals';
              43 : msg := ' only applies to integers';
              44 : msg := ' identifier is wrong kind';
              45 : msg := ' assignment to identifier not allowed here';
              46 : msg := ' types of variable and expression different';
              47 : msg := ' case label of wrong type';
              48 : msg := ' argument is of wrong type';
              49 : msg := ' program too large for pascals';
              50 : msg := ' constant begins with bad symbol';
              51 : msg := ' '':='' expected';
              52 : msg := ' ''then'' expected';
              53 : msg := ' ''until'' expected';
              54 : msg := ' ''do'' expected';
              55 : msg := ' ''to'' expected';
              56 : msg := ' ''begin'' expected';
              57 : msg := ' ''end'' expected';
              58 : msg := ' identifier,const,''not'' or ''('' expected';
              59 : msg := ' break or continue outside a loop';
              60 : msg := ' variable not initialized';
              61 : msg := ' identifier name too big';
              62 : msg := ' identifier must be declared in the same block';
          end;
          writeln(pouterr^,msg);
          errs:=errs-[k]
     end;
   end;
     end;
end (*errorMsg*) ;

procedure fatal(picp : ICPAS_PICPrivateRecord; n : integer);
var
   msg: ICPAS_TAlfa;
begin
 picp^.Status := n;
 if picp^.WriteOut then
 begin
   writeln(picp^.pouterr^); errormsg(picp);
   case n of
     FERRIDENTIFIER : msg :=  'identifier';
     FERRPROCEDURES : msg :=  'procedures';
     FERRREALS      : msg :=  'reals     ';
     FERRARRAYS     : msg :=  'arrays    ';
     FERRLEVELS     : msg :=  'levels    ';
     FERRCODE       : msg :=  'code      ';
     FERRSTRINGS    : msg :=  'strings   ';
     FERRSTRING     : msg :=  'string    ';
     FERRDOUBLE     : msg :=  'double    ';
     FERRLONGINTS   : msg :=  'longint   ';
   end;
   writeln(picp^.pouterr^, ' compiler table for ', msg, ' is too small');
 end;
   if Assigned(picp^.AppOnError) then
   begin
        if not picp^.AppOnError(n) then Halt;
   end
   else Halt;    (* terminate compilation*)
end (*fatal*) ;

procedure error(picp : ICPAS_PICPrivateRecord; n : integer);
begin
     with picp^ do
     begin
   if WriteOut then
   begin
     if errpos = 0 then write(pouterr^, ' ****');
     if cc > errpos then
     begin
          write(pouterr^, ' ': cc-errpos, '^', n:2);
          errpos := cc+3; errs := errs + [n]
     end;
   end;
     end;
end (*error*) ;

procedure endSkip(picp : ICPAS_PICPrivateRecord);
begin (*underline skipped part of input*)
     with picp^ do
     begin
          while errpos < cc do
                begin
                     if WriteOut then write(pouterr^, '-');
                     Inc(errpos);
                end ;
          skipflag := false
     end;
end (*endSkip*) ;

function InputIsFinished(pf: ICPAS_TPText) : Boolean;
begin
     InputIsFinished := eof(pf^);
end;

function GetInputLine(pf: ICPAS_TPText; var s : string) : Boolean;
begin
     if eof(pf^) then GetInputLine := False
     else
     begin
          ReadLn(pf^, s);
          GetInputLine := True;
     end;
end;

procedure nextCh(picp : ICPAS_PICPrivateRecord);
var                     (*read next character; process line end*)
   chtmp : char;
begin
     with picp^ do
     begin
          if cc = ll then
          begin
               if InAppDeclaration <> 0 then cc := cc -1
               else
               begin
                    if GetInputEof(pinfc) (*DAD*)and (ch <> '.') (*DAD*) then
                    begin
                         if WriteOut then
                         begin
                              writeln(pouterr^);
                              writeln(pouterr^,' program incomplete');
                         end;
                         errorMsg(picp);
                         ch := #0;
                         Status := -1; {Warning kill}
                         Fatal(picp, 1);
                         Exit;
                    end ;
                    if errpos <> 0 then
                    begin
                         if skipflag then endskip(picp);
                         if WriteOut then writeln(pouterr^);
                         errpos := 0
                    end ;
                    if WriteOut then write(pouterr^, lc:5, '  ');
                    ll := 0; cc := 0;
                    (*DAD*)
                    while GetInputLn(pinfc, InputLine) do
                    begin
                         ll := length(InputLine);
                         if WriteOut then writeln(pouterr^,InputLine);
                         if ll <> 0 then break;
                    end;
                    (*DAD*)
               end ;
          end;
          Inc(cc); ch := InputLine[cc];
     end;
end (*nextCh*) ;

procedure inSymbol(picp : ICPAS_PICPrivateRecord);
label
     1,2,3;           (*reads next symbol*)
var
   i,j  : ICPAS_TInteger;
   k, e : ICPAS_TLongInt;

   procedure readscale;
   var
      sign : ICPAS_TInteger;
         s : ICPAS_TLongInt;
   begin
     with picp^ do
     begin
        nextch(picp);
        (*strtoint*)
        sign := 1; s := 0;
        if ch = '+' then nextch(picp) else
        if ch = '-' then begin nextch(picp); sign := -1 end ;
        if not (ch in ['0'..'9']) then error(picp,40)
        else
        repeat
              s := 10*s + ord(ch) - ord('0'); nextch(picp)
        until not (ch in ['0'..'9']);
        (*strtoint*)
        e := s*sign + e
     end;
   end (*readscale*) ;

   procedure adjustscale;
   var
      s  : ICPAS_TLongInt;
      d,t: ICPAS_TDouble;
   begin
     with picp^ do
     begin
        if k+e > emax then error(picp,21)
        else if k+e < emin then rnum := 0
             else
             begin
                  s := abs(e); t := 1.0; d := 10.0;
                  repeat
                        while not odd(s) do
                        begin
                             s := s div 2; d := sqr(d)
                        end ;
                        Dec(s); t := d*t
                  until s = 0;
                  if e >= 0 then rnum := rnum*t
                  else rnum := rnum/t;
             end;
     end;
   end (*adjustscale*) ;

begin (*insymbol*)
     with picp^ do
     begin
1:   while (ch = ' ') or (ch = #9 (*tab*)) do nextch(picp);
     case ch of
         'A'..'Z','a'..'z':
           begin (*identifier or wordsymbol*)
             k := 0; e := 0; id := BlankId;
             repeat
                   if k < ICPAS_AlfaSize then
                   begin
                        Inc(k);
                        if ch in ['A'..'Z'] then ch := chr(ord(ch)+32);
                        id[k] := ch;
                   end
                   else e := 1;
                   nextch(picp)
             until not (ch in ['A'..'Z','a'..'z','0'..'9','_']);
             if e <> 0 then error(picp, 61);
             i := 1; j := nkw;   (*binary search*)
             repeat
                   k := (i+j) div 2;
                   if id <= ICPAS_KeyWord[k] then j := k-1;
                   if id >= ICPAS_KeyWord[k] then i := k+1
             until i > j;
             if i-1 > j then sy := ICPAS_KeySymbol[k] else sy := ident
           end;
         '0'..'9':
           begin (*number*)
             k := 0; inum := 0; sy := intcon;
             (*strtoint*)
             repeat
                   inum := inum*10 + ord(ch) - ord('0');
                   Inc(k); nextch(picp)
             until not (ch in ['0'..'9']);
             (*strtoint*)
             if (k > kmax) or (inum > nmax) then
             begin
                  error(picp,21); inum := 0; k := 0
             end ;
             if (inum > maxint) or (inum < (-maxint)) then sy := longintcon;
             if ch = '.' then
             begin
                  nextch(picp);
                  (*strtofloat*)
                  if ch = '.' then ch := ':' else
                  begin
                       sy := realcon; rnum := inum; e := 0;
                       while ch in ['0'..'9'] do
                       begin
                            e := e-1;
                            rnum := 10.0*rnum + (ord(ch)-ord('0'));
                            nextch(picp)
                       end ;
                       if e = 0 then error(picp,40);
                       if ch = 'e' then readscale;
                       if e <> 0 then adjustscale
                  end
                  (*strtofloat*)
             end
             else if ch = 'e' then
                  begin
                       sy := realcon; rnum := inum; e := 0;
                       readscale; if e <> 0 then adjustscale
                  end ;
           end;
         '%',':' :
           begin
             nextch(picp);
             if ch = '=' then
             begin
                  sy := becomes; nextch(picp)
             end
             else sy := colon
           end ;
         '<' :
           begin
             nextch(picp);
             if ch = '=' then begin sy := leq; nextch(picp) end
             else if ch = '>' then
                  begin
                       sy := neq; nextch(picp)
                  end else sy := lss
           end ;
         '>' :
           begin
             nextch(picp);
             if ch = '=' then begin sy := geq; nextch(picp) end
             else sy := gtr
           end ;
         '.' :
           begin
             nextch(picp);
             if ch = '.' then
             begin
                  sy := colon; nextch(picp)
             end
             else sy := period
           end ;
         '''':
           begin
             k := 1;
2:           nextch(picp);
             if ch = '''' then
             begin nextch(picp); if ch <> '''' then goto 3 end;
             if IdxStringTab+k >= (PStringTabSize -2) then
                GrowStringTab(picp);
             PStringTab^[IdxStringTab+k] := ch; Inc(k);
             if cc = 1 then (*end of line*) k := 1
             else goto 2;
3:           if k = 2 then
             begin
                  sy := charcon;
                  inum := ord(PStringTab^[IdxStringTab+1]);
                  PStringTab^[IdxStringTab] := #1;
             end
             else if k = 1 then
                  begin error(picp,38); sy := charcon; inum := 0 end
                  else
                  begin
                       sy := stringcon;
                       inum := IdxStringTab;
                       PStringTab^[IdxStringTab] := chr(k-1);
                       IdxStringTab := IdxStringTab+k
                  end
           end ;
         '(' :
           begin
             nextch(picp);
             if ch <> '*' then sy := lparent else
             begin (*comment*)
                  nextch(picp);
                  repeat
                        while ch <> '*' do nextch(picp);
                        nextch(picp);
                  until ch = ')';
                  nextch(picp); goto 1
             end
           end ;
         (*begin special symbols*)
         '+' : begin sy := plus;         nextch(picp); end;
         '-' : begin sy := minus;        nextch(picp); end;
         '*' : begin sy := times;        nextch(picp); end;
         '/' : begin sy := rdiv;         nextch(picp); end;
         {'(' : begin sy := lparent;      nextch(picp); end;}
         ')' : begin sy := rparent;      nextch(picp); end;
         '=' : begin sy := eql;          nextch(picp); end;
         ',' : begin sy := comma;        nextch(picp); end;
         '[' : begin sy := lbrack;       nextch(picp); end;
         ']' : begin sy := rbrack;       nextch(picp); end;
         {'"' : begin sy := neq;          nextch(picp); end;}
         '&' : begin sy := andsy;        nextch(picp); end;
         ';' : begin sy := semicolon;    nextch(picp); end;
         #0  : sy := compilerErrorsy;
         (*end special symbols*)
         '$', '!', '@', '\', '^', '_', '?', '#', '"'{, '&'} :
           begin
             error(picp,24); nextch(picp); goto 1 end;
         else begin error(picp,24); (*Halt*)fatal(picp, 1); end;
    end;
    end;
end (*inSymbol*) ;

procedure emit(picp : ICPAS_PICPrivateRecord; fct: ICPAS_OpCode);
begin
  with picp^ do
  begin
     if lc = (PCodeArraySize-2) then GrowCodeArray(picp);
     with PCodeArray^[lc] do
     begin
          f := fct; x := 0; y := 0;
     end;
     Inc(lc);
  end;
end (*emit*) ;

procedure emit1( picp : ICPAS_PICPrivateRecord;
                 fct : ICPAS_OpCode; bi: integer);
begin
  with picp^ do
  begin
     emit(picp,fct);
     with PCodeArray^[lc-1] do
     begin y := bi; x := 0; end ;
  end;
end (*emit1*) ;

procedure emit2(  picp : ICPAS_PICPrivateRecord;
                  fct : ICPAS_OpCode; ai,bi: integer);
begin
  with picp^ do
  begin
     emit(picp, fct);
     with PCodeArray^[lc-1] do
     begin x := ai; y := bi end ;
  end;
end (*emit2*) ;

procedure enterArray( picp : ICPAS_PICPrivateRecord;
                      tp: ICPAS_TTypes; l,h: integer);
begin
  with picp^ do
  begin
     if l > h then error(picp,27);
     if (abs(l)>xmax) or (abs(h)>xmax) then
     begin error(picp,27); l := 0; h := 0;
     end ;
     if IdxArrayTab = (PArrayTabSize-2) then GrowArrayTab(picp);
     begin
          Inc(IdxArrayTab);
          with PArrayTab^[IdxArrayTab] do
          begin
               inxtyp := tp; low := l; high := h
          end
      end
  end;
end (*enterarray*) ;

procedure enterBlock(picp : ICPAS_PICPrivateRecord);
begin
  with picp^ do
  begin
      if IdxBlockTab = (PBlockTabSize -2) then GrowBlockTab(picp);
      begin
           Inc(IdxBlockTab);
           PBlockTab^[IdxBlockTab].last := 0;
           PBlockTab^[IdxBlockTab].lastpar := 0
      end
  end;
end (*enterblock*) ;

procedure enterNumConst( picp : ICPAS_PICPrivateRecord;
                    x: ICPAS_TReal;
                    y: ICPAS_TLongInt);
begin
  with picp^ do
  begin
      if idxLastNConst = (PNConstArraySize-2) then GrowNConstArray(picp);
      begin
           idxCurNConst := 1;
           if x <> 0 then
           begin
                PNConstArray^[idxLastNConst+1].r := x;
                while PNConstArray^[idxCurNConst].r <> x do
                      Inc(idxCurNConst);
           end
           else
           begin
                PNConstArray^[idxLastNConst+1].l := y;
                while PNConstArray^[idxCurNConst].l <> y do
                      Inc(idxCurNConst);
           end;
           if idxCurNConst > idxLastNConst then
              idxLastNConst := idxCurNConst;
      end
  end;
end (*enterNumConst*) ;

function locId( picp : ICPAS_PICPrivateRecord;
                level : integer;
                const ids: ICPAS_TAlfa): integer;
var
   i,j: integer;     (*locate id in table*)
begin
     with picp^ do
     begin
      i := level; PIdTab^[0].name := ids;   (*sentinel*)
      repeat j := PBlockTab^[display[i]].last;
         while (PIdTab^[j].name <> ids) do
               j := PIdTab^[j].link;
               Dec(i);
         until (i<0) or (j<>0);
      if j = 0 then
         error(picp,0);
      locId := j
     end;
end (*locId*) ;

procedure block( picp : ICPAS_PICPrivateRecord;
                 const fsys: symset; blktyp: blockType; level: integer);
type
    conrec = record case tp: ICPAS_TTypes of
         chars : (c: char);
         bools : (b: boolean);
         ints: (i: integer);
         longints : (l: ICPAS_TLongInt);
         reals: (r: ICPAS_TReal);
         doubles : (d : ICPAS_TDouble);
         strings : (s : string);
    end ;

var
   dx: integer;    (*data allocation index*)
   prt: integer;   (*t-index of this procedure*)
   prb: integer;   (*b-index of this procedure*)
   x: integer;

   procedure skip(const fsys: symset; n: integer);
   begin
     with picp^ do
     begin
        error(picp,n); skipflag := true;
        while not (sy in fsys) do insymbol(picp);
        if skipflag then endskip(picp);
     end;
   end (*skip*) ;

   procedure test(const s1,s2: symset; n: integer);
   begin
         if not (picp^.sy in s1) then  skip(s1+s2,n)
   end (*test*) ;

   procedure testsemicolon;
   begin
     with picp^ do
     begin
        if sy = semicolon then insymbol(picp) else
        begin
             error(picp, 14);
             if sy in [comma,colon] then insymbol(picp)
        end ;
        test([ident]+blockbegsys, fsys, 6)
     end;
   end (*testsemicolon*) ;

   procedure enter(const ids: ICPAS_TAlfa; k: ICPAS_TObject);
   var
      j,l: integer;
      pta : ICPAS_PIdTabArray;
   begin
     with picp^ do
     begin
         if IdxIdTab = (PIdTabSize -2) then GrowIdTab(picp);
         begin
            PIdTab^[0].name := ids;
            j := PBlockTab^[display[level]].last;  l := j;
            while PIdTab^[j].name <> ids do  j := PIdTab^[j].link;
            if j <> 0 then error(picp,1) else
            begin
              Inc(IdxIdTab);
              with PIdTab^[IdxIdTab] do
              begin
               name := ids; link := l;
               obj := k; typ := notyp; ref := 0;
               normal := FromPrgFalse; lev := level; adr := 0
              end ;
              PBlockTab^[display[level]].last := IdxIdTab
            end
         end
     end;
   end (*enter*) ;


  procedure entervariable;
  begin
    with picp^ do
    begin
        if sy = ident then
        begin
             enter(id,variable);
             insymbol(picp);
        end
        else error(picp,2)
    end;
  end (*entervariable*) ;

   procedure constant(const fsys: symset; var c: conrec);
   var
      x, sign: integer;
   begin
    with picp^ do
    begin
     c.tp := notyp; c.i := 0;
     test(constbegsys, fsys, 50);
     if sy in constbegsys then
     begin
         if sy = charcon then
         begin
                c.tp := chars; c.i := inum; insymbol(picp)
         end
         else
         if sy = stringcon then
         begin
                c.tp := strings; c.i := inum; insymbol(picp)
         end
         else
         begin
              sign := 1;
              if sy in [plus,minus] then
              begin
                   if sy = minus then sign := -1;
                   insymbol(picp);
              end ;
              if sy = ident then
              begin
                   x := locId(picp,level,id);
                   if x <> 0 then
                      if PIdTab^[x].obj <> konstant then error(picp,25)
                      else
                      begin
                           c.tp := PIdTab^[x].typ;
                           case c.tp of
                             reals,doubles:
                               c.r := sign*PNConstArray^[PIdTab^[x].adr].r;
                             longints:
                               c.l := sign*PNConstArray^[PIdTab^[x].adr].l;
                             else c.i := sign*PIdTab^[x].adr;
                           end;
                      end ;
                      insymbol(picp);
                   end
                   else
                   case sy of
                        intcon :
                          begin
                            c.tp := ints; c.i := sign*inum; insymbol(picp);
                          end;
                        longintcon:
                                   begin
                                        c.tp := longints;
                                        c.l := sign*inum; insymbol(picp);
                                   end;
                        realcon,doublecon:
                               begin
                                    c.tp := reals;
                                    c.r := sign*rnum; insymbol(picp);
                               end;
                        else skip(fsys,50);
              end;
         end;
         test(fsys, [], 6)
     end;
    end
   end (*constant*) ;

   procedure typ( const fsys: symset; var tp: ICPAS_TTypes;
                  var rf, sz: integer);
   var
      x: integer;
      eltp: ICPAS_TTypes; elrf: integer;
      elsz, offset, t0,t1: integer;

      procedure arraytyp(var aref,arsz: integer);
      var
         eltp: ICPAS_TTypes;
         low, high: conrec;
         elrf, elsz: integer;
      begin
       with picp^ do
       begin
        constant([colon,rbrack,rparent,ofsy]+fsys, low);
        if low.tp in [longints,reals,doubles] then
           begin error(picp,27); low.tp := ints; low.i := 0
           end ;
        if sy = colon then insymbol(picp) else error(picp,13);
        constant([rbrack,comma,rparent,ofsy]+fsys, high);
        if high.tp <> low.tp then
           begin error(picp,27); high.i := low.i
           end ;
        enterarray(picp, low.tp, low.i, high.i); aref := IdxArrayTab;
        if sy = comma then
           begin insymbol(picp); eltp := arrays; arraytyp(elrf,elsz)
           end else
        begin
           if sy = rbrack then insymbol(picp) else
              begin error(picp,12);
                 if sy = rparent then insymbol(picp)
              end ;
           if sy = ofsy then insymbol(picp) else error(picp,8);
           typ(fsys,eltp,elrf,elsz)
        end ;
        with PArrayTab^[aref] do
        begin arsz := (high-low+1)*elsz; size := arsz;
           eltyp := eltp; elref := elrf; elsize := elsz
        end ;
      end;
     end (*arraytyp*) ;

   begin (*typ*)
    with picp^ do
    begin
     tp := notyp; rf := 0; sz := 0;
     test(typebegsys, fsys, 10);
     if sy in typebegsys then
       begin
         if sy = ident then
         begin x := locId(picp,level,id);
           if x <> 0 then
           with PIdTab^[x] do
             if obj <> type1 then error(picp,29) else
             begin tp := typ; rf := ref; sz := adr;
               if tp = notyp then error(picp,30)
             end ;
           insymbol(picp);
         end else
         if sy = arraysy then
         begin insymbol(picp);
             if sy = lbrack then insymbol(picp) else
                begin error(picp,11);
                   if sy = lparent then insymbol(picp)
                end ;
             tp := arrays; arraytyp(rf,sz)
         end else
         begin (*records*) insymbol(picp);
           enterblock(picp); tp := records; rf := IdxBlockTab;
           if level = lmax then fatal(picp, FERRLEVELS);
           Inc(level); display[level] := IdxBlockTab; offset := 0;
             while not (sy in fsys-[semicolon,comma,ident]+[endsy]) do
           begin (*field section*)
             if sy = ident then
             begin t0 := IdxIdTab; entervariable;
               while sy = comma do
                 begin insymbol(picp); entervariable
                 end ;
               if sy = colon then insymbol(picp) else error(picp,5);
               t1 := IdxIdTab;
               typ(fsys+[semicolon,endsy,comma,ident],eltp,elrf,elsz);
               while t0 < t1 do
               begin Inc(t0);
                 with PIdTab^[t0] do
                 begin typ := eltp; ref := elrf; normal := FromPrgTrue;
                   adr := offset; offset := offset + elsz
                 end
               end
             end ;
             if sy <> endsy then
             begin if sy = semicolon then insymbol(picp) else
                   begin error(picp,14);
                     if sy = comma then insymbol(picp)
                   end ;
                test([ident,endsy,semicolon], fsys, 6)
             end
           end ;
           PBlockTab^[rf].vsize := offset; sz := offset; PBlockTab^[rf].psize := 0;
           insymbol(picp); Dec(level);
         end ;
         test(fsys, [], 6)
       end
    end;
   end (*typ*) ;

   procedure parameterlist;     (*formal parameter list*)
   var
      tp: ICPAS_TTypes;
      rf, sz, x, t0: integer;
      valpar: boolean;
   begin
    with picp^ do
    begin
     insymbol(picp); tp:=notyp; rf:=0; sz:=0;
     test([ident, varsy], fsys+[rparent], 7);
     while sy in [ident,varsy] do
       begin if sy <> varsy then valpar := true else
               begin insymbol(picp); valpar := false
               end ;
         t0 := IdxIdTab; entervariable;
         while sy = comma do
            begin insymbol(picp); entervariable;
            end ;
         if sy = colon then
           begin insymbol(picp);
             if sy <> ident then error(picp,2) else
             begin x := locId(picp,level,id); insymbol(picp);
               if x <> 0 then
               with PIdTab^[x] do
                 if obj <> type1 then error(picp,29) else
                   begin tp := typ; rf := ref;
                     if valpar then sz := adr else sz := 1
                   end ;
             end ;
             test([semicolon,rparent], [comma,ident]+fsys, 14)
           end
         else error(picp,5);
         while t0 < IdxIdTab do
         begin Inc(t0);
           with PIdTab^[t0] do
           begin
                typ := tp; ref := rf;
                if valpar then normal := FromPrgTrue
                else normal := FromPrgFalse;
                adr := dx; lev := level;
                dx := dx + sz
           end
         end ;
         if sy <> rparent then
         begin if sy = semicolon then insymbol(picp) else
               begin error(picp,14);
                 if sy = comma then insymbol(picp)
               end ;
            test([ident,varsy], [rparent]+fsys, 6)
         end
       end (*while*) ;
     if sy = rparent then
       begin insymbol(picp);
         test([semicolon,colon], fsys, 6)
       end
     else error(picp,4)
    end;
   end (*parameterlist*) ;

   procedure constantdeclaration;
   var
      c: conrec;
   begin
    with picp^ do
    begin
     insymbol(picp);
     test([ident], blockbegsys, 2);
     while sy = ident do
       begin enter(id,konstant); insymbol(picp);
         if sy = eql then insymbol(picp) else
            begin error(picp,16);
               if sy = becomes then insymbol(picp)
            end ;
         constant([semicolon,comma,ident]+fsys,c);
         PIdTab^[IdxIdTab].typ := c.tp; PIdTab^[IdxIdTab].ref := 0;
         case c.tp of
           reals, doubles:
             begin
               enterNumConst(picp,c.r, 0);
               PIdTab^[IdxIdTab].adr := idxCurNConst;
             end;
           longints:
             begin
               enterNumConst(picp, 0, c.l);
               PIdTab^[IdxIdTab].adr := idxCurNConst;
             end;
           strings:
             begin
                  PIdTab^[IdxIdTab].adr := inum;
                  PIdTab^[IdxIdTab].ref := ord(PStringTab^[inum]);
             end;
           else PIdTab^[IdxIdTab].adr := c.i;
         end;
         testsemicolon;
       end
    end;
   end (*constantdeclaration*) ;

   procedure typedeclaration;
   var
      tp: ICPAS_TTypes; rf, sz, t1: integer;
   begin
    with picp^ do
    begin
     insymbol(picp);
     test([ident], blockbegsys, 2);
     while sy = ident do
       begin enter(id,type1); t1 := IdxIdTab; insymbol(picp);
         if sy = eql then insymbol(picp) else
            begin error(picp,16);
               if sy = becomes then insymbol(picp)
            end ;
         typ([semicolon,comma,ident]+fsys, tp, rf, sz);
         with PIdTab^[t1] do
           begin typ := tp; ref := rf; adr := sz
           end ;
         testsemicolon
       end
    end;
   end (*typedeclaration*) ;

   (*procedure labeldeclaration;
   var
      rf, sz: integer;
   begin
        with picp^ do
        begin
             insymbol(picp);
             while sy = ident do
             begin
                  enter(id,olabel);
                  with PIdTab^[IdxIdTab] do
                  begin
                       typ := labels; ref := IdxBlockTab;
                       normal := FromPrgFalse;
                  end ;
                  insymbol(picp);
                  if sy = comma then insymbol(picp);
             end;
             testsemicolon;
        end;
   end;*)

   procedure variabledeclaration;
   var
      t0, t1, rf, sz: integer;
      tp: ICPAS_TTypes;
   begin
    with picp^ do
    begin
     insymbol(picp);
     while sy = ident do
     begin t0 := IdxIdTab; entervariable;
       while sy = comma do
         begin insymbol(picp); entervariable;
         end ;
       if sy = colon then insymbol(picp) else error(picp,5);
       t1 := IdxIdTab;
       typ([semicolon,comma,ident]+fsys, tp, rf, sz);
       while t0 < t1 do
       begin Inc(t0);
         with PIdTab^[t0] do
         begin typ := tp; ref := rf;
           lev := level; adr := dx; normal := FromPrgTrue;
           dx := dx + sz
         end
       end ;
       testsemicolon
     end
    end;
   end (*variabledeclaration*) ;

   procedure procdeclaration;
   var
      fpTyp: blockType; ad : Integer;
   begin
    with picp^ do
    begin
     if sy = functionsy then fpTyp := functype
     else fpTyp := proctype;
     insymbol(picp);
     if sy <> ident then
        begin  error(picp,2); id := BlankId
        end ;
     if fpTyp = functype then enter(id,funktion) else enter(id,prozedure);
     PIdTab^[IdxIdTab].normal := FromPrgTrue;
     ad := IdxIdTab;
     insymbol(picp);
     if InAppDeclaration <> 0 then Inc(InAppDeclaration);
     block(picp, [semicolon]+fsys, fpTyp, level+1);
     if InAppDeclaration <> 0 then Exit;
     if sy = semicolon then insymbol(picp) else error(picp,14);
     if fpTyp = functype then emit1(picp,EXITFUNC, ad)   (*exit*)
     else emit1(picp,EXITPROC, ad);           (*exit*)
    end;
   end (*proceduredeclaration*) ;

(*---------------------------------------------------------statement--*)

   procedure statement( const fsys: symset;
                        jumponbreak, jumponcontinue : integer);
      var i: integer; x: item;
      procedure expression( const fsys: symset; var x: item); forward;

      procedure emitCvt(tsmall, tbig: ICPAS_TTypes; nemit: integer);
      (*emit convert if t1 < t2*)
      begin
           case tsmall of
                  {Warning assuming small type = ints}
                  ints:
                    begin
                         case tbig of
                           longints: emit1(picp,INTTOLINT, nemit);
                           reals,doubles: emit1(picp,INTTOFLOAT, nemit);
                         end;
                    end;
                  longints: if tbig in [reals,doubles] then
                               emit1(picp,LINTTOFLOAT, nemit);
                  {Warning assuming bigtype = [reals,doubles]}
           end;
      end;

      function resulttype(a,b: ICPAS_TTypes): ICPAS_TTypes;

      begin
        if (a>reals) or (b>reals) then
        begin
             error(picp,33); resulttype := notyp
        end
        else
        if (a=notyp) or (b=notyp) then resulttype := notyp
        else
        begin
             if a < b then
             begin
               resulttype := b;
               emitCvt(a, b, 1);
             end
             else
             begin
               resulttype := a;
               emitCvt(b, a, 0);
             end;
        end
      end (*resulttype*) ;

      procedure selector( const fsys: symset; var v:item);
      var
         x: item; a,j: integer;
      begin (*sy in [lparent, lbrack, period]*)
       with picp^ do
       begin
        repeat
          if sy = period then
          begin insymbol(picp);  (*field selector*)
            if sy <> ident then error(picp,2) else
            begin
              if v.typ <> records then error(picp,31) else
              begin (*ield identifier*)
                j := PBlockTab^[v.ref] .last; PIdTab^[0].name := id;
                while PIdTab^[j].name <> id do j := PIdTab^[j].link;
                if j = 0 then error(picp,0);
                v.typ := PIdTab^[j].typ; v.ref := PIdTab^[j].ref;
                a := PIdTab^[j].adr;
                if a <> 0 then emit1(picp,RECFLDSELECTOR,a)
              end ;
              insymbol(picp)
            end
          end else
          begin (*array selector*)
            if sy <> lbrack then error(picp,11);
            repeat insymbol(picp);
              expression(fsys+[comma,rbrack], x);
              if v.typ = arrays then
              begin
                   a := v.ref;
                   if PArrayTab^[a].inxtyp <> x.typ then error(picp,26) else
                   if PArrayTab^[a].elsize = 1 then emit2(picp,ARRAYINDEX,1,a)
                   else emit2(picp,ARRAYINDEX,0,a);
                   v.typ := PArrayTab^[a].eltyp;
                   v.ref := PArrayTab^[a].elref
              end
              else if v.typ = strings then
              begin
                   if x.typ <> ints then error(picp,26)
                   else
                   begin
                        case PIdTab^[i].normal of
                          FromPrgTrue: emit1(picp,STRINDEX, PIdTab^[i].adr);
                          FromAppTrue: emit1(picp,APPSTRINDEX, i);
                        end;
                   end;
                   v.typ := chars;
                   v.ref := 1;
                   break;
              end
              else error(picp,28);
            until sy <> comma;
            if sy = rbrack then insymbol(picp) else
              begin error(picp,12); if sy = rparent then insymbol(picp)
              end
          end
        until not (sy in [lbrack,lparent,period]);
        test(fsys, [], 6)
       end;
      end (*selector*) ;

      procedure call( const fsys: symset; i: integer);
      var
         x: item;
         lastp, cp, k: integer;
      begin
       with picp^ do
       begin
        case PIdTab^[i].obj of
             funktion, prozedure: emit1(picp,MARKSTACK,i);  (*mark stack*)
        end;
        lastp := PBlockTab^[PIdTab^[i].ref].lastpar; cp := i;
        if sy = lparent then
        begin (*actual parameter list*)
          repeat insymbol(picp);
            if cp >= lastp then error(picp,39) else
            begin Inc(cp);
              if PIdTab^[cp].normal = FromPrgTrue then
              begin (*value parameter*)
                expression(fsys+[comma,colon,rparent], x);
                if x.typ=PIdTab^[cp].typ then
                begin
                     if x.ref <> PIdTab^[cp].ref then error(picp,36)
                     else
                     if x.typ = arrays then
                            emit1(picp,LOADBLOCK,PArrayTab^[x.ref].size)
                     else
                     if x.typ = records then
                        emit1(picp,LOADBLOCK,PBlockTab^[x.ref].vsize)
                end
                else
                if (x.typ in [ints,longints]) and
                   (PIdTab^[cp].typ in [longints, reals,doubles]) then
                   emitCvt(x.typ, PIdTab^[cp].typ, 0)
                else
                if x.typ<>notyp then error(picp,36);
              end
              else
              begin (*variable parameter*)
                if sy <> ident then error(picp,2) else
                begin k := locId(picp,level,id); insymbol(picp);
                  if k <> 0 then
                  begin
                    if not (PIdTab^[k].obj in [variable, appvar]) then
                       error(picp,37);
                    x.typ := PIdTab^[k].typ; x.ref := PIdTab^[k].ref;
                    case PIdTab^[k].normal of
                      FromPrgFalse:
                        begin
                          if PIdTab^[k].typ = strings then
                             emit2(picp, STRARGBYVALUE,PIdTab^[k].lev,
                                    PIdTab^[k].adr)
                          else
                            emit2( picp,ARGBYVALUE,PIdTab^[k].lev,
                                   PIdTab^[k].adr);
                        end;
                      FromPrgTrue:
                        emit2( picp,ARGBYADDRESS,PIdTab^[k].lev,
                               PIdTab^[k].adr);
                      FromAppFalse:
                        emit2(picp, ARGBYVALUE,PIdTab^[k].lev, k);
                      FromAppTrue:
                        emit2(picp, ARGBYADDRESS,PIdTab^[k].lev, k);
                    end;
                    if sy in [lbrack,lparent,period] then
                       selector(fsys+[comma,colon,rparent], x);
                    if (x.typ<>PIdTab^[cp].typ) or (x.ref<>PIdTab^[cp].ref)
                       then error(picp,36)
                  end
                end
              end
            end ;
            test([comma,rparent], fsys, 6)
          until sy <> comma;
          if sy = rparent then insymbol(picp) else error(picp,4)
        end ;
        if cp < lastp then error(picp,39); (*too few actual parameters*)
        case PIdTab^[i].obj of
             funktion, prozedure:
               begin
                    emit1(picp,CALLPROC, PBlockTab^[PIdTab^[i].ref].psize-1);
                    if PIdTab^[i].lev < level then
                       emit2(picp,UPDDISPLAY, PIdTab^[i].lev, level);
               end;
             AppFuncArg, AppProcArg: emit1(picp,CALLAPPPROC2, i);
             AppFunc: emit1(picp,CALLAPPPROC, i);
        end;
       end;
      end (*call*) ;


      procedure expression;
        var y:item; op:symbol;
        rtyp : ICPAS_TTypes;

        procedure simpleexpression( const fsys:symset; var x:item);
          var y:item; op:symbol;

          procedure term( const fsys:symset; var x:item);
          var
             y:item; op:symbol; ts:typset;

             procedure factor( const fsys:symset; var x:item);
             var
                i,f: integer;

                procedure standfct(n: integer);
                var
                   ts: typset;
                begin (*standard function no. n*)
                with picp^ do
                begin
                if sy = lparent then insymbol(picp) else error(picp,9);
                if n < ICPAS_LastStdFunc then
                  begin expression(fsys+[rparent],x);
                    case n of
(*abs,sqr*)     0,2: begin
                          ts := [ints,longints,reals,doubles];
                          PIdTab^[i].typ := x.typ;
                          if x.typ in [reals,doubles] then n := n+1
                     end ;
(*odd,chr*)     4,5: ts := [ints,longints];
(*ord*)         6:   ts := [ints,longints,bools,chars];
(*succ,pred*)   7,8: begin
                          ts := [ints,longints,bools,chars];
                          PIdTab^[i].typ := x.typ
                     end ;
(*round,trunc*) ROUND_FUNCTION,TRUNC_FUNCTION,11,12,13,14,15,16:
(*sin,cos,...*)      begin ts := [ints,longints,reals,doubles];
                         case x.typ of
                           ints: emit1(picp,INTTOFLOAT,0);
                           longints: emit1(picp,LINTTOFLOAT, 0);
                         end;
                     end ;
                 end ;
                 if x.typ in ts then emit1(picp,BUILTINFCT,n) else
                 if x.typ <> notyp then error(picp,48);
                  end else
(*eof,eoln*)      begin (*n in [17,18]*)
                    if sy <> ident then error(picp,2) else
                    if id <> InputId then error(picp,0) else insymbol(picp);
                    emit1(picp,BUILTINFCT,n);
                  end ;
                x.typ := PIdTab^[i].typ;
                if sy = rparent then insymbol(picp) else error(picp,4)
              end;
              end (*standfct*) ;

            begin (*factor*)
             with picp^ do
             begin
              x.typ := notyp; x.ref := 0;
              test(facbegsys, fsys, 58);
              while sy in facbegsys do
                begin
                  if sy = ident then
                  begin i := locId(picp,level,id); insymbol(picp);
                    with PIdTab^[i] do
                    case obj of
              konstant: begin x.typ := typ; x.ref := 0;
                          case x.typ of
                            reals,doubles: emit2( picp,LOADCONST,
                                                  ord(x.typ), adr);
                            longints: emit2(picp,LOADCONST, ord(x.typ), adr);
                            strings:
                                    begin
                                         emit2( picp,LOADCONST,
                                                ord(x.typ), adr);
                                         (*emit1(picp,LITERAL, ref);*)
                                         (*emit1(picp,WRITESTDPROC,
                                         PIdTab^[i].adr+1);*)
                                    end;
                            else  emit1(picp,LITERAL,adr);
                          end;
                        end ;
              appconst: begin x.typ := typ; x.ref := 0;
                            emit1(picp,APPVARCONST,i);
                        end ;
              variable, appvar:
                   begin
                        x.typ := typ; x.ref := ref;
                        if sy in [lbrack,lparent,period] then
                        begin
                             case normal of
                                 FromPrgTrue: emit2( picp,ARGBYADDRESS,
                                                     lev, adr);
                                 FromPrgFalse:
                                   begin
                                     (*if x.typ = strings then
                                        emit2(picp,STRARGBYVALUE, lev, adr)
                                     else*)  emit2( picp,ARGBYVALUE,
                                                    lev, adr);
                                   end;
                                 FromAppTrue:
                                   emit2(picp,APPVARCONST, lev, i);
                                 FromAppFalse:
                                   emit2(picp,APPVARCONST, lev, i);
                             end;
                             selector(fsys,x);
                             if x.typ in stantyps then emit(picp,STDTYPE)
                        end
                        else
                        begin
                             if x.typ in stantyps then
                                case normal of
                                  FromPrgTrue:
                                    begin
                                     (*if x.typ = strings then
                                        emit2(picp,STRARGBYVALUE, lev, adr)
                                     else*)  emit2( picp,ARGBYVALUE,
                                                    lev, adr);
                                    end;
                                  FromPrgFalse: emit2( picp,LOADINDIRECT,
                                                       lev, adr);
                                  FromAppTrue: emit2( picp,APPVARCONST,
                                                      lev, i);
                                  FromAppFalse: emit2( picp,APPVARCONST,
                                                       lev, i);
                                end;
                        end
                   end ;
              type1, prozedure, appproc, AppProcArg:    error(picp,44);
              funktion :begin x.typ := typ;
                          if lev <> 0 then call(fsys, i)
                                else standfct(adr)
                        end;
              AppFunc :begin x.typ := typ;
                          emit1(picp,CALLAPPPROC, i);
                        end;
              AppFuncArg :begin x.typ := typ;
                            call(fsys, i);
                        end;
                    end (*case,with*)
                  end else
                  if sy in [charcon,intcon,longintcon,doublecon,
                            realcon,stringcon] then
                  begin
                     case sy of
                       realcon,doublecon:
                         begin
                              x.typ := reals; enterNumConst(picp,rnum,0);
                              emit2(picp,LOADCONST, ord(x.typ), idxCurNConst);
                         end;
                       stringcon:
                         begin
                              x.typ := strings;
                              emit2(picp,LOADCONST, ord(x.typ), inum);
                         end;
                       longintcon:
                         begin
                              x.typ := longints; enterNumConst(picp,0,inum);
                              emit2(picp,LOADCONST, ord(x.typ), idxCurNConst);
                         end;
                       else
                         begin
                              if sy = charcon then x.typ := chars
                                           else x.typ := ints;
                              emit1(picp,LITERAL, inum);
                         end;
                     end;
                     x.ref := 0; insymbol(picp);
                  end
                  else
                  if sy = lparent then
                   begin insymbol(picp); expression(fsys+[rparent], x);
                     if sy = rparent then insymbol(picp) else error(picp,4)
                   end else
                  if sy = notsy then
                   begin insymbol(picp); factor(fsys,x);
                     if x.typ=bools then emit(picp,NOTBOOL) else
                       if x.typ<>notyp then error(picp,32)
                   end ;
                  test(fsys, facbegsys, 6)
                end (*while*)
             end;
            end (*factor*) ;

          begin (*term*)
           with picp^ do
           begin
            factor(fsys+[times,rdiv,idiv,imod,andsy], x);
            while sy in [times,rdiv,idiv,imod,andsy] do
              begin op := sy; insymbol(picp);
                factor(fsys+[times,rdiv,idiv,imod,andsy], y);
                if op = times then
                begin x.typ := resulttype(x.typ, y.typ);
                  case x.typ of
                    notyp: ;
                    ints,longints,reals,doubles:
                         emit1(picp,TIMESCODE, ord(x.typ));
                  end
                end else
                if op = rdiv then
                begin
                  case x.typ of
                    ints : begin emit1(picp,INTTOFLOAT,1); x.typ := reals
                         end ;
                    longints : begin emit1(picp,LINTTOFLOAT,1);
                               x.typ := reals
                         end ;
                  end;
                  case y.typ of
                    ints : begin emit1(picp,INTTOFLOAT,0); y.typ := reals
                      end ;
                    longints : begin emit1(picp,LINTTOFLOAT,0);
                               y.typ := reals
                      end ;
                  end;
                  if (x.typ in [reals,doubles]) and
                     (y.typ in [reals,doubles]) then
                            emit1(picp,DIVCODE, ord(x.typ)) else
                    begin if (x.typ<>notyp) and (y.typ<>notyp) then
                            error(picp,33);
                          x.typ := notyp
                    end
                end else
                if op = andsy then
                begin if (x.typ=bools) and (y.typ=bools) then
                         emit(picp,ANDBOOL) else
                      begin if (x.typ<>notyp) and (y.typ<>notyp) then
                               error(picp,32);
                         x.typ := notyp
                      end
                end else
                begin (*op in [idiv,imod]*)
                  if (x.typ=ints) and (y.typ=ints) then
                    if op=idiv then emit1(picp,DIVCODE, ord(x.typ))
                               else emit1(picp,MODCODE, ord(x.typ)) else
                    begin if (x.typ<>notyp) and (y.typ<>notyp) then
                             error(picp,34);
                          x.typ := notyp
                    end
                end
              end
           end;
          end (*term*) ;

        begin (*simpleexpression*)
         with picp^ do
         begin
          if sy in [plus,minus] then
            begin op := sy; insymbol(picp);
              term(fsys+[plus,minus], x);
              if (x.typ > reals) and not
                 ((op = plus) and (x.typ <> strings)) then error(picp,33)
              else
                if op = minus then emit1(picp,INVERTSIGN, ord(x.typ))
            end else
          term(fsys+[plus,minus,orsy], x);
          while sy in [plus,minus,orsy] do
            begin op := sy; insymbol(picp);
               term(fsys+[plus,minus,orsy], y);
               if op = orsy then
               begin
                 if (x.typ=bools) and (y.typ=bools) then emit(picp,ORBOOL)
                 else
                   begin if (x.typ<>notyp) and (y.typ<>notyp) then
                            error(picp,32);
                         x.typ := notyp
                   end
               end else
               begin
                 if (x.typ = strings) or (y.typ = strings) then
                 begin
                      if (x.typ <> y.typ) or (op <> plus) then error(picp,33)
                      else emit1(picp,PLUSCODE, ord(x.typ));
                 end
                 else
                 begin
                   x.typ := resulttype(x.typ, y.typ);
                   case x.typ of
                     notyp: ;
                     ints,longints,reals,doubles:
                        if op = plus then emit1(picp,PLUSCODE, ord(x.typ))
                        else emit1(picp,MINUSCODE, ord(x.typ));
                   end
                 end
               end
            end
         end;
        end (*simpleexpression*) ;

      begin (*expression*)
       with picp^ do
       begin
        simpleexpression(fsys+[eql,neq,lss,leq,gtr,geq], x);
        if sy in [eql,neq,lss,leq,gtr,geq] then
        begin
          op := sy; insymbol(picp); simpleexpression(fsys, y);
          if (x.typ = strings) and (y.typ = strings) then rtyp := strings
          else rtyp := resulttype(x.typ, y.typ);
          if (rtyp in [notyp,bools,chars,strings,ints,longints,reals,doubles]) then
          begin
             if rtyp in [notyp,bools,chars,ints] then rtyp := ints;
             case op of
                  eql: emit1(picp,EQLCODE, ord(rtyp));
                  neq: emit1(picp,NEQCODE, ord(rtyp));
                  lss: emit1(picp,LSSCODE, ord(rtyp));
                  leq: emit1(picp,LEQCODE, ord(rtyp));
                  gtr: emit1(picp,GTRCODE, ord(rtyp));
                  geq: emit1(picp,GEQCODE, ord(rtyp));
             end;
          end
          else error(picp,35);
          x.typ := bools
        end
       end;
      end (*expression*) ;

      procedure assignment(lv,ad: integer);
      var
         x,y: item; IsStrIndex : Boolean;
         (*PIdTab^[i].obj in [variable,prozedure]*)
      begin
       with picp^ do
       begin
        x.typ := PIdTab^[i].typ;
        x.ref := PIdTab^[i].ref;
        case PIdTab^[i].normal of
          FromPrgTrue: emit2(picp,ARGBYADDRESS, lv, ad);
          FromPrgFalse:
            begin
                 (*if x.typ = strings then
                    emit2(picp,STRARGBYVALUE, lv, ad)
                 else*) emit2(picp,ARGBYVALUE, lv, ad);
            end;
          FromAppTrue: emit2(picp,APPARGBYADDRESS, lv, i);
          FromAppFalse: emit2(picp,APPVARCONST, lv, i);
        end;
        IsStrIndex := False;
        if sy in [lbrack,lparent,period] then
        begin
             if x.typ = strings then IsStrIndex := True;
             selector([becomes,eql]+fsys, x);
        end;
        if sy = becomes then insymbol(picp) else
          begin error(picp,51); if sy = eql then insymbol(picp)
          end ;
        expression(fsys, y);
        if (x.typ = y.typ) or
           ( (x.typ in [reals,doubles]) and (y.typ in [reals,doubles])) then
          if x.typ in stantyps then
             begin
                  if x.typ = strings then
                  begin
                       case PIdTab^[i].normal of
                         FromPrgTrue : emit1(picp,STORESTRING, i);
                         FromAppTrue : emit1(picp,STOREAPPSTRING, i);
                       end;
                  end
                  else
                      if PIdTab^[i].normal = FromAppTrue then
                      begin
                           if IsStrIndex then emit1(picp,STOREAPPSTRCHAR, i)
                           else emit(picp,APPSTORESTD);
                      end
                      else
                      begin
                           if IsStrIndex then emit1(picp,STORESTRCHAR, ad)
                           else emit(picp,STORESTD);
                      end;
             end
          else
          if x.ref <> y.ref then error(picp,46) else
          if x.typ = arrays then emit1(picp,COPYBLOCK, PArrayTab^[x.ref].size)
                            else emit1(picp,COPYBLOCK, PBlockTab^[x.ref].vsize)
        else
        if (x.typ in [reals,doubles]) and (y.typ in [ints,longints]) then
          begin
            case y.typ of
              ints : emit1(picp,INTTOFLOAT,0);
              longints: emit1(picp,LINTTOFLOAT,0);
            end;
            if PIdTab^[i].normal = FromAppTrue then
               emit(picp,APPSTORESTD)
            else emit(picp,STORESTD);
          end
          else
          if (x.typ = longints) and (y.typ = ints) then
          begin
            emit1(picp,INTTOLINT,0);
            if PIdTab^[i].normal = FromAppTrue then
               emit(picp,APPSTORESTD)
            else emit(picp,STORESTD);
          end
          else
          if (x.typ<>notyp) and (y.typ<>notyp) then error(picp,46)
       end;
      end (*assignment*) ;

      procedure compoundstatement;
      var
         iscompound:boolean (* check for extra begin..ends *);
      begin
       with picp^ do
       begin
        insymbol(picp);
        iscompound:=false;
        statement([semicolon,endsy]+fsys, jumponbreak, jumponcontinue);
        while sy in [semicolon]+statbegsys do
        begin if sy = semicolon then insymbol(picp) else error(picp,14);
          iscompound:=true;
          statement([semicolon,endsy]+fsys, jumponbreak, jumponcontinue)
        end ;
        if sy = endsy then insymbol(picp) else error(picp,57);
        if not iscompound and (errs=[]) then
            if WriteOut then
               writeln(pouterr^, ' last begin..end pair superflous')
       end;
      end (*compoundstatemenet*) ;

      procedure ifstatement;
      var
         x: item; lc1,lc2: integer;
      begin
       with picp^ do
       begin
        insymbol(picp);
        expression(fsys+[thensy,dosy], x);
        if not (x.typ in [bools,notyp]) then error(picp,17);
        lc1 := lc; emit(picp,JUMPCOND);  (*jmpc*)
        if sy = thensy then insymbol(picp) else
          begin error(picp,52); if sy = dosy then insymbol(picp)
          end ;
        statement(fsys+[elsesy], jumponbreak, jumponcontinue);
        if sy = elsesy then
          begin insymbol(picp); lc2 := lc; emit(picp,JUMP);
            PCodeArray^[lc1].y := lc;
            statement(fsys, jumponbreak, jumponcontinue);
            PCodeArray^[lc2].y := lc
          end
        else PCodeArray^[lc1].y := lc
       end;
      end (*ifstatement*) ;

      procedure casestatement;
      var
         x: item;
         i,j,k,lc1: integer;
         casetab: array [1..csmax] of
                       packed record val, lc: index end ;
         exittab: array [1..csmax] of integer;

        procedure caselabel;
        var
           lab: conrec; k: integer;
        begin
         with picp^ do
         begin
          constant(fsys+[comma,colon], lab);
          if lab.tp <> x.typ then error(picp,47) else
          if i = csmax then fatal(picp,FERRCODE) else
            begin Inc(i); k := 0;
              casetab[i].val := lab.i; casetab[i].lc := lc;
              repeat Inc(k) until casetab[k].val = lab.i;
              if k < i then error(picp,1);   (*multiple definition*)
            end
         end;
        end (*caselabel*) ;

        procedure onecase;
        begin
         with picp^ do
         begin
          if sy in constbegsys then
          begin caselabel;
            while sy = comma do
              begin insymbol(picp); caselabel
              end ;
            if sy = colon then insymbol(picp) else error(picp,5);
            statement([semicolon,endsy]+fsys, jumponbreak, jumponcontinue);
            Inc(j); exittab[j] := lc; emit(picp,JUMP)
          end
         end;
        end (*onecase*) ;

      begin
       with picp^ do
       begin
        insymbol(picp); i := 0; j := 0;
        expression(fsys+[ofsy,comma,colon], x);
        if not (x.typ in [ints,bools,chars,notyp]) then error(picp,23);
        lc1 := lc; emit(picp,JUMPSWITCH);  (*jmpx*)
        if sy = ofsy then insymbol(picp) else error(picp,8);
        onecase;
        while sy = semicolon do
          begin insymbol(picp); onecase
          end ;
        PCodeArray^[lc1].y := lc;
        for k := 1 to i do
          begin
               emit1(picp,DONOTHING,casetab[k].val);
               emit1(picp,DONOTHING,casetab[k].lc)
          end ;
        emit1(picp,JUMP,0);
        for k := 1 to j do PCodeArray^[exittab[k]].y := lc;
        if sy = endsy then insymbol(picp) else error(picp,57)
       end;
      end (*casestatement*) ;

      procedure repeatstatement;
      var
         x: item; lcb, lcc, lc1: integer;
      begin
       with picp^ do
       begin
        lcb := lc;
        emit(picp,DONOTHING);
        lcc := lc;
        emit(picp,DONOTHING);
        lc1 := lc;
        insymbol(picp);
        statement([semicolon,untilsy]+fsys, lcb, lcc);
        while sy in [semicolon]+statbegsys do
        begin if sy = semicolon then insymbol(picp) else error(picp,14);
          statement([semicolon,untilsy]+fsys, lcb, lcc)
        end ;
        if sy = untilsy then
          begin
            insymbol(picp);
            PCodeArray^[lcc].y := lc;
            expression(fsys, x);
            if not (x.typ in [bools,notyp]) then error(picp,17);
            emit1(picp,JUMPCOND,lc1)
          end
        else error(picp,53);
        PCodeArray^[lcb].y := lc;
       end;
      end (*repeatstatement*) ;

      procedure whilestatement;
      var
         x: item; lcc, lc1,lc2: integer;
      begin
       with picp^ do
       begin
        insymbol(picp);
        lcc := lc;
        emit(picp,DONOTHING);
        lc1 := lc;
        PCodeArray^[lcc].y := lc;
        expression(fsys+[dosy], x);
        if not (x.typ in [bools,notyp]) then error(picp,17);
        lc2 := lc; emit(picp,JUMPCOND);
        if sy = dosy then insymbol(picp) else error(picp,54);
        statement(fsys, lc2, lcc);
        emit1(picp,JUMP,lc1); PCodeArray^[lc2].y := lc
       end;
      end (*whilestatement*) ;

      procedure forstatement;
      var
         cvt: ICPAS_TTypes; x: item;
         i,f,lc0,lc1,lc2: integer;
      begin
       with picp^ do
       begin
        insymbol(picp);
        if sy = ident then
          begin i := locId(picp,level,id); insymbol(picp);
            if i = 0 then cvt := ints else
            if PIdTab^[i].obj = variable then
              begin cvt := PIdTab^[i].typ;
                if not (PIdTab^[i].normal = FromPrgTrue) then error(picp,37)
                else
                  emit2(picp,ARGBYADDRESS, PIdTab^[i].lev, PIdTab^[i].adr);
                if not (cvt in [notyp,ints,bools,chars]) then error(picp,18)
              end else
              begin error(picp,37); cvt := ints
              end
          end else skip([becomes,tosy,downtosy,dosy]+fsys, 2);
        if sy = becomes then
          begin insymbol(picp); expression([tosy,downtosy,dosy]+fsys, x);
            if x.typ <> cvt then error(picp,19);
          end else skip([tosy,downtosy,dosy]+fsys, 51);
        f := 1;
        if sy in [tosy, downtosy] then
          begin if sy = downtosy then f := -1;
            insymbol(picp); expression([dosy]+fsys, x);
            if x.typ <> cvt then error(picp,19)
          end else skip([dosy]+fsys, 55);
        lc0 := lc;
        emit(picp,DONOTHING);
        lc1 := lc;
        if f > 0 then emit(picp,FOR1UP)
        else emit(picp,FOR1DOWN);
        if sy = dosy then insymbol(picp) else error(picp,54);
        lc2 := lc; statement(fsys, lc1, lc0);
        PCodeArray^[lc0].y := lc;
        if f > 0 then emit1(picp,FOR2UP,lc2)
        else emit1(picp,FOR2DOWN, lc2);
        PCodeArray^[lc1].y := lc;
       end;
      end (*forstatement*) ;

      procedure standproc(n: integer);
      var
         i,f, fio: integer;
         x,y: item;
         prevsy : symbol;
      begin
       with picp^ do
       begin
        case n of
   1,2: begin (*read*)
          if not iflag then
            begin error(picp,20); iflag := true
            end ;
          fio := 0;
          prevsy := sy;
          if sy = lparent then
          begin
            repeat
                  insymbol(picp);
                  if (prevsy = lparent) and (sy = ident) then
                  begin
                       prevsy := rparent;
                       i := locId(picp,level,id);
                       with PIdTab^[i] do
                       begin
                            if (obj = variable) and (typ = texts) then
                            begin
                                 fio := i;
                                 insymbol(picp);
                                 continue;
                            end;
                       end;
                  end;
                  if sy <> ident then error(picp,2)
                  else
                  begin
                       i := locId(picp,level,id); insymbol(picp);
                       if i <> 0 then
                       if PIdTab^[i].obj <> variable then error(picp,37)
                       else
                       begin
                            x.typ := PIdTab^[i].typ;
                            x.ref := PIdTab^[i].ref;
                            if PIdTab^[i].normal = FromPrgTrue then
                               emit2( picp,ARGBYADDRESS,
                               PIdTab^[i].lev, PIdTab^[i].adr)
                            else
                            begin
                                 (*if PIdTab^[i].typ = strings then
                                 emit2(picp, STRARGBYVALUE, PIdTab^[i].lev,
                                 PIdTab^[i].adr)
                                 else *)
                                 emit2( picp,ARGBYVALUE, PIdTab^[i].lev,
                                 PIdTab^[i].adr);
                            end;
                            if sy in [lbrack,lparent,period] then
                               selector(fsys+[comma,rparent], x);
                            if x.typ in
                               [ints,longints,doubles,reals,chars,notyp] then
                            begin
                                 emit2(picp,PUSHFILEPTR, 1, fio);
                                 emit1(picp,READSTDPROC, ord(x.typ))
                            end
                            else error(picp,41)
                       end
                  end ;
                  test([comma,rparent], fsys, 6);
            until sy <> comma;
            if sy = rparent then insymbol(picp) else error(picp,4)
          end;
          if n = 2 then
          begin
               emit2(picp, PUSHFILEPTR, 1, fio);
               emit(picp,READLNSTDPROC)
          end;
        end ;
   3,4: begin (*write*)
          fio := 0;
          prevsy := sy;
          if sy = lparent then
          begin
            repeat
                  insymbol(picp);
                  if (prevsy = lparent) and (sy = ident) then
                  begin
                       prevsy := rparent;
                       i := locId(picp,level,id);
                       with PIdTab^[i] do
                       begin
                            if (obj = variable) and (typ = texts) then
                            begin
                                 fio := i;
                                 insymbol(picp);
                                 continue;
                            end;
                       end;
                  end;
                  if sy = stringcon then
                  begin
                       emit1(picp,LITERAL,ord(PStringTab^[inum]));
                       emit2(picp,PUSHFILEPTR, 0, fio);
                       emit1(picp,WRITESTDPROC,inum+1);
                       insymbol(picp)
                  end
                  else
                  begin
                       expression(fsys+[comma,colon,rparent], x);
                       if not (x.typ in stantyps) then error(picp,41);
                       (*
                       if x.typ = strings then
                       begin
                       {warning emit1(picp,LITRAL, ref) in konstant}
                       {emit1(picp,WRITESTDPROC,PIdTab^[i].adr);}
                       end
                       else
                       *)
                       if sy = colon then
                       begin
                            insymbol(picp);
                            expression(fsys+[comma,colon,rparent], y);
                            if y.typ <> ints then error(picp,43);
                            if sy = colon then
                            begin
                                 if not (x.typ in [reals,doubles]) then
                                    error(picp,42);
                                 insymbol(picp);
                                 expression(fsys+[comma,rparent], y);
                                 if y.typ <> ints then error(picp,43);
                                 emit2(picp, PUSHFILEPTR, 0, fio);
                                 emit(picp,WRITEFMTSTDPROC)
                            end
                            else
                            begin
                                 emit2(picp, PUSHFILEPTR, 0, fio);
                                 emit1(picp,WRITE2STDPROC, ord(x.typ));
                            end;
                       end
                       else
                       begin
                            emit2(picp,PUSHFILEPTR, 0, fio);
                            emit1(picp,WRITE1STDPROC, ord(x.typ))
                       end;
                  end;
            until sy <> comma;
            if sy = rparent then insymbol(picp) else error(picp,4)
          end;
          if n = 4 then
          begin
               emit2(picp, PUSHFILEPTR, 0, fio);
               emit(picp,WRITELNSTDPROC);
          end;
        end ;
      end (*case*)
      end;
      end (*standproc*) ;

    begin (*statement*)
     with picp^ do
     begin
      if sy in statbegsys+[ident] then
          case sy of
            ident:
                  begin
                       i := locId(picp,level,id); insymbol(picp);
                       if i <> 0 then
                       with PIdTab^[i] do
                       begin
                          case obj of
                               konstant, type1, appconst: error(picp,45);
                               (*olabel:
                                      begin
                                           if sy <> colon then error(picp, 5);
                                           if adr <> 0 then error(picp, 1)
                                           else adr := lc;
                                           sy := semicolon;
                                      end; *)
                               variable, appvar: assignment(lev, adr);
                               prozedure:  if lev <> 0 then call(fsys, i)
                                           else standproc(adr);
                               appproc: emit1(picp,CALLAPPPROC, i);
                               AppProcArg: call(fsys, i);
                               funktion,appfunc, AppFuncArg:
                                                 if ref = display[level] then
                                                    assignment(lev+1, 0)
                                                 else error(picp,45);
                          end;
                       end;
                  end ;
            beginsy:  compoundstatement;
            ifsy:     ifstatement;
            casesy:   casestatement;
            whilesy:  whilestatement;
            repeatsy: repeatstatement;
            forsy:    forstatement;
            exitsy:
                   begin
                        insymbol(picp);
                        case blkTyp of
                          proctype : emit(picp,EXITPROC);
                          functype : emit(picp,EXITFUNC);
                          progtype : emit(picp,PROGEND);
                        end;
                   end;
            continuesy:
                       begin
                            if jumponcontinue = 0 then
                               error(picp,59) {warning}
                            else emit1(picp,JUMPINDIRECT, jumponcontinue);
                            insymbol(picp);
                       end;
            breaksy:
                    begin
                         if jumponbreak = 0 then error(picp,59) {warning}
                         else emit1(picp,BREAKLOOP, jumponbreak);
                         insymbol(picp);
                    end;
            (*gotosy:
                   begin
                        insymbol(picp);
                        if sy <> ident then skip([semicolon]+fsys, 2)
                        else
                        begin
                             i := locId(picp, level, id);
                             with PIdTab^[i] do
                             begin
                                  if obj <> olabel then
                                     skip([semicolon]+fsys, 44)
                                  else if lev <> level then
                                          skip([semicolon]+fsys, 62)
                                       else
                                       begin
                                            emit1(picp, GOTOADR, i);
                                            insymbol(picp);
                                       end;
                             end;
                        end;
                   end;*)
          end
          else if errs=[] then
                  if WriteOut then
                     writeln(pouterr^, '^':cc+6,'warning: null statement');
        test(fsys, [], 14)
     end;
    end (*statement*) ;

begin (*block*)
 with picp^ do
 begin
  dx := ICPAS_DxSize; prt := IdxIdTab;
  if level > lmax then fatal(picp,FERRLEVELS);
  test([lparent,colon,semicolon], fsys, 14);
  enterblock(picp);
  if InAppDeclaration = 1 then display[level] := 1
  else display[level] := IdxBlockTab;
  prb := IdxBlockTab;
  PIdTab^[prt].typ := notyp; PIdTab^[prt].ref := prb;
  if (sy = lparent) and (level > 1) then parameterlist;
  PBlockTab^[prb].lastpar := IdxIdTab; PBlockTab^[prb].psize := dx;
  if blktyp = functype then
    if sy = colon then
    begin insymbol(picp);   (*function type*)
      if sy = ident then
      begin x := locId(picp,level,id); insymbol(picp);
        if x <> 0 then
          if PIdTab^[x].obj <> type1 then error(picp,29) else
            if PIdTab^[x].typ in stantyps then
               PIdTab^[prt].typ := PIdTab^[x].typ
            else error(picp,15)
      end else skip([semicolon]+fsys, 2)
    end else error(picp,5);
  if sy = semicolon then insymbol(picp) else error(picp,14);
  repeat
    if sy = constsy then constantdeclaration;
    if sy = typesy then typedeclaration;
    (*if sy = labelsy then labeldeclaration;*)
    if sy = varsy then variabledeclaration;
    PBlockTab^[prb].vsize := dx;
    while sy in [proceduresy,functionsy] do procdeclaration;
    if InAppDeclaration <> 0 then Exit;
    test([beginsy], blockbegsys+statbegsys, 56)
  until sy in statbegsys;
  PIdTab^[prt].adr := lc;
  insymbol(picp);
  statement([semicolon,endsy]+fsys, 0, 0);
  while sy in [semicolon]+statbegsys do
    begin if sy = semicolon then insymbol(picp) else error(picp,14);
      statement([semicolon,endsy]+fsys, 0, 0)
    end ;
  if sy = endsy then insymbol(picp) else error(picp,57);
  test(fsys+[period], [], 6)
 end;
end (*block*) ;

procedure printtables(picp : ICPAS_PICPrivateRecord);
   var i: integer; o: ICPAS_Order;
begin
 with picp^ do
 begin
   writeln( pouterr^,
            '0identifiers          link  obj  typ  ref  nrm  lev  adr');
   for i := PBlockTab^[1].last +1 to IdxIdTab do
      with PIdTab^[i] do
      writeln(pouterr^, i,' ',name,link:5, ord(obj):5, ord(typ):5, ref:5,
            ord(normal):5, lev:5, adr:5);
   writeln(pouterr^, '0blocks    last lpar psze vsze');
   for i := 1 to IdxBlockTab do
      with PBlockTab^[i] do
      writeln(pouterr^, i, last:5, lastpar:5, psize:5, vsize:5);
   writeln(pouterr^, '0arrays    xtyp etyp eref  low high elsz size');
   for i := 1 to IdxArrayTab do
      with PArrayTab^[i] do
      writeln(pouterr^, i, ord(inxtyp):5, ord(eltyp):5,
              elref:5, low:5, high:5, elsize:5, size:5);
   writeln(pouterr^, '0code:');
   for i := 0 to lc-1 do
   begin if i mod 5 = 0 then
         begin writeln(pouterr^); write(pouterr^,i:5)
         end ;
      o := PCodeArray^[i]; write(pouterr^,integer(o.f):5);
      if o.f < PROGEND then
        if o.f < MARKBETWEN then write(pouterr^,o.x:2, o.y:5)
                    else write(pouterr^,o.y:7)
      else write(pouterr^,'       ');
      write(pouterr^,',')
   end ;
   writeln(pouterr^);
 end;
end (*printtables*) ;

end.