(*
This is an atempt to make a extension language for Delphi,
searching internet for such program I can't found anithing
for imediate and easy use ( ofcourse that I found TCL, LUA, ...,
but not yet adapted to use in Delphi, if somebody know one please
notyfy me mingole@redestb.es) but I found a program called pascals.pas
writed by Niklaus Wirth in 1976, see below.

(*author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76*)
(* updated 19.3.80, 22.4.81 msp uwa for cs101/200 *)

(*
So I get that file and did some investigation, changes and adaptations
and get a compiler and a interpreter for a subset of pascal language.
I think that it's near what I was looking for:

  - An extension language to embed in Delphi.
  - Reasonable easy to extend.
  - Easy to learn, it's pascal.
  - Full control over the process, full source code.

Ofcourse there are problems and I'm putting it in the net for people that
need it like me and people that can do some work and sugestions to
get it better.

    I'll apreciate sugestions and comments in Portuguese, Spanish or English
my Internet address is  mingole@resdestb.es , in TSTICPAS.PAS file I'll try
to explain how it works.
        The file list is:
            - ICPAS.PAS  : this file contain Interface routines.
            - ICPASI.PAS : this is the Interpret.
            - ICPASC.PAS : the compiler.
            - ICPASH.PAS : the internal header file.
            - PASTST.PAS : a modified version to test the compiler and
                           the interpret.
            - TSTICPAS.PAS : contain an poor example that
                             was compiled in TURBO PASCAL 7 and in
                             Delphi 1.0.
            - PASCALS.PAS : the original file from Niklaus Wirth,
                            I made some changes to compile it in
                            TURBO PASCAL 7, I include it for people
                            that want to study it and to compare
                            with the actual version.

(*
author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76

Reworked by: Domingo Alvarez Duarte, Madrid - Spain 06.01.97
             mingole@redestb.es

Version : 1.0
*)

unit ICPASH;

interface
uses ICPAS;

const
    ROUND_FUNCTION = 9;
    TRUNC_FUNCTION = 10;

    (* error *)
    IDNOTDECLARED    = 0;
    IDDECLAREDTWICE  = 1;
    IDEXPECTED       = 2;
    PRGEXPECTED      = 3;

    (*fatal errors*)
    FERRIDENTIFIER = 1;
    FERRPROCEDURES = 2;
    FERRREALS      = 3;
    FERRARRAYS     = 4;
    FERRLEVELS     = 5;
    FERRCODE       = 6;
    FERRSTRINGS    = 7;
    FERRSTRING     = 8;
    FERRDOUBLE     = 9;
    FERRLONGINTS   = 10;

    TestPrgName = 'test0     ';
    BlankId     = '          ';
    InputId     = 'input     ';
    OutputId    = 'output    ';
    nkw = 30;     (*no. of key words*)
    (*alng =  10;*)     (*no. of significant chars in identifiers*)
    llng = 250;     (*input line length*)
    emax = 308;     (*max exponent of real numbers*)
    emin =-324;     (*min exponent*)
    kmax =  15;     (*max no. of significant digits*)
    (*tmax = 100;*)     (*size of table*)
    (*bmax =  20;*)     (*size of block-table*)
    (*amax =  30;*)     (*size of array-table*)
    (*c2max = 35;*)     (*size of real constant table*)
    csmax = 30;     (*max no. of cases*)
    (*cmax = 800;*)     (*size of code*)
    lmax =   10;     (*maximum level*)
    (*smax = 600;*)     (*size of string-table*)
    ermax = 62;     (*max error no.*)
    (*omax =  63;*)     (*highest order code*)
    xmax = maxint (*131071*);  (*2**17 - 1*)
    nmax = maxint;   (*2**48-1 on CYBER*)
    lnmax = maxLongInt;
    lineleng = 255; (*output line length*)
    linelimit = 1000;
    (*stacksize = 1450;*)
    ICPAS_ProgramLevel = 1; (*level of program variables and procedures*)
    ICPAS_DxSize = 5;       (*PBlockTab start pos*)
    ICPAS_CallSaveSize = 5;   (* stack size reserved for call*)
    ICPAS_IdTabGrowStep = 20; (*amount of size increase of idTab on resize*)
    ICPAS_IdTabMaxSize  = 1000; (*max size of idTab*)
    ICPAS_ArrayTabGrowStep = 10; (*size increase of ArrayTab on resize*)
    ICPAS_ArrayTabMaxSize  = 1000; (*max size of ArrayTab*)
    ICPAS_BlockTabGrowStep = 20; (*size increase of BlockTab on resize*)
    ICPAS_BlockTabMaxSize  = 1000; (*max size of BlockTab*)
    ICPAS_StringTabGrowStep = 500; (*size increase of StringTab on resize*)
    ICPAS_StringTabMaxSize  = 20000; (*max size of StringTab*)
    ICPAS_CodeArrayGrowStep = 100; (*size increase of CodeArray on resize*)
    ICPAS_CodeArrayMaxSize  = 10000; (*max size of CodeArray*)
    ICPAS_NConstArrayGrowStep = 20; (*size increase of NConstArray on resize*)
    ICPAS_NConstArrayMaxSize  = 5000; (*max size of NConstArray*)
    ICPAS_StackRecArrayGrowStep = 20; (*size increase of StackRecArray on resize*)
    ICPAS_StackRecArrayMaxSize  = 6000; (*max size of StackRecArray*)
    ICPAS_LastStdFunc = 17;     (*last standard function*)

type
    ICPAS_OpCode =                   (* emit codes *)
                ( ARGBYADDRESS,
                  ARGBYVALUE,
                  STRARGBYVALUE,
                  APPARGBYADDRESS,
                  LOADINDIRECT,
                  UPDDISPLAY,
                  MARKBETWEN,
                  BUILTINFCT,
                  RECFLDSELECTOR,
                  (*GOTOADR,*)
                  JUMP,
                  JUMPCOND,
                  JUMPSWITCH,
                  JUMPINDIRECT,
                  DONOTHING,
                  FOR1UP,
                  FOR2UP,
                  FOR1DOWN,
                  FOR2DOWN,
                  BREAKLOOP,
                  MARKSTACK,
                  CALLPROC,
                  CALLAPPPROC,
                  CALLAPPPROC2,
                  ARRAYINDEX,
                  STRINDEX,
                  APPSTRINDEX,
                  LOADBLOCK,
                  COPYBLOCK,
                  LITERAL,
                  LOADCONST,
                  APPVARCONST,
                  INTTOLINT,
                  INTTOFLOAT,
                  LINTTOFLOAT,
                  PUSHFILEPTR,
                  READSTDPROC,
                  READLNSTDPROC,
                  WRITELNSTDPROC,
                  WRITEFMTSTDPROC,
                  WRITESTDPROC,
                  WRITE1STDPROC,
                  WRITE2STDPROC,
                  PROGEND,  (*Warnign don't alter the order before this*)
                  EXITPROC,
                  EXITFUNC,
                  STDTYPE,
                  INVERTSIGN,
                  STORESTD,
                  STORESTRING,
                  STOREAPPSTRING,
                  STORESTRCHAR,
                  STOREAPPSTRCHAR,
                  APPSTORESTD,
                  APPSTORESTRING,
                  NOTBOOL,
                  ORBOOL,
                  ANDBOOL,
                  EQLCODE,
                  NEQCODE,
                  LSSCODE,
                  LEQCODE,
                  GTRCODE,
                  GEQCODE,
                  PLUSCODE,
                  MINUSCODE,
                  TIMESCODE,
                  DIVCODE,
                  MODCODE
                );

    ICPAS_TObject = ( Konstant,Variable,Type1,Prozedure,Funktion,
                      AppVar,AppConst,AppProc,AppFunc,AppProcArg,
                      appFuncArg (*,olabel*));

    symbol = ( intcon,longintcon,doublecon,realcon,charcon,stringcon,
               notsy,plus,minus,times,idiv,rdiv,imod,andsy,orsy,
               eql,neq,gtr,geq,lss,leq,
               lparent,rparent,lbrack,rbrack,comma,semicolon,period,
               colon,becomes,constsy,typesy,varsy,functionsy,
               proceduresy,arraysy,recordsy,programsy,ident,
               beginsy,ifsy,casesy,repeatsy,whilesy,forsy,
               endsy,elsesy,untilsy,ofsy,dosy,tosy,downtosy,thensy,
               exitsy,breaksy,continuesy,(*labelsy,gotosy,*)
               compilerErrorsy);

    blockType = (progtype, functype, proctype, libtype, apptype);

    index  = -xmax .. +xmax;
    varnormal = (FromPrgFalse, FromPrgTrue, FromAppFalse,FromAppTrue);
    symset = set of symbol;
    typset = set of ICPAS_TTypes;

    item   = record
               typ: ICPAS_TTypes; ref: index;
             end ;

    ICPAS_Order  = packed record
               f: ICPAS_OpCode;
               x: -lmax..+lmax;
               y: -nmax..+nmax;
             end ;

    ICPAS_IdTab   = packed record                (*identifier table*)
                 name: ICPAS_TAlfa;  link: index;
                 typ: ICPAS_TTypes; ref: index;
                 normal: varnormal;
                 lev: 0 .. lmax;
                 case obj : ICPAS_TObject of
                      ints: (adr:integer);
                      appvar: (ptr:pointer);
             end ;

    ICPAS_BuiltinRec = record
                    x0: ICPAS_TAlfa; x1: ICPAS_TObject;
                    x2: ICPAS_TTypes; x3: integer;
    end;

    ICPAS_VarInstallRec = record
                    x0: ICPAS_TAlfa; x1: ICPAS_TObject;
                    x2: ICPAS_TTypes; x3: Pointer;
    end;

    ICPAS_TNumConst = record case ICPAS_TTypes of
                     longints : (l: ICPAS_TLongInt);
                     reals    : (r: ICPAS_TReal);
                     doubles  : (d: ICPAS_TDouble);
             end;

    ICPAS_UndefValRec = record case ICPAS_TTypes of
                  ints     : (i: integer);
                  longints : (l: ICPAS_TLongInt);
                  reals    : (r: ICPAS_TReal);
                  doubles  : (d: ICPAS_TDouble);
                  bools    : (b: ICPAS_TBoolean);
                  chars    : (c: ICPAS_TAlfa);
                  strings  : (s: ICPAS_STRVar);
              end;

    ICPAS_PStackRecArray = ^ICPAS_StackRecArray;
    ICPAS_StackRecArray = array [0 .. ICPAS_StackRecArrayMaxSize]
                       of ICPAS_StackRec;

    ICPAS_PIdTabArray = ^ICPAS_IdTabArray;
    ICPAS_IdTabArray = array [0 .. ICPAS_IdTabMaxSize] of ICPAS_IdTab;

    ICPAS_ArrayTab = packed record                (*array table*)
                 inxtyp, eltyp: ICPAS_TTypes;
                 elref, low, high, elsize, size: index;
               end ;
    ICPAS_PArrayTabArray = ^ICPAS_ArrayTabArray;
    ICPAS_ArrayTabArray = array [0 .. ICPAS_ArrayTabMaxSize]
                         of ICPAS_ArrayTab;

    ICPAS_BlockTab = packed record                 (*block-table*)
                  last, lastpar, psize, vsize: index
               end ;
    ICPAS_PBlockTabArray = ^ICPAS_BlockTabArray;
    ICPAS_BlockTabArray = array [0 .. ICPAS_BlockTabMaxSize]
                         of ICPAS_BlockTab;

    ICPAS_PStringTab = ^ICPAS_StringTab;
    ICPAS_StringTab = packed                       (*string table*)
                   array [0..ICPAS_StringTabMaxSize] of char;

    ICPAS_PCodeArray = ^ICPAS_CodeArray;
    ICPAS_CodeArray = array [0 .. ICPAS_CodeArrayMaxSize]  (*code array*)
                     of ICPAS_Order;

    ICPAS_PNConstArray = ^ICPAS_NConstArray;
    ICPAS_NConstArray = array [1 .. ICPAS_NConstArrayMaxSize]
                     (*real, longInt const tab*)
                       of ICPAS_TNumConst;
    ICPAS_InterpVars = record     (* Interpret variables *)
      pc : integer;     (*program counter*)
      tsi:  integer;    (*top stack index*)
      bi :  integer;    (*base index*)

      PStackRecArraySize : integer;
      stackSize : integer;
      stk : ICPAS_PStackRecArray;
                (*blockmark:              *)
                (*   stk[bi+0] = fct result  *)
                (*   stk[bi+1] = return adr  *)
                (*   stk[bi+2] = static link *)
                (*   stk[bi+3] = dynamic link*)
                (*   stk[bi+4] = table index *)
    end;

    ICPAS_PICPrivateRecord = ^ICPAS_ICPrivateRecord;
    ICPAS_ICPrivateRecord  = record
      Status: integer;      (*Fatal Error Code*)
      sy: symbol;           (*last symbol read by insymbol*)
      id: ICPAS_TAlfa;             (*identifier from insymbol*)
(*  inum: integer;          (*integer from insymbol*)
      inum: ICPAS_TLongInt;  (*longInt from insymbol*)
      rnum: ICPAS_TReal;     (*real number from insymbol*)
      (*sstr : string;*)        (*string from insymbol*)
      ch: char;             (*last character read from source program*)
      (*line: array [1..llng] of char;*)
      InputLine : string;
      cc: integer;          (*character counter*)
      lc: integer;          (*program location counter*)
      ll: integer;         (*length of current line*)

      iv : ICPAS_InterpVars; (*interpret variables*)

      WriteOut: Boolean;   (*flag output from compiler and interpret*)
      AppOnError : ICPAS_TPFuncOnError;
      (*called on a severe error occur*)

      GetInputLn  : ICPAS_TPFuncGetInputLn; (*get input for compiler*)
      GetInputEof : ICPAS_TPFuncGetInputEof; (*test input eof for compiler*)

      pinf, pinfc, poutf, pouterr : ICPAS_TPText;

      errs: set of 0..ermax;
      errpos: integer;
      progname: ICPAS_TAlfa;
      PrgBlkStart, InAppDeclaration : integer;

      iflag, oflag, skipflag: boolean;
      constbegsys,typebegsys,blockbegsys,facbegsys,statbegsys: symset;

      IdxIdTab,IdxArrayTab,IdxBlockTab,IdxStringTab,idxCurNConst,
      idxLastNConst: integer;  (*indices to tables*)

      stantyps: typset;
      display: array [0 .. lmax] of integer;

      PIdTab : ICPAS_PIdTabArray;        (*identifier table*)
      PIdTabSize : integer;

      PArrayTab : ICPAS_PArrayTabArray;        (*array table*)
      PArrayTabSize : integer;

      PBlockTab : ICPAS_PBlockTabArray;        (*block table*)
      PBlockTabSize : integer;

      PStringTab : ICPAS_PStringTab;        (*string table*)
      PStringTabSize : integer;

      PNConstArray : ICPAS_PNConstArray;        (*real, longint const table*)
      PNConstArraySize : integer;

      PCodeArray : ICPAS_PCodeArray;        (*code table*)
      PCodeArraySize : integer;
    end;

const
     undefVal : ICPAS_UndefValRec =
     (c : #0#0#0#0#0#0#0#0#0#0);

    ICPAS_KeyWord: array [1..nkw] of ICPAS_TAlfa =
           ( 'and       ', 'array     ', 'begin     ',
             'break     ', 'case      ', 'const     ',
             'continue  ', 'div       ', 'do        ',
             'downto    ', 'else      ', 'end       ',
             'exit      ', 'for       ', 'function  ',
             (*'goto      ',*) 'if        ',(* 'label     ',*)
             'mod       ', 'not       ', 'of        ',
             'or        ', 'procedure ', 'program   ',
             'record    ', 'repeat    ', 'then      ',
             'to        ', 'type      ', 'until     ',
             'var       ', 'while     '
           );

    ICPAS_KeySymbol: array [1..nkw] of symbol =
           ( andsy,       arraysy,      beginsy,
             breaksy,     casesy,       constsy,
             continuesy,  idiv,         dosy,
             downtosy,    elsesy,       endsy,
             exitsy,      forsy,        functionsy,
             (*gotosy,*)      ifsy,        (* labelsy,*)
             imod,        notsy,        ofsy,
             orsy,        proceduresy,  programsy,
             recordsy,    repeatsy,     thensy,
             tosy,        typesy,       untilsy,
             varsy,       whilesy
           );

    nStdFunctions = 33;

    ICPAS_StdFunctions : array[1.. nStdFunctions] of ICPAS_BuiltinRec =
         (
               (x0:'          '; x1:variable; x2:notyp; x3:0),
               (*sentinel*)
               (x0:'false     '; x1: konstant;x2:bools;x3:0),
               (x0:'true      '; x1: konstant;x2:bools;x3:1),
               (x0:'real      '; x1: type1;x2:reals;x3:1),
               (x0:'double    '; x1: type1;x2:doubles;x3:1),
               (x0:'char      '; x1: type1;x2:chars;x3:1),
               (x0:'string    '; x1: type1;x2:strings;x3:1),
               (x0:'boolean   '; x1: type1;x2:bools;x3:1),
               (x0:'integer   '; x1: type1;x2:ints ;x3:1),
               (x0:'longint   '; x1: type1;x2:longints ;x3:1),
               (x0:'text      '; x1: type1;x2:texts ;x3:1),
               (x0:'abs       '; x1: funktion;x2:reals;x3:0),
               (x0:'sqr       '; x1: funktion;x2:reals;x3:2),
               (x0:'odd       '; x1: funktion;x2:bools;x3:4),
               (x0:'chr       '; x1: funktion;x2:chars;x3:5),
               (x0:'ord       '; x1: funktion;x2:ints;x3:6),
               (x0:'succ      '; x1: funktion;x2:chars;x3:7),
               (x0:'pred      '; x1: funktion;x2:chars;x3:8),
               (x0:'round     '; x1: funktion;x2:ints;x3:ROUND_FUNCTION),
               (x0:'trunc     '; x1: funktion;x2:ints;x3:TRUNC_FUNCTION),
               (x0:'sin       '; x1: funktion;x2:reals;x3:11),
               (x0:'cos       '; x1: funktion;x2:reals;x3:12),
               (x0:'exp       '; x1: funktion;x2:reals;x3:13),
               (x0:'ln        '; x1: funktion;x2:reals;x3:14),
               (x0:'sqrt      '; x1: funktion;x2:reals;x3:15),
               (x0:'arctan    '; x1: funktion;x2:reals;x3:16),
               (x0:'eof       '; x1: funktion;x2:bools;x3:17),
               (x0:'eoln      '; x1: funktion;x2:bools;x3:18),
               (x0:'read      '; x1: prozedure;x2:notyp;x3:1),
               (x0:'readln    '; x1: prozedure;x2:notyp;x3:2),
               (x0:'write     '; x1: prozedure;x2:notyp;x3:3),
               (x0:'writeln   '; x1: prozedure;x2:notyp;x3:4),
               (x0:'          '; x1: prozedure;x2:notyp;x3:0)
         );

function ReallocMem(var P : Pointer; Size, NewSize : word ): Boolean;

implementation

function ReallocMem(var P : Pointer; Size, NewSize : word ): Boolean;
var
   ptr : Pointer;
begin
     ReallocMem := True;
     if (MaxAvail < NewSize) then
     begin
          ReallocMem := False;
          Exit;
     end;
     GetMem(ptr, NewSize);
     if P <> nil then
     begin
          Move(P^, ptr^, Size);
          FreeMem(P, Size);
     end;
     P := ptr;
end;

end.