unit MDIEdit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Printers,
  Dialogs, Menus, Clipbrd, StdCtrls;

type
  TEditForm = class(TForm)
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    MemoPopUp: TPopupMenu;
    FontDialog1: TFontDialog;
    WordWrap1: TMenuItem;
    Left1: TMenuItem;
    Right1: TMenuItem;
    Center1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    Edit1: TMenuItem;
    SelectAll1: TMenuItem;
    Character1: TMenuItem;
    Font1: TMenuItem;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N2: TMenuItem;
    Print1: TMenuItem;
    PrintSetup1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1: TPrintDialog;
    SaveFileDialog: TSaveDialog;
    procedure SelectAll(Sender: TObject);
    procedure SetFont(Sender: TObject);
    procedure SetWordWrap(Sender: TObject);
    procedure AlignClick(Sender: TObject);
    procedure CopyToClipboard(Sender: TObject);
    procedure CutToClipboard(Sender: TObject);
    procedure PasteFromClipboard(Sender: TObject);
    procedure Delete(Sender: TObject);
    procedure SetPopUpItems(Sender: TObject);
    procedure SetEditItems(Sender: TObject);
    procedure Open(const AFilename: string);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: Char);
  private
    Filename: string;
    procedure UpdateMenus;
    procedure SetEditRect;
  end;

implementation

{$R *.DFM}

uses MDIFrame, SysUtils, Messages, Extens;

const
  BackupExt = '.BAK';
  SWarningText = 'Save Changes to ''%s''?';
  DefaultCaption = 'Untitled';

procedure TEditForm.SelectAll(Sender: TObject);
begin
  Memo1.SelectAll;
end;

procedure TEditForm.SetFont(Sender: TObject);
begin
  FontDialog1.Font := Memo1.Font;
  if FontDialog1.Execute then
    Memo1.Font := FontDialog1.Font;
  SetEditRect;
end;

procedure TEditForm.SetWordWrap(Sender: TObject);
begin
  with Memo1 do
  begin
    WordWrap := not WordWrap;
    if WordWrap then
      ScrollBars := ssVertical else
      ScrollBars := ssBoth;
    WordWrap1.Checked := WordWrap;
  end;
  SetEditRect;
end;

procedure TEditForm.AlignClick(Sender: TObject);
begin
  Left1.Checked := False;
  Right1.Checked := False;
  Center1.Checked := False;
  with Sender as TMenuItem do Checked := True;
  with Memo1 do
    if Left1.Checked then
      Alignment := taLeftJustify
    else if Right1.Checked then
      Alignment := taRightJustify
    else if Center1.Checked then
      Alignment := taCenter;
end;

procedure TEditForm.CopyToClipboard(Sender: TObject);
begin
  Memo1.CopyToClipboard;
end;

procedure TEditForm.CutToClipboard(Sender: TObject);
begin
  Memo1.CutToClipboard;
end;

procedure TEditForm.PasteFromClipboard(Sender: TObject);
begin
  Memo1.PasteFromClipboard;
end;

procedure TEditForm.Delete(Sender: TObject);
begin
  Memo1.ClearSelection;
end;

procedure TEditForm.UpdateMenus;
var
  HasSelection: Boolean;
begin
  Paste1.Enabled := Clipboard.HasFormat(CF_TEXT);
  Paste2.Enabled := Clipboard.HasFormat(CF_TEXT);
  HasSelection := Memo1.SelLength <> 0;
  Cut1.Enabled := HasSelection;
  Copy1.Enabled := HasSelection;
  Delete1.Enabled := HasSelection;
  Cut2.Enabled := HasSelection;
  Copy2.Enabled := HasSelection;
end;

procedure TEditForm.SetEditItems(Sender: TObject);
begin
  UpdateMenus;
end;

procedure TEditForm.SetPopUpItems(Sender: TObject);
begin
  UpdateMenus;
end;

procedure TEditForm.Open(const AFilename: string);
begin
  Filename := AFilename;
  Memo1.Lines.LoadFromFile(FileName);
  Memo1.SelStart := 0;
  Caption := ExtractFileName(FileName);
  Memo1.Modified := False;
end;

procedure TEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  DialogValue: Integer;
  FName: string;
begin
  if Memo1.Modified then
  begin
    FName := Caption;
    DialogValue := MessageDlg(Format(SWarningText, [FName]), mtConfirmation,
      [mbYes, mbNo, mbCancel], 0);
    case DialogValue of
      id_Yes: Save1Click(Self);
      id_Cancel: CanClose := False;
    end;
  end;
end;

procedure TEditForm.New1Click(Sender: TObject);
begin
  FrameForm.NewChild(Sender);
end;

procedure TEditForm.Open1Click(Sender: TObject);
begin
  FrameForm.OpenChild(Sender);
end;

procedure TEditForm.Exit1Click(Sender: TObject);
begin
  FrameForm.Exit1Click(Sender);
end;

procedure TEditForm.Close1Click(Sender: TObject);
begin
  Close;
end;

{ the printing performed in this example either prints the entire buffer,   }
{ or...if a section of text is selected, will print the selected text;      }
{ in addition, the first line of selected text will be printed left         }
{ justified; no attempt is made to make the lines appear as they do on the  }
{ monitor.  WYSIWYG printing is beyond the scope of this demo program.      }
{ The following features of printing are not demonstrated:                  }
{     Multiple Copies                                                       }
{     Collating Multiple Copies                                             }
{     Page Ranges                                                           }
{     Multiple Fonts, Word Wrapping, etc.                                   }
procedure TEditForm.Print1Click(Sender: TObject);
var
  Line: Integer;
  PrintText: System.Text;
begin
  if PrintDialog1.Execute then
  begin
    AssignPrn(PrintText);
    Rewrite(PrintText);
    Printer.Canvas.Font := Memo1.Font;
    for Line := 0 to Memo1.Lines.Count - 1 do
      Writeln(PrintText, Memo1.Lines[Line]);
    System.Close(PrintText);
  end;
end;

procedure TEditForm.PrintSetup1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TEditForm.SaveAs1Click(Sender: TObject);
begin
  SaveFileDialog.Filename := Filename;
  if SaveFileDialog.Execute then
  begin
    Filename := SaveFileDialog.Filename;
    Caption := ExtractFileName(Filename);
    Save1Click(Sender);
  end;
end;

procedure TEditForm.Save1Click(Sender: TObject);

  procedure CreateBackup(const Filename: string);
  var
    BackupFilename: string;
  begin
    BackupFilename := ChangeFileExt(Filename, BackupExt);
    DeleteFile(BackupFilename);
    RenameFile(Filename, BackupFilename);
  end;

  function IsReadOnly(const Filename: string): Boolean;
  begin
    Result := Boolean(FileGetAttr(Filename) and faReadOnly);
    if Result then MessageDlg(Format('%s is read only.',
      [ExtractFilename(Filename)]), mtWarning, [mbOK], 0);
  end;

begin
  if (Filename = '') or IsReadOnly(Filename) then
    SaveAs1Click(Sender)
  else
  begin
    CreateBackup(Filename);
    Memo1.Lines.SaveToFile(Filename);
    Memo1.Modified := False;
  end;
end;

procedure TEditForm.SetEditRect;
var
  R: TRect;
begin
  R := Memo1.ClientRect;
  InflateRect(R, -3, -2);
  SendMessage(Memo1.Handle, EM_SETRECT, 0, Longint(@R));
end;

procedure TEditForm.FormCreate(Sender: TObject);
begin
  SetEditRect;
end;

procedure TEditForm.FormResize(Sender: TObject);
begin
  SetEditRect;
end;

procedure TEditForm.Memo1KeyPress(Sender: TObject; var Key: Char);
begin
     VerifyKey( Memo1.Handle, Integer(Key));
end;

end.

