unit MDIFrame;

interface

uses WinTypes, WinProcs, Classes, Graphics, Controls, Printers,
  Menus, MDIEdit, Dialogs, Forms;

type
  TFrameForm = class(TForm)
    OpenFileDialog: TOpenDialog;
    MainMenu1: TMainMenu;
    Open1: TMenuItem;
    Window1: TMenuItem;
    Tile1: TMenuItem;
    Cascade1: TMenuItem;
    ArrangeIcons1: TMenuItem;
    Separator3: TMenuItem;
    procedure NewChild(Sender: TObject);
    procedure OpenChild(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure ArrangeIcons1Click(Sender: TObject);
end;

var
  FrameForm: TFrameForm;

implementation

uses SysUtils;

{$R *.DFM}

procedure TFrameForm.NewChild(Sender: TObject);
var
  EditForm: TEditForm;
begin
  EditForm := TEditForm.Create(Application);
  EditForm.Show;
end;

procedure TFrameForm.OpenChild(Sender: TObject);
var
  EditForm: TEditForm;
begin
  if OpenFileDialog.Execute then
  begin
    EditForm := TEditForm.Create(Self);
    EditForm.Open(OpenFileDialog.Filename);
    EditForm.Show;
  end;
end;

procedure TFrameForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TFrameForm.Tile1Click(Sender: TObject);
begin
  Tile;
end;

procedure TFrameForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

procedure TFrameForm.ArrangeIcons1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

end.



