(*
This is an atempt to make a extension language for Delphi,
searching internet for such program I can't found anithing
for imediate and easy use ( ofcourse that I found TCL, LUA, ...,
but not yet adapted to use in Delphi, if somebody know one please
notyfy me mingole@redestb.es) but I found a program called pascals.pas
writed by Niklaus Wirth in 1976, see below.

(*author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76*)
(* updated 19.3.80, 22.4.81 msp uwa for cs101/200 *)

(*
So I get that file and did some investigation, changes and adaptations
and get a compiler and a interpreter for a subset of pascal language.
I think that it's near what I was looking for:

  - An extension language to embed in Delphi.
  - Reasonable easy to extend.
  - Easy to learn, it's pascal.
  - Full control over the process, full source code.

Ofcourse there are problems and I'm putting it in the net for people that
need it like me and people that can do some work and sugestions to
get it better.

    I'll apreciate sugestions and comments in Portuguese, Spanish or English
my Internet address is  mingole@resdestb.es , in TSTICPAS.PAS file I'll try
to explain how it works.
        The file list is:
            - ICPAS.PAS  : this file contain Interface routines.
            - ICPASI.PAS : this is the Interpret.
            - ICPASC.PAS : the compiler.
            - ICPASH.PAS : the internal header file.
            - PASTST.PAS : a modified version to test the compiler and
                           the interpret.
            - TSTICPAS.PAS : contain an poor example that
                             was compiled in TURBO PASCAL 7 and in
                             Delphi 1.0.
            - PASCALS.PAS : the original file from Niklaus Wirth,
                            I made some changes to compile it in
                            TURBO PASCAL 7, I include it for people
                            that want to study it and to compare
                            with the actual version.

(*
author: n.wirth, e.t.h. ch-8092 zurich, 1.3.76

Reworked by: Domingo Alvarez Duarte, Madrid - Spain 06.01.97
             mingole@redestb.es

Version : 1.0
*)


program tsticpas;

{$N+,E+}

uses ICPAS, ICPASI;

var
   icp, icp2, icp3 : ICPAS_PICRecord;
   x : integer;

   pi, PrgResult : ICPAS_TDouble;
   hoy : integer;
   hora : longint;
   appcharvar : char;
   ssv : string;
   sc : string;

   afa : ICPAS_TAppFuncArg;
   retRec : ICPAS_TReturnRec;

procedure Example( icp : ICPAS_PICRecord;
                  var pvar : array of ICPAS_StackRec); far;
var
   xi : integer;
   xs : string;
begin
     xi := pvar[0].i;
     xs := pvar[1].s.s^;
end;

function Example2( icp : ICPAS_PICRecord;
                  var pvar : array of ICPAS_StackRec) : ICPAS_TString; far;
var
   xi : integer;
   xs : string;
begin
     xi := pvar[0].i;
     xs := pvar[1].s.s^;
     Example2 := xs + ' Example2';
end;

function appchar : char; far;
begin
     appchar := 'X';
end;

procedure hello; far;
begin
     writeln('Hello there');
end;

function valuePi : ICPAS_TDouble; far;
begin
     valuePi := 3.14161111;
end;

function getStr : string; far;
begin
     getStr := ssv + sc;
end;

function MyErrorFunc( ne : integer) : Boolean; far;
begin
     (* Here we can raise an exception *)
     (* if ne = someError then MyErrorFunc := False;*)
     MyErrorFunc := False;
{$ifdef InDelphi}
     Abort;
{$else}
       Halt;
{$endif}
end;

function InputIsFinished(pf: ICPAS_TPText) : Boolean; far;
begin
     InputIsFinished := eof(input);
end;

function GetInputLine(pf : ICPAS_TPText; var s : string) : Boolean; far;
begin
     if eof(input) then GetInputLine := False
     else
     begin
          ReadLn(s);
          GetInputLine := True;
     end;
end;

begin
     pi := 3.1416895792;
     hoy := 20;
     hora := 123899;
     sc := 'Tais Alvarez Presoto';
     ssv := ' Domingo';

(*
  ICPAS_Init is a function that alloc the internal structure for the
  compiler and interpret, if it can get memory and initialize the
  internal structure the returned value is a pointer that works as a
  handle for the other functions.
*)
     Writeln('Free memory on start: ', MemAvail);

     icp := ICPAS_Init;
     if icp = nil then Exit;

(*
  ICPAS_InstallGetInputLn is to install a function that will be called
  by the compiler to get lines to compile, the main purpose is to
  suply the source code from other sources than files, maybe TMemos,
  streams and so long, if not installed the compiler will use the standard
  input redirected to the fileName suplied in ICPAS_Compile.

  ICPAS_InstallGetInputEof is to indicate the compiler when the source
  is finished, only applicable when the input is supplied by
  ICPAS_GetInputLn.

  This two functions require a ICPAS_PICRecord initialized handle,
  a function of type ICPAS_TPFuncGetInputLn and ICPAS_TPFuncGetInputEof
  and the return value is a pointer to the old functions installed.
*)
     ICPAS_InstallGetInputLn(icp, GetInputLine);
     ICPAS_InstallGetInputEof(icp, InputIsFinished);

(*
  ICPAS_InstallAppVar is to install application procedures, functions,
  read & write variables, and read only variables.

  Limitations:
     - All names must be in lower case and with max 10 characters long.
     - Actually only procedure and functions without parameters can be
       installed.
     - For functions the return value must be of type:
       - chars, boolean, integer, longint, doubles, string,
         represented by ICPAS_AppChar, ICPAS_AppInteger and
         so on.
     - For procedures the type ICPAS_AppNoTyp.
     - The strings should be ever 255 characters long for
       write.
*)
     ICPAS_InstallAppVar(icp, 'pi        ', ICPAS_AppConst,
                              ICPAS_AppDouble, @pi);
     ICPAS_InstallAppVar(icp, 'prgresult ', ICPAS_AppVar,
                              ICPAS_AppDouble, @prgresult);
     ICPAS_InstallAppVar(icp, 'hoy       ', ICPAS_AppVar,
                              ICPAS_AppInteger, @hoy);
     ICPAS_InstallAppVar(icp, 'ssv       ', ICPAS_AppVar,
                              ICPAS_AppString, @ssv);
     ICPAS_InstallAppVar(icp, 'hora      ', ICPAS_AppConst,
                              ICPAS_AppLongInt, @hora);
     ICPAS_InstallAppVar(icp, 'sc        ', ICPAS_AppConst,
                              ICPAS_AppString, @sc);
     ICPAS_InstallAppVar(icp, 'hello     ', ICPAS_AppProc,
                              ICPAS_AppNoTyp, @hello);
     ICPAS_InstallAppVar(icp, 'valuepi   ', ICPAS_AppFunc,
                              ICPAS_AppDouble, @valuepi);
     ICPAS_InstallAppVar(icp, 'appchar   ', ICPAS_AppFunc,
                              ICPAS_AppChar, @appchar);
     ICPAS_InstallAppVar(icp, 'appcharvar', ICPAS_AppVar,
                              ICPAS_AppChar, @appcharvar);
     ICPAS_InstallAppVar(icp, 'getstr    ', ICPAS_AppFunc,
                              ICPAS_AppString, @getStr);

     afa.n := Example;
     ICPAS_InstallAppProcArg( icp,
                              'procedure Example(i:integer;s:string);',
                              afa);

     afa.s := Example2;
     ICPAS_InstallAppProcArg( icp,
                              'function Example2(i:integer;s:string):string;',
                              afa);

(*
  ICPAS_InstallOnError
  When a severe error occurr the program will halt if no
  Error handle routine is supplied, in Delphi here is the
  place to generate an exception and prevent the program
  to terminate without clean up.
  The return value is a pointer to the
  old OnError handler if it exist.

  Actually the error code that this function get isn't allways
  correct, this is an area that need some work.
*)
     ICPAS_InstallOnError(icp, MyErrorFunc);

(*
  ICPAS_DuplicateHandle the main purpose is to obtain another
  valid handle without call initialization routines, it duplicate
  the handle passed.
  if the handle passed have compiled a source with succes the handle
  returned can be interpreted in the same way as the original.

  Warning when duplicating the handle all routines installed will
  remain in the returned handle, problably before use it to
  compile another source the routines that supply the source and
  inform that the input is finished need to be changed.

  Warning after an compillation or attempt to compile the handle
  can't be used to compile other source, in the future this
  limitation maybe wil disapear.
*)
     icp2 := ICPAS_DuplicateHandle(icp);

     if icp2 = nil then Exit;

(*
  ICPAS_Compile with a valid handle this routine will try to compile
  a source code given by the first string interpreted as a file,
  this is an area that need more work.
  By the routines ICPAS_TPFuncGetInputLn and ICPAS_TPFuncGetInputEof
  supplied we can get the source from other site.
*)
     Writeln('Free memory before compile: ', MemAvail);

     ICPAS_CompileFile(icp, 'pastst.pas', 'tmp.err');

     Writeln('Free memory after compile: ', MemAvail);
(*
  ICPAS_RunInterpret with a valid handle compiled succefully this
  routine execute the compiled result.
  It can be called many times with the same handle to reexecute.
  Warning
  - Because of the use of pointers to application functions and
    variables the compiled code can't be saved and used with other
    section.
*)

     for x := 1 to 5 do
         ICPAS_RunInterpret(icp);
     ICPAS_CompileFile(icp2, 'pastst.pas', 'tmp.err');
     for x := 1 to 5 do
         ICPAS_RunInterpret(icp2);

     ICPAS_CallFunc(icp, 'dosome    ', retRec);
     ICPAS_CallFunc(icp, 'retstring ', retRec);

     icp3 := ICPAS_DuplicateHandle(icp);

     Writeln('Free memory before free: ', MemAvail);

     if icp3 = nil then Exit;
     for x := 1 to 5 do
         ICPAS_RunInterpret(icp3);

     if not ICPAS_QuitAndFree(icp) then
        Writeln('Error in icp');
     if not ICPAS_QuitAndFree(icp2) then
        Writeln('Error in icp2');
(*
  ICPAS_QuitAndFree this is the routine that will free all memory
  used by the handle. After it the handle is unusable.
*)
     if not ICPAS_QuitAndFree(icp3) then
        Writeln('Error in icp3');

     Writeln('Free memory on end: ', MemAvail);

end.