{****************************************************************************}

{**                                                                        **} 

{**                          I  P  C  .  P  P                              **} 

{**                                                                        **} 

{****************************************************************************}

{**                                                                        **} 

{** Unit for Inter Process Communication in Linux                          **} 

{**                                                                        **} 

{** converted from ipc.h, msg,h, sem.h semparam.h shm.h                    **} 

{**                                                                        **} 

{** Author: Hansi Glaser <Johann.Glaser@gmx.net>                           **} 

{** Date:   24.12.1998                                                     **} 

{**                                                                        **} 

{** If you find any errors, please let me know and send me an EMail.       **} 

{** All other constructive suggestions are welcome.                        **} 

{**                                                                        **} 

{** For example programs contact me too.                                   **} 

{**                                                                        **} 

{****************************************************************************}

Unit IPC;

{$PACKRECORDS 1}



Interface

Uses Linux;



{ types.h }



Type Time_T = Cardinal;



{ ipc.h }



Const Version = 0;



Type Key_T = LongInt;

     IPC_Perm = record

                  Key  : Key_T;

		  UID  : Word;               { owner EUID and EGID }

		  GID  : Word;

                  CUID : Word;               { creator EUID and EGID }

		  CGID : Word;

		  Mode : Word;               { acces modes see mode flags below }

		  Seq  : Word;               { sequence number }

		End;  { is Word a unsigned short? }



Const IPC_PRIVATE : Key_T = 0;



{ resource get request flags }

Const IPC_CREAT  = $200;    { create if key is nonexistent }

      IPC_EXCL   = $400;    { fail if key exists }

      IPC_NOWAIT = $800;    { return error on wait }



{ Control commands used with semctl, msgctl and shmctl }

{ see also specific commands in sem.h, msg.h and shm.h }



Const IPC_RMID = 0;     { remove resource }

      IPC_SET  = 1;     { set ipc_perm options }

      IPC_STAT = 2;     { get ipc_perm options }

      IPC_INFO = 3;     { see ipcs }



{ IPC system-call function numbers }

      CSEMOP  =  1;

      CSEMGET =  2;

      CSEMCTL =  3;

      CMSGSND = 11;

      CMSGRCV = 12;

      CMSGGET = 13;

      CMSGCTL = 14;

      CSHMAT  = 21;

      CSHMDT  = 22;

      CSHMGET = 23;

      CSHMCTL = 24;



{ special shmsegs[id], msgque[id] or semary[id]  values }

Const IPC_UNUSED = -1;

      IPC_NOID   = -2;		{ being allocated/destroyed }



{ msg.h }



{ msgrcv options }

Const MSG_NOERROR = $1000;  { no error if message is too big }

      MSG_EXCEPT  = $2000;  { recv any msg except of specified type.}



      MSGMNI =   128;   { <= 1K }     { max # of msg queue identifiers }

      MSGMAX =  4056;   { <= 4056 }   { max size of message (bytes) }

      MSGMNB = 16384;   { ? }         { default max size of a message queue }



{ unused }

      MSGPOOL  = (MSGMNI*MSGMNB div 1024);	{ size in kilobytes of message pool }

      MSGTQL   = MSGMNB;                 	{ number of system message headers }

      MSGMAP   = MSGMNB;                     	{ number of entries in message map }

      MSGSSZ   = 16;                		{ message segment size }

      __MSGSEG = ((MSGPOOL*1024) div MSGSSZ); 	{ max no. of segments }

{      MSGSEG   = (__MSGSEG <= $ffff ? __MSGSEG : $ffff);}



{ one msg structure for each message }

Type PMsg = ^Msg;

     Msg = Record

             Msg_Next : PMsg;		{ next message on queue }

             Msg_Type : LongInt;

             Msg_Spot : ^Char;     	{ message text address }

             Msg_STime : Time_T;	{ msgsnd time }

	     Msg_TS    : Word;          { message text size }

	   End;



     PWait_Queue = ^Wait_Queue;

     Wait_Queue = Record

		    {Task : PTask_Struct; } { Task_Struct is very complicated! defined in /usr/src/linux/include/linux/sched.h }

		    Task : Pointer;

		    Next : PWait_Queue;

                  End;



{ one msqid structure for each queue on the system }

     PMsQID_ds = ^MsQID_ds;

     MsQID_ds = Record

                  Msg_Perm : IPC_Perm;

                  Msg_First : PMsg; 	{ first message on queue }

                  Msg_Last  : PMsg; 	{ last message in queue }

                  Msg_STime : Time_T; 	{ last msgsnd time }

                  Msg_RTime : Time_T; 	{ last msgrcv time }

                  Msg_CTime : Time_T; 	{ last change time }

                  WWait : ^Wait_Queue;

                  RWait : ^Wait_Queue;

                  Msg_CBytes,           { current number of bytes on queue }

                  Msg_QNum,  		{ number of messages in queue }

                  Msg_QBytes,		{ max number of bytes on queue }

                  Msg_LSPID,		{ pid of last msgsnd }

                  Msg_LRPID : Word;	{ last receive pid }

                End;



{ message buffer for msgsnd and msgrcv calls }

     PMsgBuf = ^TMsgBuf;

     TMsgBuf = Record

                 MType : Cardinal;  		{ type of message }

                 MText : Array[0..1] of Char;  	{ message text }

               End;



{ buffer for msgctl calls IPC_INFO, MSG_INFO }

     PMsgInfo = ^MsgInfo;

     MsgInfo = Record

     		 MsgPool : LongInt;

		 MsgMap  : LongInt;

		 MsgMax  : LongInt;

		 MsgMnb  : LongInt;

		 MsgMni  : LongInt;

		 MsgSsz  : LongInt;

		 MsgTql  : LongInt;

		 MsgSeg  : Word;

	       End;



{ These are used to wrap system calls. See ipc/util.c. }

     IPC_Kludge = Record

                    MsgP : PMsgBuf;

                    MsgTyp : LongInt;

                  End;



{ ipcs ctl commands }

Const MSG_STAT = 11;

      MSG_INFO = 12;



{ sem.h }



{ semop flags }

Const SEM_UNDO = $1000;  { undo the operation on exit }



{ semctl Command Definitions. }

       GETPID  = 11;       { get sempid }

       GETVAL  = 12;       { get semval }

       GETALL  = 13;       { get all semval's }

       GETNCNT = 14;       { get semncnt }

       GETZCNT = 15;       { get semzcnt }

       SETVAL  = 16;       { set semval }

       SETALL  = 17;       { set all semval's }



{ ipcs ctl cmds }

       SEM_STAT = 18;

       SEM_INFO = 19;



{ One semaphore structure for each semaphore in the system. }

Type PSem = ^Sem;

     Sem  = Record

	      SemVal : LongInt;         { current value }

	      SemPID : LongInt;         { pid of last operation }

	    End;





{ Each task has a list of undo requests. They are executed }

{ automatically when the process exits. }

     PSem_Undo = ^TSem_Undo;

     TSem_Undo  = Record

	 	    Proc_Next : PSem_Undo;	{ next entry on this process }

	 	    ID_Next   : PSem_Undo;	{ next entry on this semaphore set }

		    SemID     : LongInt;	{ semaphore set identifier }

		    SemAdj    : LongInt;	{ array of adjustments, one per semaphore }

		  End;



{ One semid data structure for each set of semaphores in the system. }

     PSemID_ds = ^SemID_ds;

     SemID_ds = Record

		  Sem_Perm : IPC_Perm;            { permissions .. see ipc.h }

		  Sem_OTime : Time_T;           { last semop time }

		  Sem_CTime : Time_T;           { last change time }

		  Sem_Base : PSem;           { ptr to first semaphore in array }

		  Sem_Pending : PSem;       { pending operations to be processed }

		  Sem_Pending_Last : ^PSem_Queue; { last pending operation }

		  Undo : PSem_Undo;	       { undo requests on this array }

		  Sem_NSems : Word;           { no. of semaphores in array }

		End;



{ semop system calls takes an array of these. }

     PSemBuf = ^SemBuf;

     SemBuf = Record

                Sem_Num  : Word;           { semaphore index in array }

		Sem_Op   : LongInt;        { semaphore operation }

		Sem_Flg  : LongInt;        { operation flags }

	      End;



{ One queue for each semaphore set in the system. }

     PSem_Queue = ^Sem_Queue;

     Sem_Queue  = Record

		    Next     : PSem_Queue;	 { next entry in the queue }

		    Prev     : ^PSem_Queue;	 { previous entry in the queue, *(q->prev) == q }

		    Sleeper  : PWait_Queue;      { sleeping process }

		    Undo     : PSem_Undo;	 { undo structure }

		    PID      : LongInt;	 	 { process id of requesting process }

		    Status   : LongInt;	 	 { completion status of operation }

		    Sma      : PSemID_ds;	 { semaphore array for operations }

		    SOps     : PSemBuf;	 	 { array of pending operations }

		    NSOps    : LongInt;	 	 { number of operations }

		  End;



     PSemInfo = ^SemInfo;

     SemInfo = Record

		 SemMap : LongInt;

		 SemMni : LongInt;

		 SemMns : LongInt;

		 SemMnu : LongInt;

		 SemMsl : LongInt;

		 SemOpm : LongInt;

		 SemUme : LongInt;

		 SemUsz : LongInt;

		 SemVmx : LongInt;

		 SemAem : LongInt;

	       End;



     SemUn = Record

               Case Word of

                 0 : (Val : LongInt);

                 1 : (Buf : PSemId_ds);

                 2 : (Arr : ^Word);

                 3 : (__Buf : PSemInfo);

                 4 : (Pad : Pointer);

               End;



(*

{ arg for semctl system calls. }

union semun {

  int val;			{ value for SETVAL }

  struct semid_ds *buf;		{ buffer for IPC_STAT & IPC_SET }

  ushort *array;		{ array for GETALL & SETALL }

  struct seminfo *__buf;	{ buffer for IPC_INFO }

  void *__pad;

{;

*)



Const  SEMMNI  = 128;             { ?  max # of semaphore identifiers }

       SEMMSL  = 32;              { <= 512 max num of semaphores per id }

       SEMMNS  = (SEMMNI*SEMMSL); { ? max # of semaphores in system }

       SEMOPM  = 32; 	          { ~ 100 max num of ops per semop call }

       SEMVMX  = 32767;           { semaphore maximum value }

{ unused }

       SEMUME  = SEMOPM;          { max num of undo entries per process }

       SEMMNU  = SEMMNS;          { num of undo structures system wide }

       SEMAEM  = (SEMVMX shr 1);  { adjust on exit max value }

       SEMMAP  = SEMMNS;          { # of entries in semaphore map }

       SEMUSZ  = 20;		  { sizeof struct sem_undo }



{ shmparam.h }



{ address range for shared memory attaches if no address passed to shmat() }

Const SHM_RANGE_START	= $50000000;

      SHM_RANGE_END	= $60000000;



{

 * Format of a swap-entry for shared memory pages currently out in

 * swap space (see also mm/swap.c).

 *

 * SWP_TYPE = SHM_SWP_TYPE

 * SWP_OFFSET is used as follows:

 *

 *  bits 0..6 : id of shared memory segment page belongs to (SHM_ID)

 *  bits 7..21: index of page within shared memory segment (SHM_IDX)

 *		(actually fewer bits get used since SHMMAX is so low)

 }



{

 * Keep _SHM_ID_BITS as low as possible since SHMMNI depends on it and

 * there is a static array of size SHMMNI.

 }

      _SHM_ID_BITS	= 7;

      SHM_ID_MASK	= ((1 shl _SHM_ID_BITS)-1);



      SHM_IDX_SHIFT	= (_SHM_ID_BITS);

      _SHM_IDX_BITS	= 15;

      SHM_IDX_MASK	= ((1 shl _SHM_IDX_BITS)-1);



{

 * _SHM_ID_BITS + _SHM_IDX_BITS must be <= 24 on the i386 and

 * SHMMAX <= (PAGE_SIZE << _SHM_IDX_BITS).

 }



      SHMMAX = $2000000;		{ max shared seg size (bytes) }

      SHMMIN = 1; { really PAGE_SIZE }	{ min shared seg size (bytes) }

      SHMMNI = (1 shl _SHM_ID_BITS);	{ max num of segs system wide }

      SHMALL =				{ max shm system wide (pages) }

	(1 shl (_SHM_IDX_BITS+_SHM_ID_BITS));

{      SHMLBA = PAGE_SIZE;	}	{ attach addr a multiple of this } { dont know PAGE_SIZE }

      SHMSEG = SHMMNI;			{ max shared segs per process }



{ shm.h }



Type PShmID_ds = ^PShmID_ds;

     ShmID_ds = record

	 	  Shm_Perm   : IPC_Perm;	{ operation perms }

		  Shm_SegSz  : LongInt;		{ size of segment (bytes) }

		  Shm_ATime  : Time_T;		{ last attach time }

		  Shm_DTime  : Time_T;		{ last detach time }

		  Shm_CTime  : Time_T;		{ last change time }

		  Shm_CPID   : Word;            { pid of creator }

		  Shm_LPID   : Word;            { pid of last operator }

		  Shm_NAttch : LongInt;		{ no. of current attaches }

		  { the following are private }

		  Shm_NPages : Word;	{ size of segment (pages) }

		  Shm_Pages  : ^Cardinal;	{ array of ptrs to frames -> SHMMAX }

{		  Attaches   : PVM_Area_Struct;} { descriptors for attaches } { VM_Area_Struct is very complicated! in mm.h }

		  Attaches   : Pointer; { descriptors for attaches }

		End;



{ permission flag for shmget }

Const  SHM_R		= $100; 	{ or S_IRUGO from <linux/stat.h> }

       SHM_W		= $080; 	{ or S_IWUGO from <linux/stat.h> }



{ mode for attach }

      	SHM_RDONLY	= $1000;	{ read-only access }

      	SHM_RND		= $2000;	{ round attach address to SHMLBA boundary }

      	SHM_REMAP	= $4000;	{ take-over region on attach }



{ super user shmctl commands }

       SHM_LOCK 	= 11;

       SHM_UNLOCK 	= 12;

{ ipcs ctl commands }

       SHM_STAT         = 13;

       SHM_INFO         = 14;



Type ShmInfo = Record

		 ShmMax,

		 ShmMin,

		 ShmMni,

		 ShmSeg,

		 ShmAll : LongInt;

	       End;



{ shm_mode upper byte flags }

Const SHM_DEST	 = $200;       { segment will be destroyed on last detach }

      SHM_LOCKED = $400;       { segment will not be swapped }



Type TShm_Info = Record

                   Used_IDs : LongInt;

                   shm_tot, { total allocated shm }

	           shm_rss, { total resident shm }

	           shm_swp, { total swapped shm }

	           swap_attempts,

	           swap_successes : Cardinal;

                 End;



Function D2O(C:Cardinal):Cardinal;

Function FToK(PathName:String;Proc_ID:Char):Key_T;

Function MsgGet(Key:Key_T;MsgFlg:LongInt):LongInt;

Function MsgSnd(MsqId:LongInt;MsgP:PMsgBuf;MsgSz:LongInt;MsgFlg:LongInt):LongInt;

Function MsgRcv(MsqId:LongInt;MsgP:PMsgBuf;MsgSz:LongInt;MsgTyp:LongInt;MsgFlg:LongInt):LongInt;

Function MsgCtl(MsqId:LongInt;Cmd:LongInt;Buf:PMsQID_ds):LongInt;

Function SemGet(Key:Key_T;NSems,SemFlg:LongInt):LongInt;

Function SemOp (SemID:LongInt;SOps:PSemBuf;NSOps:LongInt):LongInt;

Function SemCtl(SemID:LongInt;SemNum:LongInt;Cmd:LongInt;Arg:SemUn):LongInt;

Function ShmCtl(ShmID,Cmd:LongInt;Buf:PShmID_ds):LongInt;

Function ShmGet(Key:Key_T;Size,Flag : LongInt):LongInt;

Function ShmAt(ShmID:LongInt;ShmAddr:Pointer;ShmFlag:LongInt):Pointer;

Function ShmDt(ShmAddr:Pointer):LongInt;



Implementation



{ converts a decimal number which looks as an octal to an octal }

Function D2O(C:Cardinal):Cardinal;

Var B : Byte;

    R : Cardinal;

Begin

  R := 0;

  B := 0;

  While (C > 0) do

    Begin

      R := R or (((C mod 10) and $7) shl (3*B));

      C := C div 10;

      Inc(B);

    End;

  D2O := R;

End;



Function IPCSysCall(Call:LongInt;{Var} A1,A2,A3 : LongInt;A4 : Pointer):LongInt;

Var Regs : SysCallRegs;

Begin

  Regs.reg2 := Call or (Version shl 2);

  Regs.reg3 := A1;

  Regs.reg4 := A2;

  Regs.reg5 := A3;

  Regs.reg6 := LongInt(A4);

  IPCSysCall := SysCall(syscall_nr_ipc,Regs);

{  A1 := Regs.Reg3;

  A2 := Regs.Reg4;

  A3 := Regs.Reg5;

  A4 := Pointer(Regs.Reg6);}

{  Is it possible, that there comes something back from the kernel except as  }

{  the normal result (EAX)?                                                   }

End;



{ ipc.h }



Function FToK(PathName:String;Proc_ID:Char):Key_T;

Var Buf : Stat;

Begin

  FToK := -1;

  if not FStat(PathName,Buf) then Exit;

  FToK := (Buf.INo and $FFFF) or ((Buf.Dev and $FF) shl 16) or (Ord(Proc_ID) shl 24);

End;



{ msg.h }



Function MsgGet(Key:Key_T;MsgFlg:LongInt):LongInt;

Begin

  MsgGet := IPCSysCall(CMSGGET,Key,MsgFlg,0,Nil);

End;

Function MsgSnd(MsqId:LongInt;MsgP:PMsgBuf;MsgSz:LongInt;MsgFlg:LongInt):LongInt;

Begin

  MsgSnd := IPCSysCall(CMSGSND,MsqId,MsgSz,MsgFlg,MsgP);

End;

Function MsgRcv(MsqId:LongInt;MsgP:PMsgBuf;MsgSz:LongInt;MsgTyp:LongInt;MsgFlg:LongInt):LongInt;

Var Tmp : IPC_Kludge;

Begin

  Tmp.MsgP := MsgP;

  Tmp.MsgTyp := MsgTyp;

  MsgRcv := IPCSysCall(CMSGRCV,MsqID,MsgSz,MsgFlg,@Tmp);

End;

Function MsgCtl(MsqId:LongInt;Cmd:LongInt;Buf:PMsQID_ds):LongInt;

Begin

  MsgCtl := IPCSysCall(CMSGCTL,MsqID,Cmd,0,Buf);

End;



{

 * <asm/bitops.h>:

 * set_bit, clear_bit, test_bit

 * all return the value of the bit prior to alteration.

 * It seems they are more useful than sysv sems if you

 * dont have a need for semaphore arrays.

}



Function SemGet(Key:Key_T;NSems,SemFlg:LongInt):LongInt;

Begin

  SemGet := IPCSysCall(CSEMGET,Key,NSems,SemFlg,Nil);

End;

Function SemOp (SemID:LongInt;SOps:PSemBuf;NSOps:LongInt):LongInt;

Begin

  SemOp  := IPCSysCall(CSEMOP,SemID,NSOps,0,SOps);

End;

Function SemCtl(SemID:LongInt;SemNum:LongInt;Cmd:LongInt;Arg:SemUn):LongInt;

Begin

  SemCtl := IPCSysCall(CSEMCTL,SemID,SemNum,Cmd,@Arg);

End;



{ shm.h }



Function ShmCtl(ShmID,Cmd:LongInt;Buf:PShmID_ds):LongInt;

Begin

  ShmCtl := IPCSysCall(CSHMCTL,ShmID,Cmd,0,Buf);

End;

Function ShmGet(Key:Key_T;Size,Flag : LongInt):LongInt;

Begin

  ShmGet := IPCSysCall(CSHMGET,Key,Size,Flag,Nil);

End;

Function ShmAt(ShmID:LongInt;ShmAddr:Pointer;ShmFlag:LongInt):Pointer;

Var RVal : LongInt;

    RAddr : Cardinal;

Begin

  RVal := IPCSysCall(CSHMAT,ShmID,ShmFlag,Cardinal(@RAddr),ShmAddr);

  if RVal < 0 then ShmAt := Pointer(RVal) else ShmAt := Pointer(RAddr);

End;

Function ShmDt(ShmAddr:Pointer):LongInt;

Begin

  ShmDt := IPCSysCall(CSHMDT,0,0,0,ShmAddr);

End;



End.

