{ "Match The Picture".
   Written & designed by: Patrick Kooman, 1997.
   Last updated: november 25, 1997. }

uses dos,crt,large_ch,small_ch; { large_ch and small_ch for the graphic characters.}
const
   HOR  = 20;   { The width of a picture (inc.lines when they can't move.)}
   VERT = 17;   { The hight ".}
   VGA  = $a000;{ The addres of a VGA-screen.}
type
    falling_picture = array [1..2] of record { Max. 2 pictures at once.}
                     figure_number : 1..4; {1=apple, 2=cherry, 3=banana, 4=pine-apple.}
                     colum         : 1..4; {4 colums }
                     row           : 0..9; {9 rows.}
                     can_move      : boolean; {false if a picture is beneath it.}
                     moves         : byte
                     end;

    stack_type = record
                    top    : byte;     { Hight of stack.}
                    inside : array [0..9] of 0..4 { 0= no picture, 1..4 are the four pictures.}
                 end;

    four_stacks = array [1..4] of stack_type;  { there are four stacks.}

    temptable = array [1..VERT,1..HOR] of byte; { Uses in get/putimage.}

    store_stack_background = array [1..4,37..180,0..HOR] of byte; { To store the background of the stacks.}

  { A virtual screen can be used when doing a lot of getimage and putimage,
    or when you have animations in your program. You use this screen by
    writing everything to that screen and copy it to your visual screen
    when the drawings etc. are done. This avoids flickering, and assures
    smooth moving.}
    V_screen = Array [1..64000] of byte;  { The size of the Virtual Screen }

    VirtPtr = ^V_screen;  { A pointer to this array.}

      {$I fruit.dat }         { Links the file with the four pictures.}
      {$I div.dat }           { Links the file with the cloud, the tree and}
                              { the sun.}
var
   falling     : falling_picture;
   stack       : four_stacks;
   stack_back  : store_stack_background;
   loop1       : integer;     { I use loop1 for the main-loops, and loop2 for}
   loop2       : integer;     { the sub-loops.}
   left_arrow  : byte;        { The arrow under the left of two stacks.}
   right_arrow : byte;        { "                   right       ".}

 { The next 6 variables are used to make it possible to show the next pictures
   who will fall down. At the moment they fall, they are copied to the records
   of the falling pictures in the procedure 'IntroducePictures".}
   NextImage1  : temptable;
   NextImage2  : temptable;
   NextPic1    : 1..4;
   NextPic2    : 1..4;
   NextCol1    : 1..4;
   NextCol2    : 1..4;
   ShowNext    : boolean;   { Becomes true if the pictures have moved.}

   Y           : integer;
   X           : integer;
   Image1      : temptable; { To store the background of picture 1.}
   Image2      : temptable;
   hit1        : boolean;   { Becomed true if picture 1 matches with }
   hit2        : boolean;   { the picture under it.}
   score       : integer;
   old_score   : integer;   { To check if the score has changed.}
   Virtscr     : VirtPtr;
   Vscr        : word;      { Holds the addres of the virtual screen.}
   level       : integer;   { Holds the level the player is in.}
   wait        : integer;   { Holds the delay between two moves.}
   key         : char;
   config      : char;      { Holds if the player has a pentium or not.}
   pal         : array [0..255,1..3] of byte; { Used in fade-procedures.}
   score_bg    : array [49..59,230..290] of byte;
   level_bg    : array [59..69,283..293] of byte;
   color       : byte;
   quit        : boolean;   { Becomes true if player wants to quit current game.}
 { Used for the OutTro.}
   LightRight  : boolean;
   LightUp     : boolean;
   LightLeft   : boolean;
   LightDown   : boolean;

 { The next six variabes are used for the interrupt-procedure witch checks
   if you move, swap, pauses or end the game.}
   old_addr    : pointer;  { To store the addres the interrupt points to.}
   left        : Boolean;  { The five keys used in the game. They become true}
   right       : Boolean;  { if they are pressed.}
   space       : Boolean;
   escape      : Boolean;
   pause       : boolean;

{ THE FIRST SEVEN PROCEDURES HAVE NOTHING TO DO WITH THE FUNCTIONALITY OF THE
  GAME. THEY ARE JUST TO MAKE THE GAME LOOK NICER.}

{ Set the red, green and blue value of a given color.}
procedure SetPal (col,R,G,B: byte);
begin
   port [$3c8] := col;
   port [$3c9] := R;
   port [$3c9] := G;
   port [$3c9] := B
end; { Procedure SetPal.}

{ Gets the red, green and blue value of a given color.}
procedure GetPal(Col : Byte; Var R,G,B : Byte);
begin
   Port[$3c7] := Col;
   R := Port[$3c9];
   G := Port[$3c9];
   B := Port[$3c9];
end; { Procedure GetPal.}

{ Stores the hole palette.}
procedure StorePal;
begin
   for loop1 := 0 to 255 do
      GetPal (loop1, pal [loop1,1], pal [loop1,2], pal [loop1,3])
end; { Procedure StorePal.}

{ Resets the hole palette.}
procedure RestorePal;
begin
   for loop1 := 0 to 255 do
      SetPal (loop1, pal [loop1,1], pal [loop1,2], pal [loop1,3])
end; { Procedure RestorePal.}

{ Sets all colors to black.}
procedure BlackScreen;
begin
   for loop1 := 0 to 255 do
      SetPal (loop1, 0, 0, 0)
end; { Procedure BlackScreen.}

{ Fades all 256 colors down to 0 (black), using 'pal' as stored in 'StorPal'.}
procedure FadeOut;
var
   tmp     : array [1..3] of byte;      { To store 1 color.}
begin
   for loop1 := 0 to 63 do              { 64 values.}
   begin
      for loop2 := 0 to 255 do          { 256 colors.}
      begin
         GetPal (loop2, tmp [1], tmp [2], tmp [3]); { Get values of 1 color.}
         if tmp [1] > 0 then dec (tmp [1]); { If value > 0 then decrease red.}
         if tmp [2] > 0 then dec (tmp [2]); { "                        green.}
         if tmp [3] > 0 then dec (tmp [3]); { "                         blue.}
         SetPal (loop2,tmp [1], tmp [2], tmp [3]) { Set color with new values.}
      end;
      delay (50)        { Not too fast.}
   end
end; { Procedure FadeOut.}

{ Fades all colors back to it's original values, using 'pal' as stored
  in 'StorePal'.}
procedure FadeIn;
var
   tmp     : array [1..3] of byte;
begin
   for loop1 := 0 to 63 do
   begin
      for loop2 := 0 to 255 do
      begin
         GetPal (loop2, tmp [1], tmp [2], tmp [3]);
         if tmp [1] < pal [loop2,1] then inc (tmp [1]); { Increas values untill}
         if tmp [2] < pal [loop2,2] then inc (tmp [2]); { they are as high as}
         if tmp [3] < pal [loop2,3] then inc (tmp [3]); { stored in 'pal'.}
         SetPal (loop2,tmp [1], tmp [2], tmp [3])
      end;
      delay (25)        { Not too fast.}
   end
end; { Procedure FadeIn.}

{ Go 320x200.}
procedure SetMCGA;
begin
  asm
     mov ax,13h;
     int 10h
  end
end; { Procedure SetMCGA.}

{ Go 80x25.}
procedure SetText;
begin
  asm
     mov        ax,0003h
     int        10h
  end
end; { Procedure SetText.}

{ Clears the screen with a given color.}
procedure Cls (Col : Byte; where : word);
begin
  FillChar (Mem [where:0],64000,col);
end; { Procedure Cls.}

{ Writes a pixel directly to memory.}
procedure Putpixel (Y,X : Integer; Col : Byte; where : word);
begin
  mem [where:X+(Y*320)]:=Col;
end; { Procedure PutPixel.}

{ Allocates memory for the virtual screen and returns it's addres.}
procedure SetupVirtual;
begin
  GetMem (VirtScr,64000);
  Vscr := seg (virtscr^);
end; { Procedure SetupVirtual.}

{ Frees the memory witch was used by the virtual screen.}
procedure ShutDown;
begin
  FreeMem (VirtScr,64000);
end; { Procedure ShutDown.}

{ Copies the virtual screen to the visual screen (VGA).}
procedure CopyScreen;
begin
  Move (Virtscr^,mem [VGA:0],64000);
end; { Procedure CopyScreen.}

{ Draws the blocks on the screen in different colors.}
procedure StartScreen;
var a,b,hor,vert : integer;
    col : byte;
begin
   Cls (0,Vscr);        { Clear the virtual screen.}
   hor := 0;
   vert := 0;
   repeat
      repeat
         col := random (151)    { Choose a random color between 100 and 151.}
      until col > 105;
      for a := 1 to 24 do       { This draws 1 square.}
         for b := 1 to 31 do
            putpixel (vert+a,hor+b,col,Vscr);
      if hor < 260 then inc (hor,32)
      else
      begin                     { Goto the next vertical position.}
         inc (vert,25);hor := 0
      end;
  until vert > 175;
  for a := 6 to 193 do
     for b := 109 to 212 do
     begin
        col := mem [Vscr:b+(a*320)];
        if col <> 0 then                 { the colors in the playfield are }
           putpixel (a,b,col + 80,Vscr) { increased by 80 to make them darker.}
     end;
  for a := 185 to 192 do        { Draws the bar where the arrows are in.}
     for b := 110 to 211 do
        putpixel (a,b,7,Vscr)
end; { Procedure StartScreen.}

{ Draws the 'nature' that you see through the window.}
procedure DrawView;
var
   y,x,i : byte;
begin
   x := 114;
   for loop1 := 6 to 35 do
      for loop2 := 109 to 212 do
          putpixel (loop1,loop2,9,Vscr);
   for loop1 := 1 to 5 do               { This draws the sun.}
      for loop2 := 1 to 5 do
         if SUN [loop1,loop2] <> 0 then
            putpixel (loop1+6,loop2+150,SUN [loop1,loop2],Vscr);
   for i := 1 to 4 do       { 4 clouds.}
   begin
      repeat
         y := random (20)
      until y > 7;
      for loop1 := 1 to 6 do             { This draws a cloud.}
         for loop2 := 1 to 15 do
            if cloud [loop1,loop2] <> 0 then
               putpixel (loop1+y,loop2+x,cloud [loop1,loop2],Vscr);
      inc (x,26)
   end;
   x := 112;
   for i := 1 to 11 do       { 11 trees.}
   begin
      for loop1 := 1 to 9 do                    { This draws a tree.}
         for loop2 := 1 to 7 do
            if tree [loop1,loop2] <> 0 then
               putpixel (loop1+26,loop2+x,tree [loop1,loop2],Vscr);
      inc (x,9)
   end
end; { Procedure DrawView.}

{ Surrounds the playfield by a gray line.}
procedure Borders;
var
   i : integer;
begin
   for i := 108 to 213 do
   begin
      putpixel (5,i,7,Vscr);
      putpixel (36,i,7,Vscr);
      putpixel (194,i,7,Vscr)
   end;
   for i := 6 to 193 do
   begin
      putpixel (i,108,7,Vscr);
      putpixel (i,213,7,Vscr)
   end;
   for i := 36 to 91 do
   begin
      putpixel (i,229,7,Vscr);
      putpixel (i,313,7,Vscr)
   end;
   for i := 229 to 313 do
   begin
      putpixel (36,i,7,Vscr);
      putpixel (91,i,7,Vscr)
   end;
   WriteLargeChar (39,231,50,2,'score',Vscr,true,false);    { Write the words }
   WriteLargeChar (59,231,50,2,'level',Vscr,true,false);    { into the info-screen.}
   WriteLargeChar (69,231,50,2,'p pause',Vscr,true,false);
   WriteLargeChar (79,231,50,2,'esc exit',Vscr,true,false)
end; { Procedure Borders.}

{ Draws the four bottoms of the stacks.}
procedure DrawPalettes;
   { Local procedure line.}
   procedure Line (a,b,Y : integer);
   var
      i : byte;
   begin
      for i := a to b do
         putpixel (Y,i,8,Vscr)
   end; { Procedure Line.}
   { Start the main procedure.}
begin
   for loop1 := 181 to 183 do
   begin
      Line (118,128,loop1);
      Line (143,153,loop1);
      Line (168,178,loop1);
      Line (193,203,loop1)
   end
end; { Procedure Drawpalettes.}

{ Draws an arrow under one of the stacks.}
procedure DrawArrow (where : byte; visible : boolean);
const
   arrow : array [1..8,1..7] of byte =
           ((0,0,0,8,0,0,0),
            (0,0,8,8,8,0,0),
            (0,8,8,8,8,8,0),
            (8,8,8,8,8,8,8),
            (0,0,8,8,8,0,0),
            (0,0,8,8,8,0,0),
            (0,0,8,8,8,0,0),
            (0,0,8,8,8,0,0));
begin
   Y := 184;
   case where of
      1 : X := 118;
      2 : X := 143;
      3 : X := 168;
      4 : X := 193
   end;
   for loop1 := 1 to 8 do
      for loop2 := 1 to 7 do
         if arrow [loop1,loop2] <> 0 then
            if visible then     { Show arrow.}
               putpixel (Y+loop1,X+loop2,1,Vscr)
            else
               putpixel (Y+loop1,X+loop2,7,Vscr) { Erase arrow.}
end; { procedure DrawArrow.}

{ Draws a gray bar with a dark-gray border, and writes a given text in it.
  xB = Xbegin; xE = Xend.}
procedure Window (xB, xE : integer; S : string);
begin
   for loop1 := 82 to 92 do
      for loop2 := xB to xE do
          putpixel (loop1,loop2,7,vga);
   for loop1 := xB to xE do
   begin
      putpixel (82,loop1,8,vga);
      putpixel (92,loop1,8,vga)
   end;
   for loop1 := 82 to 92 do
   begin
      putpixel (loop1,xB,8,vga);
      putpixel (loop1,xE,8,vga)
   end;
   WriteSmallChar (84,xB+2,4,S); { Writes the text.}
end;

{ Returns the Y-position to start with.
  Quite diffucult because the row of a pictures DEcreases when it falls
  down, while the Y-position INcreases, so you have to decrease the maximum
  Y-value (191) with row*VERT. The 10+ is because the pictures has to lay
  against eachother and not over eachother. The -(11...) is to make space
  for the line witch is drawn in procedure 'Inbox'.}
function startY (hight : integer):integer;
var Y : integer;
begin
   Y := 10+hight*VERT;
   Y := 191-Y;
   dec (y,11-(11-hight));
   startY := Y
end; { function startY.}

{ Returns the X-position to start with.
  This depents on the given colum (1..4).}
function StartX (which : byte): integer;
begin
   case which of
        1 : startX := 113;
        2 : startX := 113 + HOR+5;
        3 : startX := 113 + (2*HOR)+10;
        4 : startX := 113 + (3*HOR)+15
   end
end; { procedure startX.}

{ Stores the backgrounds of the 4 stacks by reading from the memory
  and returns the array.}
procedure StoreStackBackGround (var pstack_back : store_stack_background);
begin
   for loop1 := 37 to 180 do
      for loop2 := 0 to HOR do
      begin
          pstack_back [1,loop1,loop2] := mem [Vscr:(113+loop2)+(loop1*320)];
          pstack_back [2,loop1,loop2] := mem [Vscr:(113+HOR+5+loop2)+(loop1*320)];
          pstack_back [3,loop1,loop2] := mem [Vscr:(113+(2*HOR)+10+loop2)+(loop1*320)];
          pstack_back [4,loop1,loop2] := mem [Vscr:(113+(3*HOR)+15+loop2)+(loop1*320)]
      end
end; { procedure GetStackBackground.}

{ Restores a part of the background after two pictures have matched.}
procedure RestoreBackground (A : integer);
begin
   X := startX (A);
   for loop1 := 37 to 180-(stack [A].top)*19 + stack [A].top do { Here you see}
      for loop2 := 0 to HOR do { the same problems as spoken of in 'startY'.}
         mem [Vscr:(X+loop2)+(loop1*320)] := stack_back [A,loop1,loop2]
end; { procedure PutBackground.}

{ Swaps two stack-records, not visible.}
procedure SwapStack (var stack1,stack2 : stack_type);
var
   tmp : stack_type;
begin
   tmp := stack1;
   stack1 := stack2;
   stack2 := tmp
end; { procedure SwapStack.}

{ Swaps two stacks, visible.}
procedure SwitchStackImage (a,b : integer);
var
   startX1 : integer;
   startX2 : integer;
   dummy1  : integer;
   dummy2  : byte; { To store two pixels.}
begin
   startX1 := startX (a);
   startX2 := startX (b);
   for loop1 := 37 to 180 do    { Get the total image of the stacks...}
     for loop2 := 0 to HOR do
     begin
        dummy1 := mem [Vscr:(startX1+loop2)+(loop1*320)]; { Get two pixels }
        dummy2 := mem [Vscr:(startX2+loop2)+(loop1*320)]; { and switch them.}
        if dummy2 in FILTER then { Filters holds the colors used by the pictures.}
           { the pixel-color 'belongs' to a picture.}
           mem [Vscr:(startX1+loop2)+(loop1*320)] := dummy2
        else
           { a pixel-color 'belongs' to the background, so put the pixel from
             the right background.}
           mem [Vscr:(startX1+loop2)+(loop1*320)] := stack_back [a,loop1,loop2];
        if dummy1 in FILTER then
           mem [Vscr:(startX2+loop2)+(loop1*320)] := dummy1
        else
           mem [Vscr:(startX2+loop2)+(loop1*320)] := stack_back [b,loop1,loop2];
     end
end; { Procedure SwitchStackImage.}

{ Stores a background with the size of a picture,
  before a pictures is drawn om it.}
procedure GetImage (row, colum : byte; var temp : temptable);
begin
   Y := startY (row);   { Get startpositions.}
   X := startX (colum);
   for loop1 := 1 to VERT do
      for loop2 := 1 to HOR-1 do
         temp [loop1,loop2] := mem [Vscr:(X+loop2)+((Y+loop1)*320)]
end; { procedure GetImage.}

{ Retores a background with the size of a picture,
  before a pictures falls further down.}
procedure PutImage (row, colum : byte; temp : temptable);
begin
   Y := startY (row);  { Get startpositions.}
   X := startX (colum);
   for loop1 := 1 to VERT do
      for loop2 := 1 to HOR-1 do
          mem [Vscr:(X+loop2)+((Y+loop1)*320)] := temp [loop1,loop2]
end; { procedure PutImage.}

{ Draws a border around a picture when it can't move further down.}
procedure InBox (hight, which, color : byte);
begin
   Y := startY (hight);
   X := startX (which);
   for loop1 := X+1 to X+HOR-1 do
   begin
      putpixel (Y,loop1,color,Vscr);
      putpixel (Y+VERT,loop1,color,Vscr)
   end;
   for loop1 := Y+1 to Y + VERT-1 do
   begin
      putpixel (loop1,X,color,Vscr);
      putpixel (loop1,X+HOR,color,Vscr)
   end
end; { procedure Inbox.}

{ Draws a picture.}
procedure DrawPicture (row, colum, number : byte);
begin
   Y := startY (row);
   X := startX (colum);
   for loop1 := 1 to 16 do
      for loop2 := 1 to 19 do
         if pictures [number,loop1,loop2] <> 0 then  { No black pixels.}
            putpixel (Y+loop1,X+loop2,pictures [number,loop1,loop2],Vscr)
end; { procedure DrawPicture.}

{ Beeps when two pictures matches.}
procedure Beep;
begin
  sound (500);
  delay (10);
  nosound
end; { procedure beep.}

{ Writes the (new) score in the info-screen.}
procedure WriteScore;
var
   score_string : string [5];  { Because you haven to convert your score into}
begin                          { a string.}
   for loop1 := 49 to 59 do    { First, restore the used background.}
      for loop2 := 230 to 290 do
         putpixel (loop1,loop2,score_bg[loop1,loop2],Vscr);
   str (score,score_string);   { Convert.}
   for loop1 := length (score_string) to 4 do
      insert ('0',score_string,1); { Inserts '0' into the string.}
   WriteLargeChar (49,231,50,2,score_string,Vscr,true,false) { Write the string.}
end; { procedure WriteScore.}

{ Writes the (new) level in the info-screen.}
procedure WriteLevel;
var
   level_str : string;
begin
   for loop1 := 59 to 69 do
       for loop2 := 283 to 293 do
          mem [Vscr:loop2+(loop1*320)] := level_bg [loop1,loop2];
   str (level,level_str);
   WriteLargeChar (59,285,50,2,level_str,Vscr,true,false)
end; { procedure WriteLevel.}

{ Checks if the pictures can move further down. If They can't this procedure
  checks for matches.}
procedure PicturesDown;
var i : integer;
begin
   for i := 1 to 2 do  { Two pictures.}
   with falling [i] do { 'step' into record.}
   if can_move then        { Not neccesary if the picture is allready down or gone.}
   begin
      inc (moves);         { Go down if ther is space.}
      if (row > 0) and (row - stack [colum].top>1)
         and (moves mod 2 = 0) then dec (row)
      else if row - stack [colum].top = 1 then { Picture has reached top of stack.}
      begin
         can_move := false;
       { Check if the pictures metch.}
         if (figure_number = stack [colum].inside [stack [colum].top]) then
         begin             { True.}
            Beep;
            inc (score);
            WriteScore;
            case i of
               1 : hit1 := true; { Look witch one matches.}
               2 : hit2 := true
            end;
          { The next line removes the picture-number from the stack.
            Note that this happens 'inside' your computer. The visual
            picture is beeing erased in procedure 'PutBackground'.}
            stack [colum].inside [stack [colum].top]:=0;
            dec (stack [colum].top); { Decreas the hight of the stack.}
            RestoreBackground (colum)   { Erase the picture (visually).}
         end
         else
         begin              { False.}
            inc (stack [colum].top); { Increase the hight of the stack.}
          { Sets the picture number at the right position of the stack.}
            stack [colum].inside [stack [colum].top] := figure_number
         end
      end
   end
end;  { procedure PicturesDown.}

{ Draws the next two pictures and also computes the position and the number.}
procedure DrawNext;
begin
   NextPic1 := random (4)+1;    { Picture1 number 1..4 }
   NextPic2 := random (4)+1;    { Picture2 number 1..4 }
   NextCol1 := random (4)+1;    { Picture1 colum 1..4 }
   repeat
      NextCol2 := random (4)+1
   until NextCol2 <> NextCol1;  { Avoid that the pictures have the same colums.}
   GetImage (9,NextCol1,NextImage1); { Get the background.}
   GetImage (9,NextCol2,NextImage2);
   DrawPicture (9,NextCol1,NextPic1); { Draw the pictures.}
   DrawPicture (9,NextCol2,NextPic2)
end; { procedure DrawNext.}

{ Init the new pictures.}
procedure IntroducePictures;
begin
   hit1 := false;
 { The Next_Pictures are beeing 'overtaken' by the two records.}
   PutImage (9,NextCol1,NextImage1);
   falling [1].figure_number := NextPic1;
   falling [1].colum := NextCol1;
   falling [1].row := 9;
   falling [1].can_move := true;
   falling [1].moves := 0;
   hit2 := false;
   PutImage (9,NextCol2,NextImage2);
   falling [2].figure_number := NextPic2;
   falling [2].colum := NextCol2;
   falling [2].row := 9;
   falling [2].can_move := true;
   falling [2].moves := 0
end; { procedure IntroducePictures.}

{ This procedure uses interrupt $1c, witch allows you to press keys
  while the computer delays between two moves. Without this the game
  wouldn't be funny at all, because you would have to wait until the
  delay was over. }
procedure CheckKeyboard; Interrupt;
begin
  port [$60] := 0;
  case port [$60] of
     1 : escape := true;
    75 : left := true;
    77 : right := true;
    57 : space := true;
   153 : pause := true
  end;
end; { procedure CheckKeyboard.}

{ Reads the level a player wants to start, and sets score etc.}
procedure Init;
begin
   Cls (0,vga); { Clear visual screen.}
   WriteSmallChar (1,1,7,'At which level do you want to start ? ');
   WriteSmallChar (22,10,7,'1: easy');
   WriteSmallChar (29,10,7,'2: normal');
   WriteSmallChar (36,10,7,'3: fast');
   WriteSmallChar (43,10,7,'4: faster');
   WriteSmallChar (50,10,7,'5: where is that turbo button !!');
   repeat
      key := readkey
   until key in ['1'..'5'];
   level := ord (key)-48;  { Convert char into byte.}
   if config = '1' then            { Compute start-delay.}
      wait := 1100 - level * 150   { A pentium delays much shorter then a 486.}
   else
      wait := 550 - level * 100;
   old_score := 0;
   score := 0;
   left_arrow := 2;           { Sets the arrows under the center stacks.}
   right_arrow := 3;
   for loop1 := 1 to 4 do
      stack [loop1].top := 0; { The stacks are empty.}
   for loop1 := 1 to 4 do
      for loop2 := 0 to 9 do
         stack [loop1].inside [loop2] := 0
end; { procedure Init.}

{ Pauses until player hits a key.}
procedure PauseProc;
begin
   Window (141,180,'pause');
   readkey
end; { procedure PauseProc.}

{ Return true if one of the four stacks has reached the top.}
function GameOver : boolean;
begin
   if (stack [1].top = 9) or (stack [2].top = 9) or
      (stack [3].top = 9) or (stack [4].top = 9) then
   begin
      Window (129,191,'game over');
      delay (1000);
      GameOver := true
   end
   else GameOver := false
end; { function GemeOver.}

{ Checks if you want to stop with the current game.
  If you do, pquit becomes true.}
procedure QuitCurrent (var pquit : boolean);
begin
   Window (93,227,'quit this game ? (Y/N)');
   repeat
      key := upcase (readkey)
   until key in ['Y','N'];
   pquit := key ='Y';
  { CopyScreen}
end; { procedure QuitCurrent.}

{ Returns true if the payer doesn't want to play anymore.}
function QuitGame : boolean;
begin
   Window (106,215,'play again ? (Y/N)');
   repeat
      key := upcase (readkey)
   until key in ['Y','N'];
   QuitGame := key = 'N';
{   CopyScreen}
end; { function QuitGame.}

{ Writes the infoscreen.}
procedure Info;
begin
   WriteLargeChar (24,98,4,8,'about the game',vga,false,false);
   WriteSmallChar (41,30,4,'The game starts with four empty colums.');
   WriteSmallChar (49,30,4,'Two pictures will come down until they');
   WriteSmallChar (57,30,4,'cannot move further down.');
   WriteSmallChar (65,30,4,'Then two new pictures will come down and');
   WriteSmallChar (73,30,4,'so on. The meaning of the game is to let');
   WriteSmallChar (81,30,4,'a picture fall onto its equal so that');
   WriteSmallChar (89,30,4,'they both will dissapeare. This makes' );
   WriteSmallChar (97,30,4,'space and increases your score. You can');
   WriteSmallChar (105,30,4,'force this by swithing the colums, so');
   WriteSmallChar (113,30,4,'that a picture will fall onto the right');
   WriteSmallChar (121,30,4,'colum. You can switch colums by pressing');
   WriteSmallChar (129,30,4,'the spacebar. The two colums with the');
   WriteSmallChar (137,30,4,'arrow under them will then be switched.');
   WriteSmallChar (145,30,4,'The game is over when one of the four');
   WriteSmallChar (153,30,4,'colums has reached the top.');
   WriteLargeChar (164,105,4,8,'press any key',vga,false,false);
   readkey
end; { procedure Info.}

{ Does the intro.}
procedure Intro;
type
   tmp = array [1..16,1..70] of byte;
   large_temp = array [1..16,1..170] of byte;
var
   pal   : array [1..3] of byte;
   fg,bg : byte;
   tmp1  : ^tmp; { Dynamic because they'r only used once.}
   tmp2  : ^tmp;
   L_tmp : ^large_temp;
   Stmp1 : integer;
   Etmp1 : integer;
   Stmp2 : integer;
   Etmp2 : integer;
   S     : integer;
   pos   : integer;
begin
   fg := 10;
   bg := 2;
   Cls (0,Vscr);
   new (tmp1);  { Allocates memory.}
   WriteLargeChar (1,1,fg,bg,'patrick',Vscr,false,true); { Write them in the left corner.}
   for loop1 := 3 to 18 do
      for loop2 := 1 to 70 do
         tmp1^[loop1-2,loop2] := mem [Vscr:loop2+(loop1*320)]; { Read from memory.}
 { The word 'patrick' is now stored. Now you can do whatever you want, as
   you'll see some lines below.}
   Cls (0,Vscr);
   new (tmp2);
   WriteLargeChar (1,1,fg,bg,' kooman',Vscr,false,true);
   for loop1 := 3 to 18 do
      for loop2 := 1 to 70 do
         tmp2^[loop1-2,loop2] := mem [Vscr:loop2+(loop1*320)];
   Cls (0,Vscr);
   new (L_tmp);
   WriteLargeChar (1,1,fg,bg,'match the picture',Vscr,false,true);
   for loop1 := 3 to 18 do
      for loop2 := 1 to 170 do
         L_tmp^[loop1-2,loop2] := mem [Vscr:loop2+(loop1*320)];
   Cls (0,Vscr);
   Stmp1 := 317;
   Etmp1 := 2;
   Stmp2 := 69;
   Etmp2 := 70;
   S := 1;
   while Stmp1 > 90 do
   begin
      for loop1 := 1 to 16 do
      begin { From the right to the left.}
         for loop2 := 1 to Etmp1 do     { Put the pixels as stores in the temp}
             if tmp1^[loop1,loop2] = fg then { put give them another color!!}
                mem [Vscr:Stmp1+loop2+(90+loop1)*320] := -loop1+32; { Fades from white down to black.}
         pos := S;
         for loop2 := Stmp2 to Etmp2 do
         begin { From the left to the right.}
            if tmp2^[loop1,loop2] = fg then
               mem [Vscr:pos+(90+loop1)*320] := -loop1+32;
            inc (pos)
         end
      end;
      CopyScreen;       { Switch when done.}
      delay (200);
      for loop1 := 90 to 106 do { Draw a black bar to erase the pixels.}
         for loop2 :=  1 to 320 do
            putpixel (loop1,loop2,0,Vscr);
      if Stmp2 > 2 then dec (Stmp2,4)
         else inc (S,4);
      dec (Stmp1,4);
      if Etmp1 < 70 then inc (Etmp1,4);
      if Etmp2 < 70 then inc (Etmp2,4);
   end;
   delay (1000);
   Setpal (12,21,21,21);
   WriteLargeChar (105,93,12,bg,'s o f t w a r e',vga,false,false);
   for loop1 := 22 to 63 do
   begin                   { Brighter.}
      Setpal (12,loop1,21,21);
      delay (10)
   end;
   for loop1 := 63 downto 43 do
   begin                   { Darker.}
      Setpal (12,loop1,21,21);
      delay (15)
   end;
   dispose (tmp1);      { Free memory.}
   dispose (tmp2);
   delay (2000);
   Cls (0,vga);
   WriteLargeChar (93,122,2,8,'presents',vga,true,false);
   delay (2000);
   Cls (0,vga);
   for loop1 := 1 to 16 do      { Writes 'match the picture'.}
      for loop2 := 1 to 170 do
         if L_tmp^[loop1,loop2] = fg then
            mem [vga:78+loop2+(92+loop1)*320] := 80-loop1;
   delay (2000);
   dispose (L_tmp);
   Cls (0,vga)
end; { procedure Intro.}

{ Shows the light at a part of the screen.}
procedure ShineLight (y,x : integer);
var
   tmpx : integer;      { To store the x-value.}
begin
   tmpx := x;
   for loop1 := 1 to 15 do
   begin
      for loop2 := 1 to 19 do
      begin
         if LIGHT [loop1,loop2] <> 0 then       { To avoid black pixels.}
         begin
          { The 'if mem [...]' is to look if the pixel at that position is
            a part of a letter or a part of the background. When it is a
            part of a letter, a blue pixel is putted. When it is a part
            of the background, a pixel from LIGHT is putted. Doing this you
            only see the letters witch are shined with the light.
            As you see, the light becomes four times the size as in the array,
            because for each pixel in LIGHT four pixels are putted.}
            if mem [Vscr:x+loop2+(y+loop1)*320] = 2 then  { Pixel left above.}
               putpixel (y+loop1,x+loop2,1,Vscr)
            else
               putpixel (y+loop1,x+loop2,197,Vscr);

            if mem [Vscr:x+loop2+(y+loop1+1)*320] = 2 then { Pixel left down.}
               putpixel (y+1+loop1,x+loop2,1,Vscr)
            else
               putpixel (y+1+loop1,x+loop2,197,Vscr);

            if mem [Vscr:x+1+loop2+(y+loop1)*320] = 2 then { Pixel right above.}
               putpixel (y+loop1,x+1+loop2,1,Vscr)
            else
               putpixel (y+loop1,x+1+loop2,197,Vscr);

            if mem [Vscr:x+1+loop2+(y+1+loop1)*320] = 2 then{ Pixel right down.}
               putpixel (y+1+loop1,x+1+loop2,1,Vscr)
            else
               putpixel (y+1+loop1,x+1+loop2,197,Vscr);
         end;
         inc (x,1) { One extra position to the right.}
      end;
      x:=tmpx;     { Back to the start X.}
      inc (y,1)    { One extra position down.}
   end
end; { procedure ShineLight.}

{ Erases the light at the position, where 'ShineLight' has put it.}
procedure EraseLight (y,x : integer);
var tmpx : integer;
begin
   tmpx := x;
   for loop1 := 1 to 15 do
   begin
      for loop2 := 1 to 19 do
      begin
         if LIGHT [loop1,loop2] <> 0 then
         begin
          { You might think why i just don't put color 200-pixels
            instead of also using green. This is because you'd lose
            the letters. The letters look like 200, but they are GREEN.
            So when the light would shine over it a next time, you wouldn't
            see the letters because they would be gone.}
            if mem [Vscr:x+loop2+(y+loop1)*320] = 1 then
               putpixel (y+loop1,x+loop2,2,Vscr)
            else
               putpixel (y+loop1,x+loop2,200,Vscr);

            if mem [Vscr:x+loop2+(y+loop1+1)*320] = 1 then
               putpixel (y+1+loop1,x+loop2,2,Vscr)
            else
               putpixel (y+1+loop1,x+loop2,200,Vscr);

            if mem [Vscr:x+1+loop2+(y+loop1)*320] = 1 then
               putpixel (y+loop1,x+1+loop2,2,Vscr)
            else
               putpixel (y+loop1,x+1+loop2,200,Vscr);

            if mem [Vscr:x+1+loop2+(y+1+loop1)*320] = 1 then
               putpixel (y+1+loop1,x+1+loop2,2,Vscr)
            else
               putpixel (y+1+loop1,x+1+loop2,200,Vscr);
         end;
         inc (x,1)
      end;
      x:=tmpx;
      inc (y,1)
   end
end; { procedure EraseLight.}

{ Returns the next positions of the light.}
procedure MoveLight (var y,x : integer);
{ Four smoother (but slower) moving, change the '2's into '1's.}
begin
   if x=2 then          { Check the left side of the screen.}
   begin
      LightRight := true; { If the light can't move further to the left, }
      LightLeft := false  { then change it's direction.}
   end;
   if (x+2*19=320) then  { Also for the right position. The size of the }
   begin                 { light is multiplied by 2, because it's blown up.}
      LightLeft := true;
      LightRight := false
   end;
   if y = 2 then         { The same for up and down.}
   begin
      LightDown := true;
      LightUp := false
   end;
   if y+2*15 = 200 then
   begin
      LightUp := true;
      LightDown := false
   end;
   if LightLeft then    { Now change the positions.}
       dec (x,2)
   else
       inc (x,2);
   if LightUp then
      dec (y,2)
   else
      inc (y,2)
end; { procedure MoveLight.}

{ Does the end-screen.}
procedure OutTro;
var
   posY : integer;
   posX : integer;
begin
   Cls (0,VGA);
   Cls (200,Vscr);     { dark color.}
   RestorePal;
   SetPal (2,8,8,16);  { Change the values of green into those of color 200.}
 { As you see, the next lines are written in green. Because
   that color has the same values as color 200, you can't see them.}
   WriteLargeChar (20,70,2,2,'thanks for playing',Vscr,false,true);
   WriteLargeChar (70,95,2,2,'this game was',Vscr,false,true);
   WriteLargeChar (100,60,2,2,'written and designed',Vscr,false,true);
   WriteLargeChar (130,150,2,2,'by',Vscr,false,true);
   WriteLargeChar (160,50,2,2,'patrick kooman in 1997',Vscr,false,true);
   posY := 130;   { Start positions.}
   posX := 30;
   LightRight := true; { Start moving to the right, and up.}
   LightUp := true;
   LightLeft := false;
   LightDown := false;
   repeat
      ShineLight (posY,posX);   { Shows the light.}
      CopyScreen;               { Copie the screen when it's done.}
      delay (10);
      EraseLight (posY,posX);   { Erase the light after a short delay.}
      MoveLight (posY,posX);    { Compute the next positions of the light.}
   until keypressed;
   CopyScreen;
   SetPal (2,0,0,42);          { Sets the color green into blue. }
   readkey;                    { The first readkey is to catch the keypressed.}
   readkey
end; { procedure OutTro.}

{ This is the main procedure of the game.}
procedure Main;
begin
   StartScreen;                 { Draws the playing screen.}
   DrawView;                    { Draws the clouds and the trees.}
   for loop1 := 37 to 90 do     { Darkens the colors in the box where the }
      for loop2 := 230 to 312 do{ score and the level are printed.}
      begin
         color := mem [Vscr:loop2+(loop1*320)];
         if color <> 0 then
            putpixel (loop1,loop2,color+80,Vscr)
      end;
    for loop1 := 49 to 59 do    { Stores two backgrounds.}
       for loop2 := 230 to 290 do
          score_bg [loop1,loop2] := mem [Vscr:loop2+(loop1*320)];
    for loop1 := 59 to 69 do
       for loop2 := 283 to 293 do
          level_bg [loop1,loop2] := mem [Vscr:loop2+(loop1*320)];
   StoreStackBackGround (stack_back);{ Store the background of the four stacks.}
   Borders;             { Draws the border around the playingfield.}
   WriteScore;          { Writes the beginscore.}
   WriteLevel;          { Writes the beginlevel.}
   DrawPalettes;        { Draws the palettes under the stacks.}
   DrawArrow (left_arrow,true); { Two arrows.}
   DrawArrow (right_arrow,true);
   DrawNext;            { Draw the next pictures.}
   IntroducePictures;   { Go move them.}
   CopyScreen;          { Switch when done.}
   FadeIn;              { From dark to light.}
   repeat
      DrawArrow (left_arrow,false);
      DrawArrow (right_arrow,false);
      if left then      { Left arrow pressed.}
         if left_arrow > 1 then
         begin
            dec (left_arrow); { Decrease position of both arrows.}
            dec (right_arrow)
         end;
      if right then
         if right_arrow < 4 then
            begin
               inc (left_arrow);{ Increase position of both arrow.}
               inc (right_arrow)
            end;
      if space then     { 'Swap-key' }
      begin
       { If a stack has to move, while on the new position a picture
         is falling down at a lower position then the top of the stack,
         that picture will swith to the other stack. You don't have to
         check if the picture may switch, because the other stack is always
         lower, because otherwise the picture wouldn't still be falling.}
         if falling [1].colum = right_arrow then
            if falling [1].row <= stack [left_arrow].top then
               falling [1].colum := left_arrow;
         if falling [1].colum = left_arrow then
            if falling [1].row <= stack [right_arrow].top then
               falling [1].colum := right_arrow;
         if falling [2].colum = right_arrow then
            if falling [2].row <= stack [left_arrow].top then
               falling [2].colum := left_arrow;
         if falling [2].colum = left_arrow then
            if falling [2].row <= stack [right_arrow].top then
               falling [2].colum := right_arrow;
         SwitchStackImage (left_arrow, right_arrow); { Swap (visual).}
         SwapStack (stack [left_arrow], stack [right_arrow]) { Swap (not visual).}
      end;
      if pause then
         PauseProc;
      while keypressed do readkey; { reads the buffer empty.}
      left := false;    { Sets all keys to 'not-pressed'.}
      right := false;
      space := false;
      pause := false;
      escape := false;
      DrawArrow (left_arrow,true); { Draw arrows visible.}
      DrawArrow (right_arrow,true);
      PicturesDown;
      if (score > old_score) and (score <> 0) and (score mod 25 = 0) then
         if level < 5 then  { Increase level.}
         begin
            inc (level);
            WriteLevel;
            dec (wait,125)
         end;
      old_score := score;
      if (falling [1].moves = 2) or (falling [2].moves = 2) then
         DrawNext; { New pictures if these one have moved.}
      if not hit1 then { Don't match.}
      begin
         GetImage (falling [1].row,falling [1].colum,Image1);
         DrawPicture (falling [1].row,falling [1].colum,falling [1].figure_number)
      end;
      if not hit2 then { Don't match.}
      begin
         GetImage (falling [2].row,falling [2].colum,Image2);
         DrawPicture (falling [2].row,falling [2].colum,falling [2].figure_number)
      end;
      CopyScreen;
      delay (wait); { Pauses.}
      if falling [1].can_move then
         PutImage (falling [1].row, falling [1].colum, Image1);
      if not falling[1].can_move and not hit1 then{ Can't move, but doesn't match.}
         InBox (falling [1].row,falling [1].colum,7);
      if falling [2].can_move then
         PutImage (falling [2].row, falling [2].colum, Image2);
      if not falling [2].can_move and not hit2 then
         InBox (falling [2].row,falling [2].colum,7);
      if not falling [1].can_move and not falling [2].can_move then
         IntroducePictures; { Both pictures lay still or are gone.}
      if escape then        { Want to quit current game ?'}
         QuitCurrent (quit)
   until gameover or quit;
end;

begin
   SetMcga;        { Go 320x200 }
   SetupVirtual;   { Allocates memory for the virtual screen.}
   StorePal;       { Stores the palette.}
   Intro;
   Cls (7,vga);
   Info;
   FadeOut;
   Cls (0,vga);
   RestorePal;     { Restores the palette.}
   WriteSmallChar (1,1,7,'please give your configuration');
   WriteSmallChar (22,10,7,'1: pentium');
   WriteSmallChar (29,10,7,'2: slower than a pentium');
   repeat
      config := upcase (readkey)
   until config in ['1','2'];
   if config = '1' then
      wait := 1000
   else
      wait := 575;
   GetIntvec ($1c,old_addr);      { Store the old addres where the interrupt pointed to.}
   SetIntvec ($1c,@CheckKeyboard);{ Make an interrupt-procedure of 'CheckKeyboard'.}
   repeat
      quit := false;
      randomize;
      Init;
      BlackScreen;
      Main     { Play the game until the player wants to quit.}
   until QuitGame;
   SetIntvec ($1c,old_addr);      { Sets the interrupt as before starting the game.}
   FadeOut;        { Fade out all colors to black.}
   OutTro;
   FadeOut;
   shutdown;       { Frees the memory used by the virtual screen.}
   settext;
   writeln ('This game was written and designed by: Patrick Kooman, 1997.');
   writeln ('If you have any questions about, or comments to the game,');
   writeln ('E-mail me at v962580@si.hhs.nl');
   writeln ('I''m Dutch, so Dutch people kunnen in het Nederlands reageren.');
   writeln;
   writeln ('-press any key-');
   readkey;
end.






