
{------------------------------------------------------------------------------------}
{\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}
{/`/`/`/`/`/`/`/`/-  Designed and Programmed by Leonid Dragun  -\`\`\`\`\`\`\`\'\`\`\}
{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}
{------------------------------------------------------------------------------------}

Program Mines_Project (input,output);
Uses WinCrt;

Const
 
     MINE   = -1;  {VALUE assigned to cell with a mine, don't change!}
     EMPTY  = -2;  {VALUE assigned to an empty cell, don't change!}
     BOOM   = -3;  {Control var - if one steps on bomb, game ends!}
  

Type
     Name_Array = string[50]; {define string length = 50; Turbo Pascal WIN v.1.5}
     Mine_Array = array [1..25,1..25] of integer; {define MAX array size}
                                                  {!Not a dynamic array }
Var
     PlayerName:Name_Array;
     Field_Array:Mine_Array;
     MAXROW,MAXCOL,MAXMINE,
     rowmain,colmain,GameEnd:integer;
     DoAgain:char;

{------------------------------------------------------------------------------------}

Procedure Get_Player_Name;
{Displays the Super Mine Sweeper Logo/ reads the name into string}
begin

 ClrScr;{Clear Screen, WinCrt unit function}
 {Super Logo!}
 writeln;
 writeln('Leonid Dragun Presents:');
 writeln;
 writeln;
 writeln('                             ****                           '); 
 writeln('                           ********                         ');
 writeln('                         ************                       ');
 writeln('                        *** SuPeR! ***                      ');
 writeln('                       * MINE SWEEPER *                     ');
 writeln('                        *** SuPeR! ***                      ');
 writeln('                         ************                       ');
 writeln('                           ********                         ');
 writeln('                             ****                           ');                                   
 writeln;

 write('Please, enter your first name: ');
 read(PlayerName);  {PlayerName = string[50]}
 ClrScr;

end;

{------------------------------------------------------------------------------------}

Procedure Get_Parameters;
{Gives user chance to set desired parameters, height, width, #mines}

 begin
  ClrScr;
   writeln;
   writeln(' ':20,'--------------------               ');
   writeln;
   write(' ':10,'Please, enter # of rows (height),{4<=row<25}: '      );
   readln(MAXROW);
   if MAXROW > 25 then MAXROW:=25;
   if MAXROW < 4 then MAXROW:=4;
   write(' ':10,'Please, enter # of colums (width),{4<=col<25}: '    );
   readln(MAXCOL);
   if MAXCOL > 25 then MAXCOL:=25;
   if MAXCOL < 4 then MAXCOL:=4;
   write(' ':10,'Please, enter # of mines, { #mines<row*col }: ');
   readln(MAXMINE);
   if MAXMINE >= (MAXROW*MAXCOL) then MAXMINE:= trunc(MAXROW*MAXCOL/4);
  ClrScr;
 end;

{------------------------------------------------------------------------------------}

Procedure Intro_Mines;
{Intro to Game/Rules}
begin                              


  writeln('/\/\/\/\/\ WELCOME to the BATTLE FIELD MINE SWEEPER /\/\/\/\/\');
  writeln('--------------------------------------------------------------');
  writeln('  Your mission, should you except it, is to determine the');
  writeln('  location of ',MAXMINE,' mines in the ',MAXROW,' x ',MAXCOL,' mine field below.');
  writeln('  In order to eliminate the chance of you stepping on a bomb');
  writeln('  on your first try, one safe location has been randomly set');
  writeln('  by the computer. You finish the mission by filling in all');
  writeln('  but the ',MAXMINE,' mine sites.');
  writeln('      NOTE: use space between coordinates { ex. row col }');

end;

{------------------------------------------------------------------------------------}

Procedure Initialize_Field (var Init_Array:Mine_Array);
{Initializes mine field and stores mines in random cells}

var
 row,col,mines,randrow,randcol,count:integer;
 pair1,pair2,pair3:integer;

  begin

     for row:=1 to MAXROW do
     for col:= 1 to MAXCOL do 
     Init_Array[row,col]:=EMPTY;

  count:=0; {initialize count}

  randomize;{Initializes the built-in random number generator with a random value
             (obtained from the system clock).}

     While (count < MAXMINE) do
       begin  
         randrow:=trunc(random*MAXROW + 1);
         randcol:=trunc(random*MAXCOL + 1);
          if Init_Array[randrow,randcol]=EMPTY then
           begin
           Init_Array[randrow,randcol]:=MINE;
           count:=count + 1;  
          end;
       end;
  end;

{------------------------------------------------------------------------------------}

Procedure Safe_Spot (var Safe_Array:Mine_Array; var saferow,safecol:integer);
{Picks a non-mine location to start of the game}

  begin
    randomize;
     repeat
       saferow:=trunc(random*MAXROW + 1);
       safecol:=trunc(random*MAXCOL + 1);
     until Safe_Array[saferow,safecol] = EMPTY
  end;

{------------------------------------------------------------------------------------}

Function Min (a,b : integer):integer;
{MIN:Returns the smaller of two numbers for Check_Input_Value procedure}

begin
      Min:=a;
       if ( b < a ) then
        Min:=b;
end; 

{------------------------------------------------------------------------------------}

Function Max (a,b : integer):integer;
{MAX:Retirns the larger of two numbers for Check_Input_Value procedure}

begin
      Max:=a;
       if ( b > a ) then
        Max:=b;
end;    

{------------------------------------------------------------------------------------}

Procedure Check_Input_Value (var Value_Array:Mine_Array;
          var row,col:integer;Check:integer);
{Figures out the value of a given cell based upon # of neighboring mines}

  var
    i,j,CellValue:integer;

    begin
      CellValue:=0;
       for i:= Max(1,row-1) to Min(MAXROW,row+1) do
       for j:= Max(1,col-1) to Min(MAXCOL,col+1) do 
       if Value_Array[i,j]=MINE then CellValue:=CellValue + 1;          
      Value_Array[row,col]:=CellValue;
      If Check <> 0 then
      ClrScr;
    end;

{------------------------------------------------------------------------------------}

Procedure Check_User_Input ( var Check_Array:Mine_Array;
                             var row,col:integer;
                             var CountWin:integer);

 {Checks input value, stops if MINE, Counts/Check value of non-mine cell}

 begin
   if Check_Array[row,col] = MINE then
     begin  
       writeln;
       writeln(' *BOOM!*BOOM!*BOOM!- ',PlayerName,', you stepped on a MINE...GAME OVER! ');  
       writeln;
       writeln('          Always learn form your mistakes!');
       writeln('          Here is where the MINES were located: '    );  
       writeln;
       CountWin := BOOM
     end

   else

     begin
       Check_Input_Value(Check_Array,row,col,CountWin);      
       CountWin:=CountWin + 1;
     end;

 end;

{------------------------------------------------------------------------------------}

Procedure Check_Bounds_Input (var row,col:integer);
{Checks if input is outside of mine field range/asks to reenter} 

   begin  
    while not(row in[1..MAXROW]) or not(col in[1..MAXCOL]) do
     begin
       write(PlayerName,' your input is out of range. Please reenter: ');
       readln(row,col);
      end;
    end;

{------------------------------------------------------------------------------------}

Procedure Get_User_Input (var Play_Array:Mine_Array; var row,col:integer);
{Get Input, send for Bound Check, handling for possibility that the user enters
the same coordinates more than once}
                                               
  begin

    write('Enter coordinate of cell: ');
    readln(row,col);   
    Check_Bounds_Input(row,col);      
      while (Play_Array[row,col] <> EMPTY) AND (Play_Array[row,col] <> MINE) do    
        begin
          writeln('You aleady checked this cell ',PlayerName,',');
          write ('Please reenter the coordinates: ');       
          readln(row,col);
          Check_Bounds_Input(row,col);    
       end;     

   end;

{------------------------------------------------------------------------------------}

Procedure Display_Field (var Output_Array:Mine_Array;ShowMines:integer);
{Draw/Update mine field, if player steps on mine will disclose location of the mines}
var
   i,j:integer;

   begin
      writeln;
      write(' ':3);
    for i:=1 to MAXCOL do write(i:3);
      writeln;
      write(' ':2,'+');  
    for i:= 1 to (3*MAXCOL+2) do write('-'); {draw horizontal border}
      write('+');
      writeln;

    for i:= 1 to MAXROW do
      begin
      write(i:2,'|');
    for j:= 1 to MAXCOL do
      begin

    if ShowMines <> BOOM then
      begin {if}
        case (Output_Array[i,j]) of
         MINE                     : write('*':3);
         EMPTY                    : write('*':3); 
         0,1,2,3,4,5,6,7,8        : write(Output_Array[i,j]:3);
         end; {case}
        if j=MAXCOL then write(' ':2,'|',i);
      end {if}


    else begin {If BOOM then show player the location of the mines}       
       case (Output_Array[i,j]) of
         MINE                     : write('M':3);
         EMPTY                    : write('*':3); 
         0,1,2,3,4,5,6,7,8        : write('*':3);
         end; {case}
        if j=MAXCOL then write(' ':2,'|',i);
       end {else}

    end;{for}
     writeln;   
    end;{for}
      
  
       write(' ':2,'+');   
       for i:= 1 to (3*MAXCOL+2) do write('-'); {draw horizontal border}
       write('+');
       writeln;
       write(' ':3);
       for i:=1 to MAXCOL do write(i:3);    
       writeln;
       writeln;

  end;{Display_Field}


{------------------------------------------------------------------------------------}


 begin {MAIN}

       {Initialize Screen Dimentions WinCrt instructions}
       ScreenSize.X := 90; {initialization of WinCrt ScreenSize (x,y)}
       ScreenSize.Y := 500;{ScreenSize.X:= 90 then MAXCOL := 25 not more!}
     

       Get_Player_Name;

  repeat {Repeat Game Cycle}

       GameEnd:=0;
       Get_Parameters; {determine field size/#mines}
       Intro_Mines; {Introduction}     
       Initialize_Field(Field_Array); {randomize mine field}
       Safe_Spot(Field_Array,rowmain,colmain); {randomize one safe spot}
       Check_User_Input(Field_Array,rowmain,colmain,GameEnd); {count val safe spot}
       Display_Field(Field_Array,GameEnd); {Draw field, safe spot}

  repeat 
   
       Get_User_Input(Field_Array,rowmain,colmain); {Get Input}
       Check_User_Input(Field_Array,rowmain,colmain,GameEnd);
       Display_Field(Field_Array,GameEnd);  

  until (GameEnd = BOOM) or (GameEnd = MAXROW*MAXCOL - MAXMINE);{Stops if lost/won game}

  if GameEnd = (MAXROW*MAXCOL - MAXMINE) then {= a win }

    begin
       writeln('Gongratulations, YOU made it without a scratch!'); 
       writeln;
    end;    
       write(PlayerName,', would you care to play again? <y/n>: '); {play again option}
       read(DoAgain);    

  until DoAgain in ['N','n'];
       
       ClrScr;
       writeln('      ',PlayerName,', I hope you enjoyed palying SuPeR MINE SWEEPER! ');
       writeln('      Copywright 98'' Leonid Dragun <leod@gis.net>');
       writeln('      Leonid reminds YOU to," Think...Think Pascal! "');

  end. {MAIN}

 