
{********************************}
{*  Sample app for Mk_Dir unit  *}
{********************************}

Uses Mk_Dir {$IFDEF Windows}, WinCRT {$ELSE}, DOS {$ENDIF};

Var
  Home, Path, Dest: PathStr;
  i: Integer;

Begin
  Writeln('MakeDir v1.0');
  GetDir(0,Home);
  Path := ParamStr(1);
  If Path = '' Then Writeln('MakeDir <directory structure>')
  Else Begin
    i := MakeDir(Path,Dest);
    Case i of
      Ok: Writeln('Ok: '+Dest);
      Err_InvalidPath: Writeln('This path can''t be created!');
      Err_AccessDenied: Writeln('Access denied!');
      Err_InvalidDrive: Writeln('Invalid drive specification!');
      Err_WriteProtect: Writeln('Disk is write-protected!');
      Err_DriveNotReady: Writeln('Drive not ready!');
      Err_WriteFault: Writeln('Disk write fault!');
      Err_ReadFault: Writeln('Disk read fault!');
      Else Writeln('Error #',i);
    End;
  End;
  ChDir(Home);
{$IFDEF Windows}
  ReadKey;
  DoneWinCRT;
{$ENDIF}
End.
