
{*****************************************************}
{*  MakeDir - Teljes elrsi t ltrehozsa.         *}
{*  Plda:                                           *}
{*  MakeDir('c:\destdir\myapp\data\pictures\main');  *}
{*****************************************************}

Unit Mk_Dir;
{$I-} {Turn off I/O error checking}

Interface

{$IFDEF Windows}
Uses WinDOS, Strings;
Type
  PathStr = String[79]; {The WinDOS unit does not define these types}
  DirStr = String[12];
Var t: PChar; {FileExpand uses null-terminated strings}
{$ELSE}
Uses DOS;
{$ENDIF}

Const {Error values returned by MakeDir}
  Ok = 0;
  Err_InvalidPath = 3;
  Err_AccessDenied = 5;
  Err_InvalidDrive = 15;
  Err_WriteProtect = 150;
  Err_DriveNotReady = 152;
  Err_WriteFault = 160;
  Err_ReadFault = 161;

Function MakeDir(p: PathStr; Var DestDir: PathStr): Integer;

Implementation

Function MakeDir;
Var
  d: DirStr;
  Err: Integer;
Begin
  DestDir := '';
{$IFDEF Windows}
  StrPCopy(t,p);
  FileExpand(t,t);
  p := StrPas(t);
{$ELSE}
  p := FExpand(p); {Expand it to full pathname}
{$ENDIF}
  While Pos('\\',p) > 0 do Delete(p,Pos('\\',p),1);
  {Remove duplicated '\' characters}
  If Copy(p,Length(p),1) <> '\' then p := p + '\';
  ChDir(Copy(p,1,3));
  Err := IoResult;
  If Err = 0 Then Begin
    Delete(p,1,3);
    While (Err=0) and (p <> '') do begin
      d := Copy(p,1,Pos('\',p)-1);
      Delete(p,1,Pos('\',p));
      ChDir(d);
      If IoResult <> 0 Then Begin
        MkDir(d);
        Err := IOResult;
        If Err = 0 Then ChDir(d);
      End;
    End;
    GetDir(0,DestDir);
    DestDir := DestDir + '\';
  End;
  MakeDir := Err;
End;

{$IFDEF Windows} {Allocate a string - requires some heap space}
Begin
  GetMem(t,80);
{$ENDIF}
End.
