                                     (* Chapter 16 - Program 2 *)
program Amortization_Table;

var Month : 1..12;
    Starting_Month : 1..12;
    Balance : real;
    Payment : real;
    Interest_Rate : real;

procedure Initialize_Data; (* ****************** initialize data *)
begin
   Balance := 2500.0;
   Starting_Month := 5;
   Payment := 100.0;
   Interest_Rate := 0.13/12.0;
end;

procedure Print_Annual_Header; (* *********** print annual header *)
begin
   Writeln('Annual header');
end;

procedure Calculate_And_Print; (* *********** calculate and print *)
var Interest_Payment : real;
    Principal_Payment : real;
begin
   if Balance > 0.0 then begin
      Interest_Payment := Interest_Rate * Balance;
      Principal_Payment := Payment - Interest_Payment;
      if Principal_Payment > Balance then begin  (* loan payed off *)
         Principal_Payment := Balance;              (* this month *)
         Balance := 0.0;
      end
      else begin  (* regular monthly payment *)
         Balance := Balance - Principal_Payment;
      end;
      Writeln(Month:5,Payment:10:2,Interest_Payment:10:2,
              Principal_Payment:10:2,Balance:10:2);
   end; (* of if balance > 0.0 then *)
end;

procedure Print_Annual_Summary; (* ********* print annual summary *)
begin
end;

begin   (* ****************************************** main program *)
   Initialize_Data;
   repeat
      Print_Annual_Header;
      for Month := Starting_Month to 12 do begin
         Calculate_And_Print;
      end;
      Print_Annual_Summary;
      Starting_Month := 1;
   until Balance <= 0.0;
end. (* of main program *)
