{ Limitations:
  1 Line : max 128 characters
  1 Text : max 63 characters
  1 File : max 800 lines }
program NGS;
uses crt, dos, graph;
type
  Tools  = (tLine, tRectangle, tEllipse, tArc, tText);
  Tokens = (_alpha, _num, _opar, _cpar, _delimit);
  Tarray = record
             avoid : boolean;
             tool  : Tools;
             shape : byte;
             tag   : byte;     { Unused Arc parameter and fill tag }
             x1    : integer;
             y1    : integer;
             case integer of
                 0 : (x2    : integer;
                      y2    : integer);
                 1 : (txt : string[63])
             end;

const
  Alpha   = ['A'..'Z', 'a'..'z'];
  Num     = ['0'..'9'];
  Sym     = ['(', ')', ';'];
  Ctrl    = [#10, #13, #32];
  Valid   = Alpha + Num + Sym;
  Op      = ['L', 'R', 'E', 'A', 'T'];
  Zoom    : boolean = false;
  Grid    : boolean = false;
  FStyle  : boolean = false;
  Stop    : boolean = false;
  Display : boolean = false;

var
  f : text;
  s : string[128];
  i, j : word;
  ch : char;
  fill : boolean;
  style : word;
  tsize : char;
  result : word;
  lines, col : word;
  Param : array[1..800] of Tarray;
  pmax : word;
  cpar : array[2..5] of string[2];
  x, y : word;
  dega, degb : integer;

  gd, gm : integer;
  FontDir : integer;


procedure VgaDriver; external; {$L egavga}
procedure Litt; external; {$L litt}

{ Check whether a file exists and can be opened }
function FileExists(name: string): boolean;
var
  rec : SearchRec;
begin
  FileExists := false;

  FindFirst(name, anyfile - directory - volumeid, rec);
  if DosError <> 0 then exit;

  assign(f, name);
  {$I-}
  reset(f);
  {$I+}
  if IOResult <> 0 then exit;

  FileExists := true
end;


{ Grumble at the user }
procedure Grumble(msg: string);
begin
  writeln(msg);
  halt
end;


{ Display an error message and exit }
procedure Error(msg: string);
begin
  if Display then
  begin
    textcolor(15);
    writeln(s);
    textcolor(12);
    for i := 1 to col-1 do write(' ');
    writeln('^');
    writeln('(', lines, ', ', col, '): ', msg);
    textcolor(15);
    write(' ');
    stop := true
  end;
  param[pmax].avoid := true
end;


{ Returns the desired style }
function GetStyle: word;
begin
  { Shape }
  if upcase(s[3]) = 'D' then
  begin
    case upcase(s[4]) of
       'D' : GetStyle := 11;
       'S' : GetStyle := 12;
       'T' : GetStyle := 13
    else
      Error('''DD'', ''DS'' or ''DT'' expected')
    end;
    inc(col, 2);
    exit
  end;

  { Thickness }
  if not (s[3] in ['0'..'9']) then
     Error('Value [1..10], ''DD'', ''DS'' or ''DT'' expected');

  col := 5;
  if (s[3] = '1') and (s[4] = '0') then GetStyle := 10
  else
    begin
      GetStyle := ord(s[3]) - 48;
      dec(col)
    end
end;


{ Return a number }
function GetNumber(limit: word): integer;
const
  neg : boolean = false;
var
  temp : integer;
begin
  temp := 0;

  neg := false;
  if s[col] = '-' then neg := true else dec(col);
  inc(col);

  if not (s[col] in Num) then Error('Numerical value expected');

  while s[col] in Num do
  begin
    temp := temp * 10 + ord(s[col]) - 48;
    if temp > limit then Error('Number too large');
    inc(col)
  end;

  if neg then temp := temp * -1;
  GetNumber := temp * (word(zoom) + 1);

  inc(col)
end;


{ Return a string }
function GetString: string;
var
  temp : string;
  ch : char;
begin
  temp := '';
  inc(col);

  while not (s[col] in ['"', #13, #0]) do
  begin
    { Ansi -> Ascii conversion }
    case s[col] of
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := '';
       '' : ch := ''
    else
      ch := s[col]
    end;

    temp := temp + ch;
    inc(col)
  end;

  GetString := temp
end;


{ Parses a line and returns an error code }
function ProcessLine: word;
begin
  if eof(f) then
  begin
    ProcessLine := 1; { end of file }
    exit
  end;

  { Read in a line }
  readln(f, s);
  while ((s = '') or (s = '#13#10')) and not eof(f) do
  begin
    readln(f, s);
    inc(lines)
  end;

  { Remove spaces }
  while s[1] = ' ' do Delete(s, 1, 1);

  col := 1;
  ch := upcase(s[1]);

  { Check command and opening parenthesis }
  if not (ch in Op) then Error('Unknown command') else col := 2;
  { -- }
  col := 3;
  { -- }

  { Return style and check for semicolon if necessary }
  if ch in ['L', 'R', 'E', 'A'] then
  begin
    style := GetStyle;
    inc(col)
  end;

  { Check if limit was exceeded }
  if pmax = 891 then Error('File exceeds 890 lines');

  { Parse parameters }
  case ch of
      'L' : begin
              { Fill in array; first coordinates }
              with Param[pmax] do
              begin
                tool := tLine;
                shape := style;

                x1 := GetNumber(639);
                y1 := GetNumber(479);

                if s[col-1] = ':' then x2 := x1 + GetNumber(639)
                                  else x2 := GetNumber(639);
                if s[col-1] = ':' then y2 := y1 + GetNumber(479)
                                  else y2 := GetNumber(479)
              end;

              { polyline }
              while (s[col-1] = ';') or (s[col-1] = ':') do
              begin
                inc(pmax);
                with Param[pmax] do
                begin
                  tool := tLine;
                  shape := Param[pmax-1].shape;

                  x1 := Param[pmax-1].x2;
                  y1 := Param[pmax-1].y2;

                  { X coordinate }
                  if s[col-1] = ':' then x2 := x1 + GetNumber(639)
                                    else x2 := GetNumber(639);

                  { Y coordinate }
                  if s[col-1] = ':' then y2 := y1 + GetNumber(479)
                                    else y2 := GetNumber(479)
                end
              end;

              inc(pmax)
            end;

  { Rectangle, Ellipse -------------------------------------------------- }
  'R','E' : begin
              if upcase(s[col]) = 'F' then fill := true else
                if upcase(s[col]) <> 'E' then Error('''E'' or ''F'' expected')
                else fill := false;
              inc(col);

              inc(col);

              { Fill in array }
              with Param[pmax] do
              begin
                if ch = 'R' then tool := tRectangle else tool := tEllipse;
                shape := style;

                x1 := GetNumber(639);
                y1 := GetNumber(479);

                { Relative or absolute coordinates }
                if s[col-1] = ':' then x2 := x1 + GetNumber(639)
                                  else x2 := GetNumber(639);
                if s[col-1] = ':' then y2 := y1 + GetNumber(479)
                                  else y2 := GetNumber(479);
                tag := byte(fill)
              end;
              inc(pmax)
            end;

      { Arc ------------------------------------------------------------- }
      'A' : begin
              if s[col] <> '0' then Error('''0'' expected') else inc(col);

              inc(col);

              { Fill in array }
              with Param[pmax] do
              begin
                tool := tArc;
                shape := style;
                tag := 0;

                x1 := GetNumber(639);
                y1 := GetNumber(479);

                if s[col-1] = ':' then x2 := x1 + GetNumber(639)
                                  else x2 := GetNumber(639);
                if s[col-1] = ':' then y2 := y1 + GetNumber(479)
                                  else y2 := GetNumber(479)
              end;
              inc(pmax)
            end;

      { Text ------------------------------------------------------------ }
      'T' : begin
              if not (upcase(s[col]) in ['S', 'M', 'L']) then
                 Error('''S'', ''M'', ''L'' expected') else tsize := upcase(s[col]);
              inc(col);

              FontDir := HorizDir;

              { Horizontal or vertical? }
              if upcase(s[col]) = 'U' then
              begin
                FontDir := VertDir;
                inc(col)
              end;

              inc(col);

              { Fill in array }
              with Param[pmax] do
              begin
                tool := tText;
                tag := FontDir;
                case tsize of
                    'S' : shape := 2;
                    'M' : shape := 4;
                    'L' : shape := 6
                end;
                x1 := GetNumber(639);
                y1 := GetNumber(479);
                txt := GetString
              end;
              inc(pmax)
            end
  else
    inc(pmax) { if the line is faulty, skip it }
  end
end;


begin
  { Analyse command line parameters }
  if ParamCount = 0 then
     Grumble('NGPaint Reader for DOS. Preliminary version 7.' + #13#10#10 +
                      'NGP Filename [/E] [/F] [/G] [/Z] ' + #13#10#10 +
                      '/E  Display errors' + #13#10 +
                      '/F  Alternative fill style' + #13#10 +
                      '/G  Draw grid' + #13#10 +
                      '/Z  Zoom (320x200 -> 640x400)');
  if (not FileExists(ParamStr(1))) and (not FileExists(ParamStr(1) + '.ngs'))
     then Grumble('File cannot be opened');

  for i := 2 to 5 do
  begin
    cpar[i] := ParamStr(i);
    if (cpar[i] = '/e') or (cpar[i] = '/E') then display := true;
    if (cpar[i] = '/f') or (cpar[i] = '/F') then fstyle := true;
    if (cpar[i] = '/g') or (cpar[i] = '/G') then grid := true;
    if (cpar[i] = '/z') or (cpar[i] = '/Z') then zoom := true
  end;

  { Initialize variables }
  lines := 0;
  col := 0;
  pmax := 1;

  repeat until ProcessLine = 1;
  close(f);


  { ======================== Interpreter ========================== }
  if stop then delay(2000);

  RegisterBGIDriver(@VgaDriver);
  RegisterBGIFont(@Litt);

  { Initialize graphics mode }
  gd := detect;
  initgraph(gd, gm, '');

  { Draw grid if requested }
  if grid then
  begin
    setcolor(8);

    i := 10 * (word(zoom) + 1);
    repeat
      line(i, 0, i, 479);
      inc(i, 10 * (word(zoom) + 1))
    until i > 639;

    j := 10 * (word(zoom) + 1);
    repeat
      line(0, j, 639, j);
      inc(j, 10 * (word(zoom) + 1))
    until j > 479;

    setcolor(15);
  end;


  { Draw }
  for i := 1 to pmax - 1 do
  begin
    with Param[i] do
    begin
      if not avoid then
      case tool of

          tline : begin
                    { line style }
                    if shape < 11 then setlinestyle(solidln, 0, shape div 3)
                                  else
                                    case shape of
                                        11 : setlinestyle(UserBitLn, $F18F, NormWidth);
                                        12 : setlinestyle(dashedln, 0, 1);
                                        13 : setlinestyle(dottedln, 0, 1)
                                    end;

                    { Draw }
                    line(x1, y1, x2, y2)
                  end;

     { ------------------------------------------------------------------ }

     trectangle : begin
                    { line style }
                    if shape < 11 then setlinestyle(solidln, 0, shape div 3)
                                  else
                                    case shape of
                                        11 : setlinestyle(UserBitLn, $F18F, NormWidth);
                                        12 : setlinestyle(dashedln, 0, 1);
                                        13 : setlinestyle(dottedln, 0, 1)
                                    end;

                    { Draw }
                    Rectangle(x1, y1, x2, y2);

                    { fill? }
                    if FStyle then SetFillStyle(9, 15);
                    if tag = 1 then FloodFill(x1 + 1, y1 + 1, 15)
                  end;

      { ------------------------------------------------------------------ }
       tellipse : begin
                    { Line style }
                    if shape < 11 then setlinestyle(solidln, 0, shape div 3)
                                  else
                                    case shape of
                                        11 : setlinestyle(UserBitLn, $F18F, NormWidth);
                                        12 : setlinestyle(dashedln, 0, 1);
                                        13 : setlinestyle(dottedln, 0, 1)
                                    end;

                    { Calculate coordinates }
                    Ellipse((x2 + x1) div 2, (y2 + y1) div 2, 0, 360,
                            ((x2 + x1) div 2) - x1, ((y2 + y1) div 2) - y1);

                    { Fill? }
                    if FStyle then SetFillStyle(9, 15);
                    if tag = 1 then
                       FloodFill((x1 + x2) div 2, (y1 + y2) div 2, 15)
                  end;

      { ------------------------------------------------------------------ }

           tArc : begin
                    { Line style }
                    if shape < 11 then setlinestyle(solidln, 0, shape div 3)
                                  else
                                    case shape of
                                        11 : setlinestyle(UserBitLn, $F18F, NormWidth);
                                        12 : setlinestyle(dashedln, 0, 1);
                                        13 : setlinestyle(dottedln, 0, 1)
                                    end;

                    if (x2 < x1) then
                    begin
                      if (y2 < y1) then { upper left }
                      begin
                        dega := 90;
                        degb := 180
                      end
                      else              { lower left }
                        begin
                          dega := 180;
                          degb := 270
                        end
                    end
                    else
                      begin
                        if (y2 < y1) then { upper right }
                        begin
                          dega := 0;
                          degb := 90
                        end
                        else
                          begin           { lower right }
                            dega := 270;
                            degb := 0
                          end
                      end;

                    { Yes, we draw an Arc using Ellipse() }
                    Ellipse(x1, y1, dega, degb, abs(x2 - x1), abs(y2 - y1))
                  end;

      { ------------------------------------------------------------------ }

          ttext : begin
                    { Font style }
                    SetTextStyle(InstallUserFont('litt'), tag, shape * (word(zoom) + 1));

                    { Vertical font? }
                    if tag = VertDir then y1 := y1 - textheight('A') * length(txt);

                    { Display }
                    OutTextXY(x1, y1, txt)
                  end
      end
    end
  end;

  readkey;
  RestoreCrtMode
end.
