unit Main;

{ Project : ImgView.Dpr
  Author  : Mike Young, Compuserve 100031,764, mike.y@zetnet.co.uk
  Date    : 13th March 1997

  External resources necessary : NViewLIB.DLL

  Program Description :

  A Delphi20 first project to aid me understand some of Delphi's object Pascal
  techniques & methods (it seemed a good idea at the time).

  Be it a bit scrappy and slightly big on repainting ! Couldn't seem to control
  when resize & repaint events happen, also I had to remove some functionality
  because the when a double click event happened it triggered mousedown, move
  & up events before the double click event so I had to remove the functionality
  which was controlled by the double click.

  This program hopefully demonstrates some useful techniques that I can pass on
  to others, I find it takes a long some digging around on-line manuals, manuals &
  external sources for information on how to do sometimes very simple things...

  Features :

  Quick and easy image viewing, image formats supported BMP, JPG, TGA, PCX, RLE,
  GIF, JIF & DIB some of the most popular.

  Could be used as a View assoicate as an additional Open type (explorer right
  click thing).

  Resizing some images well enough to enable clipboard copy to other applications.

  Command line processing (I only take one parameter but they can be accessed).
  Filemanager/Explorer FileDrop awareness.
  Runtime switchable always on top (via the Win32API).
  Captionless form with form drag & drop without disrupting the forms mouse events.
  Image clipboard copy/paste.

  Quick'ish image display, form resizing keeping the images aspect ratio correct.

  Right mouse click menu for quick and easy image selection.

  Keys:

  Control pops up the menu.
  Space, Downarrow select the next image from the internal list.
  Backspace. Uparrow select the previous image from the internal list.
  F3 toggles fit to screen.

  Sorry but I can't still find any doco on what contants are available
  for nice readable code regarding what key is what ie (F2 : 114) ?

}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, FileCtrl , ShellAPI, AboutFrm;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    PopupMenu1: TPopupMenu;
    Loadfromfile1: TMenuItem;
    Pastefromclipboard1: TMenuItem;
    N1: TMenuItem;
    Cancel1: TMenuItem;
    Image1: TImage;
    N2: TMenuItem;
    Exit1: TMenuItem;
    FileListBox1: TFileListBox;
    Nextimage1: TMenuItem;
    Previousimage1: TMenuItem;
    Maintainheight1: TMenuItem;
    Maintainwidth1: TMenuItem;
    Centerimage1: TMenuItem;
    Copy1: TMenuItem;
    N3: TMenuItem;
    AlwaysOnTop: TMenuItem;
    About1: TMenuItem;
    ImageInfo: TMenuItem;
    More: TMenuItem;
    Actual: TMenuItem;
    Now: TMenuItem;
    ByteSize: TMenuItem;
    FileDate: TMenuItem;
    Path: TMenuItem;
    N4: TMenuItem;
    ToggleFit1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure AppMessage(var Msg: Tmsg; var Handled: Boolean);
    procedure Loadfromfile1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Pastefromclipboard1Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SetCaption;
    procedure SetImage;
    procedure MoveForm(bUseParm: boolean; iHeight, iWidth: Integer);
    procedure SetListIndex;
    procedure Nextimage1Click(Sender: TObject);
    procedure LoadImage;
    procedure Previousimage1Click(Sender: TObject);
    procedure Maintainheight1Click(Sender: TObject);
    procedure Maintainwidth1Click(Sender: TObject);
    procedure Centerimage1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Copy1Click(Sender: TObject);
    procedure AlwaysOnTopClick(Sender: TObject);
    procedure AcceptFiles;
    procedure NotTopMost;
    procedure TopMost;
    procedure About1Click(Sender: TObject);
    procedure GhostForm(X, Y, H, W :Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ToggleFit1Click(Sender: TObject);
    procedure Minimise1Click(Sender: TObject);
    procedure ActualClick(Sender: TObject);
  private
    { Private declarations }
    procedure WMGetMinMaxInfo(var MSG: Tmessage); message WM_GetMinMaxInfo;
    procedure CreateParams(var Params : TCreateParams); override;
  public
    { Public declarations }
    function RemoveDot(Text: String): string;
  end;

var
  Form1: TForm1;
  sgAspectRatio : single;
  iCaptionHeight, iBordersSize , iImageLoaded, iLastHeight, iLastWidth,
  iToggleLeft, iToggleTop, iToggleHeight, iToggleWidth: integer;
  sFileName: String;
  bFrmOkToMove, bFrmMoved, bToggleFit, bHaveFileList: boolean;
  iStartLeft, iStartTop, iFrmPtrDragX, iFrmPtrDragY : Integer;
  liImageFileSize, liImageFileDate : LongInt;

const
  FLAGS = SWP_NOMOVE Or SWP_NOSIZE;

  function NViewLibLoad(FileName : PChar; ShowProgress: BooLean):hbitmap; Stdcall; external 'NViewLib.dll';

implementation

uses
  Clipbrd;

{$R *.DFM}

function TForm1.RemoveDot(Text: String): string;
var
  iPos : integer;

begin
  iPos := pos('.',Text);
  if iPos > 0 then
    Delete(Text,iPos,1);

  Result := Text;
end;

procedure TForm1.WMGetMinMaxInfo(var MSG: Tmessage);
Begin
  inherited;
  with PMinMaxInfo(MSG.lparam)^ do
  begin
    with ptMinTrackSize do
    begin
      X := 24;
      Y := 24;
    end;
    with ptMaxTrackSize do
    begin
      X := Screen.Width;
      Y := Screen.Height;
    end;
  end;
end;

procedure TForm1.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
    Style := Style or ws_Border or ws_ThickFrame;
end;

procedure TForm1.FormCreate(Sender: TObject);

begin
  FreeLibrary(GetModuleHandle('OleAut32'));
  Acceptfiles;

  iImageLoaded := 0;
  bHaveFileList := False;
  OpenDialog1.FilterIndex := 1;
  iCaptionHeight := Form1.Height - Form1.ClientHeight;
  iBordersSize := Form1.Width - Form1.ClientWidth;

  { Check for any parameters which have been passed }
  if ParamCount > 0 then
  begin
    sFileName := ParamStr(1);     { Only except the first one if any }
    LoadImage;
  end
  else
  begin
    liImageFileSize := 0;
    liImageFileDate := 0;
    sFileName := 'Internal image';
    SetImage;
  end;

  iImageLoaded := 1;

end;

procedure TForm1.AppMessage(var Msg: Tmsg; var Handled: Boolean);
const
    BufferLength : word = 255;
var
    DroppedFilename : string;
    FileIndex : word;
    QtyDroppedFiles : word;
    pDroppedFilename : array [0..255] of Char;
    DroppedFileLength : word;
begin
  if Msg.Message = WM_DROPFILES then
  begin
    FileIndex := $FFFF;
    QtyDroppedFiles := DragQueryFile(Msg.WParam, FileIndex, pDroppedFilename, BufferLength);
    if QtyDroppedFiles <> -1 then
    begin
      FileIndex := 0;
      DroppedFileLength := DragQueryFile(Msg.WParam, FileIndex, pDroppedFilename, BufferLength);
      DroppedFilename := StrPas(pDroppedFilename);
      sFileName := DroppedFilename;
      LoadImage;
    end;
    DragFinish(Msg.WParam);
    Handled := true;
  end;
end;

procedure TForm1.GhostForm(X, Y, H, W : Integer);
var
  hScreen, hRegion, iResult, hBrush, hObjOld : Integer;
  lbResult : LongBool;

begin
  hScreen := GetDC(0);
  hRegion := CreateRectRgn(0,0, Screen.Width, Screen.Height);
  iResult := SelectClipRgn(hScreen, hRegion);
  hBrush := GetStockObject(NULL_BRUSH);
  hObjOld := SelectObject(hScreen, hBrush);
  iResult := SetROP2(hScreen, R2_NOTXORPEN);
  lbResult := Rectangle(hScreen, X, Y, H, W);
  lbResult := DeleteObject(hRegion);
  lbResult := UnrealizeObject(hScreen);
  hScreen := ReleaseDC(0, hScreen);
end;

procedure TForm1.Loadfromfile1Click(Sender: TObject);
begin

{
   Open dialog options

   ofReadOnly, ofOverwritePrompt, ofHideReadOnly, ofNoChangeDir,
   ofShowHelp, ofNoValidate, ofAllowMultiSelect, ofExtensionDifferent,
   ofPathMustExist, ofFileMustExist, ofCreatePrompt, ofShareAware,
   ofNoReadOnlyReturn,ofNoTestFileCreate
}

  OpenDialog1.Options := [ofReadOnly,ofFileMustExist];
  OpenDialog1.Filter := 'All supported images|*.BMP;*.DIB;*.JPG;*.JIF;*.GIF;*.PCX;*.RLE;*.TGA|'
                      + 'Bitmap (*.BMP)|*.BMP|'
                      + 'DIB (*.DIB)|*.DIB|'
                      + 'JIF (*.JIF)|*.JIF|'
                      + 'Jpeg (*.JPG)|*.JPG|'
                      + 'GIF (*.GIF)|*.GIF|'
                      + 'PCX (*.PCX)|*.PCX|'
                      + 'RLE (*.RLE)|*.RLE|'
                      + 'Targa (*.TGA)|*.TGA';
  Image1.AutoSize := True;

  { When the open dialog appears we don't want to be always on top, otherwise
    we wouldn't see the thing }
    If AlwaysOnTop.Checked = True then
    NotTopMost;

  { If the user has clicked OK }
  if OpenDialog1.Execute then
  begin
    sFileName := ExtractFileName(OpenDialog1.Filename);
    { Load the image into the Image1 structure}
    Form1.FileListBox1.Directory := ExtractFilePath(OpenDialog1.Filename);

    LoadImage;
    { Set up and populate the filelistbox with the files in the current directory }
    case OpenDialog1.FilterIndex of
     1 : Form1.FileListBox1.Mask := '*.BMP;*.DIB;*.JIF;*.JPG;*.GIF;*.PCX;*.RLE;*.TGA';
     2 : Form1.FileListBox1.Mask := '*.BMP';
     3 : Form1.FileListBox1.Mask := '*.DIB';
     4 : Form1.FileListBox1.Mask := '*.JIF';
     5 : Form1.FileListBox1.Mask := '*.JPG';
     6 : Form1.FileListBox1.Mask := '*.GIF';
     7 : Form1.FileListBox1.Mask := '*.PCX';
     8 : Form1.FileListBox1.Mask := '*.RLE';
     9 : Form1.FileListBox1.Mask := '*.TGA';
    end;

    Form1.FileListBox1.Update;
    { Set the FileListBox.ItemIndex to the file selected }
    SetListIndex;
    { Set on the ability to select files from the directory list via Next/Previous etc }
    bHaveFileList := True;
    Nextimage1.enabled := True;
    Previousimage1.enabled := True;
  end;

  { Apply top most again if needed }
  If AlwaysOnTop.Checked = True then
    TopMost;

end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  lbResult : LongBool;

begin

  if (bFrmOkToMove = True) then
  begin
    GhostForm(iStartLeft, iStartTop, iStartLeft + Form1.Width, iStartTop + Form1.Height);
    lbResult := MoveWindow(Form1.Handle,iStartLeft,iStartTop,Form1.Width,Form1.Height,True);
    iToggleLeft := Form1.Left;
    iToggleTop := Form1.Top;
    bFrmMoved := False;
    bFrmOkToMove := False;
  end;

  if (Button = mbRight) Then
  begin
    if ClipBoard.HasFormat(CF_BITMAP) then
      PasteFromClipboard1.Enabled := True;

      PopupMenu1.AutoPopup := False;
      PopupMenu1.Popup(Form1.Left + X, Form1.Top + (Form1.Height - Form1.ClientHeight) + Y);

  end;

  if (Button = mbLeft) Then
  begin
    iStartLeft := Form1.Left;
    iStartTop := Form1.Top;
    iFrmPtrDragX := X;
    iFrmPtrDragY := Y;
    GhostForm(iStartLeft, iStartTop, iStartLeft + Form1.Width, iStartTop + Form1.Height);
    bFrmOkToMove := True;
    bFrmMoved := False;
  end

end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  iNewLeft, iNewTop : Integer;

begin
  if (bFrmOkToMove = True) then
    begin
      iNewLeft := iStartLeft + X - iFrmPtrDragX;
      iNewTop := iStartTop + Y - iFrmPtrDragY;
      GhostForm(iStartLeft, iStartTop, iStartLeft + Form1.Width, iStartTop + Form1.Height);
      GhostForm(iNewLeft, iNewTop, iNewLeft + Form1.Width, iNewTop + Form1.Height);
      iFrmPtrDragX := X;
      iFrmPtrDragY := Y;
      iStartLeft := iNewLeft;
      iStartTop := iNewTop;
      bFrmMoved := True;
    end;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  lbResult : LongBool;

begin
  if ((Button = mbLeft) and (bFrmOkToMove = True)) then
  begin
    GhostForm(iStartLeft, iStartTop, iStartLeft + Form1.Width, iStartTop + Form1.Height);
    lbResult := MoveWindow(Form1.Handle,iStartLeft,iStartTop,Form1.Width,Form1.Height,True);
    iToggleLeft := Form1.Left;
    iToggleTop := Form1.Top;
    bFrmMoved := False;
    bFrmOkToMove := False;
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Pastefromclipboard1Click(Sender: TObject);
begin
  If ClipBoard.HasFormat(CF_BITMAP) then
  begin
    Image1.Picture.Assign(ClipBoard);
    liImageFileSize := 0;
    liImageFileDate := 0;
    sFileName := 'ClipBoard';
    SetImage;
  end;

end;

procedure TForm1.FormPaint(Sender: TObject);
var
  iResult : Boolean;

begin
  Canvas.StretchDraw(ClientRect, Image1.Picture.Graphic);
  {iResult := BitBlt(Form1.Handle,0,0,ClientWidth,ClientHeight,Image1.Picture.Bitmap.Handle,0,0,SRCCOPY);}
  end;

procedure TForm1.FormResize(Sender: TObject);
var
  iTmpWidth, iTmpHeight, iHeightDiff, iWidthDiff,iDiff : integer;
  lbResult : LongBool;

begin
  iTmpWidth := Form1.ClientWidth;
  iTmpHeight := Form1.ClientHeight;
  if iImageLoaded > 0 then
  begin
    iHeightDiff := abs(iLastHeight - Form1.ClientHeight);
    iWidthDiff := abs(iLastWidth - Form1.ClientWidth);
    iDiff := iHeightDiff - iWidthDiff;
    if (iHeightDiff > iWidthDiff) and (iDiff <> 0) then
    begin
    { Adjust for Height
      Work out the width to fit the aspect ratio of the image }
      iTmpWidth := round(Form1.ClientHeight * sgAspectRatio);
      iTmpHeight := Form1.ClientHeight;
      If iTmpWidth > (Screen.Width - iBordersSize) Then
      begin
        iTmpWidth := Screen.Width - iBordersSize;
        iTmpHeight := round(iTmpWidth / sgAspectRatio);
      end
    end
    else
    begin
    { Adjust for Width
      Work out the height to fit the aspect ratio of the image }
      iTmpHeight := round(Form1.ClientWidth / sgAspectRatio);
      iTmpWidth := Form1.ClientWidth;
        If iTmpHeight > (Screen.Height - iCaptionHeight) Then
        begin
          iTmpHeight := Screen.Height - iCaptionHeight;
          iTmpWidth := round(iTmpHeight * sgAspectRatio);
        end
    end;
    iImageLoaded := 0;
    lbResult := MoveWindow(Form1.Handle,Form1.Left,Form1.Top,iTmpWidth+iBordersSize,iTmpHeight+iBordersSize,True);
    iLastWidth := Form1.ClientWidth;
    iLastHeight := Form1.ClientHeight;
    iImageLoaded := 1;
    FormPaint(Self);
    SetCaption;
  end;

end;

procedure TForm1.SetCaption;
var
  sByteSize, sFileDate, sFilePath, sFile : string;

begin

  //Form1.Caption := sFileName + ' size [' + inttostr(Image1.Width) + ',' + inttostr(Image1.Height) + '] view [' + inttostr(Form1.ClientWidth) + ',' + inttostr(Form1.ClientHeight) + ']';

  sFilePath := ExtractFilePath(sFilename);
  if sFilePath = '' then
  begin
    ImageInfo.Caption := sFileName;
    Path.Caption := 'Path ..... [' + Form1.FileListBox1.Directory + '\]';
  end
  else
  begin
    ImageInfo.Caption := ExtractFileName(sFileName);
    Path.Caption := 'Path ..... [' + sFilePath + ']';
  end;

  Actual.Caption := 'Image ... [' + inttostr(Image1.Width) + ',' + inttostr(Image1.Height) + ']';
  Now.Caption    := 'View ..... [' + inttostr(Form1.ClientWidth) + ',' + inttostr(Form1.ClientHeight) + ']';
  if liImageFileSize = 0 then
    ByteSize.Caption := 'None'
  else
    ByteSize.Caption := 'File ....... [' + FormatFloat('#,###,###,###',liImageFileSize) + ' bytes]';

  if liImageFileDate = 0 then
    FileDate.Caption := 'None'
  else
    FileDate.Caption := 'Date ..... [' + FormatDateTime('dd/mm/yyyy hh:mm:ss am/pm',FileDateToDateTime( liImageFileDate)) + ']';

end;

procedure TForm1.SetImage;
var
  iNewWidth, iNewHeight : Integer;

begin
  iToggleLeft := Form1.Left;
  iToggleTop := Form1.Top;

  sgAspectRatio := Image1.Width / Image1.Height;

  if (MaintainHeight1.Checked = false) and (MaintainWidth1.Checked = false) then
  begin
    iLastHeight := Image1.Height;
    iLastWidth := Image1.Width;
  end;

  iNewWidth := iLastWidth;
  iNewHeight := iLastHeight;

  if MaintainHeight1.Checked = True then
    iLastWidth := 0;

  if MaintainWidth1.Checked = True then
    iLastHeight := 0;

  if bToggleFit = true then
  begin
    iNewHeight := Screen.Height - iCaptionHeight;
    MoveForm(True,iNewHeight,iNewWidth);
  end
  else
    MoveForm(True,iLastHeight,iLastWidth);

end;

procedure TForm1.MoveForm(bUseParm: boolean; iHeight, iWidth: Integer);
var
  lbRefresh, lbResult : LongBool;
  iNewLeft, iNewTop, iNewWidth, iNewHeight : integer;

begin
  iNewLeft := Form1.Left;
  iNewTop := Form1.Top;
  iNewWidth := Form1.Width;
  iNewHeight := Form1.Height;
  if bUseParm = True then
  begin
    if iHeight = 0 then
    begin
      iNewWidth := iWidth;
      iNewHeight := round(iNewWidth / sgAspectRatio);
      if iNewHeight > (Screen.Height - iCaptionHeight) then
      begin
        iNewHeight := Screen.Height - iCaptionHeight;
        iNewWidth := round(iNewHeight * sgAspectRatio);
      end;
      iNewHeight := iNewHeight + iCaptionHeight;
      iNewWidth := iNewWidth + iBordersSize;
    end
    else
    begin
      iNewHeight := iHeight;
      iNewWidth := round(iNewHeight * sgAspectRatio);
      if iNewWidth > (Screen.Width - iBordersSize) then
      begin
        iNewWidth := Screen.Width - iBordersSize;
        iNewHeight := round(iNewWidth / sgAspectRatio);
      end;
      iNewHeight := iNewHeight + iCaptionHeight;
      iNewWidth := iNewWidth + iBordersSize;
    end;
  end;

  if ((CenterImage1.Checked = True) or (bToggleFit = True)) then
  begin
    iNewLeft := (Screen.Width - iNewWidth) div 2;
    iNewTop := (Screen.Height - iNewHeight) div 2;
  end
  else
  begin
    iNewLeft := iToggleLeft;
    iNewTop := iToggleTop;
  end;

  iImageLoaded := 0;
  lbRefresh := True;
  lbResult := MoveWindow(Form1.Handle,iNewLeft,iNewTop,iNewWidth,iNewHeight,lbRefresh);

  iLastWidth := Form1.ClientWidth;
  iLastHeight := Form1.ClientHeight;

  FormPaint(Self);
  iImageLoaded := 1;
  SetCaption;

end;

procedure TForm1.SetListIndex;
var
   iI : Integer;
   iCount : Integer;

begin
    iCount := FileListBox1.Items.Count;
     If (iCount > 0) then
        begin
             For iI := 0 to iCount-1 do
                 begin
                   if uppercase(sFileName) = uppercase(Form1.FileListBox1.items[iI]) then
                   begin
                     Form1.FileListBox1.ItemIndex := iI;
                     break;
                   end
                 end;
        end;
end;

procedure TForm1.LoadImage;
  var
  sSearchRec: TsearchRec;
  iResult, iResponse : Integer;
  sMessageText, sFileExtension: String;

begin
  Form1.Cursor := crHourGlass;
  sFileExtension := RemoveDot(uppercase(ExtractFileExt(sFileName)));

  if (sFileExtension = 'JPG')
  or (sFileExtension = 'JIF')
  or (sFileExtension = 'GIF')
  or (sFileExtension = 'DIB')
  or (sFileExtension = 'RLE')
  or (sFileExtension = 'PCX')
  or (sFileExtension = 'TGA')
  or (sFileExtension = 'BMP') then
  begin
    Image1.Picture.Bitmap.Handle := NViewLibLoad(Pchar(sFileName),False);
    Form1.Cursor := crDefault;

    iResult := FindFirst(sFilename, faAnyFile, sSearchRec);
    if iResult = 0 then;
    begin
      liImageFileSize := sSearchRec.Size;
      liImageFileDate := sSearchRec.Time;
    end;
    FindClose(sSearchRec);

    SetImage;
    iImageLoaded := 1;
  end
  else
  begin
    Form1.Cursor := crDefault;
    sMessageText := sFileName + ' is not a valid image file';
    iResponse := MessageBox(Form1.Handle,PChar(sMessageText),'Image Viewer',mB_OK);
  end

end;

procedure TForm1.Nextimage1Click(Sender: TObject);
var iCheck: integer;

begin
  iCheck := Form1.FileListBox1.ItemIndex + 1;
  if iCheck < FileListBox1.Items.Count then
  begin
    Form1.FileListBox1.ItemIndex := iCheck;
  end
  else
    Form1.FileListBox1.ItemIndex := 0;

  sFileName := Form1.FileListBox1.items[Form1.FileListBox1.ItemIndex];
  LoadImage;

end;

procedure TForm1.Previousimage1Click(Sender: TObject);
var iCheck: integer;

begin
  iCheck := Form1.FileListBox1.ItemIndex - 1;
  if iCheck >= 0 then
  begin
    Form1.FileListBox1.ItemIndex := iCheck;
  end
  else
    Form1.FileListBox1.ItemIndex := FileListBox1.Items.Count - 1;

  sFileName := Form1.FileListBox1.items[Form1.FileListBox1.ItemIndex];
  LoadImage;

end;

procedure TForm1.Maintainheight1Click(Sender: TObject);
begin
  MaintainHeight1.Checked := NOT MaintainHeight1.Checked;
  if MaintainHeight1.Checked = true then
    MaintainWidth1.Checked := false;

end;

procedure TForm1.Maintainwidth1Click(Sender: TObject);
begin
  MaintainWidth1.Checked := NOT MaintainWidth1.Checked;
  if MaintainWidth1.Checked = true then
    MaintainHeight1.Checked := false;

end;

procedure TForm1.Centerimage1Click(Sender: TObject);
begin
  CenterImage1.Checked := NOT CenterImage1.Checked;
  if CenterImage1.Checked = true then
  begin
    MoveForm(False,0,0);
  end
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
  iPopLeft, iPopTop : Integer;
begin

  if bHaveFileList = True then
   case key of
     vk_Down, vk_Space : Nextimage1Click(Self);
     vk_up,   vk_Back  : Previousimage1Click(Self);
   end;

  if key = vk_F3 then
    ToggleFit1Click(Self);

  if Shift = [ssCtrl] then
  begin
    PopupMenu1.AutoPopup := False;
    iPopLeft := Form1.Left + (Form1.Width div 4);
    iPopTop := Form1.Top + (Form1.Height - Form1.ClientHeight) + (Form1.ClientHeight div 4);
    PopupMenu1.Popup(iPopLeft, iPopTop);
  end

end;

procedure TForm1.Copy1Click(Sender: TObject);
var
  FormImage: TBitmap;
begin
  FormImage := GetFormImage;
  try
    Clipboard.Assign(FormImage);
  finally
    FormImage.Free;
  end;
end;

procedure TForm1.AlwaysOnTopClick(Sender: TObject);
begin
  AlwaysOnTop.Checked := NOT AlwaysOnTop.Checked;
  If AlwaysOnTop.Checked = True then
    TopMost
  else
    NotTopMost;

end;

procedure TForm1.AcceptFiles;
begin
  { Tell windows that we will accept files being dropped }
  DragAcceptFiles(Form1.Handle, true);
  DragAcceptFiles(Application.Handle, true);
  Application.OnMessage := AppMessage;
end;

procedure TForm1.TopMost;
var
  lbSuccess : LongBool;
begin
  lbSuccess := SetWindowPos(Form1.Handle, HWND_TOPMOST, 0, 0, 0, 0, FLAGS);
end;

procedure TForm1.NotTopMost;
var
  lbSuccess : LongBool;
begin
  lbSuccess := SetWindowPos(Form1.Handle, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS);
end;

procedure TForm1.About1Click(Sender: TObject);
begin

  If AlwaysOnTop.Checked = True then
    NotTopMost;

  About.ShowModal;

  If AlwaysOnTop.Checked = True then
    TopMost;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action := caFree;
end;

procedure TForm1.ToggleFit1Click(Sender: TObject);
var
  iNewHeight, iNewWidth: Integer;

begin
  bFrmOkToMove := False;
  bToggleFit := NOT bToggleFit;
  If bToggleFit then
  begin
    iToggleLeft := Form1.Left;
    iToggleTop := Form1.Top;
    iToggleHeight := Form1.ClientHeight;
    iToggleWidth := Form1.ClientWidth;
    iNewHeight := Screen.Height - iCaptionHeight;
    MoveForm(True,iNewHeight,iNewWidth);
    ToggleFit1.Caption := 'Toggle fit (Image)'
  end
  else
  begin
    iNewHeight := iToggleHeight;
    MoveForm(True,iNewHeight,iNewWidth);
    ToggleFit1.Caption := 'Toggle fit (Screen)'
  end
end;

procedure TForm1.Minimise1Click(Sender: TObject);
begin
  Form1.WindowState := wsMinimized;
end;

procedure TForm1.ActualClick(Sender: TObject);
begin
  MoveForm(True,Image1.Height,Image1.Width);
end;

end.
