Program tstent2;

{ Testprogram for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following nwFile calls:

  GetDirectoryEntry
  ScanDirectoryInformation
  ScanFileInformation
  ScanSalvagableFiles
}

uses nwMisc,nwBindry,nwFile;


Procedure PrintEntry(e:Tentry);
VAr s,ObjName:String;
    ObjType:Word;
begin
with e
 do begin
    writeln('----------------------------------');
    writeln('Name:',EntryName);
    writeln('FileSize       :',FileSize);
    writeln('Name space     :',NStype);
    writeln('Data fork size :',DataForkSize);
    writeln;
    writeln('Attributes:',HexStr(Attributes,8));
    writeln('RightsMask:',HexStr(RightsMask,4));
    writeln;

    objName:='';
    NovTime2String(CreationTime,s);
    GetBinderyObjectName(OwnerId,ObjName,ObjType);
    writeln('Created at       :',s,' by ',ObjName,' (',HexStr(OwnerId,8),')');

    objName:='';
    NovTime2String(ArchiveTime,s);
    GetBinderyObjectName(ArchiverId,ObjName,ObjType);
    writeln('Last archived at :',s,' by ',ObjName,' (',HexStr(ArchiverId,8),')');

    objName:='';
    NovTime2String(ModifyTime,s);
    GetBinderyObjectName(ModifierId,ObjName,ObjType);
    writeln('Last modified at :',s,' by ',ObjName,' (',HexStr(ModifierId,8),')');

    NovTime2String(LastAccessTime,s);
    writeln('Last accessed at :',s);

    objName:='';
    NovTime2String(DeleteTime,s);
    GetBinderyObjectName(DeletorId,ObjName,ObjType);
    writeln('Deleted at       :',s,' by ',ObjName,' (',HexStr(DeletorId,8),')');
    writeln;
  end;
end;

Var DirHandle,EffRights:Byte;
    DirEntry:Tentry;
    SearchFlags,EntryId:Longint;
    PathNAme:STring;
    SeqNbr:Integer;
    WseqNbr:word;

begin

AllocPermanentDirHandle(7,0,'SYS:PUBLIC',DirHandle,EffRights);

writeln;
writeln('Test of GetDirectoryEntry (get entry SYS:\PUBLIC');
write('<RETURN> to contimue...');
readln;

IF GetDirectoryEntry(dirHandle,dirEntry)
 then PrintEntry(dirEntry)
 else writeln('Error using GetDirectoryEntry, err#',nwFile.result);

SetDirectoryHandle(0,'SYS:',DirHandle);

GetDirectoryPAth(DirHandle,PathNAme);
writeln('handle ass. with:',PathName);

writeln;
writeln('Test of ScanDirectoryInformation (scan subdirs of SYS:\PUBLIC');
write('<RETURN> to contimue...');
readln;

WseqNbr:=0;
while ScanDirectoryInformation(dirHandle,'PUBLIC\*',WseqNbr,dirEntry)
 do begin
    writeln('SeqNbr now is: ',WseqNbr);
    PrintEntry(DirEntry);
    end;
if nwFile.result<>$9C
 then writeln('error using ScanDirInfo :',nwFile.result);


writeln;
writeln('Test of ScanFileInformation (scan *.EXE files in SYS:\PUBLIC');
write('<RETURN> to contimue...');
readln;

seqNbr:=-1;
while ScanFileInformation(DirHandle,'PUBLIC\*.EXE',
                          $FF,
                          SeqNbr,
                          dirEntry)
 do begin
    PrintEntry(DirEntry);
    end;
if nwFile.result<>$FF
 then writeln('error using ScanFileInfo :',nwFile.result);


writeln;
writeln('Test of ScanSalvagableFiles (erased files in SYS:\PUBLIC');
write('<RETURN> to contimue...');
readln;

SetDirectoryHandle(0,'SYS:\PUBLIC',DirHandle);


EntryId:=-1;
WHILE ScanSalvagableFiles(DirHandle,
                          EntryId,
                          dirEntry)
 do begin
    PrintEntry(dirEntry);
    writeln('NextEntryId:',hexStr(entryId,8));
    end;
if nwFile.result<>$FF
 then writeln('error using ScanSalvagable files :',nwFile.result);


DeallocateDirHandle(DirHandle);


end.