Program TstPFL;

{ Example for the nwLock unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following nwLock calls: (Physical File Locking)

  ClearPhysicalFileSet
  LogPhysicalFile
  LockPhysicalFileSet
  ReleasePhysicalFile
}

Uses nwFile,nwLock; { using this unit will automatically set the locmode to 1 }

Var FileName:string;
    TimeOutTicks:word;

begin
TimeOutTicks:=360; {wait 20 seconds before locking process times out}

writeln('TSTLF: Test of logical file locking.');
writeln('       -Make sure the files referenced to in this example exist.');
writeln('       -Start the exe on 2 or more workstations & enjoy the effect.');
writeln;

{ Put the names of files-to-be-locked in the 'logged file set' }
FileName:='SYS:PUBLIC/SYSCON.EXE';
IF NOT LogPhysicalFile(FileName,LD_LOG,0)
 then writeln('Logfile failed. Error# ',nwLock.result);
{ Note: The files specified have to exist, or an error 156 is
        returned. Using EXE files instead of data files can be
        a bit confusing in this example, but at least those
        files are very likely to be there. }
FileName:='SYS:\PUBLIC\PCONSOLE.EXE';
IF NOT LogPhysicalFile(FileName,LD_LOG,0)
 then writeln('Logfile failed. Error# ',nwLock.result);
 { Repeat logging process for other (if needed) }


{ Lock all files that are currently stored in the 'logged file set' }
writeln('Attempting to Lock files.. ');
IF NOT LockPhysicalFileSet(TimeOutTicks)
 then writeln('LockFileSet (after TimeOut=20 sec) failed. Error# ',nwLock.result);

if nwlock.result=0 { locking of files was successful }
 then begin
      { ---Update file, change file, etc.--- }

      { Readln to simulate update }
      writeln('Now ''processing'' files. Press RETURN to release locks.');
      readln;

      { Suppose we're done with the 1st datafile, but still need file #2:
        -unlock 1 single file; keep in log }
      IF NOT ReleasePhysicalFile('SYS:\PUBLIC\SYSCON.EXE')
       then writeln('ReleaseFile Failed. Error# ',nwLock.result);

      writeln('Now ''processing'' still locked file');
      end;

{ unlock all files; clear 'logged file set' }
IF NOT ClearPhysicalFileSet
 then writeln('ClearFileSet Failed. Error# ',nwLock.result);

end.
