Unit ODBFile;

{
     Unit for Borland Pascal 7.0 for DOS (Object-Oriented)
     (For Windows Applications Use OWDBFile Unit)
     Reading / Writing DBF Tables
     Written by Leonid Schavelev (December, 1995)
     Ivanovo
     Russia
     E-mail: leonid@polytech.ivanovo.su
}

Interface

Uses Objects, Strings, Dos;

Type TDate = Record Y, M, D: Byte; end;

     TIterProc = Procedure;
     PIterProc = ^TIterProc;

     TIterFunc = Function: Boolean;
     PIterFunc = ^TIterFunc;

     TFileHeader = Record {32}
            Version: Byte; {03h/83h}
            DateUpdate: TDate;
            NumOfRecords: Longint;
            HeaderSize: Word; {32+(Number of Fields)*32+2}
            RecordSize: Longint;
            Ignored: Array [1..18] of Byte;
     end;

     TFieldHeader = Record {32}
            FiName: Array [0..10] of Char;
            FiType: Char; {C/N/D/L/M}
            FiOfs: Longint;
            FiLength: Byte;
            FiDecimals: Byte;
            Ignored: Array [1..14] of Byte;
     end;

     PFieldList = ^TFieldList;
     TFieldList = Array [1..256] of TFieldHeader;

     TMemoHeader = Record {512}
            FreePage: Longint; {DBT-File Size}
            Ignored: Array [1..508] of Byte;
     end;

Const DefaultFileHeader: TFileHeader =
      (Version: $03; DateUpdate: (Y: 95; M: 1; D: 1);
      NumOfRecords: 0; HeaderSize: 33; RecordSize: 1);

      DefaultMemoHeader: TMemoHeader =
      (FreePage: 512);

Type PField = ^TField;
     TField = Object (TObject)
            FiName: Array [0..10] of Char;
            FiType: Char;
            FiOfs: Longint;
            FiLength: Byte;
            FiDecimals: Byte;
            Constructor Init (NewName: PChar; NewType: Char;
                              NewLength, NewDecimals: Byte);
            Function Copy: PField;
     end;

     PDBF = ^TDBF;

     TDBF = Object (TObject)         {Database Object}
            FileHeader: TFileHeader; {General File Sets}
            MemoHeader: TMemoHeader; {Memo File Length}
            Fields: PFieldList;      {Array [1..?] of Field Headers}
            RecBuffer: PChar;        {Operating Record Window}
            DBFName,                        {DBF File Name}
            DBTName: Array [0..79] of Char; {DBT File Name}
            DBFError: Integer;       {0 when Ok}
            RecNo: Longint;          {Operating Record Number}
            Constructor Init;
            Destructor Done; virtual;
               {Opens Existing Database}
            Procedure Use (Path, Name: PChar);
               {Creates Database by Collection of PField}
            Procedure Create (Path, Name: PChar; Structure: PCollection);
               {Returns Collection of PField}
            Function GetStructure: PCollection;
               {Appends New Space Filled Record}
            Procedure AppendBlank;
               {Makes the N-th Record an Operating One}
            Procedure Go (N: Longint);
               {Makes the 1-st Record an Operating One}
            Procedure GoTop;
               {Makes the Last Record an Operating One}
            Procedure GoBottom;
               {Goes to the Record N-th from the Operating One}
            Procedure Skip (N: Longint);
               {Updates Current Record in the Base by Operating Window}
            Procedure ReplaceRecord;
               {Marks Operating Window Record for Deleting}
            Procedure Delete;
               {Vice Versa}
            Procedure Undelete;
               {Tells Whether Operating Window Record Deleted or not}
            Function Deleted: Boolean;
               {Returns the Field Address in the Operating Window}
            Function FieldAddr (FieldName: PChar): PChar;
               {Takes Data from the Field as a 0-Terminated String}
            Procedure GetField (FieldName: PChar; P: PChar); {i,o}
               {Takes Data from the Numeric Field as a Real Number}
            Procedure GetN (FieldName: PChar; P: PChar; var N: Real); {i,o,o}
               {Takes Data from the Date Field as a Date Value}
            Procedure GetD (FieldName: PChar; P: PChar; var Y, M, D: Word); {i,o,o,o,o}
               {Takes Data from the Logical Field as a Boolean Variable}
            Procedure GetL (FieldName: PChar; P: PChar; var L: Boolean); {i,o,o}
               {Sets Data from the 0-Terminated String into the Field}
            Procedure SetField (FieldName: PChar; P: PChar);
               {Sets Data from the Real Number into the Numeric Field}
            Procedure SetN (FieldName: PChar; N: Real);
               {Sets Data from the Date Value into the Date Field}
            Procedure SetD (FieldName: PChar; Y, M, D: Word);
               {Sets Data from the Boolean Variable into the Logical Field}
            Procedure SetL (FieldName: PChar; L: Boolean);
               {Lets Repeat Far Procedure Iterator for All Records;
                Access Executes Through the Global Variable CurrentDBF}
            Procedure ForEach (Iterator: PIterProc);
               {Seeks the First Record for Condition Described by
                Boolean Function Iterator; if Success Returns Its
                Number and Makes That Record Current,
                Otherwise Returns Zero}
            Function FirstThat (Iterator: PIterFunc): Longint;
               {Seeks the Record forward from the Current Record}
            Function NextThat (Iterator: PIterFunc): Longint;
               {Seeks the Last Fitted Record}
            Function LastThat (Iterator: PIterFunc): Longint;
               {Seeks the Record backward from the Current Record}
            Function PredThat (Iterator: PIterFunc): Longint;
               {Erases All Deleted Records from the Database}
            Procedure Pack;
               {Writes Zero into the Flag DBFError}
            Procedure ClearError;
     end;

Const CurrentDBF: PDBF = NIL;

     {
     DBFError
      0 - OK;
      1 - Cannot Open File;
      2 - Error Reading File;
      3 - Not DBF-File;
      4 - Error Writing File;
      5 - Error in Structure;
      6 - Empty Structure;
      7 - Record Out of Range;
      8 - Unknown Name;
      9 - Error Reading N/D/L Field;
     10 - Error Writing N/D/L Field;
     }

   {Returns a Possible Unique File Name in the Pointed Directory}
Procedure GetUniqueName (Path, Name: PChar);  {i,o}

   {Creates Symbolic Expression According to the Date (D.M.Y);
      if Mode=0, Expression is Like in Database - YYYYMMDD (StrLen=8);
      if Mode=1, Expression is Normal - DD.MM.YYYY (StrLen=10);
      if Mode=2, Expression is Alternative - MM/DD/YYYY (StrLen=10);
    in Case of Error Returns Array of Spaces in the Buffer P}
Procedure DateString (P: PChar; Y, M, D: Word; Mode: Byte);    {o,i,i,i,i}

   {Deciphers Symbolic Expression of Date into Variables (D.M.Y);
      if Mode=0, Expression is Like in Database - YYYYMMDD (StrLen=8);
      if Mode=1, Expression is Normal - DD.MM.YYYY (StrLen=10);
      if Mode=2, Expression is Alternative - MM/DD/YYYY (StrLen=10);
    in Case of Error Returns Y=0, M=0, D=0}
Procedure SplitDate (P: PChar; var Y, M, D: Word; Mode: Byte); {i,o,o,o,i}

   {Shows Next Calendar Date}
Procedure NextDate (var Y, M, D: Word);

   {Counts Number of Days between Two Dates with Them
      (if (Y1,M1,D1)=(Y2,M2,D2) then Returns 1)}
Function CountDays (Y1, M1, D1, Y2, M2, D2: Word): Longint;

Implementation

Constructor TField.Init;
begin
     StrCopy(FiName,NewName);
     FiType:=NewType;
     FiOfs:=0;
     FiLength:=NewLength;
     FiDecimals:=NewDecimals;
end;

Function TField.Copy;
begin
     Copy:=New(PField,Init(FiName,FiType,FiLength,FiDecimals));
end;

Constructor TDBF.Init;
begin
     FileHeader:=DefaultFileHeader;
     MemoHeader.FreePage:=0;
     Fields:=NIL;
     RecBuffer:=NIL;
     FillChar(DBFName,80,0);
     FillChar(DBTName,80,0);
     DBFError:=0;
     RecNo:=0;
end;

Destructor TDBF.Done;
begin
     if Fields<>NIL then with FileHeader do
        FreeMem(Fields,HeaderSize-33+RecordSize);
     Inherited Done;
end;

Procedure TDBF.Use;
var DirInfo: {T}SearchRec;
    Buffer: Array [0..79] of Char;
    ExtAddress: PChar;
    F: File;
    AByte: Byte;
    NumOfFields, Index: Word;
    CurrentOffset: Longint;
begin
     if Fields<>NIL then with FileHeader do
        begin
             FreeMem(Fields,HeaderSize-33+RecordSize);
             Fields:=NIL; RecBuffer:=NIL;
        end;
     RecNo:=0;
     DBFError:=0;

     StrCopy(Buffer,Path);
     if (Buffer[StrLen(Buffer)-1]<>'\') AND (StrLen(Buffer)>0)
        then StrCat(Buffer,'\');
     StrCat(Buffer,Name);
     FindFirst(Buffer,{fa_}AnyFile,DirInfo);
     if DosError<>0 then begin DBFError:=1; exit; end;

     Assign(F,Buffer);
     {$I-} Reset(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     {$I-} BlockRead(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     if Not (FileHeader.Version in [$03,$83])
        then begin DBFError:=3; Close(F); exit; end;
     with FileHeader do
          begin
               GetMem(Fields,HeaderSize-33+RecordSize);
               RecBuffer:=@(PChar(Fields)[HeaderSize-33]);
          end;

     {$I-} BlockRead(F,Fields^,FileHeader.HeaderSize-33); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     NumOfFields:=(FileHeader.HeaderSize-33) div 32;
     CurrentOffset:=1;
     for Index:=1 to NumOfFields do
         begin
              Fields^[Index].FiOfs:=CurrentOffset;
              CurrentOffset:=CurrentOffset+Longint(Fields^[Index].FiLength);
         end;
     {$I-} Seek(F,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,Fields^,FileHeader.HeaderSize-33); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;

     {$I-} Seek(F,FileHeader.HeaderSize-2); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     Close(F);
     StrCopy(DBFName,Buffer);

     if FileHeader.Version=$83 then
        begin
             ExtAddress:=StrScan(Buffer,'.');
             if ExtAddress=NIL
                then StrCat(Buffer,'.DBT')
                else StrCopy(ExtAddress,'.DBT');
             FindFirst(Buffer,{fa_}AnyFile,DirInfo);
             if DosError<>0 then begin DBFError:=1; exit; end;
             Assign(F,Buffer);
             {$I-} Reset(F,1); {$I+}
             if IOResult<>0 then begin DBFError:=1; exit; end;
             {$I-} BlockRead(F,MemoHeader,512); {$I+}
             if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
             Close(F);
             StrCopy(DBTName,Buffer);
        end;
end;

Procedure TDBF.Create;
var DirInfo: {T}SearchRec;
    Buffer: Array [0..79] of Char;
    F: File;
    AByte: Byte;
    Year, Month, Day, DayOfWeek: Word;
    CurrentOffset, RecSize, Index: Longint;
function FindMemo (P: PField): Boolean; far;
begin
     FindMemo:=(P^.FiType='M');
end;
procedure AddLength (P: PField); far;
begin
     RecSize:=RecSize+Longint(P^.FiLength);
end;
procedure StoreFieldHeader (P: PField); far;
var i: Byte;
begin
     if DBFError=0 then
        begin
             with Fields^[Index] do
                  begin
                       StrCopy(FiName,P^.FiName);
                       for i:=StrLen(FiName) to 10 do FiName[i]:=#0;
                       FiType:=P^.FiType;
                       if Not (FiType in ['C','N','D','L','M'])
                          then begin DBFError:=5; exit; end;
                       case FiType of
                            'C','N': FiLength:=P^.FiLength;
                            'D': FiLength:=8;
                            'L': FiLength:=1;
                            'M': FiLength:=10;
                       end;
                       if FiType='N'
                          then FiDecimals:=P^.FiDecimals
                          else FiDecimals:=0;
                       FiOfs:=CurrentOffset;
                       CurrentOffset:=CurrentOffset+Longint(FiLength);
                  end;
             {$I-} BlockWrite(F,Fields^[Index],32); {$I+}
             if IOResult<>0 then begin DBFError:=4; exit; end;
             Inc(Index);
        end;
end;
begin
     if Fields<>NIL then with FileHeader do
        begin
             FreeMem(Fields,HeaderSize-33+RecordSize);
             Fields:=NIL; RecBuffer:=NIL;
        end;
     RecNo:=0;
     DBFError:=0;
     StrCopy(Buffer,Path);
     if (Buffer[StrLen(Buffer)-1]<>'\') AND (StrLen(Buffer)>0)
        then StrCat(Buffer,'\');
     StrCat(Buffer,Name);
     FindFirst(Buffer,{fa_}AnyFile,DirInfo);
     if Not (DosError in [0,2,18]) then begin DBFError:=1; exit; end;
     Assign(F,Buffer);
     {$I-} Rewrite(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     FileHeader:=DefaultFileHeader;
     with FileHeader do
          begin
               if Structure^.FirstThat(@FindMemo)=NIL
                  then Version:=$03
                  else Version:=$83;
               GetDate(Year, Month, Day, DayOfWeek);
               Year:=Year mod 100;
               with DateUpdate do begin Y:=Year; M:=Month; D:=Day; end;
               NumOfRecords:=0;
               HeaderSize:=33+32*Structure^.Count;
               RecSize:=1;
               Structure^.ForEach(@AddLength);
               RecordSize:=RecSize;
          end;
     {$I-} BlockWrite(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     with FileHeader do
          begin
               GetMem(Fields,HeaderSize-33+RecordSize);
               RecBuffer:=@(PChar(Fields)[HeaderSize-33]);
          end;
     DBFError:=0;
     CurrentOffset:=1; Index:=1;
     Structure^.ForEach(@StoreFieldHeader);
     if DBFError<>0 then begin Close(F); exit; end;
     AByte:=$0D;
     {$I-} BlockWrite(F,AByte,1); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     AByte:=$1A;
     {$I-} BlockWrite(F,AByte,1); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     Close(F);
     StrCopy(DBFName,Buffer);
     if Structure^.FirstThat(@FindMemo)<>NIL then
        begin
             MemoHeader:=DefaultMemoHeader;
             Buffer[StrLen(Buffer)-1]:='T';
             Assign(F,Buffer);
             {$I-} Rewrite(F,1); {$I+}
             if IOResult<>0 then begin DBFError:=1; exit; end;
             {$I-} BlockWrite(F,MemoHeader,512); {$I+}
             if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
             Close(F);
             StrCopy(DBTName,Buffer);
        end;
end;

Function TDBF.GetStructure;
var Structure: PCollection;
    AField: PField;
    NumOfFields, Index: Word;
begin
     if DBFError<>0 then begin GetStructure:=NIL; exit; end;
     NumOfFields:=(FileHeader.HeaderSize-33) div 32;
     Structure:=New(PCollection,Init(NumOfFields,1));
     if Fields=NIL then begin GetStructure:=Structure; exit; end;
     for Index:=1 to NumOfFields do with Fields^[Index] do
         begin
              AField:=New(PField,Init(FiName,FiType,FiLength,FiDecimals));
              AField^.FiOfs:=FiOfs;
              Structure^.Insert(AField);
         end;
     GetStructure:=Structure;
end;

Procedure TDBF.AppendBlank;
var F: File;
    AByte: Byte;
    Year, Month, Day, DayOfWeek: Word;
begin
     if DBFError<>0 then exit;
     FillChar(RecBuffer[0],FileHeader.RecordSize,$20);
     Assign(F,DBFName);
     {$I-} Reset(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     with FileHeader do
     {$I-} Seek(F,Longint(HeaderSize)+RecordSize*NumOfRecords); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,RecBuffer^,FileHeader.RecordSize); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     AByte:=$1A;
     {$I-} BlockWrite(F,AByte,1); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     with FileHeader do
          begin
               GetDate(Year, Month, Day, DayOfWeek);
               Year:=Year mod 100;
               with DateUpdate do begin Y:=Year; M:=Month; D:=Day; end;
               Inc(NumOfRecords);
          end;
     {$I-} Seek(F,0); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     Close(F);
     RecNo:=FileHeader.NumOfRecords;
     DBFError:=0;
end;

Procedure TDBF.Go;
var F: File;
begin
     if DBFError<>0 then exit;
     RecNo:=0;
     if (N>FileHeader.NumOfRecords) OR (N<1)
        then begin DBFError:=7; exit; end;
     Assign(F,DBFName);
     {$I-} Reset(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     with FileHeader do
     {$I-} Seek(F,Longint(HeaderSize)+RecordSize*(N-1)); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockRead(F,RecBuffer[0],FileHeader.RecordSize); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     Close(F);
     RecNo:=N;
     DBFError:=0;
end;

Procedure TDBF.GoTop;
begin
     if DBFError<>0 then exit;
     Go(1);
end;

Procedure TDBF.GoBottom;
begin
     if DBFError<>0 then exit;
     Go(FileHeader.NumOfRecords);
end;

Procedure TDBF.Skip (N: Longint);
begin
     if DBFError<>0 then exit;
     Go(RecNo+N);
end;

Procedure TDBF.ReplaceRecord;
var F: File;
    Year, Month, Day, DayOfWeek: Word;
begin
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;
     Assign(F,DBFName);
     {$I-} Reset(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     with FileHeader do
     {$I-} Seek(F,Longint(HeaderSize)+RecordSize*(RecNo-1)); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,RecBuffer[0],FileHeader.RecordSize); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     with FileHeader do
          begin
               GetDate(Year, Month, Day, DayOfWeek);
               Year:=Year mod 100;
               with DateUpdate do begin Y:=Year; M:=Month; D:=Day; end;
          end;
     {$I-} Seek(F,0); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     Close(F);
     DBFError:=0;
end;

Procedure TDBF.Delete;
begin
     if DBFError<>0 then exit;
     RecBuffer[0]:=#$2A;
     ReplaceRecord;
end;

Procedure TDBF.Undelete;
begin
     if DBFError<>0 then exit;
     RecBuffer[0]:=#$20;
     ReplaceRecord;
end;

Function TDBF.Deleted;
begin
     if RecNo=0 then begin Deleted:=TRUE; DBFError:=7; exit; end;
     Deleted:=(RecBuffer[0]=#$2A);
end;

Function TDBF.FieldAddr (FieldName: PChar): PChar;
var NumOfFields, FieldNo, Index: Word;
begin
     if DBFError<>0 then begin FieldAddr:=NIL; exit; end;
     if RecNo=0 then begin DBFError:=7; FieldAddr:=NIL; exit; end;
     NumOfFields:=(FileHeader.HeaderSize-33) div 32;
     FieldNo:=0;
     for Index:=1 to NumOfFields do
         if StrIComp(FieldName,Fields^[Index].FiName)=0
            then FieldNo:=Index;
     if FieldNo=0 then begin DBFError:=8; FieldAddr:=NIL; exit; end;
     FieldAddr:=@RecBuffer[Fields^[FieldNo].FiOfs];
     DBFError:=0;
end;

Procedure TDBF.GetField;
var Structure: PCollection;
    Source: PChar;
    Field: PField;
    Index: Word;
function FindField (P: PField): Boolean; far;
begin
     FindField:=(StrIComp(FieldName,P^.FiName)=0);
end;
begin
     P[0]:=#0;
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;
     Source:=FieldAddr(FieldName);
     if DBFError<>0 then exit;
     Structure:=GetStructure;
     if DBFError<>0 then exit;
     if Structure^.Count=0 then
        begin Dispose(Structure,Done); DBFError:=6; exit; end;
     Field:=Structure^.FirstThat(@FindField);
     if Field=NIL then begin Dispose(Structure,Done); DBFError:=8; exit; end;
     StrLCopy(P,Source,Field^.FiLength);
     for Index:=Field^.FiLength-1 downto 0 do
         if P[Index]=#$20 then P[Index]:=#0 else break;
     if P[Field^.FiLength-1]<>#0 then P[Field^.FiLength]:=#0;
     Dispose(Structure,Done);
     DBFError:=0;
end;

Procedure TDBF.GetN;
var S: String[20];
    Code: Integer;
begin
     N:=0;
     GetField(FieldName,P);
     if DBFError<>0 then exit;
     while P[0]=#$20 do P:=@P[1];
     if P[0]=#0 then begin DBFError:=0; exit; end;
     S:=StrPas(P);
     Val(S,N,Code);
     if Code<>0 then begin DBFError:=9; exit; end;
     DBFError:=0;
end;

Procedure TDBF.GetD;
var Index: Byte;
    Empty: Boolean;
begin
     Y:=0; M:=0; D:=0;
     GetField(FieldName,P);
     if DBFError<>0 then exit;
     Empty:=TRUE;
     for Index:=0 to 7 do
         if P[Index]<>#$20 then Empty:=FALSE;
     if Empty then begin DBFError:=0; exit; end;
     for Index:=0 to 7 do
         if Not (P[Index] in ['0'..'9'])
            then begin DBFError:=9; exit; end;
     Y:=(Ord(P[0])-48)*1000+(Ord(P[1])-48)*100+
        (Ord(P[2])-48)*10+Ord(P[3])-48;
     M:=(Ord(P[4])-48)*10+Ord(P[5])-48;
     if (M<1) OR (M>12) then begin DBFError:=9; exit; end;
     D:=(Ord(P[6])-48)*10+Ord(P[7])-48;
     if D<1 then begin DBFError:=9; exit; end;
     case M of
          1,3,5,7,8,10,12: Index:=31;
          4,6,9,11: Index:=30;
          2: if (Y mod 4)=0 then Index:=29 else Index:=28;
     end;
     if D>Index then begin DBFError:=9; exit; end;
     DBFError:=0;
end;

Procedure TDBF.GetL;
begin
     GetField(FieldName,P);
     if DBFError<>0 then exit;
     DBFError:=0;
     if P[0]='T' then L:=TRUE else
        if (P[0]='F') OR (P[0]=#$20) then L:=FALSE else
           DBFError:=9;
end;

Procedure TDBF.SetField;
var Structure: PCollection;
    Dest: PChar;
    Field: PField;
    Index: Word;
function FindField (P: PField): Boolean; far;
begin
     FindField:=(StrIComp(FieldName,P^.FiName)=0);
end;
begin
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;
     Dest:=FieldAddr(FieldName);
     if DBFError<>0 then exit;
     Structure:=GetStructure;
     if DBFError<>0 then exit;
     if Structure^.Count=0 then
        begin Dispose(Structure,Done); DBFError:=6; exit; end;
     Field:=Structure^.FirstThat(@FindField);
     if Field=NIL then begin Dispose(Structure,Done); DBFError:=8; exit; end;
     Move(P[0],Dest[0],Field^.FiLength);
     for Index:=0 to Field^.FiLength do
         if Dest[Index]=#0 then break;
     for Index:=Index to Field^.FiLength-1 do
         Dest[Index]:=#$20;
     Dispose(Structure,Done);
     DBFError:=0;
end;

Procedure TDBF.SetN;
var S: String[20];
    P: Array [0..20] of Char;
    Structure: PCollection;
    Field: PField;
function FindField (P: PField): Boolean; far;
begin
     FindField:=(StrIComp(FieldName,P^.FiName)=0);
end;
begin
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;

     Structure:=GetStructure;
     if DBFError<>0 then exit;
     if Structure^.Count=0 then
        begin Dispose(Structure,Done); DBFError:=6; exit; end;
     Field:=Structure^.FirstThat(@FindField);
     if Field=NIL then begin Dispose(Structure,Done); DBFError:=8; exit; end;
     if Field^.FiType<>'N' then
        begin Dispose(Structure,Done); DBFError:=10; exit; end;
     Dispose(Structure,Done);

     Str(N:Field^.FiLength:Field^.FiDecimals,S);
     Move(S[1],P,Field^.FiLength);
     SetField(FieldName,P);
     if DBFError<>0 then exit;
     DBFError:=0;
end;

Procedure TDBF.SetD;
var P: Array [0..7] of Char;
    Index: Byte;
    Structure: PCollection;
    Field: PField;
function FindField (P: PField): Boolean; far;
begin
     FindField:=(StrIComp(FieldName,P^.FiName)=0);
end;
begin
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;

     Structure:=GetStructure;
     if DBFError<>0 then exit;
     if Structure^.Count=0 then
        begin Dispose(Structure,Done); DBFError:=6; exit; end;
     Field:=Structure^.FirstThat(@FindField);
     if Field=NIL then
        begin Dispose(Structure,Done); DBFError:=8; exit; end;
     if Field^.FiType<>'D' then
        begin Dispose(Structure,Done); DBFError:=10; exit; end;
     Dispose(Structure,Done);

     if (M<1) OR (M>12) then begin DBFError:=10; exit; end;
     if D<1 then begin DBFError:=10; exit; end;
     case M of
          1,3,5,7,8,10,12: Index:=31;
          4,6,9,11: Index:=30;
          2: if (Y mod 4)=0 then Index:=29 else Index:=28;
     end;
     if D>Index then begin DBFError:=10; exit; end;
     P[0]:=Chr (Y div 1000 + 48);
     P[1]:=Chr ((Y mod 1000) div 100 + 48);
     P[2]:=Chr ((Y mod 100) div 10 + 48);
     P[3]:=Chr (Y mod 10 + 48);
     P[4]:=Chr (M div 10 + 48);
     P[5]:=Chr (M mod 10 + 48);
     P[6]:=Chr (D div 10 + 48);
     P[7]:=Chr (D mod 10 + 48);
     SetField(FieldName,P);
     if DBFError<>0 then exit;
     DBFError:=0;
end;

Procedure TDBF.SetL;
var P: Array [0..0] of Char;
    Structure: PCollection;
    Field: PField;
function FindField (P: PField): Boolean; far;
begin
     FindField:=(StrIComp(FieldName,P^.FiName)=0);
end;
begin
     if DBFError<>0 then exit;
     if RecNo=0 then begin DBFError:=7; exit; end;

     Structure:=GetStructure;
     if DBFError<>0 then exit;
     if Structure^.Count=0 then
        begin Dispose(Structure,Done); DBFError:=6; exit; end;
     Field:=Structure^.FirstThat(@FindField);
     if Field=NIL then
        begin Dispose(Structure,Done); DBFError:=8; exit; end;
     if Field^.FiType<>'L' then
        begin Dispose(Structure,Done); DBFError:=10; exit; end;
     Dispose(Structure,Done);

     if L then P[0]:='T' else P[0]:='F';
     SetField(FieldName,P);
     if DBFError<>0 then exit;
     DBFError:=0;
end;

Procedure TDBF.ForEach;
var Index: Longint;
    OldCurrentDBF: PDBF;
    X: Word;
begin
     if DBFError<>0 then exit;
     if Iterator=NIL then exit;
     OldCurrentDBF:=CurrentDBF;
     for Index:=1 to FileHeader.NumOfRecords do
         begin
              if Index>FileHeader.NumOfRecords then Break;
              Go(Index);
              if DBFError<>0 then exit;
              CurrentDBF:=@Self;
              TIterProc(Iterator);
              asm
                 mov X,ax
                 xor ax,ax
                 push ax
                 mov ax,X
              end;
              CurrentDBF:=OldCurrentDBF;
              if DBFError<>0 then exit;
         end;
     RecNo:=0;
     if DBFError<>0 then exit;
     DBFError:=0;
end;

Function TDBF.FirstThat;
var Index: Longint;
    OldCurrentDBF: PDBF;
    X: Word;
begin
     if DBFError<>0 then begin FirstThat:=0; exit; end;
     if Iterator=NIL then begin FirstThat:=0; exit; end;
     OldCurrentDBF:=CurrentDBF;
     for Index:=1 to FileHeader.NumOfRecords do
         begin
              if Index>FileHeader.NumOfRecords then Break;
              Go(Index);
              if DBFError<>0 then begin FirstThat:=0; exit; end;
              CurrentDBF:=@Self;
              if TIterFunc(Iterator) then
                 begin
                      FirstThat:=Index; CurrentDBF:=OldCurrentDBF; exit;
                 end;
              asm
                 mov X,ax
                 xor ax,ax
                 push ax
                 mov ax,X
              end;
              CurrentDBF:=OldCurrentDBF;
              if DBFError<>0 then begin FirstThat:=0; exit; end;
         end;
     FirstThat:=0;
     RecNo:=0;
     DBFError:=0;
end;

Function TDBF.NextThat;
var Index: Longint;
    OldCurrentDBF: PDBF;
    X: Word;
begin
     if DBFError<>0 then begin NextThat:=0; exit; end;
     if Iterator=NIL then begin NextThat:=0; exit; end;
     OldCurrentDBF:=CurrentDBF;
     if RecNo=0 then Index:=1 else Index:=RecNo+1;
     for Index:=Index to FileHeader.NumOfRecords do
         begin
              if Index>FileHeader.NumOfRecords then Break;
              Go(Index);
              if DBFError<>0 then begin NextThat:=0; exit; end;
              CurrentDBF:=@Self;
              if TIterFunc(Iterator) then
                 begin
                      NextThat:=Index; CurrentDBF:=OldCurrentDBF; exit;
                 end;
              asm
                 mov X,ax
                 xor ax,ax
                 push ax
                 mov ax,X
              end;
              CurrentDBF:=OldCurrentDBF;
              if DBFError<>0 then begin NextThat:=0; exit; end;
         end;
     NextThat:=0;
     RecNo:=0;
     DBFError:=0;
end;

Function TDBF.LastThat;
var Index: Longint;
    OldCurrentDBF: PDBF;
    X: Word;
begin
     if DBFError<>0 then begin LastThat:=0; exit; end;
     if Iterator=NIL then begin LastThat:=0; exit; end;
     OldCurrentDBF:=CurrentDBF;
     for Index:=FileHeader.NumOfRecords downto 1 do
         begin
              if Index>FileHeader.NumOfRecords then Break;
              Go(Index);
              if DBFError<>0 then begin LastThat:=0; exit; end;
              CurrentDBF:=@Self;
              if TIterFunc(Iterator) then
                 begin
                      LastThat:=Index; CurrentDBF:=OldCurrentDBF; exit;
                 end;
              asm
                 mov X,ax
                 xor ax,ax
                 push ax
                 mov ax,X
              end;
              CurrentDBF:=OldCurrentDBF;
              if DBFError<>0 then begin LastThat:=0; exit; end;
         end;
     LastThat:=0;
     RecNo:=0;
     DBFError:=0;
end;

Function TDBF.PredThat;
var Index: Longint;
    OldCurrentDBF: PDBF;
    X: Word;
begin
     if DBFError<>0 then begin PredThat:=0; exit; end;
     if Iterator=NIL then begin PredThat:=0; exit; end;
     OldCurrentDBF:=CurrentDBF;
     if RecNo=0
        then Index:=FileHeader.NumOfRecords
        else Index:=RecNo-1;
     for Index:=Index downto 1 do
         begin
              if Index>FileHeader.NumOfRecords then Break;
              Go(Index);
              if DBFError<>0 then begin PredThat:=0; exit; end;
              CurrentDBF:=@Self;
              if TIterFunc(Iterator) then
                 begin
                      PredThat:=Index; CurrentDBF:=OldCurrentDBF; exit;
                 end;
              asm
                 mov X,ax
                 xor ax,ax
                 push ax
                 mov ax,X
              end;
              CurrentDBF:=OldCurrentDBF;
              if DBFError<>0 then begin PredThat:=0; exit; end;
         end;
     PredThat:=0;
     RecNo:=0;
     DBFError:=0;
end;

Procedure TDBF.Pack;
var F, OldF: File;
    AByte: Byte;
    Year, Month, Day, DayOfWeek: Word;
    Buffer: Array [0..79] of Char;
    NewRecNumber, Index: Longint;
    Ptr: PChar;
begin
     if DBFError<>0 then exit;
     GetUniqueName('',Buffer);
     Assign(F,Buffer);
     {$I-} Rewrite(F,1); {$I+}
     if IOResult<>0 then begin DBFError:=1; exit; end;
     {$I-} BlockWrite(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     {$I-} BlockWrite(F,Fields^,FileHeader.HeaderSize-33); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=1; exit; end;
     if Odd(FileHeader.HeaderSize)
        then
            begin
                 AByte:=$0D;
                 {$I-} BlockWrite(F,AByte,1); {$I+}
                 if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
            end
        else
            begin
                 AByte:=$00;
                 {$I-} BlockWrite(F,AByte,1); {$I+}
                 if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
            end;
     NewRecNumber:=0;

     for Index:=1 to FileHeader.NumOfRecords do
         begin
              Go(Index);
              if DBFError<>0 then exit;
              if Not Deleted then
              begin
                   {$I-} BlockWrite(F,RecBuffer[0],FileHeader.RecordSize); {$I+}
                   if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
                   Inc(NewRecNumber);
              end;
         end;

     AByte:=$1A;
     {$I-} BlockWrite(F,AByte,1); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     with FileHeader do
          begin
               GetDate(Year, Month, Day, DayOfWeek);
               Year:=Year mod 100;
               with DateUpdate do begin Y:=Year; M:=Month; D:=Day; end;
               NumOfRecords:=NewRecNumber;
          end;
     {$I-} Seek(F,0); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=2; exit; end;
     {$I-} BlockWrite(F,FileHeader,32); {$I+}
     if IOResult<>0 then begin Close(F); DBFError:=4; exit; end;
     Close(F);

     StrCopy(Buffer,DBFName);
     Ptr:=StrRScan(Buffer,'.');
     if Ptr=NIL then StrCat(Buffer,'.bak') else StrCopy(Ptr,'.bak');
     Assign(OldF,Buffer);
     {$I-} Rewrite(OldF); Close(OldF); Erase(OldF); {$I+}
     if IOResult<>0 then begin DBFError:=4; exit; end;
     Assign(OldF,DBFName);
     {$I-} Rename(OldF,Buffer); {$I+}
     if IOResult<>0 then begin DBFError:=4; exit; end;
     {$I-} Rename(F,DBFName); {$I+}
     if IOResult<>0 then begin DBFError:=4; exit; end;
     RecNo:=0;
     DBFError:=0;
end;

Procedure TDBF.ClearError;
begin
     DBFError:=0;
end;

Procedure GetUniqueName (Path, Name: PChar);
var DirInfo: {T}SearchRec;
    i: Byte;
    Buffer: Array [0..79] of Char;
begin
     StrCopy(Name,'unique00.$$$');
     for i:=0 to 99 do
         begin
              Name[6]:=Chr (i div 10 + 48);
              Name[7]:=Chr (i mod 10 + 48);
              StrCopy(Buffer,Path);
              if (Buffer[StrLen(Buffer)-1]<>'\') AND (StrLen(Buffer)>0)
                 then StrCat(Buffer,'\');
              StrCat(Buffer,Name);
              FindFirst(Buffer,{fa_}AnyFile,DirInfo);
              if DosError<>0 then exit;
         end;
end;

Procedure DateString (P: PChar; Y, M, D: Word; Mode: Byte);
var Index: Byte;
begin
     if Mode=1 then Index:=10 else Index:=8;
     FillChar(P[0],Index,#$20);
     P[Index]:=#0;
     if (M<1) OR (M>12) then exit;
     if D<1 then exit;
     case M of
          1,3,5,7,8,10,12: Index:=31;
          4,6,9,11: Index:=30;
          2: if (Y mod 4)=0 then Index:=29 else Index:=28;
     end;
     if D>Index then exit;
     case Mode of
          0: begin
             P[0]:=Chr (Y div 1000 + 48);
             P[1]:=Chr ((Y mod 1000) div 100 + 48);
             P[2]:=Chr ((Y mod 100) div 10 + 48);
             P[3]:=Chr (Y mod 10 + 48);
             P[4]:=Chr (M div 10 + 48);
             P[5]:=Chr (M mod 10 + 48);
             P[6]:=Chr (D div 10 + 48);
             P[7]:=Chr (D mod 10 + 48);
             end;
          1: begin
             P[0]:=Chr (D div 10 + 48);
             P[1]:=Chr (D mod 10 + 48);
             P[2]:='.';
             P[3]:=Chr (M div 10 + 48);
             P[4]:=Chr (M mod 10 + 48);
             P[5]:='.';
             P[6]:=Chr (Y div 1000 + 48);
             P[7]:=Chr ((Y mod 1000) div 100 + 48);
             P[8]:=Chr ((Y mod 100) div 10 + 48);
             P[9]:=Chr (Y mod 10 + 48);
             end;
          2: begin
             P[0]:=Chr (M div 10 + 48);
             P[1]:=Chr (M mod 10 + 48);
             P[2]:='/';
             P[3]:=Chr (D div 10 + 48);
             P[4]:=Chr (D mod 10 + 48);
             P[5]:='/';
             P[6]:=Chr (Y div 1000 + 48);
             P[7]:=Chr ((Y mod 1000) div 100 + 48);
             P[8]:=Chr ((Y mod 100) div 10 + 48);
             P[9]:=Chr (Y mod 10 + 48);
             end;
     end;
end;

Procedure SplitDate (P: PChar; var Y, M, D: Word; Mode: Byte);
var Index: Byte;
    Empty: Boolean;
begin
     Y:=0; M:=0; D:=0;
     Empty:=TRUE;
     for Index:=0 to 7+Mode*2 do
         if P[Index]<>#$20 then Empty:=FALSE;
     if Empty then exit;
     case Mode of
          0: begin
             for Index:=0 to 7 do
                 if Not (P[Index] in ['0'..'9']) then exit;
             Y:=(Ord(P[0])-48)*1000+(Ord(P[1])-48)*100+
                (Ord(P[2])-48)*10+Ord(P[3])-48;
             M:=(Ord(P[4])-48)*10+Ord(P[5])-48;
             D:=(Ord(P[6])-48)*10+Ord(P[7])-48;
             end;
          1: begin
             for Index:=0 to 9 do
                 if (Index<>2) AND (Index<>5) AND
                    (Not (P[Index] in ['0'..'9'])) then exit;
             Y:=(Ord(P[6])-48)*1000+(Ord(P[7])-48)*100+
                (Ord(P[8])-48)*10+Ord(P[9])-48;
             M:=(Ord(P[3])-48)*10+Ord(P[4])-48;
             D:=(Ord(P[0])-48)*10+Ord(P[1])-48;
             end;
          2: begin
             for Index:=0 to 9 do
                 if (Index<>2) AND (Index<>5) AND
                    (Not (P[Index] in ['0'..'9'])) then exit;
             Y:=(Ord(P[6])-48)*1000+(Ord(P[7])-48)*100+
                (Ord(P[8])-48)*10+Ord(P[9])-48;
             M:=(Ord(P[0])-48)*10+Ord(P[1])-48;
             D:=(Ord(P[3])-48)*10+Ord(P[4])-48;
             end;
     end;
     if (M<1) OR (M>12) then begin Y:=0; M:=0; D:=0; exit; end;
     if D<1 then begin Y:=0; M:=0; D:=0; exit; end;
     case M of
          1,3,5,7,8,10,12: Index:=31;
          4,6,9,11: Index:=30;
          2: if (Y mod 4)=0 then Index:=29 else Index:=28;
     end;
     if D>Index then begin Y:=0; M:=0; D:=0; exit; end;
end;

Procedure NextDate (var Y, M, D: Word);
var MaxDay: Word;
begin
     case M of
          1,3,5,7,8,10,12: MaxDay:=31;
          4,6,9,11: MaxDay:=30;
          2: if (Y mod 4)=0 then MaxDay:=29 else MaxDay:=28
          else Exit;
     end;
     if D<MaxDay
        then Inc(D)
        else begin
                  D:=1; Inc(M);
                  if M>12 then begin M:=1; Inc(Y); end;
             end;
end;

Function CountDays (Y1, M1, D1, Y2, M2, D2: Word): Longint;
var L: Longint;
    DY, DM, DD, Index: Word;
begin
     if (Y1>Y2) OR ((Y1=Y2) AND (M1>M2)) OR
        (((Y1=Y2) AND (M1=M2) AND (D1>D2))) then
        begin CountDays:=0; Exit; end;
     if (Y1=Y2) AND (M1=M2) AND (D1=D2) then
        begin CountDays:=1; Exit; end;
     if Y1=Y2
        then begin
                  L:=0;
                  DY:=Y1; DM:=M1; DD:=D1;
                  repeat
                        NextDate(DY,DM,DD); Inc(L);
                  until (DM=M2) AND (DD=D2);
                  Inc(L);
             end
        else begin
                  DY:=Y2-Y1-1;
                  L:=Longint(DY) div 4;
                  for Index:=1 to (DY mod 4) do
                      if ((Y1+Index) mod 4)=0 then Inc(L);
                  L:=L+Longint(DY)*365;
                  DY:=Y1; DM:=M1; DD:=D1;
                  repeat
                        NextDate(DY,DM,DD); Inc(L);
                  until DY<>Y1;
                  DY:=Y2-1; DM:=12; DD:=31;
                  repeat
                        NextDate(DY,DM,DD); Inc(L);
                  until (DM=M2) AND (DD=D2);
             end;
     CountDays:=L;
end;

end.
