Program TestDbf;

uses Objects, ODBFile;

var Struct: PCollection;
    DBF: PDBF;

Procedure Terminate;
var ErrorCode: Integer;
begin
     ErrorCode:=DBF^.DBFError;
     if DBF<>NIL then Dispose(DBF,Done);
     if Struct<>NIL then Dispose(Struct,Done);
     halt(ErrorCode);
end;

Procedure CreateDBF;
begin
     Struct:=New(PCollection,Init(5,5));
     Struct^.Insert(New(PField,Init('LINE','C',20,0)));
     Struct^.Insert(New(PField,Init('NUM','N',5,2)));
     Struct^.Insert(New(PField,Init('LOG','L',1,0)));
     Struct^.Insert(New(PField,Init('DATE','D',8,0)));
     DBF:=New(PDBF,Init);
     DBF^.Create('','test.dbf',Struct);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     Dispose(Struct,Done);
     Struct:=NIL;
end;

Procedure FillDBF;
begin
     {First Record Definition}
     DBF^.AppendBlank;
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetField('LINE','First line');
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetN('NUM',1.01);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetL('LOG',TRUE);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetD('DATE',1996,1,10);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.ReplaceRecord;
     {Second Record Definition}
     DBF^.AppendBlank;
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetField('LINE','Second line');
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetN('NUM',2.02);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetL('LOG',FALSE);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.SetD('DATE',1995,1,10);
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     DBF^.ReplaceRecord;
end;

Procedure UseDBF;
begin
     DBF:=New(PDBF,Init);
     DBF^.Use('','test.dbf');
end;

Procedure PrintHeader;
Procedure PrintFieldHeader (P: PField); far;
var OutputLength: Byte;
begin
     case P^.FiType of
          'L': OutputLength:=6;
          'D': OutputLength:=11;
          else OutputLength:=P^.FiLength+1;
     end;
     Write(P^.FiName:OutputLength);
end;
begin
     Writeln;
     Struct:=DBF^.GetStructure;
     if DBF^.DBFError<>0 then
        begin Writeln('Error occures!'); Terminate; end;
     Struct^.ForEach(@PrintFieldHeader);
     Dispose(Struct,Done);
end;

Procedure PrintDBF;
Procedure PrintRecord; far;
var Buffer: Array [0..20] of Char;
    N: Real;
    L: Boolean;
    Y, M, D: Word;
begin
     with CurrentDBF^ do
       begin
         GetField('LINE',Buffer);
         if DBFError<>0 then begin ClearError; Writeln; exit; end;
         Write(Buffer:21);
         GetN('NUM',Buffer,N);
         if DBFError<>0 then begin ClearError; Writeln; exit; end;
         Write(N:6:2);
         GetL('LOG',Buffer,L);
         if DBFError<>0 then begin ClearError; Writeln; exit; end;
         Write(L:6);
         GetD('DATE',Buffer,Y,M,D);
         if DBFError<>0 then begin ClearError; Writeln; exit; end;
         DateString(Buffer,Y,M,D,1);
         Write(Buffer:11);
         Writeln;
       end;
end;
begin
     Writeln;
     DBF^.ForEach(@PrintRecord);
end;

begin
     CreateDBF;
     FillDBF;
     {You may work with DB here; but, for example, you close it}
     Dispose(DBF,Done);
     DBF:=NIL;
     {Here you open already existing DB}
     UseDBF;
     PrintHeader;
     PrintDBF;
     Dispose(DBF,Done);
     {Press Enter when enough}
     Readln;
end.
