/******************************************************************************/
UNIT MemBios;

INTERFACE

CONST

	{ ShiftState constants }

	ShiftStateRight	= $01;	{ Right shift pressed }
	ShiftStateLeft	= $02;	{ Left Shift pressed }
	ShiftStateShift	= $03;	{ Any Shift pressed }
	ShiftStateCtrl	= $04;	{ Ctrl pressed }
	ShiftStateAlt	= $08;	{ Alt pressed }
	ShiftScrollLock	= $10;	{ Scroll Lock active }
	ShiftNumLock	= $20;  { Num Lock active }
	ShiftCapsLock	= $40;  { Caps Lock active }
	ShiftInsert		= $80;	{ INSert active }

	{ VideoMode constants }

	CGA620x200x2	= 6;
	Herc720x348		= 7;

	{ VideoSeg constants }

	HercVideoSeg	= $b000;
	NoHercVideoSeg	= $b800;

	{ Various interrupts }

	CtrlBrkInt		= $1B;

VAR
	ShiftState	: BYTE absolute $0000:$0417;
	VideoMode	: BYTE absolute $0000:$0449;
	BIOS_POINTS : BYTE absolute $0000:$0485;	{ if 0 then 8}
	COLS		: BYTE absolute $0040:$004A;
	ROWS		: BYTE absolute $0040:$0084;	{ if 0 then 25 else +1}

IMPLEMENTATION

END.
/******************************************************************************/
