unit user;

interface

uses comport, crt, strings;

type
     UserPtr = ^UserObj;

     UserObj = object
                  port: comportobj;
                  portnr: word;
                  baud: word;
                  curdir: string;
                  cmdstr: string;
                  typ: word;
                  watched_by: UserPtr;
                  id: pchar;

                  constructor init (t : word; arg1 : integer; arg2 : integer; idstr: string);

                  procedure cwrite (ch : char);
                  procedure swrite (str : pchar);
                  procedure swriteln (str : pchar);
                  function cread (var ch : char): boolean;
                  procedure prompt;

                  destructor done;
                end;


implementation

var
  sptr: pchar;

constructor UserObj.init (t: word; arg1 : integer; arg2 : integer; idstr : string);
begin
  typ:= t;
  cmdstr:= '';
  watched_by:= nil;
  portnr:= arg1;
  baud:= arg2;
  getmem (id, ord (idstr[0]) + 1);
  strpcopy (id, idstr);
  case typ of
  1: begin
        swrite ('system@host: welcome, ');
        swrite (id);
        swriteln (', type /? for a list of commands');
        swriteln ('system@host: now loading the shell..');
        swriteln ('');
        swrite ('Shared Shell 1.0   (c) 1995 Prinssoft Corp.  All right reserved.');
       getdir (0, curdir);
     end;
  2: begin
       if not (port.open (portnr, baud, 0, 8, 1)) then
       begin
         writeln ('loader@host: could not open COM', portnr, ':, going in single user mode..');
       end
       else
       begin
         swriteln ('');
         swriteln ('');
         swrite ('system@host: welcome, ');
         swrite (id);
         swriteln (', type /? for a list of host commands');
         swriteln ('system@host: now connecting to running shell..');
         swriteln ('');
         swrite ('Shared Shell 1.0   (c) 1995 Prinssoft Corp.  All rights reserved.');
         getdir (0, curdir);
       end;
     end;
  end;
end;

procedure UserObj.cwrite (ch : char);
begin
  case typ of
  1: write (ch);
  2: port.cwrite (ch);
  end;
end;

procedure UserObj.swrite (str : pchar);
var i : word;
begin
  case typ of
  1: write (str);
  2: port.swrite (str);
  end;
end;

procedure UserObj.swriteln (str : pchar);
var i : word;
begin
  case typ of
  1: writeln (str);
  2: begin
        port.swrite (str);
        port.cwrite (#10);
        port.cwrite (#13);
     end;
  end;
end;

function UserObj.cread (var ch : char) : boolean;
begin
  cread:= false;
  case typ of
  1: if (keypressed) then
     begin
        ch:= readkey;
        cread:= true;
     end;
  2: cread:= port.cread (ch);
  end;
end;

procedure UserObj.prompt;
begin
  swriteln ('');
  strpcopy (sptr, curdir);
  swrite (sptr);
  cwrite ('>');
end;

destructor UserObj.done;
begin
  freemem (sptr, 30);
  port.done;
end;

begin
  getmem (sptr, 30);
end.
