UNIT ArraDlg;

INTERFACE

USES Objects,Dialogs,Drivers,App,MsgBox,Views,CompWin,NewCol,FMVoice;

TYPE
  pArraChangeDlg   = ^tArraChangeDlg;
  tArraChangeDlg   = OBJECT(TDialog)
    LB             : PListBox;
    SB             : PScrollBar;
    C              : pXStringCollection;
    CONSTRUCTOR      Init;
    PROCEDURE        HandleEvent(VAR Event: TEvent);       Virtual;
    PROCEDURE        AddPattern(Num: INTEGER);
    PROCEDURE        DelPattern(Num: INTEGER);
    PROCEDURE        Update;
    DESTRUCTOR       Done;                                 Virtual;
  END;

CONST
  pcdAdd           = 21020;
  pcdDel           = 21021;
  pcdUpdateArra    = 21022;

IMPLEMENTATION

CONSTRUCTOR tArraChangeDlg.Init;
VAR
  R      : TRect;
BEGIN
  R.Assign(0,0,41,12);
  TDialog.Init(R,'Arrangement');
  Flags:=wfMove;

  R.Assign(1,9,20,11);
  Insert(NEW(PButton,Init(R,'~H~inzufgen',pcdAdd,bfNormal)));

  R.Assign(21,9,40,11);
  Insert(NEW(PButton,Init(R,'~E~ntfernen',pcdDel,bfNormal)));

  R.Assign(39,1,40,8);
  SB:=NEW(PScrollBar,Init(R));
  Insert(SB);
  R.Assign(1,1,39,8);
  LB:=NEW(PListBox,Init(R,1,SB));
  Insert(LB);

  Update;
END;

PROCEDURE tArraChangeDlg.Update;
VAR
  S1     : STRING[3];
  X      : WORD;
  S      : PString;
  P      : pPattern;
BEGIN
  C:=NEW(pXStringCollection,Init(90,20));
  C^.Duplicates:=TRUE;
  IF FMSong^.Arrangement^.Count>0 THEN
    FOR X:=0 TO FMSong^.Arrangement^.Count-1 DO
      BEGIN
        Str((X+1):3,S1);
        P:=FMSong^.Arrangement^.At(X);
        S:=NewStr(S1+' '+P^.Name);
        C^.Insert(S);
      END;
  C^.Insert(NewStr('------------------------------------'));
  LB^.NewList(C);
  ReDraw;
END;

PROCEDURE tArraChangeDlg.HandleEvent;
VAR
  P      : pPattern;
  S      : PString;
  X      : WORD;
  S1     : STRING[3];
BEGIN
  IF Event.What=evCommand THEN
    CASE Event.Command OF
        pcdAdd        : AddPattern(LB^.Focused);
        pcdDel        : DelPattern(LB^.Focused);
      END;
  IF Event.What=evBroadCast THEN
    CASE Event.Command OF
        cmpNameChanged,
        cmpPatDeleted,
        pcdUpdateArra : Update;
      END;
  INHERITED HandleEvent(Event);
END;

PROCEDURE tArraChangeDlg.AddPattern;
VAR
  P      : pPattern;
BEGIN
  P:=ChoosePattern;
  IF P<>NIL THEN
    BEGIN
      FMSong^.Arrangement^.AtInsert(Num,P);
      Update;
      LB^.FocusItem(Num);
      ReDraw;
    END;
END;

PROCEDURE tArraChangeDlg.DelPattern;
BEGIN
  IF Num<FMSong^.Arrangement^.Count THEN
    BEGIN
      FMSong^.Arrangement^.AtDelete(Num);
      Update;
      IF Num>FMSong^.Arrangement^.Count THEN
        LB^.FocusItem(FMSong^.Arrangement^.Count)
      ELSE
        LB^.FocusItem(Num);
      ReDraw;
    END;
END;

DESTRUCTOR tArraChangeDlg.Done;
BEGIN
  Dispose(C,Done);
  TDialog.Done;
END;

END.

