UNIT CompWin;

INTERFACE

USES Objects,Dialogs,Views,Drivers,Memory,App,crt,StdDlg,MsgBox,Dos,
     FMVoice;

TYPE
  pZahl           = ^tZahl;
  tZahl           = OBJECT(tView)
    nummer        : integer;
    max           : integer;
    min           : integer;
    constructor     init(var bounds: trect; a,i,n: integer);
    procedure       draw;                                   virtual;
    procedure       handleevent(var event: tevent);         virtual;
    function        getpalette: ppalette;                   virtual;
  end;

  pEffektRegler   = ^tEffektRegler;
  tEffektRegler   = OBJECT(tZahl)
    PROCEDURE       Draw;                                   VIRTUAL;
  END;

  pCompScroll     = ^tCompScroll;
  tCompScroll     = OBJECT(TScroller)
    Spur          : pTrack;
    Inst,Octave,
    Effekt,Wert   : pZahl;
    CONSTRUCTOR     Init(VAR Bounds: TRect; S: pTrack;
                    SB: PScrollBar; L,I,O,E,W: pZahl);
    PROCEDURE       Draw;                                   Virtual;
    PROCEDURE       HandleEvent(VAR Event: TEvent);         Virtual;
    FUNCTION        GetPalette: PPalette;                   Virtual;
  END;

  pCompWin        = ^tCompWin;
  tCompWin        = OBJECT(TDialog)
    Scrolls       : ARRAY[1..9] OF pCompScroll;
    L,I,O,W       : pZahl;
    E             : pEffektRegler;
    Arra          : pPattern;
    CONSTRUCTOR     Init(A: pPattern);
    PROCEDURE       HandleEvent(VAR Event: TEvent);           Virtual;
    DESTRUCTOR      Done;                                     Virtual;
  END;

PROCEDURE Note2Str(Note: tNote; VAR St1,St2,St4,St5: STRING);
PROCEDURE Str2Note(St1,St2: STRING; VAR Note: tNote);

PROCEDURE LoadPat(VAR P: pPattern);
PROCEDURE SavePat(VAR P: pPattern);

PROCEDURE InstrumentVerschieben;
PROCEDURE InstrumentAendern;
PROCEDURE InstrumentSetzen;
PROCEDURE InstrumentTransponieren;

PROCEDURE MakePattern;
PROCEDURE EditPattern(P: pPattern);
PROCEDURE RenamePattern;
PROCEDURE DeletePattern;
PROCEDURE CopyTrack;
PROCEDURE InsertTrack;
PROCEDURE TransposeTrack;
FUNCTION  ChoosePattern: pPattern;

PROCEDURE UpDateArrangement(Name,NewName: STRING; Del: BOOLEAN);

CONST
  cmpNameChanged  = 20001;
  cmpPatDeleted   = 20002;
  cmpEditPat      = 20003;
  cmpCopyTrack    = 20004;
  cmpInsTrack     = 20005;
  cmCopyPat       = 20007;
  cmInsertPat     = 20008;
  cmpCloseAllWins = 20009;
  cmpmoveinst     = 20010;
  cmpchangeinst   = 20011;
  cmpsetinst      = 20012;
  cmpTranspTrack  = 20013;
  hcEditWin       = 20014;
  cmpTranspInst   = 20015;

VAR
  TrackBuf       : ARRAY[1..64] OF tNote;
  PatBuf         : ARRAY[1..64,1..9] OF tNote;
  FillVar        : tNote;
  MoveInstBuf1,
  MoveInstBuf2   : INTEGER;
  ChangeAll      : BOOLEAN;

IMPLEMENTATION

PROCEDURE UpDateArrangement;
VAR
  X      : INTEGER;
  P      : pPattern;
BEGIN
  P:=NIL;
  IF Del THEN
    BEGIN
      FOR X:=FMSong^.Arrangement^.Count-1 DOWNTO 0 DO
        BEGIN
          P:=FMSong^.Arrangement^.At(X);
          IF P^.Name=Name THEN
            FMSong^.Arrangement^.AtDelete(X);
        END;
    END;
END;

PROCEDURE CopyTrack;
VAR
  Z      : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
BEGIN
  R.Assign(0,0,24,6);
  D:=NEW(PDialog,Init(R,'Spur kopieren'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(8,1,22,2);
      Z:=NEW(PZahl,Init(R,9,1,1));
      Z^.Options:=Z^.Options XOR OfFramed;
      Insert(Z);

      R.Assign(1,1,7,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z)));

      R.Assign(1,3,12,5);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(12,3,23,5);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      E.What:=evBroadCast;
      E.Command:=cmpCopyTrack;
      E.InfoByte:=Z^.Nummer;
      Application^.PutEvent(E);
    END;
  Dispose(D,Done);
END;

PROCEDURE TransposeTrack;
VAR
  Z1,Z2  : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
  N      : tNote;
  P      : pPattern;
  X,Y    : INTEGER;
BEGIN
  R.Assign(0,0,34,7);
  D:=NEW(PDialog,Init(R,'Spur transponieren'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(18,1,32,2);
      Z1:=NEW(PZahl,Init(R,9,1,1));
      Z1^.Options:=Z1^.Options XOR OfFramed;
      Insert(Z1);
      R.Assign(1,1,17,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z1)));

      R.Assign(18,2,32,3);
      Z2:=NEW(PZahl,Init(R,40,-40,0));
      Z2^.Options:=Z2^.Options XOR OfFramed;
      Insert(Z2);
      R.Assign(1,2,17,3);
      Insert(NEW(PLabel,Init(R,'~H~albtne:',Z2)));

      R.Assign(1,4,17,6);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(17,4,33,6);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      IF NOT ChangeAll THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpTranspTrack;
          E.InfoByte:=Z1^.Nummer;
          MoveInstBuf1:=Z2^.Nummer;
          Application^.PutEvent(E);
        END
      ELSE
        BEGIN
          FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
            BEGIN
              P:=FMSong^.Patterns^.At(X);
              FOR Y:=1 TO 64 DO
                BEGIN
                  N:=P^.Spuren[Z1^.Nummer]^.Noten[Y];
                  IF NOT (N.Wert IN [NNoNote,NSetSpeed,NPatBreak]) THEN
                    BEGIN
                      N.Wert:=N.Wert+Z2^.Nummer;
                      IF N.Wert>127 THEN
                        N.Wert:=127;
                      IF N.Wert<0 THEN
                        N.Wert:=0;
                      P^.Spuren[Z1^.nummer]^.Noten[Y]:=N;
                    END;
                END;
            END;
          DoneMemory;
          Application^.ReDraw;
        END;
    END;
  Dispose(D,Done);
END;

PROCEDURE InsertTrack;
VAR
  Z      : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
BEGIN
  R.Assign(0,0,24,6);
  D:=NEW(PDialog,Init(R,'Spur einfgen'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(8,1,22,2);
      Z:=NEW(PZahl,Init(R,9,1,1));
      Z^.Options:=Z^.Options XOR OfFramed;
      Insert(Z);

      R.Assign(1,1,7,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z)));

      R.Assign(1,3,12,5);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfDefault)));

      R.Assign(12,3,23,5);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      E.What:=evBroadCast;
      E.Command:=cmpInsTrack;
      E.InfoByte:=Z^.Nummer;
      Application^.PutEvent(E);
    END;
  Dispose(D,Done);
END;

PROCEDURE MakePattern;
VAR
  S      : STRING[30];
  P      : pPattern;
  W      : WORD;
  X      : INTEGER;
  Ok     : BOOLEAN;
BEGIN
  S:='';
  REPEAT
    Ok:=TRUE;
    W:=InputBox('Neuer Abschnitt','Name:',S,30);
    IF S='' THEN S:=' ';
    FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
      BEGIN
        P:=FMSong^.Patterns^.At(X);
        IF P^.Name=S THEN
          Ok:=FALSE;
      END;
    IF (Ok=FALSE) AND (W<>cmCancel) THEN
      MessageBox('Dieser Name ist schon vergeben !',NIL,mfError+mfOkButton);
  UNTIL Ok OR (W=cmCancel);
  IF W<>cmCancel THEN
    BEGIN
      IF NOT LowMemory THEN
        BEGIN
          P:=NEW(pPattern,Init);
          P^.Name:=S;
          FMSong^.Patterns^.Insert(P);
          EditPattern(P);
        END
      ELSE
        BEGIN
          Application^.OutOfMemory;
          Exit;
        END;
    END;
END;

PROCEDURE EditPattern;
VAR
  W      : pCompWin;
  E      : TEvent;
BEGIN
  IF P=NIL THEN
    P:=ChoosePattern;
  IF P=NIL THEN
    Exit;
  IF P^.Bearbeitung=FALSE THEN
    BEGIN
      W:=NEW(pCompWin,Init(P));
      IF Application^.ValidView(W)<>NIL THEN
        DeskTop^.Insert(W);
    END
  ELSE
    BEGIN
      E.What:=evBroadCast;
      E.Command:=cmpEditPat;
      E.InfoPtr:=P;
      Application^.PutEvent(E);
    END;
END;

PROCEDURE RenamePattern;
VAR
  P,P1   : pPattern;
  S      : STRING[30];
  W      : WORD;
  X      : INTEGER;
  Ok     : BOOLEAN;
  E      : TEvent;
  OldName: STRING[30];
BEGIN
  P:=ChoosePattern;
	IF P<>NIL THEN
    BEGIN
      S:=P^.Name;
      REPEAT
        Ok:=TRUE;
        W:=InputBox('Abschnitt umbenennen','Name:',S,30);
        FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
          BEGIN
            P1:=FMSong^.Patterns^.At(X);
            IF P1^.Name=S THEN
              Ok:=FALSE;
          END;
        IF (Ok=FALSE) AND (W<>cmCancel) THEN
          MessageBox('Dieser Name ist schon vergeben !',NIL,
          mfError+mfOkButton);
      UNTIL Ok OR (W=cmCancel);
      IF W<>cmCancel THEN
        BEGIN
{          OldName:=P^.Name;}
          P^.Name:=S;
          E.InfoPtr:=P;
          E.What:=evBroadCast;
          E.Command:=cmpNameChanged;
          Application^.PutEvent(E);
        END;
    END;
END;

PROCEDURE DeletePattern;
VAR
  W      : WORD;
  P      : pPattern;
  S      : STRING[30];
  E      : TEvent;
BEGIN
  P:=ChoosePattern;
  IF P<>NIL THEN
    BEGIN
      S:=P^.Name;
      sound(880);
      delay(30);
      sound(440);
      delay(30);
      Nosound;
      W:=MessageBox('Abschnitt '+S+' wirklich lschen ?',NIL,
      mfConfirmation+mfYesButton+mfNoButton+mfCancelButton);
      IF W=cmYes THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpPatDeleted;
          E.InfoPtr:=P;
          Application^.PutEvent(E);
          UpDateArrangement(S,'',TRUE);
          FMSong^.Patterns^.Free(P);
        END;
    END;
END;

FUNCTION ChoosePattern: pPattern;
VAR
  LB     : PListBox;
  C      : pStringCollection;
  SB     : PScrollBar;
  D      : PDialog;
  R      : TRect;
  X,Y    : INTEGER;
  P      : pPattern;
  S      : PString;
BEGIN
  IF FMSong^.Patterns^.Count=0 THEN
    BEGIN
      ChoosePattern:=NIL;
      Exit;
    END;
  R.Assign(0,0,40,12);
  D:=NEW(PDialog,Init(R,'Abschnitt whlen'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;
      Flags:=wfMove;

      R.Assign(1,9,39,11);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfDefault)));

      R.Assign(37,1,38,8);
      SB:=NEW(PScrollBar,Init(R));
      Insert(SB);

      R.Assign(2,1,37,8);
      LB:=NEW(PListBox,Init(R,1,SB));
      Insert(LB);

      C:=NEW(PStringCollection,Init(100,20));
      FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
        BEGIN
          P:=FMSong^.Patterns^.At(X);
          C^.Insert(NewStr(P^.Name));
        END;
      LB^.NewList(C);
    END;
  DeskTop^.ExecView(D);
  S:=C^.At(LB^.Focused);
  FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
    BEGIN
      P:=FMSong^.Patterns^.At(X);
      IF P^.Name=S^ THEN
        Y:=X;
    END;
  Dispose(C,Done);
  Dispose(D,Done);
  ChoosePattern:=FMSong^.Patterns^.At(Y);
END;

PROCEDURE SavePat;
VAR
  Data     : tPatType;
  F        : FILE OF tPatType;
  dateiname: string;
  d        : pFiledialog;
  exists   : boolean;
  w,X      : word;
  s1,s2,s3 : string;

  PROCEDURE MakeBAK(d: STRING);
  VAR
    dat   : FILE;
    dat1  : FILE;
    a,b,c : STRING;
    w     : word;
  BEGIN
    {$I-}
    FSplit(d,a,b,c);
    Assign(dat,a+b+'.BAK');
    Erase(dat);
    Assign(dat1,d);
    Rename(dat1,a+b+'.BAK');

    w:=ioresult;
    {$I+}
  END;

begin
  FOR W:=1 TO 9 DO
    FOR X:=1 TO 64 DO
      Data.Noten[W,X]:=P^.Spuren[W]^.Noten[X];

  Data.Name:=P^.Name;

  d:=new(pfiledialog,init('*.MMA','Speichern','Dateiname:',
         fdokbutton,201));
  {$I-}
  if desktop^.execview(d) <> cmcancel then
    begin
      d^.getfilename(dateiname);

      w:=cmyes;
      exists:=FALSE;
      FSplit(dateiname,s1,s2,s3);
      dateiname:=s1+s2+'.MMA';

      IF FSearch(s2+s3,s1)<>'' THEN
        BEGIN
          exists:=TRUE;
          sound(880);
          delay(30);
          sound(440);
          delay(30);
          Nosound;
          w:=MessageBox(^c+'Die Datei '+dateiname+' existiert bereits.'#13+
          ^c+'berschreiben ?',NIL,
          mfwarning+mfyesbutton+mfnobutton);
        END;
      IF w=cmyes THEN
        BEGIN
          IF exists THEN
            MakeBAK(dateiname);
          assign(f,dateiname);
          rewrite(f);
          write(f,data);
          system.close(f);
          IF IOResult<>0 THEN
            BEGIN
              sound(880);
              delay(30);
              sound(440);
              delay(30);
              Nosound;
              MessageBox(^c+'Fehler beim schreiben der Datei!',NIL,
              mfError+mfOkButton);
            END;
          {$I+}
        END
      ELSE
        BEGIN
          dispose(d,done);
          Exit;
        END;
    end;
  dispose(d,done);
end;

PROCEDURE LoadPat;
VAR
  Data     : tPatType;
  F        : FILE OF tPatType;
  dateiname: string;
  d        : pFiledialog;
  w,X      : word;

begin
  d:=new(pfiledialog,init('*.MMA','Laden','Dateiname:',
         fdokbutton,201));
  if desktop^.execview(d) <> cmcancel then
    begin
      d^.getfilename(dateiname);

      {$I-}
      assign(f,dateiname);
      reset(f);
      read(f,data);
      system.close(f);
      IF IOResult<>0 THEN
        BEGIN
          sound(880);
          delay(30);
          sound(440);
          delay(30);
          Nosound;
          MessageBox(^c+'Fehler beim lesen der Datei!',NIL,
          mfError+mfOkButton);
          Dispose(P,Done);
          P:=NIL;
        END
      ELSE
        BEGIN
          FOR W:=1 TO 9 DO
            FOR X:=1 TO 64 DO
              P^.Spuren[W]^.Noten[X]:=Data.Noten[W,X];
          P^.Name:=Data.Name;
        END;
      {$I+}
    END
  ELSE
    BEGIN
      Dispose(P,Done);
      P:=NIL;
    END;
  dispose(d,done);
end;

PROCEDURE InstrumentVerschieben;
VAR
  Z1,Z2,
  Z3     : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
  X,Y    : INTEGER;
  P      : pPattern;
  N,N0   : tNote;
BEGIN
  R.Assign(0,0,28,8);
  D:=NEW(PDialog,Init(R,'Instrument verschieben'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(12,1,26,2);
      Z1:=NEW(PZahl,Init(R,9,1,1));
      Z1^.Options:=Z1^.Options XOR OfFramed;
      Insert(Z1);
      R.Assign(1,1,12,2);
      Insert(NEW(PLabel,Init(R,'~v~on Spur:',Z1)));

      R.Assign(12,2,26,3);
      Z2:=NEW(PZahl,Init(R,50,1,1));
      Z2^.Options:=Z2^.Options XOR OfFramed;
      Insert(Z2);
      R.Assign(1,2,12,3);
      Insert(NEW(PLabel,Init(R,'~I~nstr.:',Z2)));


      R.Assign(12,3,26,4);
      Z3:=NEW(PZahl,Init(R,9,1,1));
      Z3^.Options:=Z3^.Options XOR OfFramed;
      Insert(Z3);
      R.Assign(1,3,12,4);
      Insert(NEW(PLabel,Init(R,'~n~ach Spur:',Z3)));

      R.Assign(1,5,14,7);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(14,5,27,7);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      IF NOT ChangeAll THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpMoveInst;
          E.InfoByte:=Z1^.Nummer;
          MoveInstBuf1:=Z2^.Nummer;
          MoveInstBuf2:=Z3^.Nummer;
          Application^.PutEvent(E);
        END
      ELSE
        BEGIN
          N0.Instrument:=1;
          N0.Wert:=255;
          FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
            BEGIN
              P:=FMSong^.Patterns^.At(X);
              FOR Y:=1 TO 64 DO
                BEGIN
                  N:=P^.Spuren[Z1^.Nummer]^.Noten[Y];
                  IF N.Instrument=Z2^.Nummer THEN
                    BEGIN
                      P^.Spuren[Z3^.Nummer]^.Noten[Y]:=N;
                      P^.Spuren[Z1^.Nummer]^.Noten[Y]:=N0;
                    END;
                END;
            END;
          DoneMemory;
          Application^.ReDraw;
        END;
    END;
  Dispose(D,Done);
END;

PROCEDURE InstrumentAendern;
VAR
  Z1,Z2,
  Z3     : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
  X,Y    : INTEGER;
  P      : pPattern;
  N      : tNote;
BEGIN
  R.Assign(0,0,28,8);
  D:=NEW(PDialog,Init(R,'Instrument ndern'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(12,1,26,2);
      Z1:=NEW(PZahl,Init(R,9,1,1));
      Z1^.Options:=Z1^.Options XOR OfFramed;
      Insert(Z1);
      R.Assign(1,1,12,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z1)));

      R.Assign(12,2,26,3);
      Z2:=NEW(PZahl,Init(R,50,1,1));
      Z2^.Options:=Z2^.Options XOR OfFramed;
      Insert(Z2);
      R.Assign(1,2,12,3);
      Insert(NEW(PLabel,Init(R,'~I~nstr.:',Z2)));


      R.Assign(12,3,26,4);
      Z3:=NEW(PZahl,Init(R,50,1,1));
      Z3^.Options:=Z3^.Options XOR OfFramed;
      Insert(Z3);
      R.Assign(1,3,12,4);
      Insert(NEW(PLabel,Init(R,'-> I~n~str.:',Z3)));

      R.Assign(1,5,14,7);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(14,5,27,7);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      IF NOT ChangeAll THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpChangeInst;
          E.InfoByte:=Z1^.Nummer;
          MoveInstBuf1:=Z2^.Nummer;
          MoveInstBuf2:=Z3^.Nummer;
          Application^.PutEvent(E);
        END
      ELSE
        BEGIN
          FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
            BEGIN
              P:=FMSong^.Patterns^.At(X);
              FOR Y:=1 TO 64 DO
                BEGIN
                  N:=P^.Spuren[Z1^.Nummer]^.Noten[Y];
                  IF N.Instrument=Z2^.Nummer THEN
                    N.Instrument:=Z3^.Nummer;
                  P^.Spuren[Z1^.Nummer]^.Noten[Y]:=N;
                END;
            END;
          DoneMemory;
          Application^.ReDraw;
        END;
    END;
  Dispose(D,Done);
END;

PROCEDURE InstrumentSetzen;
VAR
  Z1,Z2  : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
  N      : tNote;
  P      : pPattern;
  X,Y    : INTEGER;
BEGIN
  R.Assign(0,0,28,7);
  D:=NEW(PDialog,Init(R,'Instrument setzen'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(12,1,26,2);
      Z1:=NEW(PZahl,Init(R,9,1,1));
      Z1^.Options:=Z1^.Options XOR OfFramed;
      Insert(Z1);
      R.Assign(1,1,12,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z1)));

      R.Assign(12,2,26,3);
      Z2:=NEW(PZahl,Init(R,50,1,1));
      Z2^.Options:=Z2^.Options XOR OfFramed;
      Insert(Z2);
      R.Assign(1,2,12,3);
      Insert(NEW(PLabel,Init(R,'~I~nstr.:',Z2)));

      R.Assign(1,4,14,6);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(14,4,27,6);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      IF NOT ChangeAll THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpSetInst;
          E.InfoByte:=Z1^.Nummer;
          MoveInstBuf1:=Z2^.Nummer;
          Application^.PutEvent(E);
        END
      ELSE
        BEGIN
          FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
            BEGIN
              P:=FMSong^.Patterns^.At(X);
              FOR Y:=1 TO 64 DO
                BEGIN
                  N:=P^.Spuren[Z1^.Nummer]^.Noten[Y];
                  N.Instrument:=Z2^.Nummer;
                  P^.Spuren[Z1^.Nummer]^.Noten[Y]:=N;
                END;
            END;
          DoneMemory;
          Application^.ReDraw;
        END;
    END;
  Dispose(D,Done);
END;

PROCEDURE InstrumentTransponieren;
VAR
  Z1,Z2,
  Z3     : pZahl;
  D      : PDialog;
  R      : TRect;
  E      : TEvent;
  N      : tNote;
  P      : pPattern;
  X,Y    : INTEGER;
BEGIN
  R.Assign(0,0,34,8);
  D:=NEW(PDialog,Init(R,'Instrument transponieren'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;

      R.Assign(18,1,32,2);
      Z1:=NEW(PZahl,Init(R,9,1,1));
      Z1^.Options:=Z1^.Options XOR OfFramed;
      Insert(Z1);
      R.Assign(1,1,17,2);
      Insert(NEW(PLabel,Init(R,'~S~pur:',Z1)));

      R.Assign(18,2,32,3);
      Z3:=NEW(PZahl,Init(R,50,1,1));
      Z3^.Options:=Z3^.Options XOR OfFramed;
      Insert(Z3);
      R.Assign(1,2,17,3);
      Insert(NEW(PLabel,Init(R,'~I~nstrument:',Z3)));

      R.Assign(18,3,32,4);
      Z2:=NEW(PZahl,Init(R,40,-40,0));
      Z2^.Options:=Z2^.Options XOR OfFramed;
      Insert(Z2);
      R.Assign(1,3,17,4);
      Insert(NEW(PLabel,Init(R,'~H~albtne:',Z2)));

      R.Assign(1,5,17,7);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfdefault)));

      R.Assign(17,5,33,7);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));
    END;
  IF Desktop^.Execview(D)<>cmCancel THEN
    BEGIN
      IF NOT ChangeAll THEN
        BEGIN
          E.What:=evBroadCast;
          E.Command:=cmpTranspInst;
          E.InfoByte:=Z1^.Nummer;
          MoveInstBuf1:=Z2^.Nummer;
          MoveInstBuf2:=Z3^.Nummer;
          Application^.PutEvent(E);
        END
      ELSE
        BEGIN
          FOR X:=0 TO FMSong^.Patterns^.Count-1 DO
            BEGIN
              P:=FMSong^.Patterns^.At(X);
              FOR Y:=1 TO 64 DO
                BEGIN
                  N:=P^.Spuren[Z1^.Nummer]^.Noten[Y];
                  IF NOT (N.Wert IN [NNoNote,NSetSpeed,NPatBreak]) THEN
                    IF N.Instrument=Z3^.Nummer THEN
                      BEGIN
                        N.Wert:=N.Wert+Z2^.Nummer;
                        IF N.Wert>127 THEN
                          N.Wert:=127;
                        IF N.Wert<0 THEN
                          N.Wert:=0;
                        P^.Spuren[Z1^.nummer]^.Noten[Y]:=N;
                      END;
                END;
            END;
          DoneMemory;
          Application^.ReDraw;
        END;
    END;
  Dispose(D,Done);
END;

PROCEDURE Note2Str;
VAR
  S0,S1,
  S2,
  S4,S5   : STRING[3];
BEGIN
  St1:='';
  St2:='';
  St4:='';
  St5:='';

  Str((Note.Wert DIV 12)+1,S1);
  Str(Note.Instrument:2,S2);
  CASE Note.Wert OF
      NNoNote   : BEGIN
                    S0:='--';
                    S1:='-';
                  END;
      NNoteOff  : BEGIN
                    S0:='OFF';
                    S1:='';
                  END;
      ELSE
        S0:=NoteNames[Note.Wert MOD 12];
    END;

  S4:=EffShort[Note.Effekt];
  Str(Note.EWert:2,S5);

  St1:=S0+'-'+S1;
  St2:=S2;
  St4:=S4;
  St5:=S5;
END;

PROCEDURE UpStr(VAR St: STRING);
VAR
  C  : BYTE;
  S  : STRING;
BEGIN
  FOR C:=1 TO Length(St) DO
    St[C]:=UpCase(St[C]);
END;

PROCEDURE Str2Note;
VAR
  X,Z   : BYTE;
  H,Y   : INTEGER;
  S1    : STRING;
BEGIN
  S1:=Copy(St1,Pos('-',St1)-2,2);
  UpStr(S1);
  Z:=255;
  IF S1='C ' THEN Z:=0;
  IF S1='D ' THEN Z:=2;
  IF S1='E ' THEN Z:=4;
  IF S1='F ' THEN Z:=5;
  IF S1='G ' THEN Z:=7;
  IF S1='A ' THEN Z:=9;
  IF S1='H ' THEN Z:=11;
  IF S1='C_' THEN Z:=0;
  IF S1='D_' THEN Z:=2;
  IF S1='E_' THEN Z:=4;
  IF S1='F_' THEN Z:=5;
  IF S1='G_' THEN Z:=7;
  IF S1='A_' THEN Z:=9;
  IF S1='H_' THEN Z:=11;
  IF S1='C-' THEN Z:=0;
  IF S1='D-' THEN Z:=2;
  IF S1='E-' THEN Z:=4;
  IF S1='F-' THEN Z:=5;
  IF S1='G-' THEN Z:=7;
  IF S1='A-' THEN Z:=9;
  IF S1='H-' THEN Z:=11;
  IF S1='C+' THEN Z:=1;
  IF S1='D+' THEN Z:=3;
  IF S1='E+' THEN Z:=5;
  IF S1='F+' THEN Z:=6;
  IF S1='G+' THEN Z:=8;
  IF S1='A+' THEN Z:=10;
  IF S1='H+' THEN Z:=12;
  IF S1='C#' THEN Z:=1;
  IF S1='D#' THEN Z:=3;
  IF S1='E#' THEN Z:=5;
  IF S1='F#' THEN Z:=6;
  IF S1='G#' THEN Z:=8;
  IF S1='A#' THEN Z:=10;
  IF S1='H#' THEN Z:=12;

  S1:=Copy(St1,Pos('-',St1)+1,2);
  Y:=1;
  VAL(S1,Y,H);

  IF H=0 THEN
    X:=((Y-1)*12)+Z
  ELSE
    X:=255;
  IF (Y>11) OR (Y<1) THEN
    X:=255;
  IF X>127 THEN X:=255;

  Note.Wert:=X;

  VAL(St2,Y,H);
  IF H=0 THEN
    Note.Instrument:=Y
  ELSE
    Note.Instrument:=1;
END;

{---------- tCompScroll -------------}

CONSTRUCTOR tCompScroll.Init;
BEGIN
  TScroller.Init(Bounds,NIL,SB);
  Spur:=S;
  Octave:=O;
  Inst:=I;
  Wert:=W;
  Effekt:=E;
  Options:=Options OR ofFramed;
  SetLimit(0,68);
  EventMask:=evMessage+evKeyboard+evMouse;
END;

PROCEDURE tCompScroll.Draw;
VAR
  S,S1,
  S2,S3,
  S4    : STRING;
  X,Y1,
  Y2    : INTEGER;
  F     : BYTE;
  E     : TEvent;
BEGIN
  Y1:=Delta.Y-2;
  Y2:=Delta.Y+2;
  for X:=Y1 to Y2 do
    begin
      IF (X<64) AND (X>-1) THEN
        BEGIN
          Note2Str(Spur^.Noten[X+1],S,S1,S3,S4);
          S:=S1+' '+S+' '+' '+S3+' '+S4+'      ';
        END
      ELSE
        S:='                     ';
      F:=1;
      IF X=Delta.Y THEN
        BEGIN
          Str(X+1:2,S1);
          F:=2;
          S1:=#17+S1+'   ';
          Insert(S1,S,16);
        END;
      WriteStr(0,X-Delta.Y+2,S,F);
    END;
END;

FUNCTION tCompScroll.GetPalette;
CONST
  P  : STRING[2]= #26#27;
BEGIN
  GetPalette:=@P;
END;

PROCEDURE tCompScroll.HandleEvent;
VAR
  N      : tNote;
BEGIN
  TScroller.HandleEvent(Event);
  IF Event.What=evKeyDown THEN
    BEGIN
      IF Event.CharCode='e' THEN
        BEGIN
          Spur^.Noten[Delta.Y+1].Effekt:=Effekt^.Nummer;
          Spur^.Noten[Delta.Y+1].EWert:=Wert^.Nummer;
          Draw;
        END;
      IF Event.CharCode IN ['y','s','x','d','c','v','g','b',
      'h','n','j','m',','] THEN
        BEGIN
          N.Wert:=(Octave^.Nummer-1)*12;
          N.Instrument:=Inst^.Nummer;
          N.Effekt:=Effekt^.Nummer;
          N.EWert:=Wert^.Nummer;
          CASE Event.CharCode OF
              's' : INC(N.Wert,1);
              'x' : INC(N.Wert,2);
              'd' : INC(N.Wert,3);
              'c' : INC(N.Wert,4);
              'v' : INC(N.Wert,5);
              'g' : INC(N.Wert,6);
              'b' : INC(N.Wert,7);
              'h' : INC(N.Wert,8);
              'n' : INC(N.Wert,9);
              'j' : INC(N.Wert,10);
              'm' : INC(N.Wert,11);
              ',' : BEGIN
                      N.Wert:=NNoteOff;
                      N.Instrument:=0;
                      N.Effekt:=0;
                      N.EWert:=0;
                    END;
            END;
          IF (FMSong^.Instruments[N.Instrument]<>NIL) THEN
            BEGIN
              FMSetInstrument(1,N.Instrument);
              FMNoteOn(1,N.Wert,InstSetting.Op2[1]);
            END;
          Spur^.Noten[Delta.Y+1]:=N;
          Draw;
          Delay(30);
          FMNoteOff(1);
        END;
      IF Event.CharCode IN ['1','2','3','4','5','6','7','8'] THEN
        BEGIN
          Octave^.Nummer:=Ord(Event.CharCode)-48;
          Octave^.Draw;
        END;
      IF Event.KeyCode=kbDel THEN
        BEGIN
          N.Wert:=NNoNote;
          N.Instrument:=0;
          N.Effekt:=0;
          N.EWert:=0;
          Spur^.Noten[Delta.Y+1]:=N;
          Draw;
        END;
    END;
END;

{------------ tCompWin ------------}

CONSTRUCTOR tCompWin.Init;
VAR
  R   : TRect;
  SB  : pScrollBar;
  X,Y : INTEGER;
  St  : STRING;
BEGIN
  R.Assign(0,0,80,23);
  TDialog.Init(R,A^.Name);
  Options:=Options OR OfCentered OR OfPostProcess;
  SetState(sfFocused+sfSelected,TRUE);
  HelpCtx:=hcEditWin;

  Palette:=dpBlueDialog;

  SB:=StandardScrollBar(sbVertical+sbHandleKeyboard);
  Arra:=A;
  Arra^.Bearbeitung:=TRUE;

  R.Assign(2,2,16,3);
  I:=NEW(PZahl,Init(R,30,1,1));
  Insert(I);
  R.Assign(2,1,14,2);
  Insert(NEW(PLabel,Init(R,'~I~nstrument ',I)));

  R.Assign(2,5,16,6);
  O:=NEW(PZahl,Init(R,8,1,5));
  Insert(O);
  R.Assign(2,4,10,5);
  Insert(NEW(PLabel,Init(R,'O~k~tave ',O)));

  R.Assign(2,9,16,10);
  E:=NEW(PEffektRegler,Init(R,14,0,0));
  Insert(E);
  R.Assign(2,8,10,9);
  Insert(NEW(PLabel,Init(R,'Effek~t~ ',E)));

  R.Assign(2,12,16,13);
  W:=NEW(PZahl,Init(R,63,0,0));
  Insert(W);
  R.Assign(2,11,15,12);
  Insert(NEW(PLabel,Init(R,'Eff-O~p~erand ',W)));

  FOR Y:=1 TO 3 DO
    FOR X:=1 TO 3 DO
      BEGIN
        R.Assign(X*21-3,Y*7-5,X*21+15,Y*7);
        Scrolls[Y*3-3+X]:=NEW(pCompScroll,
        Init(R,Arra^.Spuren[Y*3-3+X],SB,L,I,O,E,W));
        Insert(Scrolls[Y*3-3+X]);

        R.Assign(X*21-1,Y*7-6,X*21+7,Y*7-5);
        Str(Y*3-3+X,St);
        St:='Spur '+St;
        Insert(NEW(PLabel,Init(R,St,Scrolls[Y*3-3+X])));
      END;

  Scrolls[1]^.Select;
END;

PROCEDURE tCompWin.HandleEvent;
VAR
  X,Y    : INTEGER;
  N,N0   : tNote;
BEGIN
  IF Event.What=evBroadCast THEN
    BEGIN
      CASE Event.Command OF
          cmpNameChanged: BEGIN
                            DisposeStr(Title);
                            Title:=NewStr(Arra^.Name);
                            ReDraw;
                          END;
          cmpPatDeleted : BEGIN
                            IF Event.InfoPtr=Arra THEN
                              Close;
                          END;
          cmpEditPat    : BEGIN
                            IF Event.InfoPtr=Arra THEN
                              Select;
                          END;
          cmCopyPat     : BEGIN
                            IF GetState(sfActive) THEN
                              BEGIN
                                FOR X:=1 to 64 DO
                                  FOR Y:=1 TO 9 DO
                                    PatBuf[X,Y]:=Arra^.Spuren[Y]^.Noten[X];
                                ClearEvent(Event);
                              END;
                          END;
          cmInsertPat   : BEGIN
                            IF GetState(sfActive) THEN
                              BEGIN
                                FOR X:=1 TO 64 DO
                                  FOR Y:=1 TO 9 DO
                                    Arra^.Spuren[Y]^.Noten[X]:=PatBuf[X,Y];
                                ClearEvent(Event);
                              END;
                            ReDraw;
                          END;
          cmpCopyTrack  : BEGIN
                            IF GetState(sfActive) THEN
                              BEGIN
                                FOR X:=1 TO 64 DO
                                  TrackBuf[X]:=
                                   Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                ClearEvent(Event);
                              END;
                          END;
          cmpInsTrack   : BEGIN
                            IF GetState(sfActive) THEN
                              BEGIN
                                FOR X:=1 TO 64 DO
                                  Arra^.Spuren[Event.InfoByte]^.Noten[X]:=
                                   TrackBuf[X];
                                ClearEvent(Event);
                              END;
                            ReDraw;
                          END;
          cmpCloseAllWins: BEGIN
                            Close;
                            Exit;
                          END;
          cmpMoveInst   : BEGIN
                            N0.Instrument:=1;
                            N0.Wert:=255;
                            IF GetState(sfActive) THEN
                             BEGIN
                              FOR X:=1 TO 64 DO
                               BEGIN
                                N:=Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                IF N.Instrument=MoveInstBuf1 THEN
                                 BEGIN
                                  Arra^.Spuren[MoveInstBuf2]^.Noten[X]:=N;
                                  Arra^.Spuren[Event.InfoByte]^.Noten[X]:=N0;
                                 END;
                               END;
                              ClearEvent(Event);
                             END;
                            ReDraw;
                          END;
          cmpChangeInst : BEGIN
                            IF GetState(sfActive) THEN
                             BEGIN
                              FOR X:=1 TO 64 DO
                               BEGIN
                                N:=Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                IF N.Instrument=MoveInstBuf1 THEN
                                 BEGIN
                                  N.Instrument:=MoveInstBuf2;
                                  Arra^.Spuren[Event.InfoByte]^.Noten[X]:=N;
                                 END;
                               END;
                              ClearEvent(Event);
                             END;
                            ReDraw;
                          END;
          cmpSetInst    : BEGIN
                            IF GetState(sfActive) THEN
                             BEGIN
                              FOR X:=1 TO 64 DO
                               BEGIN
                                N:=Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                N.Instrument:=MoveInstBuf1;
                                Arra^.Spuren[Event.InfoByte]^.Noten[X]:=N;
                               END;
                              ClearEvent(Event);
                             END;
                            ReDraw;
                          END;
          cmpTranspInst : BEGIN
                            IF GetState(sfActive) THEN
                             BEGIN
                              FOR X:=1 TO 64 DO
                               BEGIN
                                N:=Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                IF NOT (N.Wert IN [NNoNote,NSetSpeed,
                                                  NPatBreak]) THEN
                                  IF N.Instrument=MoveInstBuf2 THEN
                                    BEGIN
                                      N.Wert:=N.Wert+MoveInstBuf1;
                                      IF N.Wert<0 THEN
                                        N.Wert:=0;
                                      IF N.Wert>127 THEN
                                        N.Wert:=127;
                                      Arra^.Spuren[Event.InfoByte]^.Noten[X]:=N;
                                    END;
                               END;
                              ReDraw;
                              ClearEvent(Event);
                             END;
                          END;
          cmpTranspTrack: BEGIN
                            IF GetState(sfActive) THEN
                             BEGIN
                              FOR X:=1 TO 64 DO
                               BEGIN
                                N:=Arra^.Spuren[Event.InfoByte]^.Noten[X];
                                IF NOT (N.Wert IN [NNoNote,NSetSpeed,
                                                  NPatBreak]) THEN
                                  BEGIN
                                    N.Wert:=N.Wert+MoveInstBuf1;
                                    IF N.Wert<0 THEN
                                      N.Wert:=0;
                                    IF N.Wert>127 THEN
                                      N.Wert:=127;
                                    Arra^.Spuren[Event.InfoByte]^.Noten[X]:=N;
                                  END;
                               END;
                              ReDraw;
                              ClearEvent(Event);
                             END;
                          END;
          cmCancel      : BEGIN
                            IF GetState(sfActive) THEN
                              BEGIN
                                ClearEvent(Event);
                                Close;
                              END;
                          END;
        END;
    END;
  TDialog.HandleEvent(Event);
END;

DESTRUCTOR tCompWin.Done;
BEGIN
  Arra^.Bearbeitung:=FALSE;
  TDialog.Done;
END;

{---------- tZahl ------------}

constructor tZahl.init;
begin
  tView.init(bounds);
  max:=a;
  min:=i;
  nummer:=n;
  eventmask:=evkeydown+evmouseauto+evmousedown;
  options:=options or ofselectable or offramed;
end;

function tZahl.getpalette;
const
  x : string[2]=#21#21;
begin
  getpalette:=@x;
end;

procedure tZahl.handleevent;
var
  p  : tpoint;
begin
  tView.handleevent(event);
  if (State and sfSelected <> 0) then
  begin
  if event.what=evmouseauto then
    begin
      makelocal(event.where,p);
      repeat
        if (p.y=0) and (p.x>=0) and (p.x<3) then
          begin
            inc(nummer);
            if nummer>max then nummer:=max;
          end;
        if (p.y=0) and (p.x>10) and (p.x<14) then
          begin
            dec(nummer);
            if nummer<min then nummer:=min;
          end;
      until event.what<>evmouse;
    end;
  if event.what=evmousedown then
    begin
      makelocal(event.where,p);
      if (p.y=0) and (p.x>=0) and (p.x<3) then
        begin
          inc(nummer);
          if nummer>max then nummer:=max;
        end;
      if (p.y=0) and (p.x>10) and (p.x<14) then
        begin
          dec(nummer);
          if nummer<min then nummer:=min;
        end;
    end
   else if event.what=evkeydown then
    begin
      if event.keycode=kbup then
        begin
          inc(nummer);
          if nummer>max then nummer:=max;
          event.what:=evnothing;
        end;
      if event.keycode=kbdown then
        begin
          dec(nummer);
          if nummer<min then nummer:=min;
          event.what:=evnothing;
        end;
      if event.keycode=kbpgup then
        begin
          inc(nummer,10);
          if nummer>max then nummer:=max;
          event.what:=evnothing;
        end;
      if event.keycode=kbpgdn then
        begin
          dec(nummer,10);
          if nummer<min then nummer:=min;
          event.what:=evnothing;
        end;
    end;
  end;
  drawview;
end;

procedure tZahl.draw;
var
  s  : string;
begin
  str(nummer,s);
  writestr(0,0,#221#30#222,2);
  writestr(3,0,'        ',1);
  writestr(10-length(s),0,s,1);
  writestr(11,0,#221#31#222,2);
end;

PROCEDURE tEffektRegler.Draw;
VAR
  S      : STRING;
BEGIN
  S:=EffNames[Nummer];
  writestr(0,0,#221#30#222,2);
  writestr(3,0,'        ',1);
  writestr(3,0,s,1);
  writestr(11,0,#221#31#222,2);
END;

END.
