Unit ConvMOD;

INTERFACE

USES Objects,CompWin,InstEdit,MsgBox,FMVoice;

CONST
   MaxIns = 31;  { Maximale Anzahl von Instrumenten im Modul }

   Octaves : ARRAY[1..36] OF WORD =     { Tuning-Tabelle fr 3 Oktaven }
      (856,808,762,720,678,640,604,570,538,508,480,453,
       428,404,381,360,339,320,302,285,269,254,240,226,
       214,202,190,180,170,160,151,143,135,127,120,113);

TYPE
   MODInstrumentType = RECORD
      SampName : ARRAY[0..21] OF CHAR;  { Name des Instruments       }
      SampLen  : WORD;                  { Lnge des Instr. in Worten }
      SampTune : BYTE;                  { FineTune-Einstellung       }
      SampAmp  : BYTE;                  { Lautst. des Instrumentes   }
      SampRepS : WORD;                  { Repeat-Start in Worten     }
      SampRepL : WORD;                  { Repeat-Lnge in Worten     }
      END;

   MODHeaderType = RECORD
      MODName  : ARRAY[0..19] OF CHAR;                  { MOD-Filename      }
      MODInstr : ARRAY[1..MaxIns] OF MODInstrumentType; { Instrumente       }
      MODLen   : BYTE;                                  { Lnge des Songs   }
      MODMisc  : BYTE;                                  { CIAA-Speed        }
      MODPattr : ARRAY[1..128] OF BYTE;                 { Patternliste      }
      MODSign  : ARRAY[1..4] OF CHAR;                   { Erkennungs-String }
      END;

   MODNoteType    = ARRAY[1..4] OF BYTE;        { Eine Note  = 4 Bytes   }

   MODPatternLine = RECORD                      { Eine Patternzeile ist  }
      Channel1, Channel2,                       { fr 4-8 Kanle ausgelegt }
      Channel3, Channel4,
      Channel5, Channel6,
      Channel7, Channel8  : MODNoteType;
      END;

   MODPatternType = ARRAY[1..64] OF MODPatternLine; { Ein Pattern = 64 Noten }


FUNCTION NoteName(Period : WORD): BYTE;
PROCEDURE ReadMOD(DateiName: STRING);

IMPLEMENTATION

FUNCTION ConvertString(Source : Pointer; Size : BYTE):String;
{
 * EINGABE  : Zeiger auf ein ARRAY OF CHAR, Lnge in BYTES
 * AUSGABE  : Pascal-String in Size-Bytes Lnge
 * FUNKTION : Wandelt z.B. einen Null-Terminierten String in einen
              Pascal-String um. Es kann aber auch jeder andere Speicher-
              bereich in einen String gewandelt werden.
}
VAR
   WorkStr : String;
BEGIN
   Move(Source^,WorkStr[1],Size);
   WorkStr[0] := CHR(Size);
   ConvertString := WorkStr;
   END;

FUNCTION Word2Bytes(FalseWord : WORD):LongInt;
{
 * EINGABE  : Word-Variable mit verdrehtem Hi-Byte/Lo-Byte
 * AUSGABE  : Word-Wert berichtigt und mit 2 multipliziert
 * FUNKTION : Nimmt einen Word-Wert aus der MOD-Datei und dreht die
              Reihenfolge von Hi und Lo-Byte richtig. Zustzlich wird
              das Ergebnis noch mit 2 multipliziert, weil diese
              Funktion hauptschlich zur Ermittlung von Sample-Lngen
              bentigt wird, deren Informationen in WORD-Einheiten
              gespeichert sind.
}
BEGIN
   Word2Bytes := Swap(FalseWord)*2;
   END;

FUNCTION NoteName(Period : WORD):BYTE;
VAR
   NCount  : BYTE;
BEGIN
   NCount := 1;
   IF (Period = 0) THEN BEGIN
      NCount := 37;
      NoteName := NNoNote;
      END;
   WHILE (NCount <= 36) DO BEGIN
      IF (Period = Octaves[NCount]) THEN BEGIN
         Dec(Ncount);
         NoteName := NCount+24;
         NCount := 37;
         END;
      Inc(NCount);
      END;
   END;

PROCEDURE ReadMOD;
VAR
   ModFile  : TBufStream;
   Result   : WORD;
   Header   : ModHeaderType;
   DummyStr : String;         { Stringvariable zur Datenkonvertierung }
   InsCount : BYTE;           { Zhlervariable fr Instrumentenzahl   }
   PatCount : BYTE;           { Zhlervariable fr Patternzahl        }
   Pattern  : MODPatternType; { Puffervariable fr ein Pattern        }
   HiPatt   : BYTE;           { hchste Pattern-Nummer im Modul       }
   Counter  : WORD;           { allgemeine Zhlervariable             }
   DummyB   : BYTE;
   P        : pPattern;
   OldNote  : ARRAY[1..4] OF TNote;

PROCEDURE ReadSingleNote(Kanal,Position: BYTE);
VAR
  Channel   : MODNoteType;
BEGIN
  WITH Pattern[Position] DO
    BEGIN
      CASE Kanal OF
        1  : Channel:=Channel1;
        2  : Channel:=Channel2;
        3  : Channel:=Channel3;
        4  : Channel:=Channel4;
        5  : Channel:=Channel5;
        6  : Channel:=Channel6;
        7  : Channel:=Channel7;
        8  : Channel:=Channel8;
      END;
    END;
  DummyB := NoteName((Channel[1] AND $0F)*256+(Channel[2]));
  P^.Spuren[Kanal]^.Noten[Position].Wert:=DummyB;
  P^.Spuren[Kanal]^.Noten[Position].Instrument:=
   ((Channel[1] AND $F0)+(Channel[3] SHR 4));
  P^.Spuren[Kanal]^.Noten[Position].Effekt:=ENoEffekt;
  P^.Spuren[Kanal]^.Noten[Position].EWert:=0;
  CASE (Channel[3] AND $F) OF
    12: BEGIN
          IF Channel[4]>63 THEN Channel[4]:=63;
          P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4];
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=ESetVolume;
        END;
    15: BEGIN
          P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4]*2;
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=ESetSpeed;
        END;
    13: BEGIN
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPatBreak;
        END;
    4:  BEGIN
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=EVibrato;
          P^.Spuren[Kanal]^.Noten[Position].EWert:=(Channel[4] AND $0F)*2;
        END;
    1:  BEGIN
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPortUp;
          P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4]*3;
        END;
    2:  BEGIN
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPortDown;
          P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4]*3;
        END;
    3:  BEGIN
          P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPortToNote;
          P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4]*3;
        END;
    10: BEGIN
          IF Channel[4] SHR 4=0 THEN
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EVolumeDown;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4];
            END
          ELSE
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EVolumeUp;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=(Channel[4] SHR 4);
            END;
        END;
    5:  BEGIN
          IF Channel[4] SHR 4=0 THEN
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPort_VSlideUp;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4];
            END
          ELSE
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EPort_VSlideDn;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4] SHR 4;
            END;
        END;
    6:  BEGIN
          IF Channel[4] SHR 4=0 THEN
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EVibr_VSlideUp;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4];
            END
          ELSE
            BEGIN
              P^.Spuren[Kanal]^.Noten[Position].Effekt:=EVibr_VSlideDn;
              P^.Spuren[Kanal]^.Noten[Position].EWert:=Channel[4] SHR 4;
            END;
        END;
    END;
END;

VAR
  X      : BYTE;
  DummyA : ARRAY[0..16] OF BYTE;
BEGIN
{ Prfen, ob die gewnschete MOD-Datei berhaupt vorhanden ist }
{$I-}
   ModFile.Init(DateiName,stOpenRead,5000);
   IF ModFile.Status<>stOk THEN
     BEGIN
       MessageBox('Fehler beim ffnen von '+DateiName+'.',NIL,
       mfError+mfOkButton);
       ModFile.Done;
       Exit;
     END;

{ Lesen der MOD-Header-Daten in die Variable Header }
   ModFile.Read(Header,SizeOf(Header));

{ Analyse der eingelesenen Daten }
   WITH Header DO BEGIN
{ hchste Pattern-Nummer suchen }
      HiPatt := 0;
      FOR PatCount := 1 TO MODLen DO
         IF ModPattr[PatCount] >= HiPatt THEN
            HiPatt := ModPattr[PatCount];

{ Schreiben der Instrumenteninformationen }
      FOR InsCount := 1 TO MaxIns DO BEGIN
         WITH MODInstr[InsCount] DO BEGIN
            DummyStr := ConvertString(Addr(SampName),SizeOf(SampName));
            FMSong^.Instruments[InsCount]^.Name:=DummyStr;
            END;
      END;

      FOR PatCount := 1 TO HiPatt+1 DO BEGIN
        FOR X:=1 TO 64 DO
          BEGIN
            CASE Header.MODSign[1] OF
                '6' : BEGIN
                        MODFile.Read(Pattern[X],24);
                      END;
                '8' : BEGIN
                        MODFile.Read(Pattern[X],32);
                      END;
              ELSE
                BEGIN
                  MODFile.Read(Pattern[X],16);
                END;
              END;
          END;
         P:=NEW(pPattern,Init);
         Str(PatCount,DummyStr);
         P^.Name:='Pattern '+DummyStr;

         FOR Counter := 1 TO 64 DO BEGIN
           ReadSingleNote(1,Counter);
           ReadSingleNote(2,Counter);
           ReadSingleNote(3,Counter);
           ReadSingleNote(4,Counter);
           IF (Header.MODSign[1] IN ['6','8']) AND
              (Header.MODSign[2] = 'C') AND
              (Header.MODSign[3] = 'H') THEN
             BEGIN
               ReadSingleNote(5,Counter);
               ReadSingleNote(6,Counter);
               IF Header.MODSign[1]='8' THEN
                 BEGIN
                   ReadSingleNote(7,Counter);
                   ReadSingleNote(8,Counter);
                 END;
             END;
           END;

           FMSong^.Patterns^.Insert(P);
         END;

      FOR Counter:=1 TO MODLen DO
        BEGIN
          DummyB:=Header.MODPattr[Counter];
          FMSong^.Arrangement^.Insert(FMSong^.Patterns^.At(DummyB));
        END;

      FMSong^.SongTitle:=Header.MODName;
      ModFile.Done;
      END;
{$I+}
   END;

END.
