UNIT InstEdit;

INTERFACE

USES Views,Dialogs,Objects,msgbox,crt,dos,memory,drivers,
     stddlg,app,newcol,compwin,FMVoice;

type
  SBIFile    = RECORD
    FileID            : array[1..4] of char;
    InstrName         : array[1..31] of char;
    ZeroByte          : BYTE;
    INSTR1mod         : BYTE;
    INSTR1tr          : byte;
    INSTR2mod         : byte;
    INSTR2tr          : byte;
    INSTRAttDecMod    : byte;
    INSTRAttDecTr     : byte;
    INSTRSusRelMod    : byte;
    INSTRSusRelTr     : byte;
    INSTRVerzMod      : byte;
    INSTRVerzTr       : byte;
    INSTRRueck        : byte;
    INSTRNothing      : array[47..51] of byte;
  END;

  cmfinstrp  = ^CMFInstr;
  CMFInstr   = RECORD
    INSTR1mod         : BYTE;
    INSTR1tr          : byte;
    INSTR2mod         : byte;
    INSTR2tr          : byte;
    INSTRAttDecMod    : byte;
    INSTRAttDecTr     : byte;
    INSTRSusRelMod    : byte;
    INSTRSusRelTr     : byte;
    INSTRVerzMod      : byte;
    INSTRVerzTr       : byte;
    INSTRRueck        : byte;
    INSTRNothing      : array[47..51] of byte;
  END;

  pSBIFileDialog = ^tSBIFileDialog;
  tSBIFileDialog = OBJECT(tFileDialog)
    CONSTRUCTOR    INIT(AWildCard: TWildStr; ATitle: String;
                   InputName: String; AOptions: Word; HistoryId: Byte);
    PROCEDURE      HandleEvent(VAR Event: TEvent); VIRTUAL;
  END;

  pXScrollbar     = ^tXScrollbar;
  tXScrollbar     = object(tScrollbar)
    constructor     init(var bounds: trect);
    procedure       draw;  virtual;
    procedure       handleevent(var event: tevent); virtual;
  end;

  pNoteZahl       = ^tNoteZahl;
  tNoteZahl       = OBJECT(tZahl)
    PROCEDURE       Draw; virtual;
  END;

  pCMFEditDlg     = ^tCMFEditDlg;
  tCMFEditDlg     = object(tDialog)
    tune          : pNoteZahl;
    name          : pInputline;
    plInstr       : pFMInstr;
    Playing       : BOOLEAN;
    Tr1,Mod1      : pCheckBoxes;
    Tr2,Mod2      : pxScrollbar;  {Frequenzmultiplikator}
    Tr3,Mod3      : pxScrollbar;  {Lautstrkenabsenkung}
    Tr4,Mod4      : pxScrollbar;  {Lautstrke}
    Tr5,Mod5      : pxScrollbar;  {Attack}
    Tr6,Mod6      : pxScrollbar;  {Decay}
    Tr7,Mod7      : pxScrollbar;  {Sustain}
    Tr8,Mod8      : pxScrollbar;  {Release}
    Tr9,Mod9      : pxScrollbar;  {Verzerrung}
    Kopplung      : pxScrollbar;  {Phasenverschiebung}
    Schaltung     : pCheckboxes; {Additiv-/FM- Synthese}
    Instr         : pFMInstr;
    constructor     init(I: pFMInstr);
    PROCEDURE       HandleEvent(VAR Event: TEvent); VIRTUAL;
    procedure       getinstrument(I: pFMInstr);
    procedure       setinstrument(I: pFMInstr);
    destructor      done;                            virtual;
  end;

PROCEDURE SaveInstr(I: WORD);
PROCEDURE LoadInstr(I: WORD);
PROCEDURE NeuesInstrument;
PROCEDURE LoescheInstrument;
PROCEDURE EditInstrument(I: WORD);
FUNCTION  ChooseInstrument: WORD;

CONST
  cmPlayStart = 254;

IMPLEMENTATION

VAR
  plInstr          : CMFInstrp;

CONSTRUCTOR TSBIFileDialog.INIT;
var
  S: String;
  ACurDir: String;
  Control: PView;
  R: TRect;
  Opt: Word;
begin
  R.Assign(15,1,64,20);
  TDialog.Init(R, ATitle);
  Options := Options or ofCentered;
  WildCard := AWildCard;

  R.Assign(3,3,31,4);
  FileName := New(PFileInputLine, Init(R, 79));
  FileName^.Data^ := WildCard;
  Insert(FileName);
  R.Assign(2,2,3+CStrLen(InputName),3);
  Control := New(PLabel, Init(R, InputName, FileName));
  Insert(Control);
  R.Assign(31,3,34,4);
  Control := New(PHistory, Init(R, FileName, HistoryId));
  Insert(Control);

  R.Assign(3,14,34,15);
  Control := New(PScrollBar, Init(R));
  Insert(Control);
  R.Assign(3,6,34,14);
  FileList := New(PFileList, Init(R, WildCard, PScrollBar(Control)));
  Insert(FileList);
  R.Assign(2,5,8,6);
  Control := New(PLabel, Init(R, '~D~ateien', FileList));
  Insert(Control);

  R.Assign(35,3,46,5);
  Opt := bfDefault;
  if AOptions and fdOpenButton <> 0 then
  begin
    Insert(New(PButton, Init(R, '~f~fnen', cmFileOpen, Opt)));
    Opt := bfNormal;
    Inc(R.A.Y,3); Inc(R.B.Y,3);
  end;
  if AOptions and fdOkButton <> 0 then
  begin
    Insert(New(PButton, Init(R, '~O~K', cmFileOpen, Opt)));
    Opt := bfNormal;
    Inc(R.A.Y,3); Inc(R.B.Y,3);
  end;
  if AOptions and fdReplaceButton <> 0 then
  begin
    Insert(New(PButton, Init(R, '~E~rsetzen',cmFileReplace, Opt)));
    Opt := bfNormal;
    Inc(R.A.Y,3); Inc(R.B.Y,3);
  end;
  if AOptions and fdClearButton <> 0 then
  begin
    Insert(New(PButton, Init(R, '~D~emo',cmFileClear, Opt)));
    Opt := bfNormal;
    Inc(R.A.Y,3); Inc(R.B.Y,3);
  end;
  Insert(New(PButton, Init(R, 'Abbruch', cmCancel, bfNormal)));
  Inc(R.A.Y,3); Inc(R.B.Y,3);
  if AOptions and fdHelpButton <> 0 then
  begin
    Insert(New(PButton, Init(R, 'Hilfe',cmHelp, bfNormal)));
    Inc(R.A.Y,3); Inc(R.B.Y,3);
  end;

  R.Assign(1,16,48,18);
  Control := New(PFileInfoPane, Init(R));
  Insert(Control);

  SelectNext(False);

  if AOptions and fdNoLoadDir = 0 then ReadDirectory;
end;

procedure TSBIFileDialog.HandleEvent(var Event: TEvent);

PROCEDURE PlayDemo;
var
  f        : file of SBIFile;
  data     : SBIFile;
  i        : pFMInstr;
  S        : STRING;
  X        : BYTE;
BEGIN
  {$I-}
  GetFileName(S);
  assign(f,S);
  reset(f);
  read(f,data);
  system.close(f);
  IF IOResult<>0 THEN
    BEGIN
      sound(880);
      delay(30);
      sound(440);
      delay(30);
      Nosound;
      MessageBox(^c+'Fehler beim lesen der Datei !',NIL,
      mfError+mfOkButton);
      Exit;
    END;
  {$I+}

  I:=NEW(pFMInstr);
  I^.Name:='';
  i^.instr1mod:=data.instr1mod;
  i^.instr2mod:=data.instr2mod;
  i^.instr1tr:=data.instr1tr;
  i^.instr2tr:=data.instr2tr;
  i^.instrattdecmod:=data.instrattdecmod;
  i^.instrattdectr:=data.instrattdectr;

  i^.instrsusrelmod:=data.instrsusrelmod;
  i^.instrsusreltr:=data.instrsusreltr;

  i^.instrverzmod:=data.instrverzmod;
  i^.instrverztr:=data.instrverztr;

  i^.instrrueck:=data.instrrueck;
  FMSong^.Instruments[51]:=I;

  FMReset;
  FMSetInstrument(1,51);

  for x:=2 to 5 do
    begin
      FMNoteOn(1,12*x,0);
      Delay(1000);
      FMNoteOff(1);
    end;
  FMNoteOff(1);
  Dispose(I);
END;

begin
  if (Event.What=evCommand) AND (Event.Command=cmFileClear) THEN
    PlayDemo
  ELSE
    TFileDialog.HandleEvent(Event);
end;


PROCEDURE LoescheInstrument;
VAR
  P,W    : WORD;
BEGIN
  P:=ChooseInstrument;
  IF P<>0 THEN
    BEGIN
      w:=Messagebox(^c+'Soll das Instrument "'+
        FMSong^.Instruments[P]^.Name+'"'+#13+
        ^c+'wirklich gelscht werden ?',NIL,
        mfwarning+mfyesbutton+mfnobutton);
      IF W=cmYes THEN FMSong^.InitInstrument(P);
    END;
END;

PROCEDURE NeuesInstrument;
VAR
  P,W    : WORD;
  S      : STRING[30];
  Ok     : BOOLEAN;
  X      : BYTE;
BEGIN
  P:=ChooseInstrument;
  IF P<>0 THEN
    BEGIN
      S:='';
      REPEAT
        Ok:=TRUE;
        W:=InputBox('Neues Instrument (statt "'+
          FMSong^.Instruments[P]^.Name+'")','Name:',S,30);
        FOR X:=1 TO 50 DO
          BEGIN
            IF S=FMSong^.Instruments[X]^.Name THEN
              Ok:=FALSE;
          END;
        IF (Ok=FALSE) AND (W<>cmCancel) THEN
          MessageBox('Dieser Name ist schon vergeben !',NIL,
          mfError+mfOkButton);
      UNTIL Ok OR (W=cmCancel);
      IF W<>cmCancel THEN
        BEGIN
          FMSong^.InitInstrument(P);
          EditInstrument(P);
        END;
    END;
END;

PROCEDURE EditInstrument;
VAR
  D      : pCMFEditDlg;
BEGIN
  IF I=0 THEN
    I:=ChooseInstrument;
  IF I=0 THEN EXIT;
  D:=NEW(pCMFEditDlg,Init(FMSong^.Instruments[I]));
  Desktop^.ExecView(D);
  Dispose(D,Done);
END;

FUNCTION ChooseInstrument: WORD;
VAR
  LB     : PListBox;
  C      : pXStringCollection;
  SB     : PScrollBar;
  D      : PDialog;
  R      : TRect;
  X,Y    : INTEGER;
  P      : WORD;
  S      : STRING;
  Inst   : pFMInstr;
BEGIN
  R.Assign(0,0,40,13);
  D:=NEW(PDialog,Init(R,'Instrument whlen'));
  WITH D^ DO
    BEGIN
      Options:=Options OR OfCentered;
      Flags:=wfMove+wfClose;
      HelpCtx:=30000;

      R.Assign(1,10,20,12);
      Insert(NEW(PButton,Init(R,'~O~K',cmOK,bfDefault)));

      R.Assign(20,10,39,12);
      Insert(NEW(PButton,Init(R,'~A~bbruch',cmCancel,bfNormal)));

      R.Assign(37,1,38,9);
      SB:=NEW(PScrollBar,Init(R));
      Insert(SB);

      R.Assign(2,1,37,9);
      LB:=NEW(PListBox,Init(R,1,SB));
      Insert(LB);

      C:=NEW(PXStringCollection,Init(100,20));
      FOR X:=1 TO 50 DO
        BEGIN
          Inst:=FMSong^.Instruments[X];
          Str(X:2,S);
          S:=S+' '+Inst^.Name;
          C^.Insert(NewStr(S));
        END;
      LB^.NewList(C);
    END;
  IF DeskTop^.ExecView(D)<>cmCancel THEN
    P:=LB^.Focused+1
  ELSE
    P:=0;
  Dispose(C,Done);
  Dispose(D,Done);
  ChooseInstrument:=P;
END;

constructor txscrollbar.init;
begin
  tscrollbar.init(bounds);
  options:=ofselectable+ofFirstClick;
  eventmask:=$FFFF;
end;

procedure txscrollbar.handleevent;
begin
  tscrollbar.handleevent(event);
  drawview;
end;

procedure tXScrollBar.draw;
var
  s  : string;
  F  : byte;
begin
  tScrollbar.draw;
  str(value:3,s);
  inc(size.x,3);
  if getstate(sfselected) then
    f:=2
  else
    f:=1;
  writestr(size.x-3,0,s,F);
  dec(size.x,3);
end;

constructor tCMFEditDlg.init;
const
  s1 : array[1..7] of string = ('> Mod. > Tr. >  FM',
                                ' < Rckkoppl. ',
                                ' < Rckkoppl.Ŀ',
                                '> Modulator >',
                                '                  > Add',
                                '> Trger >',
                                '');
  s2 : array[1..9] of string = ('Frequenzmultiplikator',
                                'Lautstrkenabsenkung',
                                'Lautstrke',
                                'Attack',
                                'Decay',
                                'Sustain',
                                'Release',
                                'Verzerrung',
                                'Phasenverschiebung');
var
  r  : trect;
  x  : integer;
begin
  r.assign(0,0,80,20);
  tDialog.init(r,'Instrument-Editor');
  options:=options or ofcentered;
  flags:=$0;
  instr:=i;
  helpctx:=30007;
  plInstr:=NEW(pFMInstr);
  Playing:=FALSE;

  r.assign(1,1,79,2);
  insert(new(pStaticText,init(r,'                      Modulator      Trger')));

  for x:=1 to 7 do
    begin
      r.assign(53,x,78,x+1);
      insert(new(pStatictext,init(r,s1[x])));
    end;

  for x:=1 to 9 do
    begin
      r.assign(1,x+1,22,x+2);
      insert(new(pStatictext,init(r,s2[x])));
    end;

  r.assign(23,2,33,3);
  mod2:=new(pXScrollbar,init(r));
  mod2^.setrange(0,15);
  insert(mod2);

  r.assign(23,3,33,4);
  mod3:=new(pXScrollbar,init(r));
  mod3^.setrange(0,3);
  insert(mod3);

  r.assign(23,4,33,5);
  mod4:=new(pXScrollbar,init(r));
  mod4^.setrange(0,63);
  insert(mod4);

  r.assign(23,5,33,6);
  mod5:=new(pXScrollbar,init(r));
  mod5^.setrange(0,15);
  insert(mod5);

  r.assign(23,6,33,7);
  mod6:=new(pXScrollbar,init(r));
  mod6^.setrange(0,15);
  insert(mod6);

  r.assign(23,7,33,8);
  mod7:=new(pXScrollbar,init(r));
  mod7^.setrange(0,15);
  insert(mod7);

  r.assign(23,8,33,9);
  mod8:=new(pXScrollbar,init(r));
  mod8^.setrange(0,15);
  insert(mod8);

  r.assign(23,9,33,10);
  mod9:=new(pXScrollbar,init(r));
  mod9^.setrange(0,3);
  insert(mod9);

  r.assign(38,2,48,3);
  tr2:=new(pXScrollbar,init(r));
  tr2^.setrange(0,15);
  insert(tr2);

  r.assign(38,3,48,4);
  tr3:=new(pXScrollbar,init(r));
  tr3^.setrange(0,3);
  insert(tr3);

  r.assign(38,4,48,5);
  tr4:=new(pXScrollbar,init(r));
  tr4^.setrange(0,63);
  insert(tr4);

  r.assign(38,5,48,6);
  tr5:=new(pXScrollbar,init(r));
  tr5^.setrange(0,15);
  insert(tr5);

  r.assign(38,6,48,7);
  tr6:=new(pXScrollbar,init(r));
  tr6^.setrange(0,15);
  insert(tr6);

  r.assign(38,7,48,8);
  tr7:=new(pXScrollbar,init(r));
  tr7^.setrange(0,15);
  insert(tr7);

  r.assign(38,8,48,9);
  tr8:=new(pXScrollbar,init(r));
  tr8^.setrange(0,15);
  insert(tr8);

  r.assign(38,9,48,10);
  tr9:=new(pXScrollbar,init(r));
  tr9^.setrange(0,3);
  insert(tr9);

  r.assign(23,10,33,11);
  kopplung:=new(pXScrollbar,init(r));
  kopplung^.setrange(0,7);
  insert(kopplung);

  r.assign(38,10,68,11);
  schaltung:=new(pCheckBoxes,init(r,NewSItem('~A~dditiv-Synthese',nil)));
  insert(schaltung);

  r.assign(23,12,46,16);
  mod1:=new(pCheckBoxes,Init(r,
    NewSItem('~H~he -> krzer    ',
    NewSItem('T~o~n halten        ',
    NewSItem('~F~requenz-Vibrato  ',
    NewSItem('A~m~plituden-Vibrato',
    nil))))));
  insert(mod1);

  r.assign(46,12,53,16);
  tr1:=new(pCheckBoxes,Init(r,
    NewSItem('~K~',
    NewSItem('~N~',
    NewSItem('~R~',
    NewSItem('~V~',
    nil))))));
  insert(tr1);

  r.assign(64,13,78,14);
  tune:=new(pNoteZahl,init(r,84,0,48));
  insert(tune);
  tune^.options:=tune^.options and not offramed;
  r.Assign(54,13,64,14);
  Insert(NEW(PLabel,Init(R,'~T~onhhe:',tune)));

  r.assign(66,8,78,12);
  insert(new(pButton,init(r,'Ton',cmPLayStart,bfdefault)));

  r.assign(66,17,78,19);
  insert(new(pButton,init(r,'~S~chlieen',cmok,bfnormal)));

  r.Assign(23,17,53,18);
  Name:=NEW(pInputLine,init(r,30));
  Insert(Name);
  R.Assign(17,17,23,18);
  Insert(NEW(PLabel,Init(R,'Nam~e~:',Name)));


  setinstrument(instr);
end;

procedure Saveinstr;
var
  f        : file of SBIFile;
  data     : SBIFile;
  dateiname: string;
  d        : pFiledialog;
  exists   : boolean;
  w        : word;
  s1,s2,s3 : string;

  PROCEDURE MakeBAK(d: STRING);
  VAR
    dat   : FILE;
    dat1  : FILE;
    a,b,c : STRING;
    w     : word;
  BEGIN
    {$I-}
    FSplit(d,a,b,c);
    Assign(dat,a+b+'.BAK');
    Erase(dat);
    Assign(dat1,d);
    Rename(dat1,a+b+'.BAK');

    w:=ioresult;
    {$I+}
  END;

begin
  IF FMSong^.Instruments[I]=NIL THEN Exit;
  data.fileid[1]:='S';
  data.fileid[2]:='B';
  data.fileId[3]:='I';
  data.fileid[4]:=#26;
  data.zerobyte:=0;
  WITH FMSong^.Instruments[I]^ DO
    BEGIN
      data.instr1mod:=instr1mod;
      data.instr1tr:=instr1tr;
      data.instr2mod:=instr2mod;
      data.instr2tr:=instr2tr;
      data.instrattdecmod:=instrattdecmod;
      data.instrattdectr:=instrattdectr;
      data.instrsusrelmod:=instrsusrelmod;
      data.instrsusreltr:=instrsusreltr;
      data.instrverzmod:=instrverzmod;
      data.instrverztr:=instrverztr;
      data.instrrueck:=instrrueck;

      FOR W:=1 TO 30 DO
        Data.instrname[W]:=#0;
      FOR W:=1 TO Length(Name) DO
        Data.instrname[W]:=Name[W];
    END;

  d:=new(pfiledialog,init('*.SBI','Speichern','Dateiname:',
         fdokbutton,201));
  {$I-}
  if desktop^.execview(d) <> cmcancel then
    begin
      d^.getfilename(dateiname);

      w:=cmyes;
      exists:=FALSE;
      FSplit(dateiname,s1,s2,s3);
      dateiname:=s1+s2+'.SBI';

      IF FSearch(s2+s3,s1)<>'' THEN
        BEGIN
          exists:=TRUE;
          sound(880);
          delay(30);
          sound(440);
          delay(30);
          Nosound;
          w:=MessageBox(^c+'Die Datei '+dateiname+' existiert bereits.'#13+
          ^c+'berschreiben ?',NIL,
          mfwarning+mfyesbutton+mfnobutton);
        END;
      IF w=cmyes THEN
        BEGIN
          IF exists THEN
            MakeBAK(dateiname);
          assign(f,dateiname);
          rewrite(f);
          write(f,data);
          system.close(f);
          IF IOResult<>0 THEN
            BEGIN
              sound(880);
              delay(30);
              sound(440);
              delay(30);
              Nosound;
              MessageBox(^c+'Fehler beim schreiben der Datei!',NIL,
              mfError+mfOkButton);
            END;
          {$I+}
        END
      ELSE
        begin
          dispose(d,done);
          {$I+}
          Exit;
        end;
    end;
  dispose(d,done);
  {$I+}
end;

procedure LoadInstr;
var
  f        : file of SBIFile;
  data     : SBIFile;
  dateiname: String;
  d        : pSBIFiledialog;
  X        : BYTE;
begin
  d:=new(pSBIfiledialog,init('*.SBI','Laden','Dateiname:',
         fdokbutton+fdClearButton,201));

  {$I-}
  if desktop^.execview(d) <> cmcancel then
    begin
      d^.getfilename(dateiname);

      assign(f,dateiname);
      reset(f);
      read(f,data);
      system.close(f);
      IF IOResult<>0 THEN
        BEGIN
          sound(880);
          delay(30);
          sound(440);
          delay(30);
          Nosound;
          MessageBox(^c+'Fehler beim lesen der Datei !',NIL,
          mfError+mfOkButton);
          dispose(d,done);
          Exit;
        END;
    END
  ELSE
    BEGIN
      Dispose(d,done);
      Exit;
    END;
  dispose(d,done);
  {$I+}

  WITH FMSong^.Instruments[I]^ DO
    BEGIN
      Name:='';
      FOR X:=1 TO 30 DO
        IF Data.InstrName[X]<>#0 THEN
          Name:=Name+Data.InstrName[X];
      instr1mod:=data.instr1mod;
      instr2mod:=data.instr2mod;
      instr1tr:=data.instr1tr;
      instr2tr:=data.instr2tr;

      instrattdecmod:=data.instrattdecmod;
      instrattdectr:=data.instrattdectr;

      instrsusrelmod:=data.instrsusrelmod;
      instrsusreltr:=data.instrsusreltr;

      instrverzmod:=data.instrverzmod;
      instrverztr:=data.instrverztr;

      instrrueck:=data.instrrueck;
    END;
end;

procedure tcmfeditdlg.setinstrument;
begin
  mod1^.value:=i^.instr1mod shr 4;
  mod2^.value:=i^.instr1mod mod 16;
  tr1^.value:=i^.instr1tr shr 4;
  tr2^.value:=i^.instr1tr mod 16;

  mod3^.value:=i^.instr2mod shr 6;
  mod4^.value:=63-i^.instr2mod mod 64;
  tr3^.value:=i^.instr2tr shr 6;
  tr4^.value:=63-i^.instr2tr mod 64;

  mod5^.value:=i^.instrattdecmod shr 4;
  mod6^.value:=i^.instrattdecmod mod 16;
  tr5^.value:=i^.instrattdectr shr 4;
  tr6^.value:=i^.instrattdectr mod 16;

  mod7^.value:=15-i^.instrsusrelmod shr 4;
  mod8^.value:=i^.instrsusrelmod mod 16;
  tr7^.value:=15-i^.instrsusreltr shr 4;
  tr8^.value:=i^.instrsusreltr mod 16;

  mod9^.value:=i^.instrverzmod;
  tr9^.value:=i^.instrverztr;

  schaltung^.value:=i^.instrrueck mod 2;
  kopplung^.value:=i^.instrrueck shr 1;

  Name^.Data^:=I^.Name;

  DoneMemory;
  ReDraw;
end;

procedure tcmfeditdlg.getinstrument;
begin
  i^.instr1mod:=mod1^.value*16+mod2^.value;
  i^.instr1tr:=tr1^.value*16+tr2^.value;
  i^.instr2mod:=mod3^.value*64+(63-mod4^.value);
  i^.instr2tr:=tr3^.value*64+(63-tr4^.value);
  i^.instrattdecmod:=mod5^.value*16+mod6^.value;
  i^.instrattdectr:=tr5^.value*16+tr6^.value;
  i^.instrsusrelmod:=(15-mod7^.value)*16+mod8^.value;
  i^.instrsusreltr:=(15-tr7^.value)*16+tr8^.value;
  i^.instrverzmod:=mod9^.value;
  i^.instrverztr:=tr9^.value;
  i^.instrrueck:=schaltung^.value+kopplung^.value*2;
  I^.Name:=Name^.data^;
end;

PROCEDURE tCMFEditDlg.HandleEvent;
BEGIN
  INHERITED HandleEvent(Event);
  IF (Event.What=evCommand) AND (Event.Command=cmPlayStart) THEN
    BEGIN
      IF Playing THEN
        BEGIN
          FMNoteOff(1);
          Playing:=FALSE;
        END
      ELSE
        BEGIN
          plinstr^.instr1mod:=mod1^.value*16+mod2^.value;
          plinstr^.instr1tr:=tr1^.value*16+tr2^.value;
          plinstr^.instr2mod:=mod3^.value*64+(63-mod4^.value);
          plinstr^.instr2tr:=tr3^.value*64+(63-tr4^.value);
          plinstr^.instrattdecmod:=mod5^.value*16+mod6^.value;
          plinstr^.instrattdectr:=tr5^.value*16+tr6^.value;
          plinstr^.instrsusrelmod:=(15-mod7^.value)*16+mod8^.value;
          plinstr^.instrsusreltr:=(15-tr7^.value)*16+tr8^.value;
          plinstr^.instrverzmod:=mod9^.value;
          plinstr^.instrverztr:=tr9^.value;
          plinstr^.instrrueck:=schaltung^.value+kopplung^.value*2;
          FMSong^.Instruments[51]:=plInstr;
          FMSetInstrument(1,51);
          FMNoteOn(1,Tune^.Nummer,0);
          Playing:=TRUE;
        END;
    END;
END;

destructor tCMFEditDlg.done;
begin
  getInstrument(Instr);
  Dispose(plInstr);
  tdialog.done;
end;

PROCEDURE tNoteZahl.Draw;
VAR
  S,S1   : STRING;
BEGIN
  Str(Nummer DIV 12+1,S1);
  S:=NoteNames[Nummer MOD 12]+'-'+S1;
  writestr(0,0,#221#30#222,2);
  writestr(3,0,'        ',1);
  writestr(6,0,s,1);
  writestr(11,0,#221#31#222,2);
END;

end.
