UNIT PlayWin;

{

         Unit: PlayWin
      Sprache: TurboPASCAL/TurboVISION 7.0
     Funktion: Wiedergabefenster fr MusicMaker
        Autor: Stephan Weinberger
               (C) 1994 synthesis design

}

INTERFACE

USES FMVoice,Dialogs,Views,Drivers,Objects,CompWin,ArraDlg;

CONST
  pwStart          = 12000;
  pwStop           = 12001;
  pwPause          = 12002;
  pwForward        = 12003;
  pwBackward       = 12004;
  hcPlayWin        = 32001;

TYPE
  pVolBar          = ^tVolBar;
  tVolBar          = OBJECT(TView)
    Value          : BYTE;
    CONSTRUCTOR      INIT(VAR Bounds: TRect);
    PROCEDURE        Draw;                                      VIRTUAL;
    FUNCTION         GetPalette: PPalette;                      VIRTUAL;
    PROCEDURE        UpDate(V: BYTE);
  END;

  pInfoLine        = ^tInfoLine;
  tInfoLine        = OBJECT(TView)
    Info           : STRING[20];
    CONSTRUCTOR      INIT(VAR Bounds: TRect);
    PROCEDURE        Draw;                                      VIRTUAL;
    FUNCTION         GetPalette: PPalette;                      VIRTUAL;
    PROCEDURE        UpDate(I,N,L,E: BYTE);
  END;

  pPosLine         = ^tPosLine;
  tPosLine         = OBJECT(TView)
    PosString      : STRING[40];
    CONSTRUCTOR      INIT(VAR Bounds: TRect);
    PROCEDURE        Draw;                                      VIRTUAL;
    FUNCTION         GetPalette: PPalette;                      VIRTUAL;
    PROCEDURE        UpDate(N,P: BYTE);
  END;

  pPlayWin         = ^tPlayWin;
  tPlayWin         = OBJECT(TDialog)
    VolBars        : ARRAY[1..9] OF pVolBar;
    InfoLines      : ARRAY[1..9] OF pInfoLine;
    PosLine        : pPosLine;
    Speed          : PScrollBar;
    CONSTRUCTOR      INIT;
    PROCEDURE        HandleEvent(VAR Event: TEvent);            VIRTUAL;
    PROCEDURE        UpDate;
  END;

IMPLEMENTATION

CONSTRUCTOR tPlayWin.INIT;
VAR
  R      : TRect;
  Y      : BYTE;
  S      : STRING[1];
BEGIN
  R.Assign(0,0,42,18);
  INHERITED INIT(R,'');
  Flags:=wfMove;
  Options:=Options OR ofCentered;
  HelpCtx:=hcPlayWin;

  Speed:=StandardScrollBar(2);
  Speed^.SetRange(20,200);
  Speed^.SetValue(FMSongTempo);

  R.Assign(1,1,41,2);
  PosLine:=NEW(pPosLine,INIT(R));
  Insert(PosLine);

  FOR Y:=1 TO 9 DO
    BEGIN
      R.Assign(3,Y+2,23,Y+3);
      InfoLines[Y]:=NEW(pInfoLine,INIT(R));
      Insert(InfoLines[Y]);

      R.Assign(24,Y+2,40,Y+3);
      VolBars[Y]:=NEW(pVolBar,INIT(R));
      Insert(VolBars[Y]);

      Str(Y:1,S);
      R.Assign(1,Y+2,2,Y+3);
      Insert(NEW(PStaticText,INIT(R,S)));
    END;

  R.Assign(1,13,21,15);
  Insert(NEW(PButton,INIT(R,'~P~LAY',pwStart,bfNormal)));
  R.Assign(21,13,41,15);
  Insert(NEW(PButton,INIT(R,'~S~TOP',pwStop,bfNormal)));
  R.Assign(11,15,31,17);
  Insert(NEW(PButton,INIT(R,'P~A~USE',pwPause,bfNormal)));
  R.Assign(1,15,11,17);
  Insert(NEW(PButton,INIT(R,'<<',pwBackward,bfNormal)));
  R.Assign(31,15,41,17);
  Insert(NEW(PButton,INIT(R,'>>',pwForward,bfNormal)));
END;

PROCEDURE tPlayWin.HandleEvent;
BEGIN
  IF Event.What=evCommand THEN
    BEGIN
      CASE Event.Command OF
          pwStart     : BEGIN
                          FMStartMusic;
                          FMSetTimerFreq(FMSongTempo);
                          Speed^.SetValue(FMSongTempo);
                          FMEnableTimer;
                        END;
          pwStop      : FMStopMusic;
          pwPause     : FMPauseMusic;
          pwForward   : BEGIN
                          IF FMPatternCounter<FMSong^.Arrangement^.Count-1 THEN
                            BEGIN
                              INC(FMPatternCounter);
                              FMNoteCounter:=1;
                              FMChannelStatus.UpDate:=TRUE;
                              FMChannelStatus.ActualPattern:=FMPatternCounter;
                            END;
                        END;
          pwBackward  : BEGIN
                          IF FMPatternCounter>0 THEN
                            BEGIN
                              DEC(FMPatternCounter);
                              FMNoteCounter:=1;
                              FMChannelStatus.UpDate:=TRUE;
                              FMChannelStatus.ActualPattern:=FMPatternCounter;
                            END;
                        END;
        END;
    END;
  IF (Event.What=evBroadCast) AND (Event.Command=cmScrollBarChanged) THEN
    BEGIN
      FMSongTempo:=Speed^.Value;
      FMSetTimerFreq(FMSongTempo);
      FMEnableTimer;
    END;
  INHERITED HandleEvent(Event);
END;

PROCEDURE tPlayWin.Update;
VAR
  Y      : BYTE;
BEGIN
  IF NOT FMChannelStatus.Update THEN EXIT;
  FMChannelStatus.UpDate:=FALSE;
  FOR Y:=1 TO 9 DO
    BEGIN
      WITH FMChannelStatus DO
        BEGIN
          Infolines[Y]^.Update(Instr[Y],Wert[Y],Laut[Y],Effekt[Y]);
          VolBars[Y]^.Update(VolBar[Y]);
        END;
    END;
  PosLine^.Update(FMChannelStatus.ActualNote,
    FMChannelStatus.ActualPattern);
END;

CONSTRUCTOR tVolBar.INIT;
BEGIN
  INHERITED INIT(Bounds);
  UpDate(0);
END;

FUNCTION tVolBar.GetPalette;
CONST
  X      : STRING[2] = #26#28;
BEGIN
  GetPalette:=@X;
END;

PROCEDURE tVolBar.UpDate;
BEGIN
  Value:=V;
  Draw;
END;

PROCEDURE tVolBar.Draw;
VAR
  V,X,F  : BYTE;
BEGIN
  WriteStr(0,0,'                ',1);
  V:=Value DIV 4;
  F:=1;
  FOR X:=1 TO V DO
    BEGIN
      IF X>12 THEN F:=2;
      WriteChar(X,0,'',F,1);
    END;
END;

CONSTRUCTOR TInfoLine.INIT;
BEGIN
  INHERITED INIT(Bounds);
  Info:='';
  UpDate(0,NNoNote,0,0);
END;

FUNCTION TInfoLine.GetPalette;
CONST
  X      : STRING[1] = #19;
BEGIN
  GetPalette:=@X;
END;

PROCEDURE tInfoLine.UpDate;
VAR
  S1,S2,S3,S4      : STRING[14];
BEGIN
  S1:='';
  S2:='';
  S3:='';
  S4:='';
  Str(I:2,S1);
  CASE N OF
      NNoNote   : S2:='    ';
      NNoteOff  : S2:='    ';
    ELSE
      BEGIN
        Str(N DIV 12+1:1,S2);
        S2:=NoteNames[N MOD 12]+'-'+S2;
      END;
    END;
  Str(L:2,S3);
  S4:=EffNames[E];
  Info:=S1+' '+S2+' '+S3+' '+S4+' ';
  Draw;
END;

PROCEDURE tInfoLine.Draw;
BEGIN
  WriteStr(0,0,Info,1);
END;

CONSTRUCTOR tPosLine.INIT;
BEGIN
  INHERITED INIT(Bounds);
  PosString:='';
  UpDate(0,0);
END;

FUNCTION TPosLine.GetPalette;
CONST
  X      : STRING[1] = #19;
BEGIN
  GetPalette:=@X;
END;

TYPE
  PosLineRec       = RECORD
    Arr            : LONGINT;
    Off            : LONGINT;
    Pat            : PString;
    Note           : LONGINT;
  END;

PROCEDURE tPosLine.UpDate;
VAR
  Rec    : PosLIneRec;
BEGIN
  IF FMSong^.Patterns^.Count>0 THEN
    FMPattern:=FMSong^.Arrangement^.At(P)
  ELSE
    FMPattern:=NIL;
  WITH Rec DO
    BEGIN
      IF FMPattern<>NIL THEN
        Pat:=NewStr(FMPattern^.Name)
      ELSE
        Pat:=NewStr('');
      Note:=LONGINT(N);
      Off:=FMSong^.Arrangement^.Count;
      IF FMMusicPlay THEN
        Arr:=P+1
      ELSE
        Arr:=0;
    END;
  PosString:='';
  FormatStr(PosString,'%2d/%2d: %-24s Note: %2d',Rec);
  DisposeStr(Rec.Pat);
  Draw;
END;

PROCEDURE tPosLine.Draw;
BEGIN
  WriteStr(0,0,PosString,1);
END;

END.

