unit treeobj;

interface

uses strings;

type

    ContentsPtr = ^ContentsRec;
    TreePtr = ^TreeObject;

    ContentsRec = record
                         obj  : TreePtr;
                         next : ContentsPtr;
                  end;

    TreeObject = object
                   name: pchar;
                   size: longint;
                   dirs: word;
                   total_dirs: word;
                   head, current : ContentsPtr;

                   constructor init;

                   function  create_child : TreePtr;
                   function  assign (vname: pchar; vsize: longint; vdirs, vtotal_dirs: word) : boolean;
                   procedure delete;
                   function  retrieve : TreePtr;

                   function  find_first : boolean;
                   function  find_next : Boolean;
                   function  empty : Boolean;

                   destructor destruct;
                 end;

implementation

constructor TreeObject.init;
begin
  current:= nil;
  head:= nil;
  name:= nil;
  size:= 0;
  dirs:= 0;
  total_dirs:= 0;
end;

function TreeObject.create_child : TreePtr;
var ptr : ContentsPtr;
begin
  create_child:= nil;
  if (maxavail < sizeof (ContentsRec)) then
  begin
    writeln ('tree.insert: out of memory');
    exit;
  end;
  getmem (ptr, sizeof (ContentsRec));
  getmem (ptr^.obj, sizeof (TreeObject));
  ptr^.next:= head;
  head:= ptr;
  current:= ptr;
  ptr^.obj^.init;
  create_child:= ptr^.obj;
end;

function TreeObject.assign (vname: pchar; vsize: longint; vdirs, vtotal_dirs: word) : boolean;
begin
  assign:= false;
  getmem (name, strlen (vname) + 1);
  strmove (name, vname, strlen (vname) + 1);
  size:= vsize;
  dirs:= vdirs;
  total_dirs:= vtotal_dirs;
  assign:= true;
end;

procedure TreeObject.delete;
var  ptr : ContentsPtr;
begin
  if not (current = head) then
  begin
    ptr:= head;
    while not (ptr^.next = current) do
        ptr:= ptr^.next;
    ptr^.next:=current^.next;
  end
  else
    head:= head^.next;
  current^.obj^.destruct;
  freemem (current^.obj^.name, strlen (current^.obj^.name) + 1);
  freemem (current^.obj, sizeof (TreeObject));
  freemem (current, sizeof (ContentsRec));
  current:= head;
end;

function TreeObject.retrieve : TreePtr;
begin
  retrieve:= current^.obj;
end;

function TreeObject.find_first : boolean;
begin
  current:= head;
  if (current = nil) then find_first:= false else find_first:= true;
end;

function TreeObject.find_next : Boolean;
begin
  if ((current^.next = nil) or (current = nil)) then
       find_next:= false
  else
  begin
    current:= current^.next;
    find_next:= true;
  end;
end;

function TreeObject.empty : Boolean;
begin
  empty:= (head = nil);
end;

destructor TreeObject.destruct;
begin
  find_first;
  while not empty do delete;
end;

end.
