program life;

(*  The famous life program.
    The program will keep in memory <maxfields> fields of dimension
    <maxcol>,<maxrow>. The fields[0] represents the futural field (temporary).
    fields[1] is the actual field, and fields[2..maxfields] are stored in
    memory to check periodicity.
    Mouse interface, will NOT work with keyboard (only <ESC> to quit)
*)

uses crt, mouse, mouselib;

const
    maxcol = 61;
    maxrow = 25;
    maxfields = 10;
    TESTTOG_R = 4;
    RUN_R = 8;
    STEP_R = 10;
    PAUSE_R = 12;
    BACK_R = 14;
    RESET_R = 16;
    STATUS_R = 20;
    SYSSTATUS_R = 22;
    EXIT_R = 25;

type
    fieldtype = array [0..maxcol+1,0..maxrow+1] of boolean;
    fieldstype = array [0..maxfields] of fieldtype;

var row, col : integer;
    fields   : fieldstype;
    run,
    step,
    test,
    stable   : boolean;
    i,
    gen      : word;

procedure drawfield (field : fieldtype);
var i, j : word;
begin
     textbackground (BROWN);
     for j:= 1 to maxrow do
     begin
          gotoxy (1, j);
          for i:= 1 to maxcol do
            if (field[i,j]) then write (chr (9)) else write (' ');
     end;
end;

procedure draw_act_buttons;
begin
     textbackground (RED);
     gotoxy (62, RUN_R);
     write ('      R U N       ');
     gotoxy (62, PAUSE_R);
     write ('    P A U S E     ');
     gotoxy (62, STEP_R);
     write ('     S T E P      ');
     gotoxy (62, BACK_R);
     write ('     B A C K      ');
     gotoxy (62, RESET_R);
     write ('    R E S E T     ');
end;

procedure put_on_pause;
begin
     draw_act_buttons;
     textbackground (GREEN);
     gotoxy (62, PAUSE_R);
     write ('    P A U S E     ');
end;

procedure init;
var i, j, k : word;
begin
     clrscr;
     run:= false;
     step:= false;
     test:= true;
     stable:= false;
     gen:= 0;
     textbackground (RED);
     gotoxy (62, 1);
     write (' L I F E    1 . 0 ');
     textbackground (BLUE);
     for i:= 2 to 24 do
     begin
          gotoxy (62, i);
          write ('                  ');
     end;
     textbackground (GREEN);
     gotoxy (62, TESTTOG_R);
     write ('  T E S T:  O N   ');
     put_on_pause;
     textbackground (RED);
     gotoxy (62, EXIT_R);
     write ('     E X I T      ');
     textbackground (BLUE);
     gotoxy (62, SYSSTATUS_R);
     write ('Init..');
     for k:= 0 to maxfields do
        for i:= 0 to maxcol+1 do
          for j:= 0 to maxrow+1 do
               fields[k][i,j]:= false;
     drawfield (fields[1]);
     textbackground (BLUE);
     gotoxy (62, SYSSTATUS_R);
     if (not mouse_present) then
        write ('No Mouse! -><ESC>')
     else
        write ('      ');
end;

procedure countneighbors (field : fieldtype; i, j : word; var count : word);
var x, y : word;
begin
     count:= 0;
     for x:= i - 1 to i + 1 do
        for y:= j - 1 to j + 1 do
           if (not ((x = i) and (y = j))) then
              if (field[x,y]) then inc (count);
end;

procedure mutatecel (oldalive : boolean; var newalive : boolean; count : word);
begin
     if (not oldalive) then
     begin
          if (count = 3) then newalive:= true;
     end;
     if (oldalive) then
     begin
          if ((count <= 1) or (count >= 4)) then
             newalive:= false
          else
             newalive:= true;
     end;
end;

procedure generate (var newfield : fieldtype; oldfield : fieldtype);
var i, j, count : word;
begin
     for i:= 0 to maxcol+1 do
     begin
          newfield[i, 0]:= false;
          newfield[i, maxrow+1]:= false;
     end;
     for i:= 0 to maxrow+1 do
     begin
          newfield[0, i]:= false;
          newfield[maxcol+1, i]:= false;
     end;
     for j:= 1 to maxrow do
        for i:= 1 to maxcol do
        begin
             countneighbors (oldfield, i, j, count);
             mutatecel (oldfield[i,j], newfield[i,j], count);
        end;
end;

procedure copy (sourcefield : fieldtype; var destfield : fieldtype);
var i, j : word;
begin
     for i:= 1 to maxcol do
        for j:= 1 to maxrow do
           destfield[i,j]:= sourcefield[i,j];
end;

function equal (field1, field2: fieldtype) : boolean;
var i, j : word;
begin
     equal:= false;
     for i:= 1 to maxcol do
        for j:= 1 to maxrow do
           if (field1[i,j] <> field2[i,j]) then exit;
     equal:= true;
end;

begin
     init;
     repeat
        if (mouse_click (row, col)) then
        begin
             hidemousecursor;
             case col of
             1..maxcol: begin
                             if (row <= maxrow) then
                             begin
                                  if (fields[1][col,row]) then
                                     fields[1][col,row]:= false
                                  else
                                     fields[1][col,row]:= true;
                                  drawfield (fields[1]);
                             end;
                        end;
             62..80: begin
                         case row of
                         TESTTOG_R: if (test) then
                                    begin
                                         test:= false;
                                         textbackground (RED);
                                         gotoxy (62, TESTTOG_R);
                                         write ('  T E S T: O F F  ');
                                    end
                                    else
                                    begin
                                         test:= true;
                                         textbackground (GREEN);
                                         gotoxy (62, TESTTOG_R);
                                         write ('  T E S T:  O N   ');
                                    end;
                         RUN_R: begin
                                     run:= true;
                                     draw_act_buttons;
                                     textbackground (GREEN);
                                     gotoxy (62, RUN_R);
                                     write ('      R U N       ');
                                end;
                         PAUSE_R: begin
                                       run:= false;
                                       put_on_pause;
                                  end;
                         STEP_R: begin
                                      step:= true;
                                      draw_act_buttons;
                                      textbackground (GREEN);
                                      gotoxy (62, STEP_R);
                                      write ('     S T E P      ');
                                 end;
                         BACK_R: begin
                                      draw_act_buttons;
                                      textbackground (GREEN);
                                      gotoxy (62, BACK_R);
                                      write ('     B A C K      ');
                                      if (gen >= 1) then
                                      begin
                                           textbackground (BLUE);
                                           gotoxy (62, SYSSTATUS_R);
                                           write ('                  ');
                                           gotoxy (62, SYSSTATUS_R);
                                           write ('Shift..');
                                           for i:= 1 to maxfields - 1 do
                                              copy (fields[i+1], fields[i]);
                                           drawfield (fields[1]);
                                           dec (gen);
                                           textbackground (BLUE);
                                           gotoxy (62, SYSSTATUS_R);
                                           write ('                  ');
                                           gotoxy (62, STATUS_R);
                                           write ('Gen: ', gen, '  ');
                                      end;
                                      put_on_pause;
                                 end;
                         RESET_R: begin
                                       textbackground (GREEN);
                                       gotoxy (62, RESET_R);
                                       write ('    R E S E T     ');
                                       init;
                                  end;
                         EXIT_R: begin
                                      clrscr;
                                      halt (0);
                                 end;
                         end;
                     end;
             end;
        end;
        showmousecursor;
        if (run) or (step) then
        begin
             textbackground (BLUE);
             gotoxy (62, SYSSTATUS_R);
             write ('                  ');
             gotoxy (62, SYSSTATUS_R);
             write ('Working..');

             generate (fields[0], fields[1]);

             gotoxy (62, SYSSTATUS_R);
             write ('Shift..  ');
             for i:= maxfields - 1 downto 0 do
                copy (fields[i], fields[i+1]);

             stable:= false;
             if (test) then
             begin
                  gotoxy (62, SYSSTATUS_R);
                  write ('Test.. ');
                  for i:= 2 to maxfields do
                     if equal (fields[1], fields[i]) then
                     begin
                          run:= false;
                          stable:= true;
                          gotoxy (62, SYSSTATUS_R);
                          write ('Stable period ', i - 1);
                          put_on_pause;
                          break;
                     end;
             end;

             drawfield (fields[1]);

             inc (gen);
             textbackground (BLUE);
             if (not stable) then
             begin
                  gotoxy (62, SYSSTATUS_R);
                  write ('                  ');
             end;
             gotoxy (62, STATUS_R);
             write ('Gen: ', gen, '  ');
             if step then
             begin
                  put_on_pause;
                  step:= false;
             end;
        end;
     until (keypressed) and (readkey = chr (27));
     clrscr;
end.
