program vgalife;

uses crt, graph, bgidriv, vgamouse;

const
  menuwidth = 100;
  ALIVE = #1;
  DEAD = #2;
  CELL_Y = 41;
  ALIVE_Y = 55;
  GEN_Y = 80;
  STAT_Y = 95;
  METER_TOP = 115;
  METER_BOT = 205;

type
  fieldtype = array [0..482] of pchar;

var
  menucenterx,
  cellwidth,
  gen,
  maxrow,
  maxcol: word;
  ncells: longint;
  field: fieldtype;
  newfield: fieldtype;
  ofile: text;

procedure abort (msg: string);
begin
  writeln ('error: ' + msg);
  halt (1);
end;

procedure status_msg (msg: string; y: word);
begin
  setfillstyle (SOLIDFILL, BROWN);
  bar (getmaxx - menuwidth + 2, y, getmaxx, y + textheight ('a'));
  setcolor (LIGHTGREEN);
  outtextxy (menucenterx, y, msg);
end;

procedure init;
var
  driver, mode : integer;
  msg : string;
  i, j: word;
begin
  assign (ofile, 'vgalife.dat');
  detectgraph (driver, mode);
  case driver of
     CGA :
     if registerbgidriver(@cgadriverproc) < 0 then abort ('CGA not supported');
     MCGA..EGAMono, VGA :
     if registerbgidriver(@egavgadriverproc) < 0 then abort ('EGA/VGA not supported');
     IBM8514, HercMono :
     if registerbgidriver(@hercdriverproc) < 0 then abort ('Hercules not supported');
     ATT400 :
     if registerbgidriver(@attdriverproc) < 0 then abort ('ATT not supported');
     PC3270 :
     if registerbgidriver(@pc3270driverproc) < 0 then abort ('PC3270 not supported');
     else abort ('Graphics driver is not supported...');
  end;
  if (driver <> VGA) then
  begin
    writeln ('warning: Your graphics card is supported, but the mode is untested!');
    writeln ('         Press any key to try graphics mode...');
    repeat until keypressed;
  end;

  initgraph(driver, mode, '');
  init_mouse;
  menucenterx:= getmaxx - (menuwidth div 2);

  if (graphresult < 0) then abort ('Graphics driver could not be initialized');
  setfillstyle (SOLIDFILL, BLUE);
  bar (1, 1, getmaxx - menuwidth + 1, getmaxy);
  setfillstyle (SOLIDFILL, BROWN);
  bar (getmaxx - menuwidth + 2, 1, getmaxx, getmaxy);
  setcolor (BLUE);
  line ((getmaxx - menuwidth) + 1, METER_TOP - 1, getmaxx, METER_TOP - 1);
  line ((getmaxx - menuwidth) + 1, METER_BOT + 1, getmaxx, METER_BOT + 1);
  setfillstyle (SOLIDFILL, RED);
  bar (getmaxx - menuwidth + 3, getmaxy - 255, getmaxx - 1, getmaxy - 235);
  bar (getmaxx - menuwidth + 3, getmaxy - 225, getmaxx - 1, getmaxy - 205);
  bar (getmaxx - menuwidth + 3, getmaxy - 195, getmaxx - 1, getmaxy - 175);
  bar (getmaxx - menuwidth + 3, getmaxy - 165, getmaxx - 1, getmaxy - 145);
  bar (getmaxx - menuwidth + 3, getmaxy - 135, getmaxx - 1, getmaxy - 115);
  bar (getmaxx - menuwidth + 3, getmaxy - 105, getmaxx - 1, getmaxy - 85);
  bar (getmaxx - menuwidth + 3, getmaxy - 75, getmaxx - 1, getmaxy - 55);
  bar (getmaxx - menuwidth + 3, getmaxy - 30, getmaxx - 1, getmaxy - 1);
  setcolor (LIGHTRED);
  settextstyle (triplexfont, horizdir, 1);
  settextjustify (centertext, toptext);
  outtextxy (menucenterx, 10, 'LIFE 1.0b');
  status_msg ('init..', STAT_Y);
  setcolor (LIGHTGREEN);
  outtextxy (menucenterx, getmaxy - 249, 'LOAD');
  outtextxy (menucenterx, getmaxy - 219, 'SAVE');
  outtextxy (menucenterx, getmaxy - 189, 'RUN');
  outtextxy (menucenterx, getmaxy - 159, 'STEP');
  outtextxy (menucenterx, getmaxy - 129, 'BREAK');
  outtextxy (menucenterx, getmaxy - 99, 'RANDOM');
  outtextxy (menucenterx, getmaxy - 69, 'RESET');
  outtextxy (menucenterx, getmaxy - 19, 'EXIT');
  val (paramstr (1), i, mode);
  if (mode <> 0) or (i <= 0) then i:= 10;
  cellwidth:= i;
  maxcol:= ((getmaxx - menuwidth) div cellwidth) + 1;
  maxrow:= (getmaxy div cellwidth) + 1;
  ncells:= (((getmaxx - menuwidth) div cellwidth) + 1) * ((getmaxy div cellwidth) + 1);
  for j:= 0 to maxrow + 1 do
  begin
    if (maxavail < maxcol * 2 + 100) then
    begin
      closegraph;
      writeln ('error: too many cells wanted, memory exhausted..');
      halt (0);
    end;
    getmem (field[j], maxcol + 3);
    getmem (newfield[j], maxcol + 3);
    for i:= 0 to maxcol + 1 do
    begin
      field[j][i]:= DEAD;
      newfield[j][i]:= DEAD;
    end;
  end;
  setcolor (LIGHTRED);
  str (ncells, msg);
  status_msg (msg + ' cells', CELL_Y);
  status_msg ('gen 0', GEN_Y);
  status_msg ('ready..', STAT_Y);
  gen:= 0;
end;

procedure countneighbors (l1, l2, l3: pchar; x, y : word; var count : word);
begin
  count:= 0;

  if (l1[x - 1] = ALIVE) then inc (count);
  if (l1[x] = ALIVE) then inc (count);
  if (l1[x + 1] = ALIVE) then inc (count);

  if (l2[x - 1] = ALIVE) then inc (count);
  if (l2[x + 1] = ALIVE) then inc (count);

  if (l3[x - 1] = ALIVE) then inc (count);
  if (l3[x] = ALIVE) then inc (count);
  if (l3[x + 1] = ALIVE) then inc (count);

end;

procedure mutatecel (oldcell : char; var newcell : char; count : word);
begin
  if (oldcell = DEAD) then
  begin
    if (count = 3) then newcell:= ALIVE;
    exit;
  end;
  if ((count <= 1) or (count >= 4)) then
    newcell:= DEAD
  else
    newcell:= ALIVE;
end;

function generate (var newfield : fieldtype; oldfield : fieldtype; really : boolean): boolean;
var
  x, y, i, j, count : word;
  alive_count: longint;
  msg: string;
  p: pointer;
  oldline, newline: pchar;
  maxx, maxy, tx, ty: word;
begin
  generate:= false;
  setcolor (GREEN);
  outtextxy (menucenterx, getmaxy - 249, 'LOAD');
  outtextxy (menucenterx, getmaxy - 219, 'SAVE');
  outtextxy (menucenterx, getmaxy - 189, 'RUN');
  outtextxy (menucenterx, getmaxy - 159, 'STEP');
  outtextxy (menucenterx, getmaxy - 99, 'RANDOM');
  outtextxy (menucenterx, getmaxy - 69, 'RESET');
  outtextxy (menucenterx, getmaxy - 19, 'EXIT');

  status_msg ('working..', STAT_Y);
  setcolor (LIGHTGREEN);
  alive_count:= 0;
  y:= cellwidth;
  ty:= 1;
  maxy:= maxrow * cellwidth;
  maxx:= maxcol * cellwidth;



  while (y <= maxy) do
  begin
    x:= cellwidth;
    tx:= 1;
    if mouse_click (j, i) and
      (i > getmaxx - menuwidth - 3) and
      ((j > (getmaxy - 135)) and (j < (getmaxy - 115))) then exit;
    oldline:= oldfield[ty];
    newline:= newfield[ty];
    oldline[maxcol + 1]:= oldline[1];
    oldline[0]:= oldline[maxcol];

    while (x <= maxx) do
    begin
      if not really then
      begin
        if (oldline[tx] = ALIVE) then
        begin
          inc (alive_count);
          setfillstyle (SOLIDFILL, YELLOW);
        end
        else
          setfillstyle (SOLIDFILL, BLUE);
      end
      else
      begin
        countneighbors (oldfield[ty - 1], oldline, oldfield[ty + 1], tx, ty, count);
        mutatecel (oldline[tx], newline[tx], count);
        if (newline[tx] = ALIVE) then
        begin
          inc (alive_count);
          setfillstyle (SOLIDFILL, YELLOW);
        end
        else
          setfillstyle (SOLIDFILL, BLUE);
      end;


      bar (x - cellwidth, y - cellwidth, x - 1, y - 1);

      inc (x, cellwidth);
      inc (tx);
    end;

    newline[0]:= newline[maxcol];
    newline[maxcol + 1]:= newline[1];
    line ((getmaxx - menuwidth) + 1, y - cellwidth, (getmaxx - menuwidth) + 1, y);
    inc (y, cellwidth);
    inc (ty);
  end;
  setcolor (BROWN);
  line ((getmaxx - menuwidth) + 1, 0, (getmaxx - menuwidth) + 1, getmaxy);
  str (alive_count, msg);
  status_msg (msg + ' alive', ALIVE_Y);

  setfillstyle (SOLIDFILL, BROWN);
  setcolor (YELLOW);
  getmem (p, imagesize ((getmaxx - menuwidth) + 3, METER_TOP, getmaxx, METER_BOT));
  getimage ((getmaxx - menuwidth) + 3, METER_TOP, getmaxx, METER_BOT, p^);
  bar ((getmaxx - menuwidth) + 2, METER_TOP, getmaxx, METER_BOT);
  putimage ((getmaxx - menuwidth) + 2, METER_TOP, p^, OrPut);
  freemem (p, imagesize ((getmaxx - menuwidth) + 3, METER_TOP, getmaxx, METER_BOT));
  if (alive_count / ncells) > 0 then
    line (getmaxx, METER_BOT - 1, getmaxx, round (METER_BOT - ((METER_BOT - METER_TOP) *
    (alive_count / ncells))));

  status_msg ('ready..', STAT_Y);
  generate:= true;
end;

procedure copy (sourcefield : fieldtype; var destfield : fieldtype);
var i, j : word;
begin
     for j:= 1 to maxrow do
      for i:= 1 to maxcol do
           destfield[j][i]:= sourcefield[j][i];
end;

procedure highlight_but;
begin
  setcolor (LIGHTGREEN);
  outtextxy (menucenterx, getmaxy - 249, 'LOAD');
  outtextxy (menucenterx, getmaxy - 219, 'SAVE');
  outtextxy (menucenterx, getmaxy - 189, 'RUN');
  outtextxy (menucenterx, getmaxy - 159, 'STEP');
  outtextxy (menucenterx, getmaxy - 99, 'RANDOM');
  outtextxy (menucenterx, getmaxy - 69, 'RESET');
  outtextxy (menucenterx, getmaxy - 19, 'EXIT');
end;

procedure event_handle;
var
  run, step, again: boolean;
  i, j, x, y: word;
  msg: string;
begin
  again:= true;
  run:= false;
  step:= false;
  repeat
    if mouse_click (y, x) then
    begin
      if (x < getmaxx - menuwidth - 2) then
      begin
        hide_mouse;
        inc (x, cellwidth);
        inc (y, cellwidth);
        if (field[y div cellwidth][x div cellwidth]) = DEAD then
        begin
          field[y div cellwidth][x div cellwidth]:= ALIVE;
          setfillstyle (SOLIDFILL, YELLOW);
        end
        else
        begin
          field[y div cellwidth][x div cellwidth]:= DEAD;
          setfillstyle (SOLIDFILL, BLUE);
        end;
        bar (x - (x mod cellwidth) - cellwidth, y - (y mod cellwidth) - cellwidth,
             x - (x mod cellwidth) - 1, y - (y mod cellwidth) - 1);
      end
      else
      begin
        if (y > (getmaxy - 255)) and (y < (getmaxy - 235)) then
        begin
          status_msg ('loading..', STAT_Y);
          {$I-}
          reset (ofile);
          if (ioresult <> 0) then status_msg ('no file..', STAT_Y) else
          begin
            for j:= 1 to maxrow do
              for i:= 1 to maxcol do read (ofile, field[j][i]);
            close (ofile);
            run:= false;
            gen:= 0;
            status_msg ('gen 0', GEN_Y);
            if not generate (newfield, field, false) then
            begin
              run:= false;
              step:= false;
              highlight_but;
              continue;
            end;
            highlight_but;
          end;
          {$I+}
        end;
        if (y > (getmaxy - 225)) and (y < (getmaxy - 205)) then
        begin
          status_msg ('saving..', STAT_Y);
          rewrite (ofile);
          for j:= 1 to maxrow do
            for i:= 1 to maxcol do write (ofile, field[j][i]);
          close (ofile);
          status_msg('ready..', STAT_Y);
        end;
        if (y > (getmaxy - 195)) and (y < (getmaxy - 175)) then run:= true;
        if (y > (getmaxy - 165)) and (y < (getmaxy - 145)) then step:= true;
        if (y > (getmaxy - 135)) and (y < (getmaxy - 115)) then run:= false;
        if (y > (getmaxy - 105)) and (y < (getmaxy - 85)) then
        begin
          run:= false;
          gen:= 0;
          status_msg ('gen 0', GEN_Y);
          status_msg ('randomize..', STAT_Y);
          for j:= 1 to maxrow do
            for i:= 1 to maxcol do
            begin
              if random (2) = 0 then
              begin
                field[j][i]:= DEAD;
                newfield[j][i]:= DEAD;
              end
              else
              begin
                field[j][i]:= ALIVE;
                newfield[j][i]:= ALIVE;
              end;
            end;
          if not generate (newfield, field, false) then
          begin
            run:= false;
            step:= false;
            highlight_but;
            continue;
          end;
          highlight_but;
        end;
        if (y > (getmaxy - 75)) and (y < (getmaxy - 55)) then
        begin
          run:= false;
          gen:= 0;
          status_msg ('gen 0', GEN_Y);
          for j:= 1 to maxrow do
            for i:= 1 to maxcol do
            begin
              field[j][i]:= DEAD;
              newfield[j][i]:= DEAD;
            end;
          if not generate (newfield, field, false) then
          begin
            run:= false;
            step:= false;
            highlight_but;
            continue;
          end;
          highlight_but;
        end;
        if (y > (getmaxy - 30)) then begin run:= false; again:= false; end;
      end;
    end;
    if (run or step) then
    begin
      if not generate (newfield, field, true) then
      begin
        highlight_but;
        run:= false;
        step:= false;
        continue;
      end;
      copy (newfield, field);
      inc (gen);
      str (gen, msg);
      status_msg ('gen ' + msg, GEN_Y);
      if step then
      begin
        step:= false;
        highlight_but;
      end;
    end;
    if keypressed and (readkey = #27) then again:= false;
    show_mouse;
  until not again;
end;

begin
  init;
  event_handle;
  closegraph;
end.
