unit vgamouse;

interface

uses mouselib;

procedure init_mouse;
function mouse_click (var row, col : word) : boolean;
function mouse_press (var row, col : word) : boolean;
procedure hide_mouse;
procedure show_mouse;

implementation

var
   released : boolean;

procedure init_mouse;
begin
  if not (mouse_present) then
  begin
    writeln ('You need to have a mouse installed.. sorry');
    halt (0);
  end;
  setmousegraph;
  initmouse;
  showmousecursor;
  released:= true;
end;

procedure hide_mouse;
begin
  hidemousecursor;
end;

procedure show_mouse;
begin
  showmousecursor;
end;

function mouse_press (var row, col : word) : boolean;
begin
    if (getbutton (leftbutton) = buttondown) then
    begin
         row:= getmousey;
         col:= getmousex;
         released:= false;
         mouse_press:= true;
    end
    else mouse_press:= false;
end;

function mouse_click (var row, col : word) : boolean;
begin
     mouse_click:= false;
     if (not mouse_present) then exit;
     if (not released) and (getbutton (leftbutton) = buttonup) then
        released:= true;
     if released and (mouse_press (row, col)) then
        mouse_click:= true;
end;

end.     
