//===========================================================================
//
// File: shellex.h
//
// Purpose:
//   This file provide function and structure declarations for some of the
//   undocumented functions in SHELL32.DLL. For more details on how to use
//   these functions and the latest copy of this file, visit the following
//   website - http://www.geocities.com/SiliconValley/4942/
//
// Notes:
//   * Certain functions included in this file are only available on NT. For
//     these functions there are two sets of prototypes - a function pointer
//     typedef for run-time linking with GetProcAddress, and a standard
//     function declaration that can be used in explicit function calls
//     (i.e. load-time linking). If you intend your application to run on
//     Windows 95 as well as Windows NT, you should always use run-time
//     linking. If your application is only intended for use on NT you can
//     make use of the standard function declarations by #defining NTONLY.
//  *  Most undocumented functions do not provide separate ansi and unicode
//     implementations - Windows 95 will typically only have an ansi imple-
//     mentation and Windows NT will only have the unicode implementation.
//     So, wherever you see a function parameter of type LPCSTR or LPSTR, you
//     will actually have to provide an LPCWSTR or LPWSTR when using the
//     function on NT. In the rare cases that do have both ansi and unicode
//     implementations this obviously doesn't apply, however, the unicode
//     version will usually only exist on Windows NT so you should always use
//     run-time linking as explained above.
//
//===========================================================================

#ifndef _INC_SHELLEX
#define _INC_SHELLEX

//
// Define API decoration for direct importing of DLL references.
//
#ifndef WINSHELLAPI
#if !defined(_SHELL32_)
#define WINSHELLAPI DECLSPEC_IMPORT
#else
#define WINSHELLAPI
#endif
#endif // WINSHELLAPI

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif // __cplusplus

//===========================================================================
//
// Shell Common Dialogs
//
//===========================================================================

WINSHELLAPI BOOL WINAPI PickIconDlg(HWND hwndOwner, LPSTR lpstrFile, 
  DWORD nMaxFile, LPDWORD lpdwIconIndex);

// RunFileDlg flags 
#define RFF_NOBROWSE       0x01 
#define RFF_NODEFAULT      0x02
#define RFF_CALCDIRECTORY  0x04
#define RFF_NOLABEL        0x08
#define RFF_NOSEPARATEMEM  0x20  // NT only

// RunFileFlg notification structure
typedef struct {
  NMHDR   hdr;
  LPCSTR  lpFile;
  LPCSTR  lpDirectory; 
  int     nShow;
} NM_RUNFILEDLG, * LPNM_RUNFILEDLG;

// RunFileDlg notification return values
#define RF_OK      0x00
#define RF_CANCEL  0x01
#define RF_RETRY   0x02

WINSHELLAPI void WINAPI RunFileDlg(HWND hwndOwner, HICON hIcon,
  LPCSTR lpstrDirectory, LPCSTR lpstrTitle, LPCSTR lpstrDescription, 
  UINT uFlags);

WINSHELLAPI void WINAPI ExitWindowsDialog(HWND hwndOwner);
   
WINSHELLAPI int WINAPI RestartDialog(HWND hwndOwner, LPCSTR lpstrReason, 
  UINT uFlags); 

WINSHELLAPI BOOL WINAPI GetFileNameFromBrowse(HWND hwndOwner,
  LPSTR lpstrFile, DWORD nMaxFile, LPCSTR lpstrInitialDir,
  LPCSTR lpstrDefExt, LPCSTR lpstrFilter, LPCSTR lpstrTitle);

WINSHELLAPI BOOL WINAPI SHFindFiles(LPCITEMIDLIST pidlRoot,
  LPCITEMIDLIST pidlSavedSearch);
   
WINSHELLAPI BOOL WINAPI SHFindComputer(LPCITEMIDLIST pidlRoot,
  LPCITEMIDLIST pidlSavedSearch);
 
// SHObjectProperties flags
#define OPF_PRINTERNAME  0x01
#define OPF_PATHNAME     0x02

WINSHELLAPI BOOL WINAPI SHObjectProperties(HWND hwndOwner, UINT uFlags,
  LPCSTR lpstrName, LPCSTR lpstrParameters);

WINSHELLAPI void WINAPI SHHandleDiskFull(HWND hwndOwner, UINT uDrive);

WINSHELLAPI int WINAPI SHOutOfMemoryMessageBox(HWND hwndOwner, 
  LPCSTR lpCaption, UINT uType);

WINSHELLAPI DWORD WINAPI SHNetConnectionDialog(HWND hwndOwner, 
  LPCSTR lpstrRemoteName, DWORD dwType);

WINSHELLAPI int WINAPIV ShellMessageBoxA(HINSTANCE hInstance, HWND hWnd, 
  LPCSTR lpText, LPCSTR lpCaption, UINT uType, ...);

#ifdef NTONLY
WINSHELLAPI int WINAPIV ShellMessageBoxW(HINSTANCE hInstance, HWND hWnd, 
  LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, ...);
#else
typedef int (WINAPIV * LPFNSHELLMESSAGEBOXW)(HINSTANCE, HWND, LPCWSTR, 
  LPCWSTR, UINT, ...);
#endif // !NTONLY

#ifdef UNICODE
#define ShellMessageBox  ShellMessageBoxW
#else
#define ShellMessageBox  ShellMessageBoxA
#endif // !UNICODE

//===========================================================================
//
// Shell Memory Routines
//
//===========================================================================

WINSHELLAPI LPVOID WINAPI SHAlloc(ULONG cb);

WINSHELLAPI void WINAPI SHFree(LPVOID pv);

#ifdef NTONLY

WINSHELLAPI HANDLE WINAPI SHAllocShared(LPVOID pv, ULONG cb, DWORD pid);

WINSHELLAPI BOOL WINAPI SHFreeShared(HANDLE hMem, DWORD pid);

WINSHELLAPI LPVOID WINAPI SHLockShared(HANDLE hMem, DWORD pid);

WINSHELLAPI BOOL WINAPI SHUnlockShared(LPVOID pv);

#else

typedef HANDLE (WINAPI * LPFNSHALLOCSHARED)(LPVOID, ULONG, DWORD);

typedef BOOL (WINAPI * LPFNSHFREESHARED)(HANDLE, DWORD);

typedef LPVOID (WINAPI * LPFNSHLOCKSHARED)(HANDLE, DWORD);

typedef BOOL (WINAPI * LPFNSHUNLOCKSHARED)(LPVOID);

#endif // !NTONLY

//===========================================================================
//
// PIDL Manipulation Routines
//
//===========================================================================

WINSHELLAPI HRESULT WINAPI SHILCreateFromPath(LPCSTR lpszPath,
  LPITEMIDLIST *ppidl, ULONG *pdwAttributes);

WINSHELLAPI LPITEMIDLIST WINAPI ILCreateFromPath(LPCSTR lpszPath);

WINSHELLAPI LPITEMIDLIST WINAPI SHSimpleIDListFromPath(LPCSTR lpszPath);

WINSHELLAPI void WINAPI ILFree(LPCITEMIDLIST pidl);

WINSHELLAPI BOOL WINAPI ILGetDisplayName(LPCITEMIDLIST pidl, LPSTR lpszName);

WINSHELLAPI UINT WINAPI ILGetSize(LPCITEMIDLIST pidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILGetNext(LPCITEMIDLIST pidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILFindLastID(LPCITEMIDLIST pidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILFindChild(LPCITEMIDLIST pidlParent,
  LPCITEMIDLIST pidlChild);

WINSHELLAPI LPITEMIDLIST WINAPI ILClone(LPCITEMIDLIST pidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILCloneFirst(LPCITEMIDLIST pidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILCombine(LPCITEMIDLIST pidl1,
  LPCITEMIDLIST pidl2);

WINSHELLAPI LPITEMIDLIST WINAPI ILAppendID(LPITEMIDLIST pidl,
  LPCSHITEMID lpItemID, BOOL bAddToEnd);

WINSHELLAPI BOOL WINAPI ILRemoveLastID(LPITEMIDLIST pidl);

WINSHELLAPI BOOL WINAPI ILIsEqual(LPCITEMIDLIST pidl1, LPCITEMIDLIST pidl2);

WINSHELLAPI BOOL WINAPI ILIsParent(LPCITEMIDLIST pidlParent,
  LPCITEMIDLIST pidlChild, BOOL bImmediate);

WINSHELLAPI HRESULT WINAPI ILSaveToStream(LPSTREAM pstrm,
  LPCITEMIDLIST pidl);

WINSHELLAPI HRESULT WINAPI ILLoadFromStream(LPSTREAM pstrm,
  LPITEMIDLIST *ppidl);

WINSHELLAPI LPITEMIDLIST WINAPI ILGlobalClone(LPCITEMIDLIST pidl);

WINSHELLAPI void WINAPI ILGlobalFree(LPCITEMIDLIST pidl);

//===========================================================================
//
// Shell Notifications
//
//===========================================================================

// SHChangeNotifyRegister flags
#define SHCNF_ACCEPT_INTERRUPTS      0x0001 
#define SHCNF_ACCEPT_NON_INTERRUPTS  0x0002 
#define SHCNF_NO_PROXY               0x8000  // NT only

// SHChangeNotifyRegister structure
typedef struct {
  LPCITEMIDLIST  pidlPath;
  BOOL           bWatchSubtree;
} NOTIFYREGISTER, * LPNOTIFYREGISTER;
typedef const NOTIFYREGISTER * LPCNOTIFYREGISTER;

WINSHELLAPI HANDLE WINAPI SHChangeNotifyRegister(HWND hWnd, DWORD dwFlags, 
  LONG wEventMask, UINT uMsg, DWORD cItems, LPCNOTIFYREGISTER lpItems); 
 
WINSHELLAPI BOOL WINAPI SHChangeNotifyDeregister(HANDLE hNotify);

// DWORD item id structure
typedef struct {
  USHORT cb;
  DWORD  dwItem1;
  DWORD  dwItem2;
} DWORDITEMID;

#ifdef NTONLY

WINSHELLAPI HANDLE WINAPI SHChangeNotification_Lock(HANDLE hMemoryMap, 
  DWORD dwProcessId, LPCITEMIDLIST **lppidls, LPLONG lpwEventId);

WINSHELLAPI BOOL WINAPI SHChangeNotification_Unlock(HANDLE hLock); 

#else

typedef HANDLE (WINAPI * LPFNSHCHANGENOTIFICATION_LOCK)(HANDLE, DWORD, 
  LPCITEMIDLIST**, LPLONG);

typedef BOOL (WINAPI * LPFNSHCHANGENOTIFICATION_UNLOCK)(HANDLE);

#endif // !NTONLY

//===========================================================================
//
// Cabinet Window Messages
//
//===========================================================================

#define CWM_SETPATH           (WM_USER + 2)
#define CWM_SELECTITEM        (WM_USER + 5)
#define CWM_SELECTITEMSTR     (WM_USER + 6)
#define CWM_GETISHELLBROWSER  (WM_USER + 7)
#define CWM_TESTPATH          (WM_USER + 9)
#define CWM_STATECHANGE       (WM_USER + 10)
#define CWM_GETPATH           (WM_USER + 12)

// CWM_TESTPATH types
#define CWTP_ISEQUAL  0 
#define CWTP_ISCHILD  1 

// CWM_TESTPATH structure
typedef struct {
  DWORD dwType;
  ITEMIDLIST idl;
} CWTESTPATHSTRUCT, * LPCWTESTPATHSTRUCT;

//===========================================================================
//
// System Imagelist Routines
//
//===========================================================================

WINSHELLAPI int WINAPI Shell_GetCachedImageIndex(LPCSTR lpszFileName, 
  UINT nIconIndex, BOOL bSimulateDoc);

WINSHELLAPI BOOL WINAPI Shell_GetImageLists(HIMAGELIST *lphimlLarge, 
  HIMAGELIST *lphimlSmall);

WINSHELLAPI HICON WINAPI SHGetFileIcon(DWORD dwReserved, LPCSTR lpszPath, 
  DWORD dwFileAttributes, UINT uFlags);

WINSHELLAPI int WINAPI SHMapPIDLToSystemImageListIndex(LPSHELLFOLDER psf, 
  LPCITEMIDLIST pidl, int *pOpenIndex);

#ifdef NTONLY
WINSHELLAPI BOOL WINAPI FileIconInit(BOOL bFullInit);
#else
typedef BOOL (WINAPI * LPFNFILEICONINIT)(BOOL);
#endif // !NTONLY

//===========================================================================
//
// File Menu Routines
//
//===========================================================================

// FileMenu_Create nSelHeight constants
#define FM_DEFAULT_SELHEIGHT  -1
#define FM_FULL_SELHEIGHT     0

// FileMenu_Create flags
#define FMF_SMALL_ICONS      0x00
#define FMF_LARGE_ICONS      0x08
#define FMF_NO_COLUMN_BREAK  0x10

WINSHELLAPI HMENU WINAPI FileMenu_Create(COLORREF crBorderColor, 
  int nBorderWidth, HBITMAP hBorderBmp, int nSelHeight, UINT uFlags);

WINSHELLAPI void WINAPI FileMenu_Destroy(HMENU hMenu);

// FileMenu_AppendItem constants
#define FM_SEPARATOR       (LPCSTR)1
#define FM_BLANK_ICON      -1
#define FM_DEFAULT_HEIGHT  0

WINSHELLAPI BOOL WINAPI FileMenu_AppendItem(HMENU hMenu, LPCSTR lpszText, 
  UINT uID, int iIcon, HMENU hMenuPopup, int nItemHeight);

// FileMenu_InsertUsingPidl flags
#define FMF_NO_EMPTY_ITEM      0x01
#define FMF_NO_PROGRAM_GROUPS  0x04

// FileMenu_InsertUsingPidl callback function
typedef void (CALLBACK *LPFNFMCALLBACK)(LPCITEMIDLIST pidlFolder, 
  LPCITEMIDLIST pidlFile);

WINSHELLAPI int WINAPI FileMenu_InsertUsingPidl(HMENU hMenu, UINT uID, 
  LPCITEMIDLIST pidl, UINT uFlags, UINT uEnumFlags, 
  LPFNFMCALLBACK lpfnCallback);

WINSHELLAPI int WINAPI FileMenu_ReplaceUsingPidl(HMENU hMenu, UINT uID,
  LPCITEMIDLIST pidl, UINT uEnumFlags, LPFNFMCALLBACK lpfnCallback);

WINSHELLAPI void WINAPI FileMenu_Invalidate(HMENU hMenu);

WINSHELLAPI HMENU WINAPI FileMenu_FindSubMenuByPidl(HMENU hMenu,
  LPCITEMIDLIST pidl);

WINSHELLAPI BOOL WINAPI FileMenu_TrackPopupMenuEx(HMENU hMenu, UINT uFlags,
  int x, int y, HWND hWnd, LPTPMPARAMS lptpm);

WINSHELLAPI BOOL WINAPI FileMenu_GetLastSelectedItemPidls(UINT uReserved,
  LPITEMIDLIST *ppidlFolder, LPITEMIDLIST *ppidlItem);

WINSHELLAPI LRESULT WINAPI FileMenu_MeasureItem(HWND hWnd, 
  LPMEASUREITEMSTRUCT lpmis);

WINSHELLAPI LRESULT WINAPI FileMenu_DrawItem(HWND hWnd, 
  LPDRAWITEMSTRUCT lpdis);

WINSHELLAPI BOOL WINAPI FileMenu_InitMenuPopup(HMENU hMenu);

WINSHELLAPI void WINAPI FileMenu_AbortInitMenu();

WINSHELLAPI LRESULT WINAPI FileMenu_HandleMenuChar(HMENU hMenu, 
  WPARAM wParam);

WINSHELLAPI BOOL WINAPI FileMenu_DeleteAllItems(HMENU hMenu);

WINSHELLAPI BOOL WINAPI FileMenu_DeleteItemByCmd(HMENU hMenu, UINT uID);

WINSHELLAPI BOOL WINAPI FileMenu_DeleteItemByIndex(HMENU hMenu, UINT uPos);

WINSHELLAPI BOOL WINAPI FileMenu_DeleteMenuItemByFirstID(HMENU hMenu, 
  UINT uID);

WINSHELLAPI BOOL WINAPI FileMenu_DeleteSeparator(HMENU hMenu);

WINSHELLAPI BOOL WINAPI FileMenu_EnableItemByCmd(HMENU hMenu, UINT uID, 
  BOOL bEnable);

WINSHELLAPI DWORD WINAPI FileMenu_GetItemExtent(HMENU hMenu, UINT uPos);

#ifdef NTONLY

WINSHELLAPI int WINAPI FileMenu_AppendFilesForPidl(HMENU hMenu, 
  LPCITEMIDLIST pidl, BOOL bAddSeparator);

WINSHELLAPI int WINAPI FileMenu_AddFilesForPidl(HMENU hMenu, UINT uReserved, 
  UINT uID, LPCITEMIDLIST pidl, UINT uFlags, UINT uEnumFlags, 
  LPFNFMCALLBACK lpfnCallback);

#else

typedef int (WINAPI * LPFNFILEMENU_APPENDFILESFORPIDL)(HMENU, 
  LPCITEMIDLIST, BOOL);

typedef int (WINAPI * LPFNFILEMENU_ADDFILESFORPIDL)(HMENU, UINT, UINT, 
  LPCITEMIDLIST, UINT, UINT, LPFNFMCALLBACK);

#endif // !NTONLY

//===========================================================================
//
// Shell Settings
//
//===========================================================================

// SHGetSetSettings structure
typedef struct {
  BOOL fShowAllObjects : 1;
  BOOL fShowExtensions : 1;
  BOOL fNoConfirmRecycle : 1;
  BOOL fShowSysFiles : 1;            // Win98 only
  BOOL fShowCompColor : 1;           // Win98 only
  BOOL fDoubleClickInWebView : 1;    // Win98 only
  BOOL fDesktopHTML : 1;             // Win98 only
  BOOL fWin95Classic : 1;            // Win98 only
  BOOL fDontPrettyPath : 1;          // Win98 only
  BOOL fShowAttribCol : 1;           // Win98 only
  BOOL fMapNetDrvBtn : 1;            // Win98 only
  BOOL fShowInfoTip : 1;             // Win98 only
  BOOL fHideIcons : 1;               // Win98 only
  UINT fRestFlags : 19;
  LPSTR lpszExcludeFileExts;
  DWORD cbBufferSize;
  DWORD Unknown1;                    // Win98 only
  DWORD Unknown2;                    // Win98 only
} SHELLSTATE, * LPSHELLSTATE;
#define fShowCompColorNT fShowSysFiles // NT & Win98 overlap

#define SSF_SHOWALLOBJECTS       0x0001
#define SSF_SHOWEXTENSIONS       0x0002
#define SSF_EXCLUDEFILEEXTS      0x0004
#define SSF_SHOWCOMPCOLOR        0x0008
#define SSF_UNKNOWN              0x0010
#define SSF_SHOWSYSFILES         0x0020
#define SSF_DOUBLECLICKINWEBVIEW 0x0080
#define SSF_SHOWATTRIBCOL        0x0100
#define SSF_DESKTOPHTML          0x0200
#define SSF_WIN95CLASSIC         0x0400
#define SSF_DONTPRETTYPATH       0x0800
#define SSF_MAPNETDRVBTN         0x1000
#define SSF_SHOWINFOTIP          0x2000
#define SSF_HIDEICONS            0x4000
#define SSF_NOCONFIRMRECYCLE     0x8000

WINSHELLAPI void WINAPI SHGetSetSettings(LPSHELLSTATE lpss, DWORD dwMask, 
  BOOL bSet);

//===========================================================================
//
// Drag And Drop Routines
//
//===========================================================================

WINSHELLAPI HRESULT WINAPI SHLoadOLE(DWORD dwFlags);

WINSHELLAPI HRESULT WINAPI SHRegisterDragDrop(HWND hWnd, 
  LPDROPTARGET lpDropTarget);

WINSHELLAPI HRESULT WINAPI SHRevokeDragDrop(HWND hWnd);

WINSHELLAPI HRESULT WINAPI SHDoDragDrop(HWND hWnd, 
  LPDATAOBJECT lpDataObject, LPDROPSOURCE lpDropSource, 
  DWORD dwOKEffect, LPDWORD pdwEffect);

WINSHELLAPI BOOL WINAPI DAD_DragEnter(HWND hWnd);

WINSHELLAPI BOOL WINAPI DAD_DragEnterEx(HWND hWnd, POINT pt);

WINSHELLAPI BOOL WINAPI DAD_DragMove(POINT pt);

// DAD_AutoScroll return values
#define DAD_SCROLL_UP    1
#define DAD_SCROLL_DOWN  2
#define DAD_SCROLL_LEFT  4
#define DAD_SCROLL_RIGHT 8

// DAD_AutoScroll sample structure
typedef struct {
  DWORD  dwCount;
  DWORD  dwLastTime;
  BOOL   bWrapped;
  POINT  aptPositions[3];
  DWORD  adwTimes[3];
} SCROLLSAMPLES, * LPSCROLLSAMPLES;

WINSHELLAPI DWORD WINAPI DAD_AutoScroll(HWND hWnd, 
  LPSCROLLSAMPLES lpSamples, LPPOINT lppt);

WINSHELLAPI BOOL WINAPI DAD_DragLeave();

WINSHELLAPI BOOL WINAPI DAD_SetDragImageFromListView(HWND hWnd, POINT pt);

WINSHELLAPI BOOL WINAPI DAD_SetDragImage(HIMAGELIST himlTrack, LPPOINT lppt);

WINSHELLAPI BOOL WINAPI DAD_ShowDragImage(BOOL bShow);

WINSHELLAPI HRESULT WINAPI SHCreateStdEnumFmtEtc(DWORD cFormats, 
  const FORMATETC *lpFormats, LPENUMFORMATETC *ppenumFormatetc);

WINSHELLAPI HRESULT WINAPI CIDLData_CreateFromIDArray(
  LPCITEMIDLIST pidlFolder, DWORD cpidlFiles, LPCITEMIDLIST *lppidlFiles,
  LPDATAOBJECT *ppdataObject);

//===========================================================================
//
// Path Manipulation Routines
//
//===========================================================================

WINSHELLAPI LPSTR WINAPI PathAppend(LPSTR lpszPath1, LPCSTR lpszPath2);

WINSHELLAPI LPSTR WINAPI PathCombine(LPSTR lpszDestPath, 
  LPCSTR lpszSrcPath1, LPCSTR lpszSrcPath2);

WINSHELLAPI LPSTR WINAPI PathAddBackslash(LPSTR lpszPath);

WINSHELLAPI LPSTR WINAPI PathBuildRoot(LPSTR lpszPath, int drive);

WINSHELLAPI LPSTR WINAPI PathFindFileName(LPCSTR lpszPath);

WINSHELLAPI LPSTR WINAPI PathFindExtension(LPCSTR lpszPath);

WINSHELLAPI LPSTR WINAPI PathGetExtension(LPCSTR lpszPath);

WINSHELLAPI LPSTR WINAPI PathGetArgs(LPCSTR lpszPath);

WINSHELLAPI int WINAPI PathGetDriveNumber(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathRemoveFileSpec(LPSTR lpszPath);

WINSHELLAPI LPSTR WINAPI PathGetShortPath(LPSTR lpszPath);

WINSHELLAPI void WINAPI PathRemoveBlanks(LPSTR lpszPath);

WINSHELLAPI void WINAPI PathQuoteSpaces(LPSTR lpszPath);

WINSHELLAPI void WINAPI PathUnquoteSpaces(LPSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsUNC(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsRelative(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsRoot(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsExe(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsDirectory(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathFileExists(LPCSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathMatchSpec(LPCSTR lpszPath, LPCSTR lpszSpec);

WINSHELLAPI BOOL WINAPI PathMakeUniqueName(LPSTR lpszBuffer, 
  DWORD dwBuffSize, LPCSTR lpszShortName, LPCSTR lpszLongName, 
  LPCSTR lpszPathName);

WINSHELLAPI BOOL WINAPI PathYetAnotherMakeUniqueName(LPSTR lpszBuffer,
  LPCSTR lpszPathName, LPCSTR lpszShortName, LPCSTR lpszLongName);

WINSHELLAPI BOOL WINAPI PathFindOnPath(LPSTR lpszFile, 
  LPCSTR *alpszPaths);

// PathCleanupSpec return values
#define PCS_REPLACEDCHARS  0x00000001
#define PCS_REMOVEDCHARS   0x00000002
#define PCS_SHORTENED      0x00000004
#define PCS_PATHTOOLONG    0x80000008

WINSHELLAPI DWORD WINAPI PathCleanupSpec(LPCSTR lpszPath, 
  LPSTR lpszFile);

WINSHELLAPI void WINAPI PathQualify(LPSTR lpszPath);

// PathResolve flags
#define PRF_CHECKEXISTANCE  0x01
#define PRF_EXECUTABLE      0x02
#define PRF_QUALIFYONPATH   0x04
#define PRF_WINDOWS31       0x08

WINSHELLAPI BOOL WINAPI PathResolve(LPSTR lpszPath, LPCSTR *alpszPaths, 
  DWORD dwFlags);

WINSHELLAPI BOOL WINAPI PathSetDlgItemPath(HWND hDlg, int nIDDlgItem, 
  LPCSTR lpszPath);

// PathProcessCommand flags
#define PPCF_QUOTEPATH        0x01 // implies PPCF_INCLUDEARGS
#define PPCF_INCLUDEARGS      0x02
#define PPCF_NODIRECTORIES    0x10
#define PPCF_DONTRESOLVE      0x20 // buggy when using unquoted paths
#define PPCF_PATHISRELATIVE   0x40

#ifdef NTONLY

WINSHELLAPI int WINAPI PathProcessCommand(LPCWSTR lpszPath, LPWSTR lpszBuff, 
  DWORD dwBuffSize, DWORD dwFlags);

WINSHELLAPI void WINAPI PathStripPath(LPWSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathStripToRoot(LPWSTR lpszPath);

WINSHELLAPI void WINAPI PathRemoveArgs(LPWSTR lpszPath);

WINSHELLAPI void WINAPI PathRemoveExtension(LPWSTR lpszPath);

WINSHELLAPI int WINAPI PathParseIconLocation(LPWSTR lpszPath);

WINSHELLAPI BOOL WINAPI PathIsSameRoot(LPCWSTR lpszPath1, LPCWSTR lpszPath2);

#else

typedef int (WINAPI * LPFNPATHPROCESSCOMMAND)(LPCWSTR, LPWSTR, DWORD, DWORD);

typedef void (WINAPI * LPFNPATHSTRIPPATH)(LPWSTR);

typedef BOOL (WINAPI * LPFNPATHSTRIPTOROOT)(LPWSTR);

typedef void (WINAPI * LPFNPATHREMOVEARGS)(LPWSTR);

typedef void (WINAPI * LPFNPATHREMOVEEXTENSION)(LPWSTR);

typedef int (WINAPI * LPFNPATHPARSEICONLOCATION)(LPWSTR);

typedef BOOL (WINAPI * LPFNPATHISSAMEROOT)(LPCWSTR, LPCWSTR);

#endif // !NTONLY

//===========================================================================
//
// Shell Namespace Routines
//
//===========================================================================

// SHCreateShellFolderViewEx callback function
typedef HRESULT (CALLBACK* LPFNSFVCALLBACK)(DWORD dwUser, LPSHELLFOLDER pshf,
  HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// SHCreateShellFolderViewEx structure
typedef struct {
  DWORD            dwSize;
  LPSHELLFOLDER    pshf;
  DWORD            dwUser;
  LPCITEMIDLIST    pidlFolder;
  DWORD            dwEventId;
  LPFNSFVCALLBACK  lpfnCallback;
  UINT             uViewMode;
} SHELLFOLDERVIEWINFO, * LPSHELLFOLDERVIEWINFO;
typedef const SHELLFOLDERVIEWINFO * LPCSHELLFOLDERVIEWINFO;

WINSHELLAPI HRESULT WINAPI SHCreateShellFolderViewEx(
  LPCSHELLFOLDERVIEWINFO pshfvi,
  LPSHELLVIEW *ppshv);

// SHCreateShellFolderViewEx callback messages
#define SFVCB_ADDTOMENU           0x0001
#define SFVCB_INVOKECOMMAND       0x0002
#define SFVCB_GETMENUHELP         0x0003
#define SFVCB_GETTOOLBARTIP       0x0004
#define SFVCB_GETTOOLBARINFO      0x0005
#define SFVCB_ADDTOOLBARITEMS     0x0006
#define SFVCB_INITMENUPOPUP       0x0007
#define SFVCB_SELECTIONCHANGED    0x0008
#define SFVCB_DRAWMENUITEM        0x0009
#define SFVCB_MEASUREMENUITEM     0x000A
#define SFVCB_EXITMENULOOP        0x000B
#define SFVCB_VIEWRELEASE         0x000C
#define SFVCB_GETNAMELENGTH       0x000D
#define SFVCB_CHANGENOTIFY        0x000E
#define SFVCB_WINDOWCREATED       0x000F
#define SFVCB_WINDOWCLOSING       0x0010
#define SFVCB_LISTREFRESHED       0x0011
#define SFVCB_WINDOWFOCUSED       0x0012
#define SFVCB_REGISTERCOPYHOOK    0x0014
#define SFVCB_COPYHOOKCALLBACK    0x0015
#define SFVCB_GETDETAILSOF        0x0017
#define SFVCB_COLUMNCLICK         0x0018
#define SFVCB_GETCHANGENOTIFYPIDL 0x0019
#define SFVCB_GETESTIMATEDCOUNT   0x001A
#define SFVCB_ADJUSTVIEWMODE      0x001B
#define SFVCB_REMOVEFROMMENU      0x001C
#define SFVCB_ADDINGOBJECT        0x001D
#define SFVCB_REMOVINGOBJECT      0x001E
#define SFVCB_UPDATESTATUSBAR     0x001F
#define SFVCB_ISSLOWREFRESH       0x0020
#define SFVCB_GETCOMMANDDIR       0x0021
#define SFVCB_GETCOLUMNSTREAM     0x0022
#define SFVCB_CANSELECTALL        0x0023
#define SFVCB_DRAGSUCCEEDED       0x0024
#define SFVCB_ISSTRICTREFRESH     0x0025
#define SFVCB_ISCHILDOBJECT       0x0026

// Generic structure used by several messages
typedef struct {
  DWORD          dwReserved;
  DWORD          dwReserved2;
  LPCITEMIDLIST  pidl;
  LPDWORD        lpdwUser;
} SFVCBINFO, * LPSFVCBINFO;
typedef const SFVCBINFO * LPCSFVCBINFO;

// SFVCB_ADDTOMENU structure
typedef struct  {
  HMENU  hMenu;
  UINT   indexMenu;
  UINT   idCmdFirst;
  UINT   idCmdLast;
} SFVMENUINFO, * LPSFVMENUINFO;

// SFVCB_GETTOOLBARINFO structure
typedef struct {
  UINT  nButtons;
  UINT  uFlags;
} SFVTOOLBARINFO, * LPSFVTOOLBARINFO;

// SFVTOOLBARINFO flags
typedef enum {
  SFVTI_ADDTOEND   = 0,
  SFVTI_ADDTOFRONT = 1,
  SFVTI_OVERWRITE  = 2
} SFVTIF; 

// SFVCB_SELECTIONCHANGED structure
typedef struct {
  UINT           uOldState;
  UINT           uNewState;
  LPCITEMIDLIST  pidl;
  LPDWORD        lpdwUser;
} SFVSELECTSTATE, * LPSFVSELECTSTATE;
typedef const SFVSELECTSTATE * LPCSFVSELECTSTATE;

// SFVCB_COPYHOOKCALLBACK structure
typedef struct {
  HWND    hwnd;
  UINT    wFunc;
  UINT    wFlags;
  LPCSTR  pszSrcFile;
  DWORD   dwSrcAttribs;
  LPCSTR  pszDestFile;
  DWORD   dwDestAttribs;
} SFVCOPYHOOKINFO, * LPSFVCOPYHOOKINFO;
typedef const SFVCOPYHOOKINFO * LPCSFVCOPYHOOKINFO;

// SFVCB_GETDETAILSOF structure
typedef struct {
  LPCITEMIDLIST  pidl;
  int            fmt;
  int            cx;
  STRRET         lpText;
} SFVCOLUMNINFO, * LPSFVCOLUMNINFO;

WINSHELLAPI int WINAPI SHShellFolderView_Message(HWND hwndCabinet, 
  DWORD dwMessage, DWORD dwParam); 

// SHShellFolderView_Message messages
#define SFVM_REARRANGE          0x0001
#define SFVM_GETARRANGECOLUMN   0x0002
#define SFVM_ADDOBJECT          0x0003
#define SFVM_GETITEMCOUNT       0x0004
#define SFVM_GETITEMPIDL        0x0005
#define SFVM_REMOVEOBJECT       0x0006
#define SFVM_UPDATEOBJECT       0x0007
#define SFVM_SETREDRAW          0x0008
#define SFVM_GETSELECTEDOBJECTS 0x0009
#define SFVM_ISDROPONSOURCE     0x000A
#define SFVM_MOVEICONS          0x000B
#define SFVM_GETDRAGPOINT       0x000C
#define SFVM_GETDROPPOINT       0x000D
#define SFVM_SETOBJECTPOS       0x000E
#define SFVM_ISDROPONBACKGROUND 0x000F
#define SFVM_CUTOBJECTS         0x0010
#define SFVM_TOGGLEAUTOARRANGE  0x0011
#define SFVM_LINEUPICONS        0x0012
#define SFVM_GETAUTOARRANGE     0x0013
#define SFVM_GETSELECTEDCOUNT   0x0014
#define SFVM_GETITEMSPACING     0x0015
#define SFVM_REFRESHOBJECT      0x0016
#define SFVM_SETCLIPBOARDPOINTS 0x0017

//===========================================================================
//
// Misc Stuff
//
//===========================================================================

// SHWaitForFileToOpen flags
#define SHWFF_ADD     0x01
#define SHWFF_REMOVE  0x02
#define SHWFF_WAIT    0x04

WINSHELLAPI BOOL WINAPI SHWaitForFileToOpen(LPCITEMIDLIST pidl, 
  DWORD dwFlags, DWORD dwTimeout);

WINSHELLAPI WORD WINAPI ArrangeWindows(HWND hwndParent, DWORD dwReserved,
  LPCRECT lpRect, WORD cKids, CONST HWND * lpKids);

// RegisterShellHook types
#define RSH_DEREGISTER        0
#define RSH_REGISTER          1
#define RSH_REGISTER_PROGMAN  2
#define RSH_REGISTER_TASKMAN  3

WINSHELLAPI BOOL WINAPI RegisterShellHook(HWND hWnd, DWORD dwType);

// SHCreateDefClassObject callback function
typedef HRESULT (CALLBACK *LPFNCDCOCALLBACK)(LPUNKNOWN pUnkOuter,
  REFIID riidObject, LPVOID *ppvObject);

WINSHELLAPI HRESULT WINAPI SHCreateDefClassObject(REFIID riidFactory, 
  LPVOID *ppvFactory, LPFNCDCOCALLBACK lpfnCallback, LPDWORD lpdwUsage, 
  REFIID riidObject);

WINSHELLAPI HRESULT WINAPI SHCoCreateInstance(LPCSTR lpszClsid, 
  REFCLSID rClsid, LPUNKNOWN pUnkOuter, REFIID riid, LPVOID *ppv);

WINSHELLAPI void WINAPI SHFreeUnusedLibraries();

// SHCreateLinks flags
#define SHCLF_PREFIXNAME       0x01
#define SHCLF_CREATEONDESKTOP  0x02

WINSHELLAPI HRESULT WINAPI SHCreateLinks(HWND hWnd, LPCSTR lpszDir, 
  LPDATAOBJECT lpDataObject, UINT uFlags, LPITEMIDLIST *lppidlLinks);

// SHGetNewLinkInfo flags
#define SHGNLI_PIDL        0x01
#define SHGNLI_PREFIXNAME  0x02
#define SHGNLI_NOUNIQUE    0x04

WINSHELLAPI BOOL WINAPI SHGetNewLinkInfoA(LPCSTR pszLinkTo, LPCSTR pszDir, 
  LPSTR pszName, BOOL *pfMustCopy, UINT uFlags);

#ifdef NTONLY
WINSHELLAPI BOOL WINAPI SHGetNewLinkInfoW(LPCWSTR pszLinkTo, LPCWSTR pszDir, 
  LPWSTR pszName, BOOL *pfMustCopy, UINT uFlags);
#else
typedef BOOL (WINAPI * LPFNSHGETNEWLINKINFOW)(LPCWSTR, LPCWSTR, LPWSTR, 
  BOOL*, UINT);
#endif // !NTONLY

#ifdef UNICODE
#define SHGetNewLinkInfo  SHGetNewLinkInfoW
#else
#define SHGetNewLinkInfo  SHGetNewLinkInfoA
#endif // !UNICODE

//===========================================================================

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _INC_SHELLEX

