/* **************************************************************************
*                                                                           *
*  DOSLoad.CPP                                                              *
*                                                                           *
*  11-03-97                                                    BUILD:0006   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Carrega el sistema Eros del del DOS                                      *
*                                                                           *
************************************************************************** */
// Algunes parts d'aquest programa estan basades en el carregador del MMURTL
// (c) Copyright, 1995 Richard A. Burgess

// *********************************** INCLUDES
#include <string.h>
#include <stdlib.h>	// exit
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <fcntl.h>
#include <io.h>

#include "consts.h"
#include "kernel\pat.h"
#include "headers.h"
#include "xmem.h"
#include "kernel\page.h"
#include "common.h"
#include "lang.h"

#include <ctype.h>

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER					"0.01"
#else
#define _VER					"1.00"
#endif

#define _BUILD					9
// Nom del fitxer que especifica quins controladors carregar
#define INI_FILENAME			"EROS.INI"
// Noms de les seccions a carregar
#define INIT_CODE_SECTION	"CODE"
#define INIT_DATA_SECTION	"DATA"

// *********************************** DECLARACIONS
BOOL PECheck( int, IMAGE_DOS_HEADER&, IMAGE_NT_HEADERS&, DWORD& );
BOOL LoadSection( int, char *, PTPage, PTPage, IMAGE_NT_HEADERS&, DWORD& );
BOOL SeekSection( int, char *, PIMAGE_SECTION_HEADER, IMAGE_NT_HEADERS&, DWORD& );
DWORD PATAlloc();
BOOL GetExports( int, PBYTE&, IMAGE_NT_HEADERS&, DWORD& );
BOOL GetFunctionAddress( char *, WORD, PBYTE, DWORD &, IMAGE_SECTION_HEADER& );
BOOL Map( DWORD, DWORD, PTPage, PTPage, IMAGE_SECTION_HEADER& );
VOID Pause();
BOOL Imports( int, int, DWORD = SYSTABLE_ID );
int LoadModule( PSTR, int& );

// *********************************** GLOBALS
PTModule LoadedModule = (PTModule) MODULE_16;
DWORD FirstSectionInfo[ MAX_IMAGES ];
IMAGE_DOS_HEADER mzhdr[ MAX_IMAGES ];
IMAGE_NT_HEADERS nthdr[ MAX_IMAGES ];
IMAGE_SECTION_HEADER exp_section[ MAX_IMAGES ];
PBYTE Exp[ MAX_IMAGES ];
PBYTE Imp[ MAX_IMAGES ];
extern BYTE real_gdt;

// DOSLoad funci principal
void main( int argc, char *argv[] )
	{
	char osname[ 50 ]; // Nom del primer fitxer a carregar
	char fName = 0; // Canvi de nom del SO ?

	strcpy( osname, "SYS.EXE" ); // Nom per defecte

	clrscr();
	cprintf( "EROS DOS Loader ver %s (Build %u) Date: %s\r\n", _VER, _BUILD, __DATE__ );

	// Cerquem parametres
	for( int i = 1; i < argc; ++i )
		{
		char *ptr = argv[i];

		if( *ptr == '/' )
			{
			ptr++;

			switch( *ptr )
				{
				case 'O' :
				case 'o' :
					fName = 1;
					break;

				default:
					cprintf( sINVALID_OPTION );
					exit( 1 );
					break;
			  }
			}
		else
			{
			if( fName )
				strncpy( osname, argv[i], 49 );	// Nou nom del SO
			}
		}

	cprintf( sOS_FILENAME, osname );
	cprintf( sWEB_PAGE );
	cprintf( sMAIL_TO );
	Pause();

// Inicialitzem la taula de mduls carregats
	for( int index = 0; index <= MAX_IMAGES; index++ )
		{
		LoadedModule[ index ].dwEntryPoint	= 0L;
		LoadedModule[ index ].handle			= 0;
		LoadedModule[ index ].sName[ 0 ]		= 0;
		}

	// Hem de preparar les estructures de dades del sistema com la PAT, etc.
	PTPAT pat = (PTPAT) PAT_16;

	// -- Inicialitzem la PAT amb el 1er. MB. reservat i la resta lliure
	for( WORD count = 0; count < PAT16_SIZE / sizeof( TPAT ); count++ )
		{
		pat[ count ].pRegion			= NULL;
		pat[ count ].dwOffset		= 0;
		pat[ count ].pHelper			= NULL;
		pat[ count ].dwAge			= 0;
		pat[ count ].wUsageCount	= 0;
		pat[ count ].cFlags			= 0;
		pat[ count ].cOwner 			= FREE_PAGE;
		}

	TurnOnA20(); // Alliberem la lnia A20
	x_memprep(); // Preparem el processador per a accedir a qualsevol posici de memria des del mode real

	PDWORD pmemsize = (PDWORD) 0x7000fffcL;
	DWORD val1 = *pmemsize; // Obtenim el tamany de la memria fsica (mtode 1)

// Obtenim el tamany de la memria segons la CMOS (mtode 2)
	outportb( 0x70, 0x30 );
	DWORD val2 = ((DWORD) inportb( 0x71 )) * 1024L;
	outportb( 0x70, 0x31 );
	val2 += (((DWORD) inportb( 0x71 )) << 8) * 1024L;
	val2 += 0x100000L;	// El primer MB. no es compta en la CMOS
	val2 = val2 & 0xfff00000L; // Noms ens interessen els MB. (no pas els KB.) 

// Presentem els tamanys obtinguts amb els dos mtodes (haurien de ser iguals)
	cprintf( sMEMSIZE, val1, val2 );

// En alguns ordinadors la CMOS retorna el valor ms correcte
	if( val1 < val2 )
		*pmemsize = val2;

	if( *pmemsize < 0x400000L ) // Comprovem el mnim de 4MB. exigit per el sistema
		{
		cprintf( sLOWMEM, *pmemsize / 1024 );
		exit( 1 );
		}

//	Preparem el directori de pgines i les taules de pgines
	PTPage pagedir = (PTPage) PAGEDIR_16;

	memset( pagedir, 0, PAGE_TABLES16 * PAGE_SIZE ); // n pgines a zero

// Directori de pgines com a taula de pgines
	{
	DWORD table = MK_32P( FP_SEG( pagedir ), FP_OFF( pagedir ) );

// 0x300 correspon a l'adrea 0xc00xxxxxx / 4
	pagedir[ 0x300 ].LoWord.Bits.Pres = TRUE;
	pagedir[ 0x300 ].LoWord.Bits.ReadWrite = TRUE;
	pagedir[ 0x300 ].LoWord.Bits.PageDirLo = (BYTE) ((table >> 12) & 0x0f);
	pagedir[ 0x300 ].PageDirHi = (WORD) (table >> 16);
	}

// primers 4 MB (directori de pgines)
	DWORD table = MK_32P( FP_SEG( pagedir ), FP_OFF( pagedir ) ) + FIRSTMEG_ID;

	pagedir[ 0 ].LoWord.Bits.Pres = TRUE;
	pagedir[ 0 ].LoWord.Bits.ReadWrite = TRUE;
	pagedir[ 0 ].LoWord.Bits.UserSuper = TRUE; // Una zona dels primers 4MB. ha de poder ser accedida per l'usuari
	pagedir[ 0 ].LoWord.Bits.PageDirLo = (BYTE) ((table >> 12) & 0x0f);
	pagedir[ 0 ].PageDirHi = (WORD) (table >> 16);

// primer MB (taula de pgines)
	PTPage pagetable = (PTPage) (((DWORD) pagedir) + FIRSTMEG_ID );
//	cprintf( "PageDir = %.8lx / PageTable = %.8lx\r\n", MK_32P( FP_SEG( pagedir ), FP_OFF( pagedir ) ), MK_32P( FP_SEG( pagetable ), FP_OFF( pagetable ) ) );

	for( unsigned index = 0; index < 256; index++ )
		{
		DWORD mem = ((DWORD) index) * PAGE_SIZE;

		pagetable[ index ].LoWord.Bits.Pres = TRUE;
		pagetable[ index ].LoWord.Bits.ReadWrite = TRUE;
		pagetable[ index ].LoWord.Bits.UserSuper = FALSE;
		pagetable[ index ].LoWord.Bits.PageDirLo = (BYTE) ((mem >> 12) & 0x0f);
		pagetable[ index ].PageDirHi = (WORD) (mem >> 16);
		}

// Ara, hem de carregar en memria tot el sistema operatiu
	int Syshandle;
	int sys_id = LoadModule( (PSTR) osname, Syshandle );

// Generar informaci d'exportaci del mdul 'system'
	if( SeekSection( Syshandle, ".edata", &exp_section[ sys_id ], nthdr[ sys_id ], FirstSectionInfo[ sys_id ] ) )
		{
		if( !GetExports( Syshandle, Exp[ sys_id ], nthdr[ sys_id ], FirstSectionInfo[ sys_id ] ) )
			{
			cprintf( sEXPORT_SYS );
			exit( 1 );
			}
		}
#ifdef _DEBUG
	else
		cprintf( sNOT_EXPORT_SYS );
#endif

// Preparem les importacions de 'system' i exportacions dels mduls importats per aquest
	if( !Imports( Syshandle, sys_id ) )
		{
		cprintf( sIMPORT_SYS );
		exit( 1 );
		}

// Carreguem el controladors necessaris des del mode real
	FILE *stream;

	if( (stream = fopen( INI_FILENAME, "r" )) == NULL )
		{
#ifdef _DEBUG
		cprintf( sCANNOT_OPEN, INI_FILENAME );
#endif
		}
	else
		{
		char buf[ 81 ];

		int status = fscanf( stream, "%s", buf );
		// cerquem la cadena "[real]" que especifica els controlador que ha de carregar el DOSLoad
		while( status && status != EOF && strcmpi( buf, "[real]" ) )
			{
			status = fscanf( stream, "%s", buf );
			}

		if( status && status != EOF )
			{
			status = fscanf( stream, "%s", buf );
			// mentre no s'acabi la llista
			while( status && status != EOF && *buf != '[' )
				{
				int Drvhandle;

				int drv_id = LoadModule( (PSTR) buf, Drvhandle );

				if( SeekSection( Drvhandle, ".edata", &exp_section[ drv_id ], nthdr[ drv_id ], FirstSectionInfo[ drv_id ] ) )
					{
					if( !GetExports( Drvhandle, Exp[ drv_id ], nthdr[ drv_id ], FirstSectionInfo[ drv_id ] ) )
						{
						cprintf( sEXPORT_NAME, buf );
						exit( 1 );
						}
					}
#ifdef _DEBUG
				else
					cprintf( sNOT_EXPORT_NAME, buf );
#endif

				if( !Imports( Drvhandle, drv_id, DRVTABLE_ID ) )
					{
					cprintf( sIMPORT_NAME, buf );
					exit( 1 );
					}

				status = fscanf( stream, "%s", buf );
				}
			}
		}

	cprintf( sESC_EXIT );
	int car = getch();

	if( car == 27 )
		{
		cprintf( "\r\n" );
		exit( 0 );
		}

// Petita pausa esperant la interrupci del teclat (break)
	for( DWORD wait = 0L; wait < 0x100000L; wait++ );

	gotoxy( 1, 1 );

// Executem el kernel
	cli(); // No volem interrupcions
	// Copiem la GDT preparada a la posici correcta
	x_memcopy( GDT_OFFSET, (DWORD) MK_32P( FP_SEG( &real_gdt ), FP_OFF( &real_gdt ) ), GDT_DESCRIPTORS * DESCRIPTOR_SIZE );
	memset( (void *) IDT_OFFSET, 0, IDT_ENTRIES * DESCRIPTOR_SIZE ); 	// Inicialitzem l'IDT
	Execute32(); // Executem el Kernel
	}

// Retorna el 'handle' del fitxer que volem carregar (pot ser que ja s'hagi carregat amb anterioritat)
int LoadModule( PSTR sName, int &Handle )
	{
	int ID = -1;
	BOOL trobat = FALSE;
	// el cerquem en la taula de carregats
	while( ID < MAX_IMAGES && !trobat )
		{
		ID++;
		if( strnicmp( (char *) LoadedModule[ ID ].sName, (char *) sName, MAX_MODULE_NAME ) == 0 )
			trobat = TRUE;
		}

	if( trobat )
		{
		Handle = LoadedModule[ ID ].handle;
//		cprintf( "Handle %u es de %s\r\n", Handle, sName );
		return ID | 0x8000;	// Indiquem que ja s'havia carregat
		}

	ID = -1;
	BOOL lliure = FALSE;
	// cerquem el primer espai lliure en la taula de carregats
	while( ID < MAX_IMAGES && !lliure )
		{
		ID++;
		lliure = (LoadedModule[ ID ].sName[ 0 ] == 0 ? TRUE : FALSE);
		}

	if( !lliure )
		{
		cprintf( sMAX_IMAGES ); // No podem carregar tant fitxers
		exit( 1 );
		}
	// Intentem obrir el fitxer
	if( (Handle = open( (char *) sName, O_RDONLY | O_BINARY )) == -1 )
		{
		cprintf( sCANNOT_OPEN, sName );
		exit( 1 );
		}

	strncpy( (char *) LoadedModule[ ID ].sName, (char *) sName, MAX_MODULE_NAME );
	LoadedModule[ ID ].handle = Handle;
	cprintf( "\r\n%s", sName );
	// Comprovem que sigui un executable correcte
	if( !PECheck( Handle, mzhdr[ ID ], nthdr[ ID ], FirstSectionInfo[ ID ] ) )
		{
		cprintf( sPE_FORMAT );
		exit( 1 );
		}
	// Guardem el punt d'entrada
	LoadedModule[ ID ].dwEntryPoint = nthdr[ ID ].OptionalHeader.ImageBase + nthdr[ ID ].OptionalHeader.AddressOfEntryPoint;

	return ID; // Retornem el 'handle'
	}

// Obt la taula d'exportacions d'un cert fitxer
BOOL GetExports( int handle, PBYTE& punt, IMAGE_NT_HEADERS &nthdr, DWORD &FirstSectionInfo )
	{
	IMAGE_SECTION_HEADER section;
	// Cerquem la secci ".edata"
	if( !SeekSection( handle, ".edata", &section, nthdr, FirstSectionInfo ) )
		{
		cprintf( sEDATA );
		exit( 1 );
		}

//	cprintf( "section.SizeOfRawData = %.8lx\r\n", section.SizeOfRawData );
	// Reservem memria per a la secci que volem carregar
	punt = (PBYTE) malloc( (WORD) section.SizeOfRawData );
	unsigned char *buff = (unsigned char *) punt;

//	cprintf( "section.PointerToRawData = %.8lx\r\n", section.PointerToRawData );
	// Anem a la posici del fitxer que cont la secci
	lseek( handle, section.PointerToRawData, SEEK_SET );

	DWORD readb = 0L;
	// Llegim tota la secci
	while( readb < section.SizeOfRawData )
		{
		// Necessitem el mnim entre tota una pgina o el que queda per llegir de la secci
		unsigned need = min( (unsigned) PAGE_SIZE, (unsigned) (section.SizeOfRawData - readb) );

		if( read( handle, (void *) ((DWORD) buff + readb), need ) != need )
			{
			cprintf( sERROR_HANDLE, handle, readb, need );
			exit( 1 );
			}

		readb += need;
		}
/*#ifdef _DEBUG
	// Presentem informaci de depuraci
	cprintf( "read = %lu (exports)\r\n", readb );
	getch();

	PIMAGE_EXPORT_DIRECTORY pExp = (PIMAGE_EXPORT_DIRECTORY) MK_FP( FP_SEG( buff ), FP_OFF( buff ) );

	DWORD pos = pExp->Name;
	pos -= section.VirtualAddress;
	cprintf( "cadena    = %s\r\n", &buff[ (WORD) pos ] );
	cprintf( "base      = %lu\r\n", pExp->Base );
	cprintf( "Number    = %lu/%lu\r\n", pExp->NumberOfFunctions, pExp->NumberOfNames );

	DWORD count = pExp->NumberOfFunctions;
	int y = 5;

	while( count )
		{
		pos = (DWORD) pExp->AddressOfNameOrdinals - section.VirtualAddress + (pExp->NumberOfFunctions - count) * sizeof( WORD );
		cprintf( "%4u  ", buff[ (WORD) pos ] + (buff[ (WORD) pos+1 ] << 8) );
		pos = (DWORD) pExp->AddressOfFunctions - section.VirtualAddress +  (buff[ (WORD) pos ]  + (buff[ (WORD) pos+1 ] << 8)) * sizeof( DWORD );
		DWORD npos = (DWORD) buff[ (WORD) pos ];
		npos += ((DWORD) buff[ (WORD) pos+1 ]) << 8;
		npos += ((DWORD) buff[ (WORD) pos+2 ]) << 16;
		npos += ((DWORD) buff[ (WORD) pos+3 ]) << 24;
		cprintf( "%8lx  ", npos);
		pos = (DWORD) pExp->AddressOfNames - section.VirtualAddress + (pExp->NumberOfFunctions - count) * sizeof( DWORD );
		npos = (DWORD) buff[ (WORD) pos ];
		npos += ((DWORD) buff[ (WORD) pos+1 ]) << 8;
		npos += ((DWORD) buff[ (WORD) pos+2 ]) << 16;
		npos += ((DWORD) buff[ (WORD) pos+3 ]) << 24;
		npos -= section.VirtualAddress;
		char *test = (char *) (buff + (WORD) npos);
		cprintf( "%s\r\n", test );
		y++;

		if( y > 24 )
			{
			getch();
			y = 0;
			}

		count--;
		}
#endif*/
	return TRUE; // Hem llegit correctament
	}

// Obt l'adrea de la funci que es passa com a parmetre
BOOL GetFunctionAddress( char *name, WORD, PBYTE punt, DWORD &addr, IMAGE_SECTION_HEADER &section )
	{
	unsigned char *table = (unsigned char *) punt;

	PIMAGE_EXPORT_DIRECTORY pExp = (PIMAGE_EXPORT_DIRECTORY) MK_FP( FP_SEG( table ), FP_OFF( table ) );

	DWORD count = pExp->NumberOfFunctions;
	// Mentre quedin funcions per a comprovar
	while( count )
		{
		DWORD pos = (DWORD) pExp->AddressOfNameOrdinals - section.VirtualAddress + (pExp->NumberOfFunctions - count) * sizeof( WORD );

		DWORD pseudopos = (DWORD) pExp->AddressOfNames - section.VirtualAddress + (pExp->NumberOfFunctions - count) * sizeof( DWORD );
		DWORD npos = (DWORD) table[ (WORD) pseudopos ];
		npos += ((DWORD) table[ (WORD) pseudopos+1 ]) << 8;
		npos += ((DWORD) table[ (WORD) pseudopos+2 ]) << 16;
		npos += ((DWORD) table[ (WORD) pseudopos+3 ]) << 24;
		npos -= section.VirtualAddress;

		char *test = (char *) (table + (WORD) npos);

		if( strcmp( test, name ) == 0 )
			{
			pos = (DWORD) pExp->AddressOfFunctions - section.VirtualAddress +  (table[ (WORD) pos ]  + (table[ (WORD) pos+1 ] << 8)) * sizeof( DWORD );
			DWORD npos = (DWORD) table[ (WORD) pos ];
			npos += ((DWORD) table[ (WORD) pos+1 ]) << 8;
			npos += ((DWORD) table[ (WORD) pos+2 ]) << 16;
			npos += ((DWORD) table[ (WORD) pos+3 ]) << 24;
			addr = npos;
//			cprintf( "%s (%.8lxh)\r\n", name, addr );
			return TRUE; // Hem trobat la funci
			}

		count--;
		}

	return FALSE; // No s'ha trobat!
	}

// Obt la taula d'importacions d'un mdul (tamb carrega el codi i dades)
BOOL Imports( int handle, int ID, DWORD TableID )
	{
	BOOL bloaded = FALSE;
	// Carreguem el codi
	if( !LoadSection( handle, INIT_CODE_SECTION, (PTPage) PAGEDIR_16, (PTPage) (PAGEDIR_16 + TableID), nthdr[ ID ], FirstSectionInfo[ ID ] ) )
		{
		cprintf( sERROR_LOADING, INIT_CODE_SECTION );
		exit( 1 );
		}
	// Carreguem les dades
	if( !LoadSection( handle, INIT_DATA_SECTION, (PTPage) PAGEDIR_16, (PTPage) (PAGEDIR_16 + TableID), nthdr[ ID ], FirstSectionInfo[ ID ] ) )
		{
		cprintf( sERROR_LOADING, INIT_DATA_SECTION );
		exit( 1 );
		}

	IMAGE_SECTION_HEADER section;
	// Cerquem la secci d'importacions
	if( !SeekSection( handle, ".idata", &section, nthdr[ ID ], FirstSectionInfo[ ID ] ) )
		{
		cprintf( sNOT_IMPORT_IMG );
		close( handle );
		return TRUE;
		}

//	cprintf( "Creant Imp[ %u ] amb %lu bytes\r\n", ID, section.SizeOfRawData );
	// Reservem espai per a la secci
	Imp[ ID ] = (PBYTE) malloc( (WORD) section.SizeOfRawData );
	// Anem a la posici del fitxer que cont la secci
	lseek( handle, section.PointerToRawData, SEEK_SET );

	DWORD readb = 0L;
	int imphandle;
	// Llegim la secci
	while( readb < section.SizeOfRawData )
		{
		unsigned need = min( (unsigned) PAGE_SIZE, (unsigned) (section.SizeOfRawData - readb) );

		if( read( handle, (void *) (Imp[ ID ] + (WORD) readb), need ) != need )
			{
			cprintf( sERROR_HANDLE, handle, readb, need );
			exit( 1 );
			}

		readb += need;
		}
#ifdef _DEBUG
	cprintf( "read = %lu (imports)\r\n", readb );
	getch();
#endif
	PIMAGE_IMPORT_DESCRIPTOR pImp = (PIMAGE_IMPORT_DESCRIPTOR) Imp[ ID ];
	// Mentre quedin DLLs per a importar
	while( pImp->Name )
		{
		DWORD pos = pImp->Name;
		pos -= section.VirtualAddress;
//		cprintf( "\r\n%s", &Imp[ ID ][ (WORD) pos ] );

		int newid = LoadModule( (PSTR) &Imp[ ID ][ (WORD) pos ], imphandle );

		if( newid & 0x8000 ) // Si el fitxer ja est carregat en memria
			{
			bloaded = TRUE;
			newid = newid & 0x7fff;
			}
		// Si no ho est, carreguem les seves exportacions
		if( !bloaded )
			{
			if( !SeekSection( imphandle, ".edata", &exp_section[ newid ], nthdr[ newid ], FirstSectionInfo[ newid ] ) )
				{
				cprintf( sEXPORT_ERROR );
				exit( 1 );
				}

			if( !GetExports( imphandle, Exp[ newid ], nthdr[ newid ], FirstSectionInfo[ newid ] ) )
				return FALSE;
			}

//		int y = 5;
		PIMAGE_THUNK_DATA pData = (PIMAGE_THUNK_DATA) (Imp[ ID ] + (WORD) ((DWORD) pImp->FirstThunk - section.VirtualAddress));

		while( pData->u1.AddressOfData )
			{
			PIMAGE_IMPORT_BY_NAME pName = (PIMAGE_IMPORT_BY_NAME) (Imp[ ID ] + (WORD) ((DWORD) pData->u1.AddressOfData - section.VirtualAddress));

			DWORD addr;

//			cprintf( "%s ", (char *) &pName->Name );
			// Existeix la funci referenciada?
			if( !GetFunctionAddress( (char *) &pName->Name, pName->Hint, Exp[ newid ], addr, exp_section[ newid ] ) )
				{
				cprintf( "%3u %s ERROR!", pName->Hint, &pName->Name );
				Pause();
				}
			else
				{
				// Com que existeix, en guardem l'adrea d'entrada en la taula d'importacions
				addr += nthdr[ newid ].OptionalHeader.ImageBase;
				PDWORD p = (PDWORD) pData;
//				cprintf( " %.8lx (%.8lx)", addr, p );
				*p = addr;
				}
/*
			cprintf( "\r\n" );
			y++;

			if( y > 24 )
				{
				getch();
				y = 0;
				}
*/
			pData = (PIMAGE_THUNK_DATA) (pData + 1);
			}

// Carregar importacios del modul importat, si no s'havia fet
		if( !bloaded )
			{
			if( !Imports( imphandle, newid ) )
				{
				cprintf( sIMPORT_ERROR );
				exit( 1 );
				}
			}

		pImp = (PIMAGE_IMPORT_DESCRIPTOR) pImp + 1;
		}

// Passar la taula a memria estesa
	DWORD log = section.VirtualAddress + nthdr[ ID ].OptionalHeader.ImageBase;
	readb = ROUND_UP( readb, PAGE_SIZE );
	DWORD fet = 0L;
	// Mapegem totes les pgines utilitzades per la taula
	while( readb )
		{
		DWORD phys = PATAlloc();

//		cprintf( "phys = %lx log = %lx\r\n", phys, log + fet );
		x_memcopy( phys, (DWORD) MK_32P( FP_SEG( Imp[ ID ] ), FP_OFF( Imp[ ID ] ) ) + fet, PAGE_SIZE );

		Map( log + fet, phys, (PTPage) PAGEDIR_16, (PTPage) (PAGEDIR_16 + TableID), section );
		fet += PAGE_SIZE;
		readb -= PAGE_SIZE;
		}

	close( handle );
	return TRUE; // Les importacions han estat un xit
	}

// Comprova el format PE dels executables
BOOL PECheck( int handle, IMAGE_DOS_HEADER &mzhdr, IMAGE_NT_HEADERS &nthdr, DWORD &FirstSectionInfo )
	{
	if( read( handle, &mzhdr, sizeof( IMAGE_DOS_HEADER ) ) > 0 )
		{
		if( mzhdr.e_magic == IMAGE_DOS_SIGNATURE )
			{
			lseek( handle, mzhdr.e_lfanew, SEEK_SET );

			if( read( handle, &nthdr, sizeof( IMAGE_NT_HEADERS ) ) > 0 )
				{
				FirstSectionInfo = lseek( handle, 0, SEEK_CUR );

				if( nthdr.Signature == IMAGE_EROS_SIGNATURE )
					{
					if( nthdr.FileHeader.Machine == IMAGE_FILE_MACHINE_I386 )
						{
						if( nthdr.OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR_MAGIC )
							{
//							if( nthdr.OptionalHeader.Subsystem != IMAGE_SUBSYSTEM_NATIVE )
								return TRUE; // Format correcte
							}
						}
					}
				}
			}
		}

	return FALSE; // Format erroni
	}

// Cerca la secci demanada
BOOL SeekSection( int handle, char *Name, PIMAGE_SECTION_HEADER Section, IMAGE_NT_HEADERS &nthdr, DWORD &FirstSectionInfo )
	{
	// Anem al directori de seccions
	lseek( handle, FirstSectionInfo, SEEK_SET );

	WORD sectnum = 0;
	BOOL trobat = FALSE;
	// Cerquem el nom de la secci
	while( !trobat && sectnum < nthdr.FileHeader.NumberOfSections )
		{
		read( handle, Section, sizeof( IMAGE_SECTION_HEADER ) );

		if( strncmp( Name, (char *) Section->Name, 8 ) == 0 )
			trobat = TRUE;
		else
			sectnum++;
		}

	return trobat;
	}

// Carrega la secci demanada a la memria
BOOL LoadSection( int handle, char *Name, PTPage PageDir, PTPage PageTable, IMAGE_NT_HEADERS &nthdr, DWORD& FirstSectionInfo )
	{
	static char Buf[ PAGE_SIZE + 1 ]; // 'Buffer' per a la lectura

	IMAGE_SECTION_HEADER section;
	// Cerquem la secci
	if( !SeekSection( handle, Name, &section, nthdr, FirstSectionInfo ) )
		return FALSE;

//	cprintf( "LoadSection: PageDir %.8lx / PageTable %.8lx\r\n", (DWORD) PageDir, (DWORD) PageTable );
	// Anem a la posici del fitxer que cont la secci
	lseek( handle, section.PointerToRawData, SEEK_SET );

//	cprintf( "LoadSection: %s (%lu)\r\n", Name, section.SizeOfRawData );

	DWORD readb = 0L, total = 0L;
	// Llegim tota la secci
	while( readb < section.SizeOfRawData )
		{
		unsigned need;

		if( section.SizeOfRawData - readb < PAGE_SIZE )
			need = (unsigned) (section.SizeOfRawData - readb);
		else
			need = (unsigned) PAGE_SIZE;
		// Inicialitzem el 'buffer'
		for( WORD index = 0; index < PAGE_SIZE; index++ )
			Buf[ index ] = 0;

		cprintf( "." );

		if( read( handle, (void *) &Buf, need ) != need )
			return FALSE; // Hi ha algun error

		DWORD Pos = PATAlloc(); // Reservem una nova pgina de memria

		if( !Pos ) // Si no queda memria lliure, no podem continuar
			return FALSE;
		// Copiem la pgina llegida a la posici correcta de la memria
		x_memcopy( Pos, (DWORD) MK_32P( FP_SEG( &Buf ), FP_OFF( &Buf ) ), PAGE_SIZE );

//		cprintf( "log = %.8lx / phys = %.8lx\r\n", total + nthdr.OptionalHeader.ImageBase + section.VirtualAddress, Pos );
		// Mapegem la nova pgina
		Map( total + nthdr.OptionalHeader.ImageBase + section.VirtualAddress, Pos, PageDir, PageTable, section );

		readb += need;
		total += PAGE_SIZE;
		}
	// Inicialitzem el 'buffer'
	for( WORD index = 0; index < PAGE_SIZE; index++ )
		Buf[ index ] = 0;
	// Hi ha seccions que s'han d'acabar d'omplir amb zeros, perqu en disc no cal guardar-los
	while( total < section.Misc.VirtualSize )
		{
		DWORD Pos = PATAlloc(); // Reservem una nova pgina

		if( !Pos )
			return FALSE; // Error, si no en queden de lliures
		// Copiem el zeros a la nova pgina
		x_memcopy( Pos, (DWORD) MK_32P( FP_SEG( &Buf ), FP_OFF( &Buf ) ), PAGE_SIZE );
		// Mapegem la pgina
		Map( total + nthdr.OptionalHeader.ImageBase + section.VirtualAddress, Pos, PageDir, PageTable, section );

		total += PAGE_SIZE;
		}

//	cprintf( "read = %lu, total = %lu\r\n", readb, total );
//	getch();

	return TRUE; // Tot correcte
	}

// Reserva una pgina de memria fsica
DWORD PATAlloc()
	{
	WORD current = 0;	// Comencem a cercar a partir del 2on. MB
	PTPAT PAT = (PTPAT) PAT_16;
	// Cerquem la primera pgina lliure
	while( PAT[ current ].cOwner != FREE_PAGE &&	current < PAT16_SIZE / sizeof( TPAT ) )
		current++;

	if( PAT[ current ].cOwner != FREE_PAGE )
		return 0L;	// No hi ha memria
	// Inicialitzem l'entrada de la PAT
	PAT[ current ].pRegion = NULL;
	PAT[ current ].pHelper = NULL;
	PAT[ current ].dwOffset = 0L;
	PAT[ current ].dwAge = 0;
	PAT[ current ].wUsageCount = 1;
	PAT[ current ].cOwner = SYSTEM_PAGE;
	PAT[ current ].cFlags = LOCKED_PAGE;

//	cprintf( "Alloc = %lx\r\n", (((DWORD) current) << 12) + 0x100000L );
	return (((DWORD) current) << 12) + 0x100000L; // En retornem l'adrea fsica
	}

// Mapeja una pgina fsica en una certa adrea lgica
BOOL Map( DWORD LAddress, DWORD PAddress, PTPage PageDir, PTPage PageTable, IMAGE_SECTION_HEADER &section )
	{
	// Obtenim l'ndex dins el directori de pgines
	WORD index = (WORD) (LAddress >> 22);

//	cprintf( "Map: PageDir %.8lx / PageTable %.8lx\r\n", (DWORD) PageDir, (DWORD) PageTable );

	if( !PageDir[ index ].LoWord.Bits.Pres )
		{	// Si la taula de pgines no existeix, la creem
		DWORD table = MK_32P( FP_SEG( PageTable ), FP_OFF( PageTable ) );
		// Posem els valors correctes per a la taula creada
		PageDir[ index ].LoWord.Bits.Pres = TRUE;
//		PageDir[ index ].LoWord.Bits.UserSuper = TRUE;
		PageDir[ index ].LoWord.Bits.PageDirLo = (BYTE) ((table >> 12) & 0x0f);
		PageDir[ index ].PageDirHi = (WORD) (table >> 16);

		if( section.Characteristics & IMAGE_SCN_MEM_WRITE ) // Per a poder escriure en alguna pgina dels 4MB controlats
			PageDir[ index ].LoWord.Bits.ReadWrite = TRUE; // per l'entrada del directori de pgines.
		}
	else
		{
//		cprintf( "Present\r\n" );

		if( section.Characteristics & IMAGE_SCN_MEM_WRITE )  // Per a poder escriure en alguna pgina dels 4MB controlats
			PageDir[ index ].LoWord.Bits.ReadWrite = TRUE; // per l'entrada del directori de pgines.
		}
	// Obtenim l'ndex dins la taula de pgines
	index = (WORD) ((LAddress >> 12) & 0x3ff);

//	cprintf( "LAdd = %lx Index = %u, Pos = %lx ", LAddress, index, PAddress );
	// Posem els valors correctes per a la pgina
	PageTable[ index ].LoWord.Bits.Pres = TRUE;
	PageTable[ index ].LoWord.Bits.PageDirLo = (BYTE) ((PAddress >> 12) & 0x0f);
	PageTable[ index ].PageDirHi = (WORD) (PAddress >> 16);
//	PageTable[ index ].LoWord.Bits.UserSuper = TRUE;

	if( section.Characteristics & IMAGE_SCN_MEM_WRITE ) // Si volem escriure a la pgina
		PageTable[ index ].LoWord.Bits.ReadWrite = TRUE;

	return TRUE; // S'ha pogut mapejar correctament
	}

// Presenta un missatge i espera una tecla
VOID Pause()
	{
	cprintf( sPRESS_KEY );
	getch();
	}

