/* **************************************************************************
*                                                                           *
*  Headers.H                                                                *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Estructures dels fitxers executables                                     *
*                                                                           *
************************************************************************** */

#ifndef _HEADERS_H
#define _HEADERS_H
// Si hem incls el fitxer Windows.H, ja tenim aquesta informaci
#ifndef __WINDOWS_H

#include "pshpack1.h"			// sense empaquetament

#define IMAGE_DOS_SIGNATURE                 0x5A4D      // MZ
#define IMAGE_EROS_SIGNATURE               0x00004550  // PE00

typedef struct _IMAGE_DOS_HEADER {      // Capcelera DOS .EXE
	 WORD   e_magic;                     // Marca de format DOS MZ
	 WORD   e_cblp;                      // Bytes en l'ltima pgina del fitxer
	 WORD   e_cp;                        // Pgines en el fitxer
	 WORD   e_crlc;                      // Relocalitzacions
	 WORD   e_cparhdr;                   // Tamany de la capcelera en pargrafs
	 WORD   e_minalloc;                  // Minimum extra paragraphs needed
	 WORD   e_maxalloc;                  // Maximum extra paragraphs needed
	 WORD   e_ss;                        // Initial (relative) SS value
	 WORD   e_sp;                        // Initial SP value
	 WORD   e_csum;                      // Checksum
	 WORD   e_ip;                        // Initial IP value
	 WORD   e_cs;                        // Initial (relative) CS value
	 WORD   e_lfarlc;                    // File address of relocation table
	 WORD   e_ovno;                      // Overlay number
	 WORD   e_res[4];                    // Reserved words
	 WORD   e_oemid;                     // OEM identifier (for e_oeminfo)
	 WORD   e_oeminfo;                   // OEM information; e_oemid specific
	 WORD   e_res2[10];                  // Reserved words
	 LONG   e_lfanew;                    // File address of new exe header
  } IMAGE_DOS_HEADER, *PIMAGE_DOS_HEADER;

//
// Format de capcelera de fitxer (File header)
//

typedef struct _IMAGE_FILE_HEADER {
	 WORD    Machine;							// Processador en el qual s'executa
	 WORD    NumberOfSections;				// Nombre de seccions que cont
	 DWORD   TimeDateStamp;					// Data i hora de generaci
	 DWORD   PointerToSymbolTable;		// RVA a la taula de smbols
	 DWORD   NumberOfSymbols;				// Nombre d'entrades a la taula de smbols
	 WORD    SizeOfOptionalHeader;		// Tamany de la capcelera "opcional"
	 WORD    Characteristics;				// Flags del fitxer
} IMAGE_FILE_HEADER, *PIMAGE_FILE_HEADER;

#define IMAGE_SIZEOF_FILE_HEADER             20		  // Tamany de l'estructura anterior

#define IMAGE_FILE_RELOCS_STRIPPED           0x0001  // Relocation info stripped from file
#define IMAGE_FILE_EXECUTABLE_IMAGE          0x0002  // File is executable  (i.e. no unresolved externel references)
//#define IMAGE_FILE_LINE_NUMS_STRIPPED        0x0004  // Line nunbers stripped from file
//#define IMAGE_FILE_LOCAL_SYMS_STRIPPED       0x0008  // Local symbols stripped from file
//#define IMAGE_FILE_MINIMAL_OBJECT            0x0010  // Reservat
//#define IMAGE_FILE_UPDATE_OBJECT             0x0020  // Reservat
#define IMAGE_FILE_16BIT_MACHINE             0x0040  // 16 bit word machine
#define IMAGE_FILE_BYTES_REVERSED_LO         0x0080  // Bytes of machine word are reversed
#define IMAGE_FILE_32BIT_MACHINE             0x0100  // 32 bit word machine
//#define IMAGE_FILE_DEBUG_STRIPPED            0x0200  // Debugging info stripped from file in .DBG file
//#define IMAGE_FILE_PATCH                     0x0400  // Reserved
#define IMAGE_FILE_SYSTEM                    0x1000  // System File
#define IMAGE_FILE_DLL                       0x2000  // File is a DLL
#define IMAGE_FILE_BYTES_REVERSED_HI         0x8000  // Bytes of machine word are reversed

#define IMAGE_FILE_MACHINE_I386              0x14c   // Intel 386
#define IMAGE_FILE_MACHINE_R3000             0x162   // MIPS little-endian, 0540 big-endian
#define IMAGE_FILE_MACHINE_R4000             0x166   // MIPS little-endian
#define IMAGE_FILE_MACHINE_ALPHA             0x184   // Alpha_AXP
#define IMAGE_FILE_MACHINE_POWERPC           0x1F0   // IBM PowerPC Little-Endian

//
// Format de directori (Directory format)
//

typedef struct _IMAGE_DATA_DIRECTORY {
	 DWORD   VirtualAddress;
	 DWORD   Size;
} IMAGE_DATA_DIRECTORY, *PIMAGE_DATA_DIRECTORY;

#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES    16

//
// Format de la capcelera "opcional" (Optional header)
//

typedef struct _IMAGE_OPTIONAL_HEADER {
	 //
	 // Camps standard
	 //

	 WORD    Magic;									// Marca de capcelera
	 BYTE    MajorLinkerVersion;					// Versi del linkador
	 BYTE    MinorLinkerVersion;
	 DWORD   SizeOfCode;								// Tamany del codi
	 DWORD   SizeOfInitializedData;				// Tamany de les dades inicialitzades
	 DWORD   SizeOfUninitializedData;			// Tamany de les dades no inicialitzades
	 DWORD   AddressOfEntryPoint;					// Punt d'entrada al programa
	 DWORD   BaseOfCode;
	 DWORD   BaseOfData;

	 //
	 // Camps adicionals de l'NT/Eros
	 //

	 DWORD   ImageBase;								// Adrea base del fitxer
	 DWORD   SectionAlignment;						// Tamany de l'aliniaci de les seccions
	 DWORD   FileAlignment;							// Tamany de l'aliniaci del fitxer
	 WORD    MajorOperatingSystemVersion;		// Versi del sistema operatiu
	 WORD    MinorOperatingSystemVersion;
	 WORD    MajorImageVersion;					// Versi de l'executable
	 WORD    MinorImageVersion;
	 WORD    MajorSubsystemVersion;				// Versi del subsistema que utilitza
	 WORD    MinorSubsystemVersion;
	 DWORD   Reserved1;
	 DWORD   SizeOfImage;							// Tamany del programa (segons l'aliniaci)
	 DWORD   SizeOfHeaders;							// Tamany de les capceleres
	 DWORD   CheckSum;								// Checksum del fitxer
	 WORD    Subsystem;								// Subsistema que utilitza
	 WORD    DllCharacteristics;					// Flags per a DLLs
	 DWORD   SizeOfStackReserve;					// Tamany de pila assignat
	 DWORD   SizeOfStackCommit;					// Tamany de pila reservat
	 DWORD   SizeOfHeapReserve;					// Tamany de dades assignat
	 DWORD   SizeOfHeapCommit;						// Tamany de dades reservat
	 DWORD   LoaderFlags;							// Flags per al carregador
	 DWORD   NumberOfRvaAndSizes;					// Nombre de RVAs
	 IMAGE_DATA_DIRECTORY DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
} IMAGE_OPTIONAL_HEADER, *PIMAGE_OPTIONAL_HEADER;

#define IMAGE_NT_OPTIONAL_HDR_MAGIC        0x10b

typedef struct _IMAGE_NT_HEADERS {
	 DWORD Signature;
	 IMAGE_FILE_HEADER FileHeader;
	 IMAGE_OPTIONAL_HEADER OptionalHeader;
} IMAGE_NT_HEADERS, *PIMAGE_NT_HEADERS;

#define IMAGE_FIRST_SECTION( ntheader ) ((PIMAGE_SECTION_HEADER)        \
	 ((DWORD)ntheader +                                                  \
	  FIELD_OFFSET( IMAGE_NT_HEADERS, OptionalHeader ) +                 \
	  ((PIMAGE_NT_HEADERS)(ntheader))->FileHeader.SizeOfOptionalHeader   \
	 ))

// Constants per als subsitemes

//#define IMAGE_SUBSYSTEM_UNKNOWN              0   // Subsistema desconegut
#define IMAGE_SUBSYSTEM_NATIVE               1   // No necessita subsistema
#define IMAGE_SUBSYSTEM_WINDOWS_GUI          2   // Requereix el subsistema grfic Spitfire
#define IMAGE_SUBSYSTEM_WINDOWS_CUI          3   // Requereix el subsistema de carcters Spitfire
//#define IMAGE_SUBSYSTEM_OS2_CUI              5   // image runs in the OS/2 character subsystem.
//#define IMAGE_SUBSYSTEM_POSIX_CUI            7   // image run  in the Posix character subsystem.

// Flags Dll

#define IMAGE_LIBRARY_PROCESS_INIT           1   // Inicialitzaci per procs
#define IMAGE_LIBRARY_PROCESS_TERM           2   // Finalitzaci per procs
#define IMAGE_LIBRARY_THREAD_INIT            4   // Inicialitzaci per thread
#define IMAGE_LIBRARY_THREAD_TERM            8   // Finalitzaci per thread

//
// Flags per al carregador
//

#define IMAGE_LOADER_FLAGS_BREAK_ON_LOAD    0x00000001
#define IMAGE_LOADER_FLAGS_DEBUG_ON_LOAD    0x00000002


// Entrades de directori

#define IMAGE_DIRECTORY_ENTRY_EXPORT         0   // Directori d'exportaci
#define IMAGE_DIRECTORY_ENTRY_IMPORT         1   // Directori d'importaci
#define IMAGE_DIRECTORY_ENTRY_RESOURCE       2   // Directori de recursos
#define IMAGE_DIRECTORY_ENTRY_EXCEPTION      3   // Directori d'excepcions
#define IMAGE_DIRECTORY_ENTRY_SECURITY       4   // Directori de seguretat
#define IMAGE_DIRECTORY_ENTRY_BASERELOC      5   // Taula de relocalitzacions
#define IMAGE_DIRECTORY_ENTRY_DEBUG          6   // Directori de depuraci
#define IMAGE_DIRECTORY_ENTRY_COPYRIGHT      7   // Cadena de descripci
#define IMAGE_DIRECTORY_ENTRY_GLOBALPTR      8   // Valor de la mquina (MIPS GP)
#define IMAGE_DIRECTORY_ENTRY_TLS            9   // Directori de TLS
#define IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG   10   // Directori de configuraci de crrega

//
// Format de capcelera de secci
//

#define IMAGE_SIZEOF_SHORT_NAME              8	 // Tamany del nom curt de secci

typedef struct _IMAGE_SECTION_HEADER {
	 BYTE    Name[IMAGE_SIZEOF_SHORT_NAME];		// Nom de la secci
	 union {
				DWORD   PhysicalAddress;				// Adrea fsica de la secci (OBJ)
				DWORD   VirtualSize;						// Tamany virtual de la secci (EXE/DLL)
	 } Misc;
	 DWORD   VirtualAddress;							// Adrea virtual de la secci
	 DWORD   SizeOfRawData;								// Tamany fsic de la secci
	 DWORD   PointerToRawData;							// RVA a la secci
	 DWORD   PointerToRelocations;					// RVA a les relocalitzacions
	 DWORD   PointerToLinenumbers;					// RVA als nombres de lnia
	 WORD    NumberOfRelocations;						// Nombre de relocalitzacions
	 WORD    NumberOfLinenumbers;						// Nombre de nmeros de lnia
	 DWORD   Characteristics;							// Flags de la secci
} IMAGE_SECTION_HEADER, *PIMAGE_SECTION_HEADER;

#define IMAGE_SIZEOF_SECTION_HEADER          40	// Tamany de l'estructura anterior

#define IMAGE_SCN_TYPE_REGULAR               0x00000000  //
#define IMAGE_SCN_TYPE_DUMMY                 0x00000001  // Reserved.
#define IMAGE_SCN_TYPE_NO_LOAD               0x00000002  // Reserved.
#define IMAGE_SCN_TYPE_GROUPED               0x00000004  // Used for 16-bit offset code.
#define IMAGE_SCN_TYPE_NO_PAD                0x00000008  // Reserved.
#define IMAGE_SCN_TYPE_COPY                  0x00000010  // Reserved.

#define IMAGE_SCN_CNT_CODE                   0x00000020  // Section contains code.
#define IMAGE_SCN_CNT_INITIALIZED_DATA       0x00000040  // Section contains initialized data.
#define IMAGE_SCN_CNT_UNINITIALIZED_DATA     0x00000080  // Section contains uninitialized data.

#define IMAGE_SCN_LNK_OTHER                  0x00000100  // Reserved.
#define IMAGE_SCN_LNK_INFO                   0x00000200  // Section contains comments or some other type of information.
#define IMAGE_SCN_LNK_OVERLAY                0x00000400  // Section contains an overlay.
#define IMAGE_SCN_LNK_REMOVE                 0x00000800  // Section contents will not become part of image.
#define IMAGE_SCN_LNK_COMDAT                 0x00001000  // Section contents comdat.

#define IMAGE_SCN_ALIGN_1BYTES               0x00100000  //
#define IMAGE_SCN_ALIGN_2BYTES               0x00200000  //
#define IMAGE_SCN_ALIGN_4BYTES               0x00300000  //
#define IMAGE_SCN_ALIGN_8BYTES               0x00400000  //
#define IMAGE_SCN_ALIGN_16BYTES              0x00500000  // Default alignment if no others are specified.
#define IMAGE_SCN_ALIGN_32BYTES              0x00600000  //
#define IMAGE_SCN_ALIGN_64BYTES              0x00700000  //

#define IMAGE_SCN_MEM_DISCARDABLE            0x02000000L  // Section can be discarded.
#define IMAGE_SCN_MEM_NOT_CACHED             0x04000000L  // Section is not cachable.
#define IMAGE_SCN_MEM_NOT_PAGED              0x08000000L  // Section is not pageable.
#define IMAGE_SCN_MEM_SHARED                 0x10000000L  // Section is shareable.
#define IMAGE_SCN_MEM_EXECUTE                0x20000000L  // Section is executable.
#define IMAGE_SCN_MEM_READ                   0x40000000L  // Section is readable.
#define IMAGE_SCN_MEM_WRITE                  0x80000000L  // Section is writeable.
/*
//
// Relocation format.
//

typedef struct _IMAGE_RELOCATION {
	 DWORD   VirtualAddress;
	 DWORD   SymbolTableIndex;
	 WORD    Type;
} IMAGE_RELOCATION;
typedef IMAGE_RELOCATION UNALIGNED *PIMAGE_RELOCATION;

#define IMAGE_SIZEOF_RELOCATION              10

//
// I386 relocation types.
//

#define IMAGE_REL_I386_ABSOLUTE              0           // Reference is absolute, no relocation is necessary
#define IMAGE_REL_I386_DIR16                 01          // Direct 16-bit reference to the symbols virtual address
#define IMAGE_REL_I386_REL16                 02          // PC-relative 16-bit reference to the symbols virtual address
#define IMAGE_REL_I386_DIR32                 06          // Direct 32-bit reference to the symbols virtual address
#define IMAGE_REL_I386_DIR32NB               07          // Direct 32-bit reference to the symbols virtual address, base not included
#define IMAGE_REL_I386_SEG12                 011         // Direct 16-bit reference to the segment-selector bits of a 32-bit virtual address
#define IMAGE_REL_I386_SECTION               012
#define IMAGE_REL_I386_SECREL                013
#define IMAGE_REL_I386_REL32                 024         // PC-relative 32-bit reference to the symbols virtual address

//
// MIPS relocation types.
//

#define IMAGE_REL_MIPS_ABSOLUTE              0           // Reference is absolute, no relocation is necessary
#define IMAGE_REL_MIPS_REFHALF               01
#define IMAGE_REL_MIPS_REFWORD               02
#define IMAGE_REL_MIPS_JMPADDR               03
#define IMAGE_REL_MIPS_REFHI                 04
#define IMAGE_REL_MIPS_REFLO                 05
#define IMAGE_REL_MIPS_GPREL                 06
#define IMAGE_REL_MIPS_LITERAL               07
#define IMAGE_REL_MIPS_SECTION               012
#define IMAGE_REL_MIPS_SECREL                013
#define IMAGE_REL_MIPS_REFWORDNB             042
#define IMAGE_REL_MIPS_PAIR                  045

//
// Alpha Relocation types.
//

#define IMAGE_REL_ALPHA_ABSOLUTE             0x0
#define IMAGE_REL_ALPHA_REFLONG              0x1
#define IMAGE_REL_ALPHA_REFQUAD              0x2
#define IMAGE_REL_ALPHA_GPREL32              0x3
#define IMAGE_REL_ALPHA_LITERAL              0x4
#define IMAGE_REL_ALPHA_LITUSE               0x5
#define IMAGE_REL_ALPHA_GPDISP               0x6
#define IMAGE_REL_ALPHA_BRADDR               0x7
#define IMAGE_REL_ALPHA_HINT                 0x8
#define IMAGE_REL_ALPHA_INLINE_REFLONG       0x9
#define IMAGE_REL_ALPHA_REFHI                0xA
#define IMAGE_REL_ALPHA_REFLO                0xB
#define IMAGE_REL_ALPHA_PAIR                 0xC
#define IMAGE_REL_ALPHA_MATCH                0xD
#define IMAGE_REL_ALPHA_SECTION              0xE
#define IMAGE_REL_ALPHA_SECREL               0xF
#define IMAGE_REL_ALPHA_REFLONGNB            0x10

//
// IBM PowerPC relocation types.
//

#define IMAGE_REL_PPC_ABSOLUTE 0x0000  // NOP
#define IMAGE_REL_PPC_ADDR64   0x0001  // 64-bit address
#define IMAGE_REL_PPC_ADDR32   0x0002  // 32-bit address
#define IMAGE_REL_PPC_ADDR24   0x0003  // 26-bit address, shifted left 2 (branch absolute)
#define IMAGE_REL_PPC_ADDR16   0x0004  // 16-bit address
#define IMAGE_REL_PPC_ADDR14   0x0005  // 16-bit address, shifted left 2 (load doubleword)
#define IMAGE_REL_PPC_REL24    0x0006  // 26-bit PC-relative offset, shifted left 2 (branch relative)
#define IMAGE_REL_PPC_REL14    0x0007  // 16-bit PC-relative offset, shifted left 2 (br cond relative)
#define IMAGE_REL_PPC_TOCREL16 0x0008  // 16-bit offset from TOC base
#define IMAGE_REL_PPC_TOCREL14 0x0009  // 16-bit offset from TOC base, shifted left 2 (load doubleword)

#define IMAGE_REL_PPC_ADDR32NB 0x000A  // 32-bit addr w/o image base
#define IMAGE_REL_PPC_SECREL   0x000B  // va of containing section (as in an image sectionhdr)
#define IMAGE_REL_PPC_SECTION  0x000C  // sectionheader number
#define IMAGE_REL_PPC_IFGLUE   0x000D  // substitute TOC restore instruction iff symbol is glue code
#define IMAGE_REL_PPC_IMGLUE   0x000E  // symbol is glue code; virtual address is TOC restore instruction

#define IMAGE_REL_PPC_TYPEMASK 0x00FF  // mask to isolate above values in IMAGE_RELOCATION.Type

// Flag bits in IMAGE_RELOCATION.TYPE

#define IMAGE_REL_PPC_NEG      0x0100  // subtract reloc value rather than adding it
#define IMAGE_REL_PPC_BRTAKEN  0x0200  // fix branch prediction bit to predict branch taken
#define IMAGE_REL_PPC_BRNTAKEN 0x0400  // fix branch prediction bit to predict branch not taken
#define IMAGE_REL_PPC_TOCDEFN  0x0800  // toc slot defined in file (or, data in toc)

//
// Based relocation format.
//

typedef struct _IMAGE_BASE_RELOCATION {
	 DWORD   VirtualAddress;
	 DWORD   SizeOfBlock;
//  WORD    TypeOffset[1];
} IMAGE_BASE_RELOCATION, *PIMAGE_BASE_RELOCATION;

#define IMAGE_SIZEOF_BASE_RELOCATION         8

//
// Based relocation types.
//

#define IMAGE_REL_BASED_ABSOLUTE              0
#define IMAGE_REL_BASED_HIGH                  1
#define IMAGE_REL_BASED_LOW                   2
#define IMAGE_REL_BASED_HIGHLOW               3
#define IMAGE_REL_BASED_HIGHADJ               4
#define IMAGE_REL_BASED_MIPS_JMPADDR          5

//
// Archive format.
//

#define IMAGE_ARCHIVE_START_SIZE             8
#define IMAGE_ARCHIVE_START                  "!<arch>\n"
#define IMAGE_ARCHIVE_END                    "`\n"
#define IMAGE_ARCHIVE_PAD                    "\n"
#define IMAGE_ARCHIVE_LINKER_MEMBER          "/               "
#define IMAGE_ARCHIVE_LONGNAMES_MEMBER       "//              "

typedef struct _IMAGE_ARCHIVE_MEMBER_HEADER {
	 BYTE     Name[16];                                  // File member name - `/' terminated.
	 BYTE     Date[12];                                  // File member date - decimal.
	 BYTE     UserID[6];                                 // File member user id - decimal.
	 BYTE     GroupID[6];                                // File member group id - decimal.
	 BYTE     Mode[8];                                   // File member mode - octal.
	 BYTE     Size[10];                                  // File member size - decimal.
	 BYTE     EndHeader[2];                              // String to end header.
} IMAGE_ARCHIVE_MEMBER_HEADER, *PIMAGE_ARCHIVE_MEMBER_HEADER;

#define IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR      60
*/
//
// Export Format
//

typedef struct _IMAGE_EXPORT_DIRECTORY {
	 DWORD   Characteristics;
	 DWORD   TimeDateStamp;
	 WORD    MajorVersion;
	 WORD    MinorVersion;
	 DWORD   Name;
	 DWORD   Base;
	 DWORD   NumberOfFunctions;
	 DWORD   NumberOfNames;
	 PDWORD  *AddressOfFunctions;
	 PDWORD  *AddressOfNames;
	 PWORD   *AddressOfNameOrdinals;
} IMAGE_EXPORT_DIRECTORY, *PIMAGE_EXPORT_DIRECTORY;

//
// Import Format
//

typedef struct _IMAGE_IMPORT_BY_NAME {
	 WORD    Hint;
	 BYTE    Name[1];
} IMAGE_IMPORT_BY_NAME, *PIMAGE_IMPORT_BY_NAME;

typedef struct _IMAGE_THUNK_DATA {
	 union {
		  PDWORD Function;
		  DWORD Ordinal;
		  PIMAGE_IMPORT_BY_NAME AddressOfData;
	 } u1;
} IMAGE_THUNK_DATA, *PIMAGE_THUNK_DATA;

#define IMAGE_ORDINAL_FLAG 0x80000000
#define IMAGE_SNAP_BY_ORDINAL(Ordinal) ((Ordinal & IMAGE_ORDINAL_FLAG) != 0)
#define IMAGE_ORDINAL(Ordinal) (Ordinal & 0xffff)

typedef struct _IMAGE_IMPORT_DESCRIPTOR {
	 DWORD   Characteristics;
	 DWORD   TimeDateStamp;
	 DWORD   ForwarderChain;
	 DWORD   Name;
	 PIMAGE_THUNK_DATA FirstThunk;
} IMAGE_IMPORT_DESCRIPTOR, *PIMAGE_IMPORT_DESCRIPTOR;
/*
//
// Thread Local Storage
//

typedef VOID (NTAPI *PIMAGE_TLS_CALLBACK) ( PVOID DllHandle, DWORD Reason, PVOID Reserved );

typedef struct _IMAGE_TLS_DIRECTORY {
	 DWORD   StartAddressOfRawData;
	 DWORD   EndAddressOfRawData;
	 PDWORD  AddressOfIndex;
	 PIMAGE_TLS_CALLBACK *AddressOfCallBacks;
	 DWORD   SizeOfZeroFill;
	 DWORD   Characteristics;
} IMAGE_TLS_DIRECTORY, *PIMAGE_TLS_DIRECTORY;
*/
/*
//
// Resource Format.
//

//
// Resource directory consists of two counts, following by a variable length
// array of directory entries.  The first count is the number of entries at
// beginning of the array that have actual names associated with each entry.
// The entries are in ascending order, case insensitive strings.  The second
// count is the number of entries that immediately follow the named entries.
// This second count identifies the number of entries that have 31-bit integer
// Ids as their name.  These entries are also sorted in ascending order.
//
// This structure allows fast lookup by either name or number, but for any
// given resource entry only one form of lookup is supported, not both.
// This is consistant with the syntax of the .RC file and the .RES file.
//

typedef struct _IMAGE_RESOURCE_DIRECTORY {
	 DWORD   Characteristics;
	 DWORD   TimeDateStamp;
	 WORD    MajorVersion;
	 WORD    MinorVersion;
	 WORD    NumberOfNamedEntries;
	 WORD    NumberOfIdEntries;
//  IMAGE_RESOURCE_DIRECTORY_ENTRY DirectoryEntries[];
} IMAGE_RESOURCE_DIRECTORY, *PIMAGE_RESOURCE_DIRECTORY;

#define IMAGE_RESOURCE_NAME_IS_STRING        0x80000000
#define IMAGE_RESOURCE_DATA_IS_DIRECTORY     0x80000000

//
// Each directory contains the 32-bit Name of the entry and an offset,
// relative to the beginning of the resource directory of the data associated
// with this directory entry.  If the name of the entry is an actual text
// string instead of an integer Id, then the high order bit of the name field
// is set to one and the low order 31-bits are an offset, relative to the
// beginning of the resource directory of the string, which is of type
// IMAGE_RESOURCE_DIRECTORY_STRING.  Otherwise the high bit is clear and the
// low-order 31-bits are the integer Id that identify this resource directory
// entry. If the directory entry is yet another resource directory (i.e. a
// subdirectory), then the high order bit of the offset field will be
// set to indicate this.  Otherwise the high bit is clear and the offset
// field points to a resource data entry.
//

typedef struct _IMAGE_RESOURCE_DIRECTORY_ENTRY {
	 DWORD   Name;
	 DWORD   OffsetToData;
} IMAGE_RESOURCE_DIRECTORY_ENTRY, *PIMAGE_RESOURCE_DIRECTORY_ENTRY;

//
// For resource directory entries that have actual string names, the Name
// field of the directory entry points to an object of the following type.
// All of these string objects are stored together after the last resource
// directory entry and before the first resource data object.  This minimizes
// the impact of these variable length objects on the alignment of the fixed
// size directory entry objects.
//

typedef struct _IMAGE_RESOURCE_DIRECTORY_STRING {
	 WORD    Length;
	 CHAR    NameString[ 1 ];
} IMAGE_RESOURCE_DIRECTORY_STRING, *PIMAGE_RESOURCE_DIRECTORY_STRING;

typedef struct _IMAGE_RESOURCE_DIR_STRING_U {
	 WORD    Length;
	 WCHAR   NameString[ 1 ];
} IMAGE_RESOURCE_DIR_STRING_U, *PIMAGE_RESOURCE_DIR_STRING_U;

//
// Each resource data entry describes a leaf node in the resource directory
// tree.  It contains an offset, relative to the beginning of the resource
// directory of the data for the resource, a size field that gives the number
// of bytes of data at that offset, a CodePage that should be used when
// decoding code point values within the resource data.  Typically for new
// applications the code page would be the unicode code page.
//

typedef struct _IMAGE_RESOURCE_DATA_ENTRY {
	 DWORD   OffsetToData;
	 DWORD   Size;
	 DWORD   CodePage;
	 DWORD   Reserved;
} IMAGE_RESOURCE_DATA_ENTRY, *PIMAGE_RESOURCE_DATA_ENTRY;
*/

#include "poppack.h"								// Tornem a l'aliniaci anterior

#endif		// __WINDOWS_H
#endif		// _HEADERS_H

