/* **************************************************************************
*                                                                           *
*  XMem.CPP                                                                 *
*                                                                           *
*  14-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Funcions per a accedir a memria estesa des del mode real                *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "xmem.h"
#include "common.h"

#define OFFSET_DATA			DESCRIPTOR_SIZE * 2
#define OFFSET_CODE			DESCRIPTOR_SIZE

// El processador necessita aquestes dades en aquest ordre
// Representa la GDT que utilitza el sistema en mode protegit
WORD gdt_size = GDT_ENTRIES * DESCRIPTOR_SIZE - 1;
DWORD gdt_addr = GDT_OFFSET;

// El processador necessita aquestes dades en aquest ordre
WORD idt_size = IDT_ENTRIES * DESCRIPTOR_SIZE - 1;
DWORD idt_addr = IDT_OFFSET;

// El processador necessita aquestes dades en aquest ordre
// Representa la GDT utilitzada durant l'execuci de DOSLoad
WORD r_gdt_size = GDT_DESCRIPTORS * DESCRIPTOR_SIZE - 1;
DWORD r_gdt_addr = 0L;

// Aquesta s la GDT utilitzada durant l'execuci de DOSLoad
BYTE real_gdt[ 5 * DESCRIPTOR_SIZE ] =
	{
	0, 0, 0, 0, 0, 0, 0, 0,			/* Descriptor nul */
	0xff, 0xff, 0, 0, 0, 0x9a, 0xcf, 0,	/* Descriptor de CODI: DPL 0 Base 0 Lmit 4GB */
	0xff, 0xff, 0, 0, 0, 0x92, 0xcf, 0	/* Descriptor de DADES: DPL 0 Base 0 Lmit 4GB */
	};

#define KERNEL_STACK		4096
// Aquesta s la pila que s'utilitza durant la inicialitzaci del 'Kernel' i l'AAL
BYTE pila[ KERNEL_STACK ];

// Aquesta rutina salta cap a la rutina que comenar l'execuci del Kernel
void Execute32()
	{
	asm
		{
		.386p

		mov ax, ds						// Obtenim el valor del segment de les dades
		cwde
		mov cl, 4
		shl eax, cl
		mov ecx, eax
		add ecx, offset pila
		add ecx, KERNEL_STACK		// Ara l'ECX cont la posici ms alta de la pila
		lgdt qword ptr [gdt_size]	// Li indiquem al processador on est la GDT
		cli
		lidt qword ptr [idt_size]	// Li indiquem al processador on est l'IDT
		mov eax, cr0					// Entrem en el mode protegit
		or al, 1
		mov cr0, eax
		jmp short esb1
esb1:
		mov bx, OFFSET_DATA			// Inicialitzem els registres de segment
		mov fs, bx						// amb el selector corresponent
		mov ds, bx
		mov es, bx
		mov ss, bx
		mov esp, ecx					// El desplaament dins la pila estava en ECX

		mov ecx, OFFSET_CODE
		mov eax, 80000h				// El directori de pgines est en aquesta posici
		mov cr3, eax

		push ecx							// selector
		mov ax, seg punt
		cwde
		shl eax, 4
		push eax							// desplaament
		db 66h							// s un 'retf' de 32bits
		retf								// Retornem cap a la funci 'punt'
		}
	}

// Aquesta funci copia una regi de memria a una altra zona
// Funciona a 32bits encara que estiguem en mode real perqu incorpora un truc
// Necessita que el selector de FS es correspongui amb un segment de base 0
// i lmit 4GB.
void x_memcopy( DWORD dest, DWORD source, DWORD size )
	{
	asm
		{
		mov esi, dword ptr source	// Inicialitzem els registres
		mov edi, dword ptr dest
		mov ecx, dword ptr size
		test ecx, 1
		je cop02
											// Si el tamany s senar
		mov al, byte ptr fs:[esi]	// Copiem el primer 'byte'
		mov byte ptr fs:[edi], al
		inc esi							// Incrementem en un els apuntadors
		inc edi
cop02:
		shr ecx, 1						// A partir d'ara copiarem paraules
		test ecx, 1
		je pre03
											// Si el nou tamany torna a ser senar
		mov ax, word ptr fs:[esi]	// Copiem la paraula corresponent
		mov word ptr fs:[edi], ax
		add esi, 2						// Actualitzem els apuntadors
		add edi, 2
pre03:
		shr ecx, 1						// A partir d'ara copiarem dobles paraules

cop03:
		mov eax, dword ptr fs:[esi]	// Copiem una doble paraula
		mov dword ptr fs:[edi], eax
		add esi, 4						// Actualitzem els apuntadors
		add edi, 4
		loop cop03						// Repetim
		}
// Aqu presentem una versi simplificada de la funci
// Aquesta versi copia 'byte' a 'byte' i per aix s ms ineficient
/*
	asm
		{
		mov esi, dword ptr source
		mov edi, dword ptr dest
		mov ecx, dword ptr size

cop04:
		mov al, byte ptr fs:[esi]
		mov byte ptr fs:[edi], al
		inc esi
		inc edi
		loop cop04
		}
*/
	}

// Aquesta funci prepara el processador per a poder accedir a qualsevol posici
// de la memria des del mode real
void x_memprep()
	{
	asm
		{
		mov ax, ds							// Trobem la posici de la GDT de DOSLoad
		cwde
		mov cl, 4
		shl eax, cl
		add eax, offset real_gdt
		mov dword ptr r_gdt_addr, eax
		lgdt qword ptr [r_gdt_size]	// Li indiquem al processador quina GDT volem utilitzar
		cli									// No volem rebre cap interrupci
		mov eax, cr0						// Passem al mode protegit
		or al, 1
		mov cr0, eax
		jmp short fesb1
fesb1:
		mov bx, OFFSET_DATA				// Inicialitzem FS amb un segment de 4GB.
		mov fs, bx
												// Calculem la quantitat de memria del sistema
		mov edx, 1ffffch					// Comencem al final del 1er. MB.
		xor ebx, ebx
		mov ecx, 44616e69h				// 'Dani' com a cadena de comprovaci
MEMLoop:
		mov dword ptr fs:[edx], 0h		// Inicialitzem la posici
		mov dword ptr fs:[edx], ecx	// Escrivim la cadena
		mov ebx, dword ptr fs:[edx]	// Obtenim la cadena
		cmp ebx, ecx						// Si s'ha escrit b, la memria existeix
		jne MEMLoopEnd
		add edx, 100000h					// Passem al MB. segent
		xor ebx, ebx
		jmp MEMLoop							// Repetim
MEMLoopEnd:									// Fins a EDX existeix memria fsica
		sub edx, 0ffffch					// Restem a EDX el desplaament
		mov ebx, 7fffch					// Aquesta posici de memria contindr el valor obtingut
		mov dword ptr fs:[ebx], edx	// Guardem el valor

		and al, 0feh						// Tornem al mode real
		mov cr0, eax
		jmp short fesb2
fesb2:
		xor bx, bx							// Restaurem FS amb el valor 0, per el processador
		mov fs, bx							// continuar utilitzant la GDT
		sti									// Ja podem rebre interrupcions
		}
	}

// Funci que allibera la lnia A20
// La lnia A20 s la corresponent al 'bit' d'adreces nmero 20. Els IBM PC
// originals noms podien accedir a 1MB. de memria, de manera que quan
// s'intentava accedir a la posici FFFF:0010, s'estava accedint a la posici
// 0000:0000. Amb l'aparici dels processadors 80286 es va superar aquest lmit,
// per com que hi havia moltes aplicacions per als IBM PC, els dissenyadors
// de l'IBM AT van incorporar un mecanisme de compatibilitat: la lnia A20
// sempre s zero fins que s'allibera. D'aquesta manera, els programes que volen
// accedir a la memria estesa han d'alliberar aquesta lnia abans de fer-ho.
// Aquesta lnia la gestiona el controlador del teclat.
void TurnOnA20()
	{
	asm
		{
		cli					// No volem interrupcions
								// Alliberem la lnia tal com ho fan tots els sistemes operatius
		xor cx, cx
on0:
		in al, 64h
		test al, 02h
		loopnz on0
		mov al, 0D1h
		out 64h, al
		xor cx, cx
on1:
		in al, 64h
		test al, 02h
		loopnz on1
		mov al, 0DFh
		out 60h, al
		xor cx, cx
on2:
		in al, 64h
		test al, 02h
		loopnz on2

		sti				  // Ja podem rebre interrupcions
		}
	}

// Funci que inhabilita les interrupcions
void cli()
	{
	asm cli
	}

