/* **************************************************************************
*                                                                           *
*  AAL.CPP                                                                  *
*                                                                           *
*  14-03-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Architecture Abstraction Library                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "aal\aal.h"
#include "aal\asm.h"
#include "aal\interrup.h"
#include "kernel\kernel.h"
#include "kernel\mem.h"
#include "errors.h"
#include "string.h"
#include "kernel\system.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER			TEXT( "0.01" )
#define AAL_VERSION	0x00000001
#else
#define _VER			TEXT( "1.00" )
#define AAL_VERSION	0x00010000
#endif

#define _BUILD    	10

#define FIRST_IRQ		0x20	/* Primera interrupci 'hardware' */

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;

// *********************************** FUNCIONS
CaalAAL::CaalAAL() : CkeType( CID_AAL )
	{
	{
	CHAR str[ 80 ];
	sprintf( str, TEXT( "AAL    Module ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	(System->Console())->OutText( str );
	}

	ppic = new CPIC(); // Construm els objectes de control dels xips
	pdma = new CDMA();

// Inicialitzem el 'timertick' a una interrupci cada 10ms
	Kernel->OutByte( 0x40, 0x9c );
	Kernel->OutByte( 0x40, 0x2e );

	// Preparem les rutines de gesti d'interrupcions
	System->RegisterInterrupt( INT_IRQ0 + FIRST_IRQ, (DWORD) IRQ0 );
	System->RegisterInterrupt( INT_IRQ1 + FIRST_IRQ, (DWORD) IRQ1 );
	System->RegisterInterrupt( INT_IRQ2 + FIRST_IRQ, (DWORD) IRQ2 );
	System->RegisterInterrupt( INT_IRQ3 + FIRST_IRQ, (DWORD) IRQ3 );
	System->RegisterInterrupt( INT_IRQ4 + FIRST_IRQ, (DWORD) IRQ4 );
	System->RegisterInterrupt( INT_IRQ5 + FIRST_IRQ, (DWORD) IRQ5 );
	System->RegisterInterrupt( INT_IRQ6 + FIRST_IRQ, (DWORD) IRQ6 );
	System->RegisterInterrupt( INT_IRQ7 + FIRST_IRQ, (DWORD) IRQ7 );
	System->RegisterInterrupt( INT_IRQ8 + FIRST_IRQ, (DWORD) IRQ8 );
	System->RegisterInterrupt( INT_IRQ9 + FIRST_IRQ, (DWORD) IRQ9 );
	System->RegisterInterrupt( INT_IRQA + FIRST_IRQ, (DWORD) IRQA );
	System->RegisterInterrupt( INT_IRQB + FIRST_IRQ, (DWORD) IRQB );
	System->RegisterInterrupt( INT_IRQC + FIRST_IRQ, (DWORD) IRQC );
	System->RegisterInterrupt( INT_IRQD + FIRST_IRQ, (DWORD) IRQD );
	System->RegisterInterrupt( INT_IRQE + FIRST_IRQ, (DWORD) IRQE );
	System->RegisterInterrupt( INT_IRQF + FIRST_IRQ, (DWORD) IRQF );
	}

// **************************************************************************
// Destructor de la classe
CaalAAL::~CaalAAL()
	{
// No s'arriba a cridar mai
	TRACE( TEXT( "BUG CaalAAL::~CaalAAL CRIDAT!!!!!! BUG" ) );
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CaalAAL::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_AAL )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna la versi del mdul
DWORD CaalAAL::Version()
	{
	return AAL_VERSION;
	}

// **************************************************************************
// Indica per a quina arquitectura s'ha implementat el mdul
DWORD CaalAAL::Architecture()
	{
	return AAL_ARCH_ISA;
	}

// **************************************************************************
// Indica si hi ha coprocessador matemtic
BOOL CaalAAL::MathProcessor()
	{
	CCMOS cmos;
	return cmos.MathProcessor();
	}

// **************************************************************************
// Retorna el tipus de disquetera (la primera)
BYTE CaalAAL::TypeOfFloppy0()
	{
	CCMOS cmos;
	return cmos.Drive0Type();
	}

// **************************************************************************
// Retorna el tipus de disquetera (la segona)
BYTE CaalAAL::TypeOfFloppy1()
	{
	CCMOS cmos;
	return cmos.Drive1Type();
	}

// **************************************************************************
// Retorna l'hora actual (hora 0-23, minut 0-59 i segon 0-59)
TAAL_TIME CaalAAL::Time()
	{
	CCMOS cmos;
	return cmos.Time();
	}

// **************************************************************************
// Retorna la data actual (dia, mes, any i dia de la setmana)
TAAL_DATE CaalAAL::Date()
	{
	CCMOS cmos;
	return cmos.Date();
	}

// **************************************************************************
// Canvia l'hora del sistema
// Com a entrada ha de rebre:
// Time     	- Hora, minut i segon que volem
VOID CaalAAL::Time( TAAL_TIME Time )
	{
	CCMOS cmos;
	cmos.Time( Time );
	}

// **************************************************************************
// Canvia la data del sistema
// Com a entrada ha de rebre:
// Date     	- Dia, mes i any que volem
VOID CaalAAL::Date( TAAL_DATE Date )
	{
	CCMOS cmos;
	cmos.Date( Date );
	}

// **************************************************************************
// Realitza un 'End Of Interruption'
// Com a entrada ha de rebre:
// IRQ      	- Identificador de la interrupci que s'ha de finalitzar
VOID CaalAAL::EOI( BYTE cIRQ )
	{
	ppic->EOI( cIRQ );
	}

// **************************************************************************
// Canvia el gestor d'una interrupci 'hardware'
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que volem gestionar
// Address  	- Apuntador cap a la rutina de servei d'interrupci
VOID CaalAAL::IRQHandler( BYTE cIRQ, DWORD dwAddress )
	{
	System->RegisterInterrupt( (BYTE) (cIRQ + FIRST_IRQ), dwAddress );
	}

// **************************************************************************
// Retorna l'adrea de la rutina de servei d'interrupci demanada
// Com a entrada ha de rebre:
// IRQ      	- Interrupci demanada
DWORD CaalAAL::IRQHandler( BYTE cIRQ )
	{
	return System->Interrupt( (BYTE) (cIRQ + FIRST_IRQ) );
	}

// **************************************************************************
// Enmascara una certa interrupci 'hardware'
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que volem enmascarar
VOID CaalAAL::MaskIRQ( BYTE cIRQ )
	{
	ppic->MaskIRQ( cIRQ );
	}

// **************************************************************************
// Desenmascara una certa interrupci 'hardware'
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que volem desenmascarar
VOID CaalAAL::UnmaskIRQ( BYTE cIRQ )
	{
	ppic->UnmaskIRQ( cIRQ );
	}

// **************************************************************************
// Reserva un canal DMA a un cert procs
// Com a entrada ha de rebre:
// Channel  	- Canal que volem reservar
VOID CaalAAL::ReserveDMAChannel( BYTE cChannel )
	{
	pdma->ReserveChannel( cChannel, (System->Running())->Process() );
	}

// **************************************************************************
// Allibera un canal DMA anteriorment reservat per un cert procs
// Com a entrada ha de rebre:
// Channel  	- Canal que volem alliberar
VOID CaalAAL::FreeDMAChannel( BYTE cChannel )
	{
	pdma->FreeChannel( cChannel, (System->Running())->Process() );
	}

// **************************************************************************
// Inicialitza el DMA per a una transferncia
// Com a entrada ha de rebre:
// Channel  	- Canal per el qual farem la transferncia
// Mode     	- Mode utilitzat per a la transferncia
// Type     	- Tipus de transferncia a realitzar
// Address  	- Adrea fsica origen o dest de les dades
// Size     	- Quantitat de 'bytes' a transferir
VOID CaalAAL::DMATransfer( BYTE cChannel, BYTE cMode, BYTE cType, DWORD dwAddress, DWORD dwSize )
	{
	pdma->TransferData( cChannel, (System->Running())->Process(), cMode, cType, dwAddress, dwSize );
	}

// **************************************************************************
// Retorna el residu d'una transferncia de DMA
// Com a entrada ha de rebre:
// Channel  	- Canal del qual en volem conixer el residu
DWORD CaalAAL::DMAGetResidue( BYTE cChannel )
	{
	return pdma->GetResidue( cChannel );
	}

