/* **************************************************************************
*                                                                           *
*  PIC.CPP                                                                  *
*                                                                           *
*  13-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Manipulaci del Programable Interrupt Controller                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "aal\pic.h"
#include "kernel\kernel.h"

DWORD _import CLI();
VOID _import STI( DWORD );
extern PCkeKernel _import Kernel;

// **************************************************************************
// Constructor de la classe
CPIC::CPIC() : CkeType( CID_PIC )
	{
	Kernel->OutByte( PICU1+0, 0x11 ); // ICW1 - MASTER
	Kernel->OutByte( PICU2+0, 0x11 ); // ICW1 - SLAVE
	Kernel->OutByte( PICU1+1, 0x20 ); // ICW2 - MASTER (IRQ0 s INT20h)
	Kernel->OutByte( PICU2+1, 0x28 ); // ICW2 - SLAVE (IRQ8 s INT28h)
	Kernel->OutByte( PICU1+1, 0x04 ); // ICW3 - MASTER
	Kernel->OutByte( PICU2+1, 0x02 ); // ICW3 - SLAVE
	Kernel->OutByte( PICU1+1, 0x01 ); // ICW4 - MASTER
	Kernel->OutByte( PICU2+1, 0x01 ); // ICW4 - SLAVE
	Kernel->OutByte( PICU1+1, 0xfa ); // Enmascarat tot menys 'cascade' i 'timer'
	Kernel->OutByte( PICU2+1, 0xff ); // Esclau tot enmascarat
	}

// **************************************************************************
// Destructor de la classe
CPIC::~CPIC()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CPIC::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_PIC )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Envia un EOI al controlador
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que es vol finalitzar
VOID CPIC::EOI( BYTE cIRQ )
	{
	Kernel->OutByte( PICU1, 0x20 ); // EOI cap al primer controlador

	if( cIRQ > 7 ) // Si la interrupci ve del segon controlador...
		Kernel->OutByte( PICU2, 0x20 ); // ...tamb EOI cap al segon controlador

	Kernel->EOIHelper( cIRQ ); // El 'Kernel' tamb pot realitzar algunes tasques
	}

// **************************************************************************
// Enmascara una interrupci
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que es vol enmascarar
VOID CPIC::MaskIRQ( BYTE cIRQ )
	{
// Comprovar que sigui correcte -BUG
	DWORD flags = CLI();

	DWORD Bit = 1 << cIRQ; // Obtenim el 'bit' corresponent a la interrupci

	if( Bit & 0xff ) // Interrupci del primer controlador
		{
		BYTE in = Kernel->InByte( PICU1+1 ) | (BYTE) (Bit & 0xff); // 1 - enmascara
		Kernel->OutByte( PICU1+1, in );
		}
	else // Interrupci del segon controlador
		{
		BYTE in = Kernel->InByte( PICU2+1 ) | (BYTE) ((Bit >> 8) & 0xff);
		Kernel->OutByte( PICU2+1, in );
		}

	STI( flags );
	}

// **************************************************************************
// Desenmascarar una interrupci
// Com a entrada ha de rebre:
// IRQ      	- Interrupci que es vol desenmascarar
VOID CPIC::UnmaskIRQ( BYTE cIRQ )
	{
// Comprovar que sigui correcte -BUG
	DWORD flags = CLI();

	DWORD Bit = 1 << cIRQ; // Obtenim el 'bit' corresponent a la interrupci

	if( Bit & 0xff ) // Interrupci del primer controlador
		{
		BYTE in = (BYTE) Kernel->InByte( PICU1+1 ) & (BYTE) ~(Bit & 0xff); // 0 - desenmascara
		Kernel->OutByte( PICU1+1, in );
		}
	else // Interrupci del segon controlador
		{
		BYTE in = Kernel->InByte( PICU2+1 ) & (BYTE) ~((Bit >> 8)& 0xff);
		Kernel->OutByte( PICU2+1, in );
		}

	STI( flags );
	}

