/* **************************************************************************
*                                                                           *
*  Cache.CPP                                                                *
*                                                                           *
*  28-04-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Gestor de memria 'cache' de l'Eros                                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\block\private\cache.h"
#include "sys\sys.h"
#include "string.h"
#include "sys\asm.h"
#include "kernel\boxdef.h"
#include "sys\console.h"
#include "kernel\kernel.h"
#include "drivers\messages.h"
#include "sys\timer.h"
#include "aal\aal.h"
#include "kernel\system.h"
#include "errors.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	2
#define VERSION			0x10	/* Noms un 'byte' */

#define DRIVER_LEVEL		10

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
PCsysModule SYSModule = NULL;	// Per a la comunicaci amb el nivell sistema
PCsysConsole pcons;				// Per a presentar missatges per pantalla
PTCachedBlock pCached[ HASH_LISTS ]; // Taula 'hash' de la 'cache'
PTCachedBlock pLRUListHead = NULL; // Apuntador al primer element de la llista LRU
PTCachedBlock pLRUListTail = NULL; // Apuntador a l'ltim element de la llista LRU
DWORD MaxCachedPages = 10;	// Nombre mxim de pgines ocupades per la 'cache'
DWORD CachedPages = 0; // Nombre actual de pgines ocupades per la 'cache'

DWORD _import CLI();
VOID _import STI( DWORD );
VOID _import MicroDelay( DWORD );
BOOL DispatchMessage( TMSG& );

// *********************************** FUNCIONS
void main()
	{
	CHAR str[ 80 ];

	SYSModule = new CsysModule; // Preparem la comunicaci amb el nivell sistema

	PTDriver driver = (PTDriver) malloc( sizeof( TDriver ) );
	driver->cLevel = DRIVER_LEVEL; // Preparem l'estructura de registre
	SYSModule->RegisterDriver( driver ); // Registrem el controlador

	pcons = new CsysConsole;
	sprintf( str, TEXT( "Cache  Mngr   ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( DRIVER_DIR );

	if( !pparent )
		{
		pcons->OutText( TEXT( "CACHE - Error: no pot accedir a DRIVER_DIR\r\n" ) );
		while( 1 )
			{}
		}

	CsysMailBox box( pparent, nCACHE_MAILBOX ); // Creem la bstia de la 'cache'

	TMSG msg;

	for( DWORD i = 0; i < HASH_LISTS; i++ )
		pCached[ i ] = NULL;

	SYSModule->DriverReady(); // Indiquem al sistema que estem preparats

	while( 1 )
		{
		box.WaitMessage( &msg );
		DispatchMessage( msg );
		}
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
BOOL DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Mapegem l'espai d'adreces del flux que fa la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case DRV_GETNAME_DRIVER:
			{
			PTData data = (PTData) msg.dwParam2;
			sprintf( (PSTR) data->dwParam1, TEXT( "Cache Manager" ), data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_GETDEVICENAME_DRIVER:
			{
			PTData data = (PTData) msg.dwParam2;
			sprintf( (PSTR) data->dwParam1, TEXT( "Cache" ), data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_GETVERSION_DRIVER:
			{
			msg.dwParam1 = VERSION;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_GETLEVEL_DRIVER:
			{
			msg.dwParam1 = DRIVER_LEVEL;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_IOCTL_DRIVER:
			{
			sprintf( str, TEXT( "Rebut IOCtl (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			break;
			}

		case DRV_READ_DRIVER:
			{
			sprintf( str, TEXT( "Rebut Read (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			break;
			}

		case DRV_WRITE_DRIVER:
			{
			sprintf( str, TEXT( "Rebut Write (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			break;
			}

		case DRV_GETSTATUS_DRIVER:
			{
			msg.dwParam1 = OK;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_ISEXCLUSIVE_DEVICE:
			{
			msg.dwParam1 = FALSE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_READBLOCK_BLOCKDEV:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = ((PCCache) msg.dwParam1)->Read( (PBYTE) data->dwParam2, data->dwParam1, data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_WRITEBLOCK_BLOCKDEV:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut WriteBlockCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = ((PCCache) msg.dwParam1)->Write( (PBYTE) data->dwParam2, data->dwParam1, data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_LOCK_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut LockDeviceCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = FALSE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_CHECKMEDIA_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut CheckMediaCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = 0;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_HASMEDIA_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut HasMediaCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = TRUE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_ISLOCAL_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut IsLocalCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = TRUE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_ISREMOVABLE_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut IsRemovableCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = FALSE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_CANHASPAGEFILE_DEVICE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut CanHasPageFileCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			msg.dwParam1 = FALSE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_CREATE_CACHE:
			{
			msg.dwParam1 = (DWORD) new CCache( (PCdrvBlockDevice) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_DESTROY_CACHE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut DestroyCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			delete( (PCCache) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		case DRV_FLUSHBLOCK_CACHE:
			{
#ifdef _DEBUG
			sprintf( str, TEXT( "Rebut FlushBlockCache (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
#endif
			((PCCache) msg.dwParam1)->Flush( msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			break;
			}

		default:
			sprintf( str, TEXT( "CACHE.DRV - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostre espai d'adreces

	return FALSE; // Sempre retornem FALSE
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Device   	- Dispositiu de blocs amb el qual est relacionat aquest objecte
CCache::CCache( PCdrvBlockDevice pDevice ) : CkeType( CID_Cache )
	{
	pdev = pDevice;
	dwblocksize = 512;	// Per defecte, el tamany d'un bloc s 512 -BUG
	}

// **************************************************************************
// Destructor de la classe
CCache::~CCache()
	{
	}

// **************************************************************************
// Cerca en la memria 'cache' el bloc demanat
// Com a entrada ha de rebre:
// Block    	- Bloc del dispositiu demanat
PTCachedBlock CCache::Search( DWORD dwBlock )
	{
	// Obtenim la llista segons la funci de 'hash'
	DWORD dwHashList = (dwBlock * dwblocksize / PAGE_SIZE) % HASH_LISTS;

	PTCachedBlock pblock = pCached[ dwHashList ]; // Obtenim el primer element de la llista

	// Cerquem el bloc desitjat
	while( pblock && (pblock->pDevice != pdev || pblock->dwBlock != dwBlock - (dwBlock % (PAGE_SIZE / dwblocksize))) )
		{
		pblock = pblock->pnext;
		}

	if( pblock ) // L'hem trobat
		{
		// s l'utilitzat ms recentment, el passem al final de la llista LRU...
		if( pLRUListHead == pblock && pblock->pLRUnext )
			{
			pLRUListHead = pblock->pLRUnext;
			pLRUListHead->pLRUprev = NULL;
			}

		if( pLRUListTail != pblock ) // ...si no ho est, ja
			{
			pblock->pLRUprev = pLRUListTail;

			if( pLRUListTail )
				pLRUListTail->pLRUnext = pblock;

			pblock->pLRUnext = NULL;
			pLRUListTail = pblock;
			}

		pblock->dwLastUsedTick	= System->TickTime(); // Utilitzat per ltim cop
		return pblock; // Retornem l'element
		}
	else
		return NULL; // No est en la 'cache'
	}

// **************************************************************************
// Afegeix en la memria 'cache' el bloc
// Com a entrada ha de rebre:
// Block    	- Element a afegir
VOID CCache::Add( PTCachedBlock pBlock )
	{
	CachedPages++; // Afegim una nova pgina

	if( MaxCachedPages < CachedPages ) // Si hem superat el lmit
		{
		// Traurem la utilitzada fa ms temps
		PTCachedBlock pfirst = pLRUListHead;
		pLRUListHead = pfirst->pLRUnext;

		if( pfirst->pnext )
			(pfirst->pnext)->pprev = pfirst->pprev;

		if( pfirst->pprev )
			(pfirst->pprev)->pnext = pfirst->pnext;
		else
			{
			DWORD dwHashList = (pfirst->dwBlock * dwblocksize / PAGE_SIZE) % HASH_LISTS;

			pCached[ dwHashList ] = pfirst->pnext;
			}

		// Alliberem la memria ocupada pels blocs i per l'entrada de la taula
		free( (PBYTE) pfirst->dwAddress ); // -BUG
		free( pfirst );

		CachedPages--; // Hem eliminat un element
		}

	// Obtenim la llista que correspon al bloc demanat
	DWORD dwHashList = (pBlock->dwBlock * dwblocksize / PAGE_SIZE) % HASH_LISTS;

	// Preparem les dades de l'estructura
	pBlock->pprev				= NULL;
	pBlock->pnext				= NULL;
	pBlock->pLRUprev			= NULL;
	pBlock->pLRUnext			= NULL;
	pBlock->pDevice 			= pdev;
	pBlock->dwReserved		= 0;
	pBlock->dwLastUsedTick	= System->TickTime();
	pBlock->dwFlags			= 0;

	PTCachedBlock pfirst = pCached[ dwHashList ]; // Obtenim el primer element de la llista

	if( pfirst ) // Si ja n'hi ha un
		{
		pfirst->pprev = pBlock; // l'enllacem amb el nou
		pBlock->pnext = pfirst;
		}

	pCached[ dwHashList ] = pBlock; // Ara s el nou primer

	pfirst = pLRUListTail; // Obtenim l'element utilitzat ms recentment

	if( pfirst ) // Si hi ha algun element
		{
		pfirst->pLRUnext = pBlock; // l'enllacem amb el nou
		pBlock->pLRUprev = pfirst;
		pLRUListTail = pBlock; // El nou ser l'ltim
		}
	else // Com que no hi ha cap element a la llista LRU, l'hem d'inicialitzar
		pLRUListHead = pLRUListTail = pBlock;
	}

// **************************************************************************
// Llegeix un o ms blocs
// Com a entrada ha de rebre:
// Address  	- Posici de memria des d'on comencem a escriure
// Block    	- Bloc del dispositiu des d'on comencem a llegir
// BlockCount	- Nombre de blocs que llegim
DWORD CCache::Read( PBYTE pAddress, DWORD dwBlock, DWORD dwBlockCount )
	{
	DWORD state = 0; // Retornarem el nombre de blocs llegits

	while( dwBlockCount ) // Mentre quedin blocs per llegir
		{
		PTCachedBlock pblock = Search( dwBlock ); // Cerquem el bloc demanat a la 'cache'

		if( pblock ) // L'hem trobat
			{
			// L'hem de copiar a la memria del peticionari
			if( dwBlockCount > ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize))) )
				{ // Ens han demanat ms del que hi cap en una pgina de memria
				Kernel->MemCopy( (PBYTE) (pblock->dwAddress + dwblocksize * (dwBlock % (PAGE_SIZE / dwblocksize))), pAddress, dwblocksize * ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize))) );
				// Haurem de continuar llegint, i per tant, cal recalcular el dest i la font
				state += ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				pAddress = (PBYTE) ((DWORD) pAddress + ( ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize))) * dwblocksize ));
				dwBlockCount -= ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				dwBlock += ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				}
			else // Ens han demanat menys d'una pgina de memria (o igual)
				{
				Kernel->MemCopy( (PBYTE) (pblock->dwAddress + dwblocksize * (dwBlock % (PAGE_SIZE / dwblocksize))), pAddress, dwblocksize * dwBlockCount );
				// Ja haurem acabat
				state += dwBlockCount;
				dwBlock += dwBlockCount;
				dwBlockCount = 0;
				}
			}
		else // El bloc no est en la 'cache'
			{
			// Reservem memria per a l'element
			pblock = (PTCachedBlock) malloc( sizeof( TCachedBlock ) );

			pblock->dwBlock	= dwBlock - (dwBlock % (PAGE_SIZE / dwblocksize));
			pblock->dwAddress	= (DWORD) malloc( PAGE_SIZE ); // Reservem memria per als blocs -BUG

			Add( pblock ); // Afegim la nova pgina a la 'cache'
			pdev->ReadBlock( dwBlock - (dwBlock % (PAGE_SIZE / dwblocksize)), pblock->dwAddress, (PAGE_SIZE / dwblocksize) );

			if( dwBlockCount > (PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)) )
				{ // Ens han demanat ms del que hi cap en una pgina de memria
				Kernel->MemCopy( (PBYTE) (pblock->dwAddress + dwblocksize * (dwBlock % (PAGE_SIZE / dwblocksize))), pAddress, dwblocksize * ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize))) );
				// Encara haurem de llegir ms blocs. Hem de recalcular el dest i la font
				state += ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				pAddress = (PBYTE) ((DWORD) pAddress + ( ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize))) * dwblocksize ));
				dwBlockCount -= ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				dwBlock += ((PAGE_SIZE / dwblocksize) - (dwBlock % (PAGE_SIZE / dwblocksize)));
				}
			else // Ens han demanat menys d'una pgina de memria (o igual)
				{
				Kernel->MemCopy( (PBYTE) (pblock->dwAddress + dwblocksize * (dwBlock % (PAGE_SIZE / dwblocksize))), pAddress, dwblocksize * dwBlockCount );
				// Ja haurem acabat la feina
				state += dwBlockCount;
				dwBlock += dwBlockCount;
				dwBlockCount = 0;
				}
			}
		}

	return state; // Retornem el nombre de blocs llegits
	}

// **************************************************************************
// Escriu un o ms blocs
// Com a entrada ha de rebre:
// Address  	- Posici de memria des d'on comencem a llegir
// Block    	- Bloc del dispositiu des d'on comencem a escriure
// BlockCount	- Nombre de blocs que escrivim
DWORD CCache::Write( PBYTE pAddress, DWORD dwBlock, DWORD dwBlockCount )
	{
	return pdev->WriteBlock( dwBlock, (DWORD) pAddress, dwBlockCount );
	}

// **************************************************************************
// Verifica un o ms blocs
// Com a entrada ha de rebre:
// Block    	- Bloc que volem comprovar
// Size     	- Nombre de 'bytes' a comprovar  ----------- o blocs? -BUG
BOOL CCache::Verify( DWORD, DWORD )
	{
	return TRUE;
	}

// **************************************************************************
// Escriu inmediatament el bloc especificat
// Com a entrada ha de rebre:
// Block    	- Bloc que volem escriure ara mateix
VOID CCache::Flush( DWORD )
	{
	}

