/* **************************************************************************
*                                                                           *
*  IDE.CPP                                                                  *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de dispositius IDE de l'Akula                                *
*                                                                           *
************************************************************************** */
// Parts of that code are Copyright of Bart Sekura (TINOS), Andy Valencia (VSTa)
// and Richard S. Burgess (MMURTL)

// *********************************** INCLUDES
#include "drivers\block\private\ide.h"
#include "sys\sys.h"
#include "string.h"
#include "sys\asm.h"
#include "kernel\boxdef.h"
#include "sys\console.h"
#include "kernel\kernel.h"
#include "drivers\messages.h"
#include "sys\timer.h"
#include "aal\aal.h"
#include "kernel\system.h"
#include "errors.h"

// *********************************** DEFINES
#define IDE_INTERRUPT						0x00002000

#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	1

#define DRIVER_LEVEL		5

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
PCsysModule SYSModule = NULL;	// Per a la comunicaci amb el nivell sistema
PCkeMailBox pMailBox = NULL;	// Bstia del controlador
PCsysConsole pcons;				// Per a presentar missatges per pantalla
PCIDEDrive IDE0;					// Dispositiu 'HardDisk0'
BYTE cStat;							// Registre d'estat del controlador IDE
BOOL HDDInt;						// S'activa quan ha succet una interrupci de disc dur

DWORD _import CLI();
VOID _import STI( DWORD );
VOID _import MicroDelay( DWORD );
VOID IDEISR();

// *********************************** FUNCIONS
void main()
	{
	CHAR str[ 80 ];

	SYSModule = new CsysModule; // Preparem la comunicaci amb el nivell sistema

	PTDriver driver = (PTDriver) malloc( sizeof( TDriver ) );
	driver->cLevel = DRIVER_LEVEL; // Preparem l'estructura de registre
	SYSModule->RegisterDriver( driver ); // Registrem el controlador

	pcons = new CsysConsole;
	sprintf( str, TEXT( "IDE    Driver ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( DRIVER_DIR );

	if( !pparent )
		{
		pcons->OutText( TEXT( "IDE - Error: no pot accedir a DRIVER_DIR\r\n" ) );
		while( 1 )
			{}
		}

	sprintf( str, TEXT( "%s0" ), nIDE_MAILBOX );
	CsysMailBox box( pparent, str ); // Generem la bstia de 'HardDisk0'

	TMSG msg;

	pMailBox = new CkeMailBox( NULL ); // Preparem una bstia per al controlador
	IDE0 = new CIDEDrive( 0, &box );

	(System->AAL())->IRQHandler( 14, (DWORD) IDEISR );
	(System->AAL())->UnmaskIRQ( 14 ); // Permetre interrupcions IDE

	IDE0->Reset(); // Inicialitzem la controladora
	IDE0->Recalibrate(); // Recalibrem les unitats de disc

	SYSModule->DriverReady(); // Indiquem al sistema que estem preparats

	while( 1 )
		{
		box.WaitMessage( &msg );
		IDE0->DispatchMessage( msg );
		}
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
BOOL CIDEDrive::DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Mapegem l'espai d'adreces del flux que fa la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case DRV_READBLOCK_BLOCKDEV:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = Read( (PBYTE) data->dwParam2, data->dwParam1, data->dwParam3 );
			if( msg.dwParam1 )
				Recalibrate();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_WRITEBLOCK_BLOCKDEV:
			{
			sprintf( str, TEXT( "Rebut WriteBlock (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_LOCK_DEVICE:
			{
			if( msg.dwParam1 )
				msg.dwParam1 = (DWORD) Lock();
			else
				msg.dwParam1 = (DWORD) Unlock();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_CHECKMEDIA_DEVICE:
			{
			msg.dwParam1 = CheckMedia();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_HASMEDIA_DEVICE:
			{
			msg.dwParam1 = TRUE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_ISLOCAL_DEVICE:
			{
			msg.dwParam1 = TRUE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_ISREMOVABLE_DEVICE:
			{
			msg.dwParam1 = FALSE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_CANHASPAGEFILE_DEVICE:
			{
			msg.dwParam1 = TRUE;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		default:
			sprintf( str, TEXT( "IDE.DRV - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostre espai d'adreces

	return FALSE; // Sempre retornem FALSE
	}

// **************************************************************************
// Rutina de servei d'interrupci
VOID IDEISR()
	{
	cStat = Kernel->InByte( HD_PORT + 7 ); // Obtenim el 'byte' d'estat
	HDDInt = 1; // Hi ha hagut interrupci

	TMSG msg;
	msg.dwMessage = IDE_INTERRUPT;
	// Enviem un senyal a la bstia del controlador
	pMailBox->PostMessage( &msg );
	(System->AAL())->EOI( 14 );
	}

// **************************************************************************
// Llegeix la informaci sobre la geometria del dispositiu
LONG readp_data()
	{
	DWORD c = 100000;
	DWORD stat;

	while( c-- )
		{
		stat = Kernel->InByte( HD_PORT + 7 );

		if( stat & ERROR )
			{
			pcons->OutText( TEXT( "WDS_ERROR\r\n" ) );
			return (-1);
			}

		if( stat & DATA_REQ )
			return (stat);
		}

	pcons->OutText( TEXT( "TIMEOUT\r\n" ) );
	return (-1);
	}

// **************************************************************************
// Intercanvia el 'bytes' de paraula en paraula (de LSB a MSB o a la inversa)
// Com a entrada ha de rebre:
// ptr      	- Apuntador al comenament de la zona
// count    	- Nombre de 'bytes' a intercanviar
VOID swab( PBYTE ptr, DWORD count )
	{
	PBYTE p = ptr;
	BYTE temp;
	DWORD c;

	for( c = 0; c < count; c += 2, p += 2 )
		{
		temp = p[ 0 ];
		p[ 0 ] = p[ 1 ];
		p[ 1 ] = temp;
		}
	}

// **************************************************************************
// Obtenim informaci sobre la geometria del 'hardware'
DWORD CIDEDrive::GetGeometry()
	{
#pragma option -a1
	TParms parms;
#pragma option -a4
	CHAR buffer[ 256 ];

	Kernel->OutByte( HD_PORT + 6, (BYTE) (0x20 | 0x80 | (cdrive << 4)) );

	if( SendCommand( 0xEC ) )
		{
		pcons->OutText( TEXT( "getgeometry failed\r\n" ) );
		return 1;
		}

	if( readp_data() < 0 )
		{
		pcons->OutText( TEXT( "readp_data failed\r\n" ) );
		return 1;
		}

	Kernel->InWords( HD_PORT, (PBYTE) buffer, 256 );
	Kernel->MemCopy( (PBYTE) buffer, (PBYTE) &parms, sizeof( parms ) );

	swab( parms.w_model, MODEL_SZ );
	parms.w_model[MODEL_SZ-1] = 0;
	swab( parms.w_rev, REV_SZ );
	parms.w_rev[REV_SZ-1] = 0;
	swab( parms.w_cnsn, CNSN_SZ );
	parms.w_cnsn[CNSN_SZ-1] = 0;

	hd_Cmd[ 2 ] = (BYTE) parms.w_sectors;
	hd_Cmd[ 6 ] = (BYTE) (0x80 | 0x20 |(cdrive << 4) | (parms.w_heads - 1));

	if( SendCommand( HDC_SET_PARAMS ) )
		{
		pcons->OutText( TEXT ( "wdc_specify failed\r\n" ) );
		return 1;
		}

	cyls = (WORD) (parms.w_fixedcyl + parms.w_removcyl);
	heads = parms.w_heads;
	secpertrk = (BYTE) parms.w_sectors;
/*
	CHAR str[ 100 ];
	sprintf( str, TEXT( "IDE - Model: %s, Rev: %s\r\n" ), parms.w_model, parms.w_rev );
	pcons->OutText( str );
	sprintf( str, TEXT( "IDE - Heads: %u, cyl: %u, sectors: %u\r\n" ), (DWORD) heads, (DWORD) cyls, (DWORD) secpertrk );
	pcons->OutText( str );
*/
	return 0;
	}

// **************************************************************************
// Reinicialitza la controladore de disc dur
VOID CIDEDrive::Reset()
	{
	Kernel->OutByte( HD_REG_PORT, 6 ); 	// 'Reset' cap a la controladora
	MicroDelay( 4 );  						//  Espera 60us

// El 'bit' 3 d'HD_REG ha de ser 1 per tal d'accedir als capals 8-15
// Esborrem el 'bit' "MUCHO heads", i el de 'reset'
	Kernel->OutByte( HD_REG_PORT, 2 );

	SYSModule->Sleep( 200 );		// 200ms - algunes controladores sn lentes!!

//	TMSG msg;

//	pMailBox->PeekMessage( &msg ); 	// Si ha arribat una interrupci, la ignorem -BUG

//	cResetStat = cStat;	// La ISR obt el 'byte' d'estat
/*
	if( SendCommand( 0x90 ) ) // Diagnstics
		{
		pcons->OutText( TEXT( "failed self diags\r\n" ) );
		return;
		}

	Kernel->InByte( HD_PORT + 1 );
	MicroDelay( 4 );  			//  Espera 60us
*/
	Kernel->OutByte( HD_REG_PORT, 8 );

	GetGeometry(); // Obtenim informaci sobre la geometria
	}

// **************************************************************************
// Comprova si la controladora est ocupada
DWORD CIDEDrive::CheckBusy()
	{
	WORD count = 0;

	while( count++ < 60 )
		{
		cStat = Kernel->InByte( HD_PORT + 7 );

		if( (cStat & BUSY) == 0 )
			return OK;

		SYSModule->Sleep( 50 );  // cada 50ms
		}

	return IDE_NOTREADY;	 // controladora ocupada!
	}

// **************************************************************************
// Espera una interrupci 'hardware' (un temps limitat)
DWORD CIDEDrive::Wait()
	{
	HDDInt = 0;

	PCkeTimer alarm = new CkeTimer( 3000, pMailBox, NULL );	// Alarma als 3s

	TMSG msg;

	pMailBox->WaitMessage( &msg ); // Esperem la alarma o la interrupci
	delete alarm;

	if( msg.dwMessage == SM_TIMER ) // Alarma
		{
		if( HDDInt ) // Interrupci tamb!!
			{
			pcons->OutText( TEXT( "missint\r\n" ) );
			return IDE_MISSINT; // Hi ha algun problema amb els missatges
			}
		else
			{
			pcons->OutText( TEXT( "timeout\r\n" ) );
			return IDE_TIMEOUT;		// fora de temps
			}
		}
	else // Interrupci si, alarma no
		return OK;
	}

// **************************************************************************
// Recalibra el disc
DWORD CIDEDrive::Recalibrate()
	{
	DWORD erc;

	hd_Cmd[ 6 ] = (BYTE) ((cdrive << 4) | 0xa0);
	erc = SendCommand( HDC_RECAL ); // Enviem la comanda RECAL
	if( !erc )
		erc = Wait();					  // Esperem una interrupci
	if( !erc )
		erc = Status( HDC_RECAL );	  // Obtenim l'estat

	dwlastrecal = erc;

	if( erc ) // Hi ha algun error?
		pcons->OutText( TEXT( "failed RECAL!\r\n" ) );

	return( erc );
	}

// **************************************************************************
// Prepara el cilindre, cap i sector per a totes les comandes que els necessiten
// Com a entrada ha de rebre:
// LBA      	- Primer bloc
// Blks     	- Quantitat de blocs
DWORD CIDEDrive::setupseek( DWORD dLBA, DWORD nBlks )
	{
	DWORD j;
	WORD cyl;

	if( nBlks > 256 ) return IDE_TOOMANYBLOCKS; // Fins a 256 blocs
	if( nBlks == 0 ) return IDE_ZEROBLOCKS; // Com a mnim 1

	if( nBlks == 256 )
		nsectors = 0;   // 0==256 per a la controladora
	else
		nsectors = (BYTE) nBlks;

	cyl = (WORD) (dLBA / (heads * secpertrk));
	j = dLBA % (heads * secpertrk);		// reste

	// Ja coneixem el cilindre, calculem el cap i el sector

	head = (BYTE) (j / secpertrk);
	sector = (BYTE) (j % secpertrk + 1); // els sectors comencem amb l'1!!!

	hd_Cmd[ 2 ] = (BYTE) nBlks;					// Quantitat de sectors
	hd_Cmd[ 3 ] = sector;							// Sector inicial
	hd_Cmd[ 4 ] = (BYTE) (cyl & 0xff);			// 'Byte' baix del cilindre
	hd_Cmd[ 5 ] = (BYTE) ((cyl >> 8) & 0xff);	// 'Byte' alt del cilindre
	hd_Cmd[ 6 ] = (BYTE) ((cdrive << 4) | (head & 0x0f) | 0xa0);

	return OK;
	}

// **************************************************************************
// Mou el capal cap al cilindre seleccionat
// Com a entrada ha de rebre:
// LBA      	- Bloc desitjat
DWORD CIDEDrive::Seek( DWORD dLBA )
	{
	DWORD erc = setupseek( dLBA, 1 ); 	// prepara el 'seek'

	if( !erc )
		erc = SendCommand( HDC_SEEK );  	// Enviem la comanda
	if( !erc )
		erc = Wait();							// Esperem una interrupci
	if( !erc )
		erc = Status( HDC_SEEK );			// Obtenim l'estat

	dwlastseek = erc;

	if( erc ) // Error intentant fer el 'seek'
		pcons->OutText( TEXT( "Seek - error\r\n" ) );

	return erc;
	}

// **************************************************************************
// Obt l'estat i els errors de la controladora
// Com a entrada ha de rebre:
// LastCmd  	- Indica l'ltima comanda enviada a la controladora
DWORD CIDEDrive::Status( BYTE LastCmd )
	{
	DWORD erc;
	BYTE errbyte;

	erc = CheckBusy();

	if( !erc )
		cStat = Kernel->InByte( HD_PORT + 7 ); // Obtenim l'estat
	else
		return erc;

	dwlaststat = cStat;

	if( (cStat & ERROR) == 0 )
		{		// 'Bit' d'error a zero en el registre d'estat
		erc = OK;

		switch( LastCmd )
			{
			case HDC_READ:
			case HDC_READ_LONG:
			case HDC_WRITE:
			case HDC_WRITE_LONG:
			case HDC_SEEK:
			case HDC_RECAL:
				if( cStat & WRITE_FAULT )
					erc = IDE_WRITEFAULT;
				else
				if( (cStat & SEEKOK) == 0 )
					erc =	IDE_BADSEEK;
				break;

			case HDC_SET_PARAMS:
			case HDC_VERIFY:
			case HDC_FORMAT:
			case HDC_DIAG:
				break;

			default:
				break;
			}

		return erc;
		}
	else // 'Bit' d'error activat
		{
		erc = CheckBusy();

		if( !erc )
			errbyte = Kernel->InByte( HD_PORT + 1 ); // Obtenim l'error
		else
			return erc;

		dwlasterc = errbyte;

		if( errbyte & BAD_ADDRESS )
			erc = IDE_ADDRESSMARK;
		else if( errbyte & BAD_SEEK )
			erc = IDE_BADSEEK;
		else if( errbyte & BAD_CMD )
			erc = IDE_BADCMD;
		else if( errbyte & BAD_IDMARK )
			erc = IDE_SECTORNOTFOUND;
		else if( errbyte & BAD_ECC )
			erc = IDE_BADECC;
		else if( errbyte & BAD_SECTOR )
			erc = IDE_BADBLOCK;
		else
			erc = IDE_BADHDC; // No han estat trobats 'bits' d'error, per els haurem d'haver trobat!
		}

	return erc;
	}

// **************************************************************************
// Llegeix un o ms sectors
// Com a entrada ha de rebre:
// DataRet  	- Adrea de memria on escriurem
// LBA      	- Bloc des d'on comencem a llegir
// Blocks   	- Nombre de blocs a llegir
DWORD CIDEDrive::Read( PBYTE pDataRet, DWORD dLBA, DWORD dnBlocks )
	{
	DWORD erc, nleft, nBPS = 512; // -BUG

	nleft = dnBlocks;
	erc = setupseek( dLBA, dnBlocks );	// preparem la cerca

	if( !erc )
		erc = SendCommand( HDC_READ );	// Llegir!

	while( (nleft) && (!erc) )				// Repetim per a cada bloc
		{
		erc = Wait();							// Esperem una interrupci

		if( !erc )
			erc = Status( HDC_READ );

		if( !erc )
			{
			Kernel->InWords( HD_PORT, pDataRet, nBPS ); // Llegim el sector
			pDataRet += nBPS;
			--nleft;
			}
		}

	return erc;
	}

/*************************************************************
 This is called for the DeviceOp code Write.
 This writes 1 or more whole sectors from the calculated values
 in hd_head, hd_sector, and hd_cyl
*************************************************************/
// **************************************************************************
// Escriu un o ms sectors
// Com a entrada ha de rebre:
// DataOut  	- Adrea de memria des d'on llegirem
// LBA      	- Bloc des d'on comencem a escriure
// Blocks   	- Nombre de blocs a escriure
DWORD CIDEDrive::Write( PBYTE pDataOut, DWORD dLBA, DWORD dnBlocks )
	{
	DWORD erc, nSoFar, nBPS = 512; // -BUG

	nSoFar = 0;
	setupseek( dLBA, dnBlocks );		// Preparem per a la cerca
	SendCommand( HDC_WRITE );			// Escriure!
	erc = CheckBusy();					// No hi ha interrupci per al primer sector

	if( (!erc) && (cStat & DATA_REQ) )
		{
		Kernel->OutWords( HD_PORT, pDataOut, nBPS ); // Escrivim el sector
		pDataOut += nBPS;
		nSoFar++;
		}

	while( (nSoFar < dnBlocks ) && (!erc) ) // Repetim per a la resta de sectors
		{
		erc = Wait();					// Esperem una interrupci

		if( !erc )
			erc = Status( HDC_WRITE );

		if( (!erc) && (cStat & DATA_REQ) )
			{
			Kernel->OutWords( HD_PORT, pDataOut, nBPS ); // Escrivim un sector
			pDataOut += nBPS;
			nSoFar++;
			}
		}

	if( !erc )
		erc = Wait();					// Esperem la interrupci final
	if( !erc )
		erc = Status( HDC_WRITE ); // Obtenim l'estat

	return erc;
	}

// **************************************************************************
// Formata una pista
// Com a entrada ha de rebre:
// LBA      	- Bloc des d'on comencem a formatar
// Blocks   	- Nombre de blocs a formatar
DWORD CIDEDrive::FormatTrack( DWORD dLBA, DWORD dnBlocks )
	{
	DWORD erc;

	setupseek( dLBA, dnBlocks );		// Prepara la cerca
	SendCommand( HDC_FORMAT );
	erc = Wait();							// Espera una interrupci

	if( !erc )
		erc = Status( HDC_FORMAT );	// Obt l'estat

	return erc;
	}
/*
// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
DWORD CIDEDrive::ReadSector( DWORD Cylinder, DWORD HdSect, PBYTE pDataRet )
	{
	DWORD erc;
	WORD cyl = (WORD) Cylinder;

	head = (WORD) (HdSect & 0xffff);
	sector = (WORD) ((HdSect >> 16) & 0xffff);

	hd_Cmd[ 2 ] = 1;						 How many sectors
	hd_Cmd[ 3 ] = sector;				 Which sector to start on
	hd_Cmd[ 4 ] = (BYTE) (cyl & 0xff);				 cylinder lobyte
	hd_Cmd[ 5 ] = (BYTE) ((cyl >> 8) & 0xff);		 cylinder hibyte
	hd_Cmd[ 6 ] = (BYTE) ((cdrive << 4) | (head & 0x0f) | 0xa0);

	SendCommand( HDC_READ );
	erc = Wait();					 wait for interrupt

	if( !erc )
		erc = Status( HDC_READ );
	if( !erc )
		Kernel->InWords( HD_PORT, pDataRet, 512 );

	return erc;
	}
*/
/********************************************
	 Send the command to the controller.
	 Clear the Echange of any left over
	 alarm or int messages before we
	 send a command.
*********************************************/
// **************************************************************************
// Envia la comanda cap a la controladora
// Com a entrada ha de rebre:
// Cmd      	- Comanda que volem enviar
DWORD CIDEDrive::SendCommand( BYTE Cmd )
	{
	DWORD erc;

	 // 'Bit' 3 d'HD_REG ha de ser 1 per a l'accs als caps 8-15  -BUG
	if( head > 7 )
		Kernel->OutByte( HD_REG_PORT, 0x08 ); 	//  'Bit' activat per a cap > 7

	erc = CheckBusy();

	if( erc )
		return erc;

	Kernel->OutByte( HD_PORT + 1, hd_Cmd[ 1 ] ); // Enviem tota la informaci
	Kernel->OutByte( HD_PORT + 2, hd_Cmd[ 2 ] );
	Kernel->OutByte( HD_PORT + 3, hd_Cmd[ 3 ] );
	Kernel->OutByte( HD_PORT + 4, hd_Cmd[ 4 ] );
	Kernel->OutByte( HD_PORT + 5, hd_Cmd[ 5 ] );
	Kernel->OutByte( HD_PORT + 6, hd_Cmd[ 6 ] );
	Kernel->OutByte( HD_PORT + 7, Cmd );

	return 0;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Drive    	- Dispositiu que gestiona l'objecte
// Mailbox  	- Bstia per a l'objecte
CIDEDrive::CIDEDrive( BYTE cDrive, PCsysMailBox pMailbox )
	{
	pmailbox 	= pMailbox;
	cdrive		= cDrive;
	blocked		= FALSE;
//	heads 		= 16;			/* Max */
//	secpertrk 	= 17;		/* most common */
//	cyls 			= 1024;		/* Max */
//	head 			= 0; -BUG
	}

// **************************************************************************
// Destructor de la classe
CIDEDrive::~CIDEDrive()
	{
	}

// **************************************************************************
// Verifica uns certs blocs
// Com a entrada ha de rebre:
// LBA      	- Bloc des d'on comencem a verificar
// Blocks   	- Nombre de blocs a verificar
BOOL CIDEDrive::Verify( DWORD, DWORD )
	{
	return TRUE;
	}

// **************************************************************************
// Bloqueja l's del dispositiu, de manera que noms un procs pot accedir-hi
BOOL CIDEDrive::Lock()
	{
	if( !blocked )
		{
		blocked = TRUE;
		return TRUE;
		}

	return FALSE;
	}

// **************************************************************************
// Permet la utilitzaci del dispositiu a qualsevol procs
BOOL CIDEDrive::Unlock()
	{
	if( blocked )
		{
		blocked = FALSE;
		return TRUE;
		}

	return FALSE;
	}

// **************************************************************************
// Comprova quin tipus de disc s
DWORD CIDEDrive::CheckMedia()
	{
	return IDE_HARDDISK;
	}

// **************************************************************************
// Retorna cert si s'ha canviat el disc
BOOL CIDEDrive::MediaChange()
	{
	return FALSE;
	}

// **************************************************************************
// Retorna la bstia corresponent a l'objecte
PCsysMailBox CIDEDrive::MailBox()
	{
	return pmailbox;
	}

