/* **************************************************************************
*                                                                           *
*  BlockDev.CPP                                                             *
*                                                                           *
*  10-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base genrica per a tots els dispositius de blocs                        *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\block\blockdev.h"
#include "drivers\messages.h"

// **************************************************************************
// Prepara l'objecte
CdrvBlockDevice::CdrvBlockDevice( PSTR sName ) : CdrvDriver( sName )
	{
	id = CID_BlockDevice;
	}

CdrvBlockDevice::~CdrvBlockDevice()
	{
	}

DWORD CdrvBlockDevice::ReadBlock( DWORD dwBlock, DWORD dwAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwBlock;
	data.dwParam2	= dwAddress;
	data.dwParam3	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READBLOCK_BLOCKDEV;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

DWORD CdrvBlockDevice::WriteBlock( DWORD dwBlock, DWORD dwAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwBlock;
	data.dwParam2	= dwAddress;
	data.dwParam3	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITEBLOCK_BLOCKDEV;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

