/* **************************************************************************
*                                                                           *
*  Cache.CPP                                                                *
*                                                                           *
*  21-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Gestor de memria cach de l'Akula                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\block\cache.h"
#include "drivers\messages.h"
#include "kernel\system.h"
#include "kernel\mailbox.h"
extern PCkeSystem _import System;

CdrvCache::CdrvCache( PCdrvBlockDevice pDevice ) : CdrvBlockDevice( CACHE_MAILBOX )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CREATE_CACHE;
	msg.dwParam1	= (DWORD) pDevice;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	pinstance = (PVOID) msg.dwParam1;
	}

CdrvCache::~CdrvCache()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_DESTROY_CACHE;
	msg.dwParam1	= (DWORD) pinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvCache::ReadBlock( DWORD dwBlock, DWORD dwAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwBlock;
	data.dwParam2	= dwAddress;
	data.dwParam3	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READBLOCK_BLOCKDEV;
	msg.dwParam1	= (DWORD) pinstance;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CdrvCache::WriteBlock( DWORD dwBlock, DWORD dwAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwBlock;
	data.dwParam2	= dwAddress;
	data.dwParam3	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITEBLOCK_BLOCKDEV;
	msg.dwParam1	= (DWORD) pinstance;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CdrvCache::FlushBlock( DWORD dwBlock )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_FLUSHBLOCK_CACHE;
	msg.dwParam1	= (DWORD) pinstance;
	msg.dwParam2	= dwBlock;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

