/* **************************************************************************
*                                                                           *
*  Keyb.CPP                                                                 *
*                                                                           *
*  14-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de teclat de l'Akula                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\char\private\keyb.h"
#include "sys\sys.h"
#include "string.h"
#include "sys\asm.h"
#include "kernel\boxdef.h"
#include "sys\console.h"
#include "kernel\kernel.h"
#include "drivers\messages.h"
#include "sys\timer.h"
#include "aal\aal.h"
#include "kernel\system.h"
#include "drivers\char\private\kbdtable.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	1

#define DRIVER_LEVEL		1

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
PCsysModule SYSModule = NULL;	// Per a comunicar-nos amb el nivell sistema
PCsysConsole pcons;				// Per a presentar missatges per pantalla
PCKeyboard pcurrent = NULL;	// Objecte de teclat utilitzat actualment
PCkeMailBox pmailbox = NULL;	// Bstia del controlador de teclat
BYTE cLockStatus = 0;			// Estat de les tecles de fixaci
BYTE cState = 0;					// Estat de les tecles temporals
BOOL bPrefix = FALSE;			// Indica si ha arribat un codi 0xE0

DWORD _import CLI();
VOID _import STI( DWORD );
BOOL DispatchMessage( TMSG& );
VOID KeyboardISR();
VOID SetLEDs();
VOID InBuffEmpty();
VOID OutBuffFull();
DWORD Translate( BYTE );
DWORD Shift( DWORD );
BOOL StateChange( BYTE );
BOOL LockChange( BYTE );

// *********************************** FUNCIONS
void main()
	{
	CHAR str[ 80 ];

	SYSModule = new CsysModule; // Preparem la comunicaci amb el nivell sistema

	PTDriver driver = (PTDriver) malloc( sizeof( TDriver ) );
	driver->cLevel = DRIVER_LEVEL; // Preparem l'estructura de registre
	SYSModule->RegisterDriver( driver ); // Registrem el controlador

	pcons = new CsysConsole;
	sprintf( str, TEXT( "KeybUS Driver ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( DRIVER_DIR );

	if( !pparent )
		{
		pcons->OutText( TEXT( "KEYBSP - Error: no pot accedir a DRIVER_DIR\r\n" ) );
		while( 1 )
			{}
		}

	CsysMailBox box( pparent, nKEYBOARD_MAILBOX ); // Preparem la bstia
	pmailbox = (PCkeMailBox) box.GetInternalPointer(); // Necessitem la bstia del 'Kernel'

	(System->AAL())->IRQHandler( 1, (DWORD) KeyboardISR ); // IRQ del teclat
	(System->AAL())->MaskIRQ( 1 ); // NO Permetre interrupcions del teclat
	DWORD flags = CLI();
	// Inicialitzem el teclat (xip 8042)
	InBuffEmpty();
	Kernel->OutByte( DATAPORT, 0xfa );
	OutBuffFull();
	Kernel->InByte( DATAPORT );

	InBuffEmpty();
	Kernel->OutByte( DATAPORT, 0xf0 );
	OutBuffFull();
	Kernel->InByte( DATAPORT );

	InBuffEmpty();
	Kernel->OutByte( DATAPORT, 0x02 );
	OutBuffFull();
	Kernel->InByte( DATAPORT );

	InBuffEmpty();
	Kernel->OutByte( COMMANDPORT, 0x60 );
	InBuffEmpty();
	Kernel->OutByte( DATAPORT, 0x45 );

	STI( flags );
	(System->AAL())->UnmaskIRQ( 1 ); // Permetre interrupcions del teclat

	SetLEDs(); // Posem els LEDs del teclat

	TMSG msg;

	SYSModule->DriverReady(); // Indiquem al nivell sistema que ja estem preparats

	while( 1 )
		{
		box.WaitMessage( &msg ); // Esperem i tractem missatges
		DispatchMessage( msg );
		}
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
BOOL DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Mapegem l'espai d'adreces del flux que fa la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case DRV_CREATEINSTANCE_KEY:
			{
			msg.dwParam1 = (DWORD) new CKeyboard( (PCdrvVideo) msg.dwParam1, ((PCkeMailBox) msg.pReply)->Creator() );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_DESTROYINSTANCE_KEY:
			{
			sprintf( str, TEXT( "Rebut DestroyInstance (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			delete( (PCKeyboard) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_PUTCHAR_KEY:
			{
			PCKeyboard pkey = (PCKeyboard) msg.dwParam1;
			pkey->PutChar( msg.dwParam2 );

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );

			if( pkey->MailBox() )
				{
				msg.dwParam1 = pkey->GetChar();
				(pkey->MailBox())->PostMessage( &msg );
				pkey->MailBox( NULL );
				}
			}
			break;

		case DRV_GETCHAR_KEY:
			{
			PCKeyboard pkey = (PCKeyboard) msg.dwParam1;
			msg.dwParam1 = pkey->GetChar();

			if( msg.dwParam1 )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			else
				pkey->MailBox( (PCkeMailBox) msg.pReply );
			}
			break;

		case DRV_CHECKCHAR_KEY:
			{
			msg.dwParam1 = ((PCKeyboard) msg.dwParam1)->GetChar();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_ACTIVATE_KEY:
			{
			PCKeyboard pkey = (PCKeyboard) msg.dwParam1;

			if( pcurrent != pkey )
				pkey->Activate();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		default:
			sprintf( str, TEXT( "KEYBSP.DRV - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostre espai d'adreces

	return FALSE; // Sempre retornem FALSE
	}

// **************************************************************************
// Tradueix un 'scan-code' en un codi de tecla virtual del sistema operatiu
// Com a entrada ha de rebre:
// Byte     	- 'Scan-code'
DWORD Translate( BYTE cByte )
	{
	DWORD dwCode = 0;

	if( bPrefix ) // Abans hem rebut un codi 0xE0
		{
		bPrefix = FALSE;
		DWORD dwcount = 0;
		BOOL bFound = FALSE;

		while( dwcount < nKbdTable2 && !bFound )
			{ // Transformem el codi segons una taula
			if( cByte == KbdTable2[ dwcount * 2 ] )
				{
				cByte = KbdTable2[ dwcount * 2 + 1 ];
				bFound = TRUE;
				}

			dwcount++;
			}
		}
	else
		if( cByte == 0xE0 ) // Ara rebem el codi 0xE0
			{
			bPrefix = TRUE;
			return NULL; // No s un carcter vlid
			}

	if( LockChange( cByte ) ) // Comprovem l'estat dels indicadors
		{
		SetLEDs();
		return NULL; // No s un carcter vlid
		}

	if( StateChange( cByte ) ) // Comprovem l'estat de les tecles temporals
		return NULL; // No s un carcter vlid

	if( cByte & 0x80 ) // Els codis 'break' sn ignorats
		return NULL;

	if( !cByte ) // El codi 0 tamb s ignorat
		return NULL;

	if( !pcurrent ) // Si no hi ha cap objecte teclat seleccionat, ignorem la tecla
		return NULL; // -BUG

	// Comencem a generar el codi de tecla virtual
	DWORD dwTemp = KbdTable[ cByte ];

	if( dwTemp & 0x80 ) // Correspon a una tecla del teclat numric
		dwCode = 0x10000000;

	// Tecles especials: Ctrl + Alt + tecla
	if( cState & AltDownMask && cState & CtrlDownMask && !(cState & ShftDownMask) )
		{
		if( dwTemp == 0x0f )	// F1
			{
			PCKeyboard pprev = (PCKeyboard) pcurrent->GetPrev();

			TMSG msg;

			msg.dwMessage	= DRV_ACTIVATE_KEY;
			msg.dwParam1	= (DWORD) pprev;
			msg.dwParam2	= 0;
			msg.pReply		= 0;
			// Activem el teclat i la pantalla segents
			pmailbox->PostMessage( &msg );
			}
		else
		if( dwTemp == 0x10 ) // F2
			{
			PCKeyboard pnext = (PCKeyboard) pcurrent->GetNext();

			TMSG msg;

			msg.dwMessage	= DRV_ACTIVATE_KEY;
			msg.dwParam1	= (DWORD) pnext;
			msg.dwParam2	= 0;
			msg.pReply		= 0;
			// Activem el teclat i la pantalla anteriors
			pmailbox->PostMessage( &msg );
			}

		return NULL; // No s un codi de tecla vlid
		}

	if( cState & ShftDownMask && dwTemp > 0x21 && dwTemp < 0x7e )
		dwTemp = Shift( dwTemp ); // Transformem quan polsem 'Shift'+tecla
	else
		{
		if( dwTemp & 0x80 && dwTemp != 0xad )
			dwTemp = Shift( dwTemp ); // Transformem quan polsem 'Shift'+tecla
		else
			{
			if( cLockStatus & CpLockMask && dwTemp >= 0x61 && dwTemp <= 0x7a )
				dwTemp = Shift( dwTemp ); // Transformem quan polsem una tecla i tenim 'CapsLock'
			}
		}
	// Afegim la codificaci de les tecles especials
	dwCode |= (cLockStatus << 16) | (cState << 8) | (dwTemp & 0x7f);
	return dwCode; // retornem el codi
	}

// **************************************************************************
// Transforma un codi de tecla en un altre quan polsem 'Shift'+tecla
// Com a entrada ha de rebre:
// Code     	- Codi de la tecla polsada
DWORD Shift( DWORD dwCode )
	{
	return KbdTableS[ dwCode & 0x7f ];
	}

// **************************************************************************
// Canvia la variable 'State' segons la tecla polsada
// Com a entrada ha de rebre:
// Byte     	- Codi de la tecla polsada
BOOL StateChange( BYTE cByte )
	{
	switch( cByte )
		{
		case 0x2a:	// Left Shift ON
			cState |= (1 << ShftLeftBit);
			return TRUE;

		case 0x36:	// Right Shift ON
			cState |= (1 << ShftRiteBit);
			return TRUE;

		case 0xaa:	// Left Shift OFF
			cState &= (BYTE) ~(1 << ShftLeftBit);
			return TRUE;

		case 0xb6:	// Right Shift OFF
			cState &= (BYTE) ~(1 << ShftRiteBit);
			return TRUE;

		case 0x1d:	// Left Ctrl ON
			cState |= (1 << CtrlLeftBit);
			return TRUE;

		case 0x71:	// Right Ctrl ON
			cState |= (1 << CtrlRiteBit);
			return TRUE;

		case 0x9d:	// Left Ctrl OFF
			cState &= (BYTE) ~(1 << CtrlLeftBit);
			return TRUE;

		case 0xf1:	// Right Ctrl OFF
			cState &= (BYTE) ~(1 << CtrlRiteBit);
			return TRUE;

		case 0x38:	// Left Alt ON
			cState |= (1 << AltLeftBit);
			return TRUE;

		case 0x70:	// Right Alt ON
			cState |= (1 << AltRiteBit);
			return TRUE;

		case 0xb8:	// Left Alt OFF
			cState &= (BYTE) ~(1 << AltLeftBit);
			return TRUE;

		case 0xf0:	// Right Alt OFF
			cState &= (BYTE) ~(1 << AltRiteBit);
			return TRUE;
		}

	return FALSE;
	}

// **************************************************************************
// Canvia la variable 'LockStatus' segons la tecla polsada
// Com a entrada ha de rebre:
// Byte     	- Codi de tecla polsada
BOOL LockChange( BYTE cByte )
	{
	switch( cByte )
		{
		case 0x45:	// NumLock
			cLockStatus = (BYTE) (cLockStatus ^ NmLockMask);
			return TRUE;

		case 0x3a:	// CapsLock
			cLockStatus = (BYTE) (cLockStatus ^ CpLockMask);
			return TRUE;

		case 0x46:	// ScrollLock
			cLockStatus = (BYTE) (cLockStatus ^ ScLockMask);
			return TRUE;
		}

	return FALSE;
	}

// **************************************************************************
// Espera fins que el 'buffer' d'entrada del 8042 estigui buit
VOID InBuffEmpty()
	{
	BYTE cByte = 0xff;
	DWORD dwCount = 0x2ffff;

	while( cByte && dwCount )
		{
		cByte = (BYTE) (Kernel->InByte( STATUSPORT ) & INPUTBUFFFULL);
		dwCount--;
		}
	}

// **************************************************************************
// Espera fins que el 'buffer' de sortida del 8042 estigui ple
VOID OutBuffFull()
	{
	BYTE cByte = 0;
	DWORD dwCount = 0x2ffff;

	while( !cByte && dwCount )
		{
		cByte = (BYTE) (Kernel->InByte( STATUSPORT ) & OUTPUTBUFFFULL);
		dwCount--;
		}
	}

// **************************************************************************
// Canvia els indicadors del teclat segons la variable 'LockStatus'
VOID SetLEDs()
	{
	(System->AAL())->MaskIRQ( 1 );

	InBuffEmpty();
	Kernel->OutByte( DATAPORT, 0xed );
	OutBuffFull();
	Kernel->InByte( DATAPORT );

	InBuffEmpty();
	Kernel->OutByte( DATAPORT, (BYTE) (cLockStatus & 7) );
	OutBuffFull();
	Kernel->InByte( DATAPORT );

	(System->AAL())->UnmaskIRQ( 1 );
	}

// **************************************************************************
// Rutina de servei d'interrupci del teclat
VOID KeyboardISR()
	{
	BYTE cValue = Kernel->InByte( DATAPORT ); // Obtenim el codi de tecla
	TMSG msg;

	msg.dwParam2 = Translate( cValue ); // Tradum la tecla

	if( pcurrent && msg.dwParam2 )// Si hi ha algun objecte teclat seleccionat...
		{ // ...i el codi de tecla s vlid
		msg.dwMessage	= DRV_PUTCHAR_KEY;
		msg.dwParam1	= (DWORD) pcurrent;
		msg.pReply		= 0;
		// Enviem el codi de tecla al 'buffer' corresponent
		pmailbox->PostMessage( &msg );
		}

	(System->AAL())->EOI( 1 ); // 'End-Of-Interruption'
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Video    	- Objecte video associat a l'objecte teclat
// Thread   	- Flux al qual pertany l'objecte video
CKeyboard::CKeyboard( PCdrvVideo pVideo, PCkeThread pThread ) : CkeDblListItem( NULL, NULL )
	{
	pmailbox 	= NULL;
	pthread 		= pThread;
	pvideo 		= pVideo;
	pbufferin 	= pbufferout = buffer; // 'Buffer' buit

	if( pcurrent ) // Si hi ha algun objecte teclat seleccionat
		{
		SetPrev( pcurrent ); // Inserim el nou objecte teclat
		SetNext( pcurrent->GetNext() );
		pcurrent->SetNext( this );
		((PCKeyboard) pnext)->SetPrev( this );
		}
	else // Si no hi ha cap objecte teclat
		{
		SetNext( this );
		SetPrev( this );
		Activate(); // El primer l'activem automticament
		}

	for( DWORD index = 0; index < BUFFER_SIZE; index++ )
		buffer[ index ] = 0; // Inicialitzem el 'buffer'
	}

// **************************************************************************
// Destructor de la classe
CKeyboard::~CKeyboard()
	{
	}

// **************************************************************************
// Posa un carcter en el 'buffer'
// Com a entrada ha de rebre:
// Code     	- Codi del carcter a afegir al 'buffer'
VOID CKeyboard::PutChar( DWORD dwCode )
	{
	if( (DWORD) pbufferin - (DWORD) buffer + sizeof( DWORD ) > BUFFER_SIZE * sizeof( DWORD ) )
		pbufferin = buffer;

	if( (DWORD) pbufferout > (DWORD) pbufferin )
		{
		if( (DWORD) pbufferout - (DWORD) pbufferin <= sizeof( DWORD ) )
			return;
		}

	*pbufferin = dwCode;
	pbufferin++;
	}

// **************************************************************************
// Obt un carcter del 'buffer' (retorna NULL si no n'hi ha)
DWORD CKeyboard::GetChar()
	{
	if( pbufferout == pbufferin )
		return NULL;

	if( (DWORD) pbufferout - (DWORD) buffer + sizeof( DWORD ) > BUFFER_SIZE * sizeof( DWORD ) )
		pbufferout = buffer;

	DWORD dwCode = *pbufferout;
	pbufferout++;

	return dwCode;
	}

// **************************************************************************
// Selecciona la nova bstia per a l'objecte
// Com a entrada ha de rebre:
// Mailbox  	- Nova bstia de l'objecte
VOID CKeyboard::MailBox( PCkeMailBox pMailbox )
	{
	pmailbox = pMailbox;
	}

// **************************************************************************
// Retorna la bstia de l'objecte
PCkeMailBox CKeyboard::MailBox()
	{
	return pmailbox;
	}

// **************************************************************************
// Activem la consola de l'objecte (teclat i pantalla)
VOID CKeyboard::Activate()
	{
	pcurrent = this; // Objecte teclat actiu
	Kernel->MapThreadSpace( pthread );
	pvideo->Activate(); // Activem la pantalla corresponent
	Kernel->UnmapSpace();
	}

