/* **************************************************************************
*                                                                           *
*  Driver.CPP                                                               *
*                                                                           *
*  10-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base generica per a qualsevol controlador de dispositiu                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\driver.h"
#include "drivers\messages.h"
#include "kernel\system.h"
#include "kernel\mailbox.h"
extern PCkeSystem _import System;

CdrvDriver::CdrvDriver( PSTR sName ) : CkeType( CID_Driver )
	{
	pobject = (PCkeMailBox) System->FindObject( sName );
	}

CdrvDriver::~CdrvDriver()
	{
	}

VOID CdrvDriver::DriverName( PSTR sName, DWORD dwMaxSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= DRV_GETNAME_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvDriver::DeviceName( PSTR sName, DWORD dwMaxSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= DRV_GETDEVICENAME_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BYTE CdrvDriver::Version()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETVERSION_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CdrvDriver::Level()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETLEVEL_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

PCkeMailBox CdrvDriver::MailBox()
	{
	return pobject;
	}
// -BUG
VOID CdrvDriver::IOCtl( DWORD, DWORD )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_IOCTL_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CdrvDriver::IsLocal()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_ISLOCAL_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CdrvDriver::IsRemovable()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_ISREMOVABLE_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CdrvDriver::HasMedia()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_HASMEDIA_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

DWORD CdrvDriver::CheckMedia()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CHECKMEDIA_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

BOOL CdrvDriver::IsExclusive()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_ISEXCLUSIVE_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CdrvDriver::Lock()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_LOCK_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 1;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvDriver::Unlock()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_LOCK_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvDriver::Read( DWORD dwSource, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwSource;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READ_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CdrvDriver::Write( DWORD dwDestination, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;

	data.dwParam1	= dwDestination;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITE_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CdrvDriver::Status()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETSTATUS_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

