/* **************************************************************************
*                                                                           *
*  FS.CPP                                                                   *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base genrica per a tots els sistemes de fitxers                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\fs.h"
#include "drivers\messages.h"
#include "kernel\system.h"
extern PCkeSystem _import System;

CdrvFileSystem::CdrvFileSystem( PSTR sName )
	{
	pobject = (PCkeMailBox) System->FindObject( sName );
	}

CdrvFileSystem::~CdrvFileSystem()
	{
	}

VOID CdrvFileSystem::Name( PSTR sName, DWORD dwMaxSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= DRV_GETNAME_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::Delete( PCkeProcess pProc, const PSTR sName )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = (DWORD) pProc;

	TMSG msg;

	msg.dwMessage	= DRV_DELETE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::Rename( PCkeProcess pProc, const PSTR sName, const PSTR sNewName )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = (DWORD) sNewName;
	data.dwParam3 = (DWORD) pProc;

	TMSG msg;

	msg.dwMessage	= DRV_RENAME_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::Create( PCkeProcess pProc, const PSTR sName, DWORD dwMode )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMode;
	data.dwParam3 = (DWORD) pProc;

	TMSG msg;

	msg.dwMessage	= DRV_CREATE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::GrowPageFile( DWORD dwDeltaSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_READFILE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwDeltaSize;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::ShrinkPageFile( DWORD dwDeltaSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_READFILE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwDeltaSize;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::ReadPageFile( DWORD dwLogAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = dwLogAddress;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READPAGEFILE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvFileSystem::WritePageFile( DWORD dwLogAddress, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = dwLogAddress;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITEPAGEFILE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvFileSystem::PageFileSize()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_PAGEFILESIZE_FS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

PVOID CdrvFileSystem::GetInternalPointer()
	{
	return pobject;
	}

