/* **************************************************************************
*                                                                           *
*  FAT.CPP                                                                  *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CFAT per al control del sistema de fitxers de l'MS-DOS            *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\private\fat\fat.h"
#include "sys\sys.h"
#include "string.h"
#include "sys\asm.h"
#include "kernel\boxdef.h"
#include "sys\console.h"
#include "kernel\kernel.h"
#include "drivers\messages.h"
#include "sys\timer.h"
#include "aal\aal.h"
#include "kernel\system.h"
#include "errors.h"
#include "kernel\objdir.h"
#include "drivers\block\cache.h"
#include "drivers\block\ide.h"
#include "kernel\mem.h"
#include "sys\symlink.h"
#include "drivers\fs\private\fub.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	1

#define DRIVER_LEVEL		15

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
PCsysModule SYSModule = NULL;		// Per a comunicar-nos amb el nivell sistema
PCsysConsole pcons;					// Per a mostrar missatges per pantalla
PCFAT FATC;								// Controlador de la primera partici FAT del disc

PCdrvBlockDevice Mount( DWORD&, DWORD& );
LONG Compare( PSTR, PSTR, DWORD );

// *********************************** FUNCIONS
VOID main()
	{
	SYSModule = new CsysModule; // Preparem la comunicaci amb el nivell sistema

	PTDriver driver = (PTDriver) malloc( sizeof( TDriver ) );
	driver->cLevel = DRIVER_LEVEL; // Preparem l'estructura de registre
	SYSModule->RegisterDriver( driver ); // Registrem el controlador

	TMSG msg;
	CHAR str[ 80 ];

	pcons = new CsysConsole;
	sprintf( str, TEXT( "FAT    Driver ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( FILESYSTEM_DIR );

	if( !pparent )
		{
		pcons->OutText( TEXT( "FAT - ERROR cercant FILESYSTEM_DIR\r\n" ) );
		CsysMailBox nothing;
		while( 1 ) { nothing.WaitMessage( &msg ); }
		}

	DWORD dwfirst, dwcount;
	PCdrvBlockDevice dev = Mount( dwfirst, dwcount ); // Montem la partici FAT

	if( dev ) // Si s'ha trobat
		{
		// Generem el directori FAT
		PCkeObjectDirectory pfat = new CkeObjectDirectory( (PCkeObject) pparent, nFAT_DIRECTORY );
		// Generem la bstia per al disc lgic C
		CsysMailBox box( pfat, TEXT( "C" ) );
		// Generem l'enlla dinmic "C:" -> "\FileSystem\FAT\C"
		PVOID plinkparent = FindObject( TEXT( "\\" ) );
		PCsysSymbolicLink plink = new CsysSymbolicLink( plinkparent, TEXT( "C:" ) );
		plink->NewName( TEXT( "\\FileSystem\\FAT\\C" ) );

		FATC = new CFAT( 2, dev, &box, dwfirst, dwcount ); // Generem l'objecte FAT

		SYSModule->DriverReady(); // Indiquem al sistema que estem preparats

		while( 1 )
			{
			box.WaitMessage( &msg );
			FATC->DispatchMessage( msg );
			}
		}
	else // No hi ha cap partici FAT en el primer disc dur
		{
		pcons->OutText( TEXT( "FAT - Mount failed!\r\n" ) );
		CsysMailBox nothing;

		SYSModule->DriverReady(); // Indiquem al sistema que estem preparats

		while( TRUE )
			{
			nothing.WaitMessage( &msg ); // Ignorem els missatges
			}
		}
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
BOOL CFAT::DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Mapegem l'espai d'adreces del flux que ha fer la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case DRV_OPENFILE_FS:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = (DWORD) OpenFile( (PCkeProcess) data->dwParam4, (PSTR) data->dwParam1, (BYTE) data->dwParam2, (BYTE) data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_DELETE_FS:
			{
			sprintf( str, TEXT( "Rebut Delete (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_RENAME_FS:
			{
			sprintf( str, TEXT( "Rebut Rename (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_CREATE_FS:
			{
			sprintf( str, TEXT( "Rebut Create (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GROWPAGEFILE_FS:
			{
			sprintf( str, TEXT( "Rebut GrowPageFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SHRINKPAGEFILE_FS:
			{
			sprintf( str, TEXT( "Rebut ShrinkPageFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_READPAGEFILE_FS:
			{
			sprintf( str, TEXT( "Rebut ReadPageFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_WRITEPAGEFILE_FS:
			{
			sprintf( str, TEXT( "Rebut WritePageFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_PAGEFILESIZE_FS:
			{
			sprintf( str, TEXT( "Rebut PageFileSize (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
			msg.dwParam1 = PageFileSize();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

// Sistemes de fitxers (GlobalFile)
		case DRV_CREATEUSERFILE_FCB:
			{
			msg.dwParam1 = (DWORD) new CUserFile( (PCkeProcess) msg.dwParam2, (PCGlobalFile) msg.dwParam1, 0 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

// Sistemes de fitxers (UserFile)
		case DRV_CLOSEFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut CloseFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str ); // -BUG
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_READFILE_FUB:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = ((PCUserFile) msg.dwParam1)->Read( (PVOID) data->dwParam1, data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_WRITEFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut WriteFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SEEKFILE_FUB:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = ((PCUserFile) msg.dwParam1)->Seek( data->dwParam1, (BYTE) data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_FLUSHFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut FlushFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_TELLFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut TellFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_LOCKFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut LockFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_UNLOCKFILE_FUB:
			{
			sprintf( str, TEXT( "Rebut UnlockFile (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETATTRIBUTES_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetAttributes( msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETATTRIBUTES_FUB:
			{
			msg.dwParam1 = ((PCUserFile) msg.dwParam1)->GetAttributes();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETFILESIZE_FUB:
			{
			sprintf( str, TEXT( "Rebut SetFileSize (%08x,%08x) des de %08x\r\n" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETCREATIONTIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetCreationTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETACCESSTIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetLastAccessTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETWRITETIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetLastWriteTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETCREATIONDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetCreationDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETACCESSDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetLastAccessDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_GETWRITEDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->GetLastWriteDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETCREATIONTIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetCreationTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETACCESSTIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetLastAccessTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETWRITETIME_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetLastWriteTime( (PTFILETIME) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETCREATIONDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetCreationDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETACCESSDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetLastAccessDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case DRV_SETWRITEDATE_FUB:
			{
			((PCUserFile) msg.dwParam1)->SetLastWriteDate( (PTFILEDATE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		default:
			sprintf( str, TEXT( "FAT.DRV - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			pcons->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostre espai d'adreces

	return FALSE; // Retornem sempre FALSE
	}

// **************************************************************************
// Montem una partici (retorna el dispositiu controlador)
// Com a entrada ha de rebre:
// FirstBlock	- Primer bloc de la partici
// BlockCount	- Tamany de la partici
PCdrvBlockDevice Mount( DWORD &dwFirstBlock, DWORD &dwBlockCount )
	{
	CHAR mb[ 50 ];
	strcpy( mb, IDE_MAILBOX ); // Cerquem el dispositiu "HardDisk0"
	strcat( mb, TEXT( "0" ) );
	PCdrvBlockDevice pdev = new CdrvBlockDevice( mb );

	if( !pdev ) // No s'ha trobat!
		return NULL;

	PBYTE pBuffer = (PBYTE) malloc( 512 ); // Creem un 'buffer' de 512 'bytes'
	pdev->ReadBlock( 0, (DWORD) pBuffer, 1 ); // Llegim la taula de particions

	// Comprovem la signatura
	if( pBuffer[ 0x1fe ] != 0x55 || pBuffer[ 0x1ff ] != 0xAA )
		{
		pcons->OutText( TEXT( "Master Boot Sector signature incorrect!" ) );
		free( pBuffer );
		return NULL;
		}

	PTPartitionEntry part = (PTPartitionEntry) &pBuffer[ 0x1be ];
	DWORD dwcount = 4; // Mxim: 4 particions
	BOOL bFound = FALSE; // Encara no l'hem trobada

	while( dwcount && !bFound )
		{ // Cerquem les particions FAT12, FAT16 i FAT16-Huge
		if( part->cType == 1 || (part->cType > 3 && part->cType < 7 ) )
			bFound = TRUE;
		else
			{
			part++;
			dwcount--;
			}
		}

	free( pBuffer ); // Ja no necessitem el 'buffer'

	if( !bFound )
		{ // No hi ha cap partici vlida
		pcons->OutText( TEXT( "FAT Partition NOT found!\r\n" ) );
		return NULL;
		}

	dwFirstBlock = part->dwFirstSector; // Retornem els parmetres de la partici
	dwBlockCount = part->dwSectorsTotal;

	return pdev;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Drive    	- Disc de l'objecte
// Device   	- Dispositiu que cont la partici
// Mailbox  	- Bstia de l'objecte
// FirstBlock	- Primer bloc de la partici
// BlockCount	- Tamany de la partici
CFAT::CFAT( BYTE cDrive, PCdrvBlockDevice pDevice, PCsysMailBox pMailbox, DWORD dwFirstBlock, DWORD dwBlockCount ) : CFileSystem( cDrive, pDevice, pMailbox, dwFirstBlock, dwBlockCount )
	{
	pcache = new CdrvCache( pDevice ); // Ens comunicarem amb la 'cache'

	PBYTE pBuffer = (PBYTE) malloc( 512 ); // Creem un 'buffer' per al sector de 'boot'

	pcache->ReadBlock( dwFirstBlock, (DWORD) pBuffer, 1 ); // Llegim el 'boot sector'
	Kernel->MemCopy( pBuffer, (PBYTE) &boot, sizeof( TFATBoot ) ); // Ens el guardem
	// Calculem el bloc corresponent al primer 'cluster' (nmero 2)
	dwfirstdatablock = dwfirstblock + boot.wResSectors + boot.cFATs * boot.wSecPerFAT + (boot.wRootDirEnts * sizeof( TDirEntry )) / dwblocksize;

	free( pBuffer ); // Ja no necessitem el 'buffer'
	}

// **************************************************************************
// Destructor de la classe
CFAT::~CFAT()
	{
	delete pcache; // No necessitem comunicaci amb la 'cache'
	delete pdev; 	// Ni amb el controlador
	}

// **************************************************************************
// Obre un fitxer retornant el seu FCB
// Com a entrada ha de rebre:
// Proc     	- Procs que intenta obrir el fitxer
// Name     	- Nom del fitxer que volem obrir
// Mode     	- Mode d'obertura del fitxer
// Share    	- Mode de compartici del fitxer
PCGlobalFile CFAT::OpenFile( PCkeProcess /*pProc*/, const PSTR sName, BYTE /*cMode*/, BYTE cShare )
	{
	PSTR filename = sName + 3;		// ignorem el disc
	PCGlobalFile pglob = SearchFCB( filename ); // Intentem trobar-lo

	if( !pglob ) // Si no s'havia obert abans
		{
		// Calculem la posici i tamany del directori arrel
		DWORD dwroot = boot.wResSectors + boot.cFATs * boot.wSecPerFAT + dwfirstblock;
		DWORD dwrootsize = (boot.wRootDirEnts * sizeof( TDirEntry )) / dwblocksize;
		TDirEntry entry;
		DWORD current;
		BOOL bFound = TRUE;
		BOOL bLast = FALSE;

		while( bFound && !bLast ) // Mentre no el trobem
			{
			// Agafem la part segent del nom: xxx\yyy -> xxx
			PSTR pos = strchr( filename, '\\' );

			if( pos )
				*pos = 0;
			else
				bLast = TRUE; // Ja s l'ltima part

			// Cerquem aquest nom en el directori
			if( SearchName( filename, dwroot, dwrootsize, &entry, current ) )
				{
				if( !bLast ) // Si no s l'ltima part, calculem la posici del directori segent
					{
					dwrootsize = 0;
					dwroot = dwfirstdatablock + (entry.wStartCluster - 2) * boot.cSecPerCluster;
					}
				}
			else // Si no s'ha trobat alguna part, no existeix el fitxer
				{
				CHAR str[ 80 ];
				sprintf( str, TEXT( "El fitxer %s no s'ha trobat\r\n" ), filename );
				pcons->OutText( str );
				bFound = FALSE;
				}

			if( pos )
				{ // Tornem a deixar la cadena com estava
				*pos = '\\';
				filename = pos + 1;
				}
			}

		if( bFound ) // Si l'hem trobat, en creem el seu FCB
			{
			pglob = new CGlobalFile( entry.dwFileSize, dwroot, current, entry.wStartCluster, this, filename, cShare );

			if( fcbs ) // Enllacem els FCBs
				fcbs->SetPrev( pglob );

			pglob->SetNext( fcbs );
			pglob->SetPrev( NULL );
			fcbs = pglob;
			}
		}

	return pglob; // Retornem l'FCB
	}

// **************************************************************************
// Tanca un fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que tanca el fitxer
// FCB      	- Fitxer que es vol tancar
VOID CFAT::CloseFile( PCkeProcess pProc, PCGlobalFile pFCB )
	{
	FlushFile( pProc, pFCB ); // Buidem la 'cache'
	}

// **************************************************************************
// Llegeix una certa zona d'un fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que demana les dades
// Global   	- Fitxer sobre el que es realitza la lectura
// Pos      	- Posici des d'on comena la lectura
// Address  	- Adrea de memria on comena l'escriptura
// Size     	- Nombre de 'bytes' a llegir
DWORD CFAT::ReadFile( PCkeProcess, PCGlobalFile pGlobal, DWORD dwPos, DWORD dwAddress, DWORD dwSize )
	{
	// Calculem el 'cluster' corresponent al primer bloc del fitxer
	DWORD dwCluster = pGlobal->FirstBlock();

	{ // Cerquem el 'cluster' corresponent a la posici des d'on comencem a llegir
	DWORD dwNumber = dwPos / (dwblocksize * boot.cSecPerCluster);
	while( dwNumber )
		{
		dwCluster = SearchFAT( dwCluster );
		dwNumber--;
		}
	}

	// Calculem el primer bloc desitjat dins del 'cluster'
	DWORD block = (dwCluster - 2) * boot.cSecPerCluster + dwfirstdatablock;
	DWORD dwCount = 0;

	// Llegim els n blocs del primer 'cluster' (si n s menor que tot un 'cluster')
	if( (dwPos / dwblocksize) % boot.cSecPerCluster )
		{
		DWORD delta = (dwPos / dwblocksize) % boot.cSecPerCluster; // Blocs a llegir
		PSTR buffer = (PSTR) malloc( boot.cSecPerCluster * dwblocksize ); // Reservem memria

		pcache->ReadBlock( block + delta, (DWORD) buffer, boot.cSecPerCluster - delta ); // Llegim

		if( (dwPos % dwblocksize) + dwSize < (boot.cSecPerCluster - delta) * dwblocksize )
			{ // Hem llegit tot el que ens han demanat
			Kernel->MemCopy( buffer + (dwPos % dwblocksize), (PBYTE) dwAddress, dwSize ); // Passem la informaci a l'aplicaci que la demanava
			dwCount = dwSize;
			dwSize = 0;
			}
		else
			{ // Encara no hem acabat de llegir-ho tot
			Kernel->MemCopy( buffer + (dwPos % dwblocksize), (PBYTE) dwAddress, (boot.cSecPerCluster - delta) * dwblocksize - (dwPos % dwblocksize) ); // Passem dades a l'aplicaci
			// Calculem el que hem llegit i el que ens falta per llegir
			dwCount += (dwblocksize * (boot.cSecPerCluster - delta) - (dwPos % dwblocksize));
			dwSize -= (dwblocksize * (boot.cSecPerCluster - delta) - (dwPos % dwblocksize));
			dwAddress += dwCount;
			dwCluster = SearchFAT( dwCluster ); // Calculem quin s el 'cluster' segent
			block = (dwCluster - 2) * boot.cSecPerCluster + dwfirstdatablock; // Transformem 'cluster' a bloc
			}

		free( buffer ); // Ja no necessitem el 'buffer'
		}

	// Calculem el nombre de 'clusters' sencers que falten per llegir
	DWORD dwBlocks = dwSize / (dwblocksize * boot.cSecPerCluster);
	dwSize = dwSize % (dwblocksize * boot.cSecPerCluster);

	while( dwBlocks ) // Llegim de 'cluster' en 'cluster'
		{
		pcache->ReadBlock( block, dwAddress, boot.cSecPerCluster ); // Llegim
		// Calculem el que hem fet fins ara i quin s el 'cluster' segent
		dwCount += (dwblocksize * boot.cSecPerCluster);
		dwAddress += (dwblocksize * boot.cSecPerCluster);
		dwBlocks--;
		dwCluster = SearchFAT( dwCluster );
		block = (dwCluster - 2) * boot.cSecPerCluster + dwfirstdatablock;
		}

	// Comprovem si necessitem llegir part de l'ltim 'cluster'
	if( dwSize )
		{
		// Reservem memria per al 'cluster'
		PSTR buffer = (PSTR) malloc( boot.cSecPerCluster * dwblocksize );
		pcache->ReadBlock( block, (DWORD) buffer, boot.cSecPerCluster ); // Llegim

		if( dwCount ) // Des del principi del 'buffer' perqu ja havem llegit alguna cosa
			Kernel->MemCopy( buffer, (PBYTE) dwAddress, dwSize );
		else // Hem d'utilitzar el desplaament correcte, perqu encara no hem llegit res
			Kernel->MemCopy( buffer + (dwPos % dwblocksize), (PBYTE) dwAddress, dwSize );

		free( buffer ); // Ja no necessitem ms el 'cluster'
		dwCount += dwSize;
		}

	return dwCount; // Retornem el nombre de 'bytes' llegits
	}

// **************************************************************************
// Escriu una certa zona d'un fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que vol escriure dades
// Global   	- Fitxer sobre el que es realitza l'escriptura
// Pos      	- Posici des d'on comena l'escriptura
// Address  	- Adrea de memria on comena la lectura
// Size     	- Nombre de 'bytes' a escriure
DWORD CFAT::WriteFile( PCkeProcess, PCGlobalFile, DWORD, DWORD, DWORD )
	{
	return 0; // -BUG
	}

// **************************************************************************
// Escriu els canvis en el fitxer
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// FCB      	- Fitxer que es vol escriure
VOID CFAT::FlushFile( PCkeProcess, PCGlobalFile )
	{
	// -BUG
	}

// **************************************************************************
// Esborra el fitxer/directori especificat
// Com a entrada ha de rebre:
// Proc     	- Procs que fa la petici
// Name     	- Nom del fitxer/directori que vol esborrar
VOID CFAT::Delete( PCkeProcess, const PSTR )
	{
	// -BUG
	}

// **************************************************************************
// Tracta els missatges que arriben al controlador
// Com a entrada ha de rebre:
// msg      	- Missatge que volem tractar
VOID CFAT::Rename( PCkeProcess, const PSTR, const PSTR )
	{
	// -BUG
	}

// **************************************************************************
// Selecciona un nou tamany de fitxer
// Com a entrada ha de rebre:
// Process  	- Procs que demana la informaci
// FCB      	- Fitxer sobre el qual demana informaci
// Size     	- Nou tamany
VOID CFAT::SetFileSize( PCkeProcess, PCGlobalFile, DWORD )
	{
	// -BUG
	}

// **************************************************************************
// Crea un nou fitxer o directori
// Com a entrada ha de rebre:
// Process  	- Procs que demana la informaci
// FCB      	- Fitxer sobre el qual demana informaci
PCGlobalFile CFAT::Create( PCkeProcess, const PSTR, DWORD )
	{
	return NULL;	// -BUG
	}

// **************************************************************************
// Obt l'hora de creaci d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Time     	- Hora
VOID CFAT::GetCreationTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	GetLastWriteTime( pFCB, pTime ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Obt l'hora d'ltim accs d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Time     	- Hora
VOID CFAT::GetLastAccessTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	GetLastWriteTime( pFCB, pTime ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Obt l'hora d'ltima escriptura d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Time     	- Hora
VOID CFAT::GetLastWriteTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];
	// Retornem el camp demanat
	pTime->cHour = (BYTE) (entry->wTime >> 11);
	pTime->cMinute = (BYTE) ((entry->wTime >> 5) & 0x3f);
	pTime->cSecond = (BYTE) ((entry->wTime << 1) & 0x3f);

	free( pBuffer );
	}

// **************************************************************************
// Obt la data de creaci d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Date     	- Data
VOID CFAT::GetCreationDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	GetLastWriteDate( pFCB, pDate ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Obt la data d'ltim accs d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Date     	- Data
VOID CFAT::GetLastAccessDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	GetLastWriteDate( pFCB, pDate ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Obt la data d'ltima escriptura d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol consultar informaci
// Date     	- Data
VOID CFAT::GetLastWriteDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];
	// Retornem el camp demanat
	pDate->wYear = (WORD) ((entry->wDate >> 9) + 1980);
	pDate->cMonth = (BYTE) ((entry->wDate >> 5) & 0x0f);
	pDate->cDay = (BYTE) (entry->wDate & 0x1f);

	free( pBuffer );
	}

// **************************************************************************
// Canvia l'hora de creaci d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Time     	- Nova hora
VOID CFAT::SetCreationTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	SetLastWriteTime( pFCB, pTime ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Canvia l'hora d'ltim accs d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Time     	- Nova hora
VOID CFAT::SetLastAccessTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	SetLastWriteTime( pFCB, pTime ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Canvia l'hora d'ltima escriptura d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Time     	- Nova hora
VOID CFAT::SetLastWriteTime( PCGlobalFile pFCB, PTFILETIME pTime )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];
	// Modifiquem el camp demanat
	entry->wTime = (WORD) ((pTime->cHour << 11) + (pTime->cMinute << 5) + (pTime->cSecond >> 1));

//	pcache->WriteBlock( dwBlock, (DWORD) pBuffer, 1 ); // Escrivim els canvis
	free( pBuffer );
	}

// **************************************************************************
// Canvia la data de creaci d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Date     	- Nova data
VOID CFAT::SetCreationDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	SetLastWriteDate( pFCB, pDate ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Canvia la data d'ltim accs d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Date     	- Nova data
VOID CFAT::SetLastAccessDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	SetLastWriteDate( pFCB, pDate ); // La FAT noms guarda un valor
	}

// **************************************************************************
// Canvia la data d'ltima escriptura d'un fitxer
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es vol canviar la informaci
// Date     	- Nova data
VOID CFAT::SetLastWriteDate( PCGlobalFile pFCB, PTFILEDATE pDate )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];
	// Modifiquem el camp demanat
	entry->wDate = (WORD) (((pDate->wYear - 1980) << 9) + (pDate->cMonth << 5) + pDate->cDay);

//	pcache->WriteBlock( dwBlock, (DWORD) pBuffer, 1 ); // Escrivim els canvis
	free( pBuffer );
	}

// **************************************************************************
// Canvia els atributs d'un cert fitxer
// Com a entrada ha de rebre:
// Process  	- Procs que demana el canvi
// FCB      	- Fitxer sobre el qual es fa el canvi
// Attributes	- Atributs nous
VOID CFAT::SetAttributes( PCkeProcess, PCGlobalFile pFCB, DWORD dwAttributes )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];
	entry->cAttr = (BYTE) dwAttributes; // Modifiquem el camp demanat

//	pcache->WriteBlock( dwBlock, (DWORD) pBuffer, 1 ); // Escrivim els canvis
	free( pBuffer );
	}

// **************************************************************************
// Obt els atributs d'un cert fitxer
// Com a entrada ha de rebre:
// Process  	- Procs que demana la informaci
// FCB      	- Fitxer sobre el qual demana informaci
DWORD CFAT::GetAttributes( PCkeProcess, PCGlobalFile pFCB )
	{
	// Cerquem l'entrada de directori
	DWORD dwBlock = pFCB->DirectoryBlock();
	DWORD dwOffset = pFCB->DirectoryEntry();

	PSTR pBuffer = (PSTR) malloc( dwblocksize );
	pcache->ReadBlock( dwBlock, (DWORD) pBuffer, 1 ); // Llegim l'entrada de directori

	PTDirEntry entry = (PTDirEntry) &pBuffer[ dwOffset ];

	free( pBuffer );

	return (DWORD) entry->cAttr; // Retornem el camp demanat
	}

// **************************************************************************
// Retorna el nom del sistema de fitxers
PSTR CFAT::Name()
	{
	return TEXT( "FAT" );
	}

// **************************************************************************
// Cerca el 'cluster' segent d'un 'cluster' donat
// Com a entrada ha de rebre:
// Cluster 		- 'Cluster' del qual en volem conixer el segent
DWORD CFAT::SearchFAT( DWORD dwCluster )
	{
	// Calculem el sector de la FAT que necessitem
	DWORD dwFATBlock = dwfirstblock + boot.wResSectors + dwCluster / 256;
	DWORD dwOffset = dwCluster % 256;

	// Llegim el sector de la FAT
	WORD buffer[ 256 ];
	pcache->ReadBlock( dwFATBlock, (DWORD) buffer, 1 );

	return buffer[ dwOffset ];
	}

// **************************************************************************
// Cerca el nom d'un fitxer dins d'un sector d'un directori
// Com a entrada ha de rebre:
// FileName 	- Nom que s'est cercant
// Directory	- Bloc que cont el directori
// DirSize  	- Tamany del directori
// DirEntry 	- Entrada del directori
// current  	- Desplaament cap a l'entrada del diretori
BOOL CFAT::SearchName( PSTR sFileName, DWORD dwDirectory, DWORD dwDirSize, PTDirEntry pDirEntry, DWORD &current )
	{
	DWORD dwCount = 0;

	// Transformem el nom de fitxer en un nom: nnnnnnnneee
	PSTR filename = (PSTR) malloc( 13 );

	for( DWORD a = 0; a < 12; a++ )
		filename[ a ] = 0;

	PSTR pos = strchr( sFileName, '.' );

	if( pos )
		strncpy( filename, sFileName, (DWORD) pos - (DWORD) sFileName );
	else
		strcpy( filename, sFileName );

	for( DWORD a = strlen( filename ); a < 8; a++ )
		strcat( filename, TEXT( " " ) );

	if( pos )
		strcat( filename, pos + 1 );

	BOOL bFAT = FALSE; // Indica si hem de cercar per la FAT

	if( dwDirSize == 0 ) // Si el tamany del directori s 0, hem de cercar per la FAT
		{
		bFAT = TRUE;
		dwDirSize = 1;
		}

	CHAR buffer[ 512 ]; // 'Buffer' per al sector

	pcache->ReadBlock( dwDirectory, (DWORD) buffer, 1 ); // Llegim el primer sector del directori

	BOOL bFound = FALSE;		// Encara no s'ha trobat
	BOOL bFinished = FALSE; // Encaran no hem acabat
	PTDirEntry pentry;

	while( dwDirSize && !bFound && !bFinished ) // Repetim
		{
		current = 0; // Comencem pel principi

		while( current < dwblocksize && !bFound && !bFinished )
			{
			pentry = (PTDirEntry) &buffer[ current ];

			if( pentry->cName[ 0 ] == 0 ) // Hem arribat al final
				bFinished = TRUE;
			else
				{
				if( Compare( pentry->cName, filename, 13 ) == 0 )
					bFound = TRUE; // Hem trobat el nom cercat

				if( !bFound ) // Passem al segent
					current += sizeof( TDirEntry );
				}
			}

		if( !bFound && !bFinished ) // Ni trobat, ni final
			{
			if( !bFAT )
				{ // Llegim el sector segent de l'arrel
				dwDirSize--;
				pcache->ReadBlock( ++dwDirectory, (DWORD) buffer, 1 );
				}
			else
				{ // Llegim el sector segent d'un subdirectori
				dwCount++;
				if( dwCount < boot.cSecPerCluster ) // Encara no hem acabat amb el 'cluster'
					pcache->ReadBlock( dwDirectory + dwCount, (DWORD) buffer, 1 );
				else // Hem de llegir el 'cluster' segent
					{
					dwCount = 0;
					DWORD dwCluster = 2 + (dwDirectory - dwfirstdatablock) / boot.cSecPerCluster;
					dwCluster = SearchFAT( dwCluster ); // Cerquem el 'cluster' segent
					if( dwCluster != 0xfff8 ) // No estvem en l'ltim
						{ // Llegim el primer sector del 'cluster'
						dwDirectory = dwfirstdatablock + (dwCluster - 2) * boot.cSecPerCluster;
						pcache->ReadBlock( dwDirectory, (DWORD) buffer, 1 );
						}
					else
						dwDirSize = 0;
					}
				}
			}
		}

	if( bFound ) // Si l'hem trobat, omplim l'estructura de dades
		Kernel->MemCopy( (PBYTE) pentry, (PBYTE) pDirEntry, sizeof( TDirEntry ) );

	free( filename ); // Ja no necessitem el nom
	return bFound;
	}

// **************************************************************************
// Compara dues cadenes de carcters fins al primer NUL o espai
// Com a entrada ha de rebre:
// str1     	- Primera cadena de carcters
// str2     	- Segona cadena de carcters
// Size     	- Tamany mxim a comparar
LONG Compare( PSTR str1, PSTR str2, DWORD dwSize )
	{
	BOOL bOK = TRUE;

	while( dwSize && *str1 && *str2 && bOK )
		{
		if( *str1 != *str2 )
			{
			if( (*str1 == 0 || *str1 == 20) && (*str2 == 0 || *str2 == 20) )
				bOK = TRUE;
			else
				bOK = FALSE;
			}

		str1++;
		str2++;
		dwSize--;
		}

	if( bOK )
		return 0;

	if( *str1 < *str2 )
		return -1;
	else
		return 1;
	}

