/* **************************************************************************
*                                                                           *
*  FS.CPP                                                                   *
*                                                                           *
*  25-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CFileSystem que cont el sistema de fitxers genric               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\private\fs.h"
#include "string.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Drive    	- Dispositiu sobre el que actua
// Device   	- Controlador que gestiona el dispositiu fsic
// Mailbox  	- Bstia de l'objecte
// FirstBlock	- Primer bloc del dispositiu que controla el sistema de fitxers
// BlockCount	- Nombre de blocs de la partici
CFileSystem::CFileSystem( BYTE cDrive, PCdrvBlockDevice pDevice, PCsysMailBox pMailbox, DWORD dwFirstBlock, DWORD dwBlockCount )
	{
	id = CID_FileSystem;

	cdrive 			= cDrive;
	pmailbox 		= pMailbox;
	pdev 				= pDevice;
	fcbs 				= NULL;
	dwfirstblock 	= dwFirstBlock;
	dwblockcount 	= dwBlockCount;
	dwblocksize 	= 512; // -BUG
	}

// **************************************************************************
// Destructor de la classe
CFileSystem::~CFileSystem()
	{
	}

// **************************************************************************
// Retorna el nom del sistema de fitxers
PSTR CFileSystem::Name()
	{
	return TEXT( "NULL-FS" );
	}

// **************************************************************************
// Amplia el fitxer de paginaci
// Com a entrada ha de rebre:
// Delta    	- Nombre de 'bytes' a afegir
VOID CFileSystem::GrowPageFile( DWORD )
	{
	}

// **************************************************************************
// Redueix el fitxer de paginaci
// Com a entrada ha de rebre:
// Delta    	- Nombre de 'bytes' a eliminar
VOID CFileSystem::ShrinkPageFile( DWORD )
	{
	}

// **************************************************************************
// Llegeix una certa pgina del fitxer de paginaci
// Com a entrada ha de rebre:
// Address  	- Posici de memria on comencem a escriure
// Block    	- Bloc del fitxer de paginaci des d'on comencem a llegir
VOID CFileSystem::ReadPageFile( DWORD, DWORD )
	{
	}

// **************************************************************************
// Escriu una certa pgina en el fitxer de paginaci
// Com a entrada ha de rebre:
// Address  	- Posici de memria des d'on comencem a llegir
// Block    	- Bloc del fitxer on comencem a escriure
VOID CFileSystem::WritePageFile( DWORD, DWORD )
	{
	}

// **************************************************************************
// Retorna el tamany del fitxer de paginaci
DWORD CFileSystem::PageFileSize()
	{
	return 0L;
	}

// **************************************************************************
// Cerca entre els FCBs el fitxer demanat
// Com a entrada ha de rebre:
// FileName 	- Nom del fitxer que volem trobar
PCGlobalFile CFileSystem::SearchFCB( PSTR sFileName )
	{
	PCGlobalFile pitem = fcbs; // Comencem per el primer
	BOOL bfound = FALSE; 		// Encara no l'hem trobat

	while( pitem && !bfound ) // -BUG
		{
		pitem = (PCGlobalFile) pitem->GetNext(); // Passem al segent
		}

	if( bfound )
		return pitem; // Retornem l'objecte trobat
	else
		return NULL; // No s'ha trobat
	}

